package com.ejianc.foundation.front.business.ide.service;

import java.util.List;

import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import com.ejianc.foundation.front.business.ide.bo.IdeModuleBo;
import com.ejianc.foundation.front.business.ide.entity.IdeModule;
import com.ejianc.foundation.front.business.ide.entity.IdeModulePrivate;
import com.ejianc.foundation.front.business.ide.entity.IdeModulePrivateVerifyHis;
import com.ejianc.framework.core.exception.BusinessException;

public interface IdeModulePrivateService {
	
	Page<IdeModulePrivate> findByCode(String code,String orgId,String appId,String tenantId,Pageable pageable) throws BusinessException,Exception;

	IPage<IdeModulePrivate> findByCode(int pageNumber,int pageSize,String code, String orgId, String appId, String tenantId) throws BusinessException,Exception;

	void saveOrUpdate(IdeModulePrivate ideModulePrivate) throws BusinessException;

	void changeIsDevelopment(IdeModulePrivate ideModulePrivate) throws BusinessException;
	
	void deleteByIds(List<String> ids) throws BusinessException,Exception;
	
	//查询当前层级无实例，查询父级层级
	IdeModulePrivate findByOrgId(String pageCode,String appCode,String orgId,String tenantId);
	
	//只查询当前层级
	IdeModulePrivate findByOrgIdAndCode(String pageCode,String appCode,String orgId) throws BusinessException;

	//查询同一页面所有私有化实例
	List<IdeModulePrivate> findByPageCodeAndAppCode(String pageCode, String appCode);

	void saveData(IdeModulePrivate ideModulePrivate) throws BusinessException;

	void updateData(IdeModulePrivate ideModulePrivate) throws BusinessException;
	
	List<String> findNodeIds(String orgId,String tenantId) throws BusinessException,Exception;
	
	List<IdeModule> findModule(String appId) throws BusinessException;
	//按页面编码和页面名称进行模糊匹配搜索，返回最多maxCount项集合
	List<IdeModuleBo> searchByModuleCodeAndName(String searchText,int maxCount) throws BusinessException;

	IdeModulePrivate findById(String id) throws Exception;

	List<IdeModulePrivate> findByIds(String id) throws Exception;

	// 更新js附件信息
	void updateAttach(IdeModulePrivate ideModulePrivate) throws BusinessException;

	Page<IdeModulePrivate> findUnverifyList(String code, String orgId, String appId, String tenantId, Pageable pageable,
			String condition) throws BusinessException, Exception;

	void updateAttachVerify(List<String> ids, String modifyId, String modifyName) throws BusinessException;

	Page<IdeModulePrivateVerifyHis> findVerifyHistoryList(String code, String orgId, String appId, String tenantId,
			Pageable pageable, String condition) throws BusinessException, Exception;

}
