package com.ejianc.foundation.front.business.ide.service.impl;

import org.springframework.stereotype.Service;

import com.ejianc.foundation.front.business.ide.service.IdeCommonService;
import com.ejianc.support.idworker.util.IdWorker;
@Service
public class IdeCommonServiceImpl implements IdeCommonService{

	@Override
	public String generateAppCode() {
		return "A"+IdWorker.getId();
	}

	@Override
	public String generateAppGroupCode() {
		return "AG"+IdWorker.getId();
	}

	@Override
	public String generateTeamCode() {
		return "T"+IdWorker.getId();
	}

	@Override
	public String generateModuleCode() {
		return "M"+IdWorker.getId();
	}

	@Override
	public String[] generateModuleCodes(int count) {
		String[] codeArr = new String[count];
		for(int i=0;i<count;i++) {
			codeArr[i] = "P"+IdWorker.getId();
		}
		return codeArr;
	}

	@Override
	public String generateModuleGroupCode() {
		return "MG"+IdWorker.getId();
	}

	@Override
	public String generateResourceCode() {
		return "R"+IdWorker.getId();
	}
    
}
