package com.ejianc.foundation.front.business.ide.service.impl;

import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.foundation.front.business.ide.repository.IdeModuleDataBoRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeModuleDataRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeModuleRepo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejianc.foundation.front.business.ide.bo.IdeModuleDataBO;
import com.ejianc.foundation.front.business.ide.entity.IdeModule;
import com.ejianc.foundation.front.business.ide.entity.IdeModuleData;
import com.ejianc.foundation.front.business.ide.service.IdeModuleDataService;

/**
 * Created by cdr_c on 2017/6/15.
 */
@Transactional(readOnly = true)
@Service
public class IdeModuleDataServiceImpl implements IdeModuleDataService {

	private static final String NID = "nid";
	private static final String UI_KEY = "uikey";
	private static final String UI_TITLE = "uititle";
	private static final String UI_TYPE = "uitype";
	private static final String CHILDREN = "children";
	private static final Set<String> FIXED_KEYS = new HashSet<>(Arrays.asList(NID, UI_KEY, UI_TITLE, UI_TYPE, CHILDREN));
	@Autowired
	private IdeModuleDataRepo moduleDataRepo;
	@Autowired
	private IdeModuleRepo moduleRepo;
	@Autowired
	private IdeModuleDataBoRepo moduleDataRepoImpl;

	@Transactional
	@Override
	public IdeModuleData createFromIdeModule(String moduleId) {
		IdeModule module = moduleRepo.selectById(moduleId);
		if (module != null) {
			return this.createFromIdeModule(module);
		}
		return null;
	}

	@Transactional
	@Override
	public Map<Long, IdeModuleData> createFromIdeModules(List<String> moduleIds) {
		if (!CollectionUtils.isEmpty(moduleIds)) {
			return moduleIds.stream().map(this::createFromIdeModule).filter(Objects::nonNull)
					.collect(Collectors.toMap(moduleData -> moduleData.getModule().getId(), moduleData -> moduleData));
		}
		return null;
	}

	@Override
	public IdeModuleData createFromIdeModule(IdeModule module) {
		IdeModuleData _moduleData = moduleDataRepo.findByModuleId(module.getId());
		if (_moduleData != null) {
			moduleDataRepo.deleteById(_moduleData.getId());
		}
		JSONObject data = JSONObject.parseObject(module.getData());
		IdeModuleData moduleData = this.parseJSONObject(data, null, module);
		if (moduleData != null) {
			moduleDataRepo.insert(moduleData);
			return moduleData;
		}
		return null;
	}
	private IdeModuleData parseJSONObject(JSONObject jsonObject, IdeModuleData parent, IdeModule module) {
		if (jsonObject != null) {
			IdeModuleData moduleData = new IdeModuleData();
			moduleData.setModule(module);
			moduleData.setAppId(module.getAppId());
			moduleData.setParent(parent);
			moduleData.setRoot(parent == null);
			moduleData.setNid(jsonObject.getString(NID));
			moduleData.setUikey(jsonObject.getString(UI_KEY));
			moduleData.setUititle(jsonObject.getString(UI_TITLE));
			moduleData.setUitype(jsonObject.getString(UI_TYPE));
			// 将不属于固定属性和名为"children"但值不为JSONArray的属性放入"data"属性
			Map<String, Object> otherData = jsonObject.keySet().stream().filter(key -> !FIXED_KEYS.contains(key) ||
					(key.equals(CHILDREN) && !(jsonObject.get(CHILDREN) instanceof JSONArray))).
					filter(key -> jsonObject.get(key) != null).
					peek(key -> System.out.println("key: " + key + ", value: " + jsonObject.get(key))).
					collect(Collectors.toMap(key -> key, jsonObject::get));
			moduleData.setData(CollectionUtils.isEmpty(otherData) ? null : JSONObject.toJSONString(otherData));

			if (jsonObject.containsKey(CHILDREN) && jsonObject.get(CHILDREN) instanceof JSONArray) {
				List<IdeModuleData> children = jsonObject.getJSONArray(CHILDREN).stream()
						.map(item -> this.parseJSONObject((JSONObject) item, moduleData, module)).collect(Collectors.toList());
				moduleData.setChildren(children);
			}
			return moduleData;
		}
		return null;
	}

	@Override
	public List<IdeModuleData> createFromIdeApp(String appId) {
		List<IdeModule> ideModules = moduleRepo.findByAppId(appId);
		return Optional.ofNullable(ideModules).orElse(new ArrayList<>()).stream()
				.filter(Objects::nonNull)
				.map(this::createFromIdeModule).collect(Collectors.toList());
	}

	@Override
	public List<IdeModuleData> createFromUser(String userId) {
		List<IdeModule> ideModules = moduleRepo.findByUserId(userId);
		return Optional.ofNullable(ideModules).orElse(new ArrayList<>()).stream()
				.filter(Objects::nonNull)
				.map(this::createFromIdeModule).collect(Collectors.toList());
	}

	@Override
	public Map<String, List<IdeModuleData>> findByModuleIdsAndUitypes(List<String> moduleIds, List<String> uiTypes) {
		String moduleids = "'"+ org.apache.commons.lang.StringUtils.join(moduleIds,"','")+"'";
		String types = "'"+ org.apache.commons.lang.StringUtils.join(uiTypes,"','")+"'";
		List<IdeModuleData> moduleDataList = moduleDataRepo.findByModuleIdsAndUitypes(moduleids, types);
		Map<String, List<IdeModuleData>> moduleDataMap =  moduleDataList.stream()
				.collect(Collectors.groupingBy(moduleData -> String.valueOf(moduleData.getModule().getId())));
		moduleDataMap.forEach((key, value) -> value.forEach(item -> {
			item.setModule(null);
			item.setParent(null);
			item.setChildren(null);
		}));
		return moduleDataMap;
	}

	@Override
	public List<IdeModuleDataBO> findDataByEntity(String entityName) {
		if(!StringUtils.isEmpty(entityName)){
			List<IdeModuleDataBO> allData = moduleDataRepoImpl.findDataByEntity(entityName);
			if(allData != null&&allData.size() > 0){
				List<IdeModuleDataBO> result = allData.stream().collect(Collectors
						.collectingAndThen(Collectors.toCollection(() ->
								new TreeSet<>(Comparator.comparing(IdeModuleDataBO::getUikey))), ArrayList::new));
				return result;
			}
		}
		return null;
	}
    
}
