package com.ejianc.foundation.front.business.ide.service.impl;

import java.util.*;

import com.alibaba.fastjson.JSONArray;
import com.ejianc.foundation.cfs.api.ICustomTableApi;
import com.ejianc.foundation.cfs.vo.PageData;
import com.ejianc.foundation.front.business.ide.cache.IdeModulePageCache;
import com.ejianc.foundation.front.business.ide.entity.*;
import com.ejianc.foundation.front.util.StringUtils;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.front.business.ide.Constant;
import com.ejianc.foundation.front.business.ide.bo.IdeAppBo;
import com.ejianc.foundation.front.business.ide.bo.IdeModuleBo;
import com.ejianc.foundation.front.business.ide.bo.IdeProductionBo;
import com.ejianc.foundation.front.business.ide.bo.IdeTeamBo;
import com.ejianc.foundation.front.business.ide.repository.IdeAppRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeModuleDataRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeModulePrivateRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeModuleProRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeModuleRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeTeamRepo;
import com.ejianc.foundation.front.business.ide.service.IdeAppService;
import com.ejianc.foundation.front.business.ide.service.IdeCommonService;
import com.ejianc.foundation.front.business.ide.service.IdeEnvironmentService;
import com.ejianc.foundation.front.business.ide.service.IdeModulePrivateService;
import com.ejianc.foundation.front.business.ide.service.IdeModuleProService;
import com.ejianc.foundation.front.business.ide.service.IdeModuleService;
import com.ejianc.foundation.front.business.ide.service.MetadataReaderService;
import com.ejianc.foundation.front.common.http.HttpClientUtil;
import com.ejianc.foundation.front.util.JsonBackData;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.support.idworker.util.IdWorker;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;

/**
 * @author Dio.zhu
 */
@Service
@Transactional
public class IdeModuleServiceImpl implements IdeModuleService {

	private static final Logger LOGGER = LoggerFactory.getLogger(IdeModuleServiceImpl.class);

	private static final Gson gson = new Gson();
    @Autowired
    IdeModuleRepo ideModuleRepo;
    @Autowired
    IdeModuleDataRepo moduleDataRepo;
    @Autowired
    IdeModuleRepo ideModuleRepoImpl;
    @Autowired
    IdeTeamRepo ideTeamRepo;
    @Autowired
    IdeAppService ideAppService;
    @Autowired
    IdeAppRepo ideAppRepo;
    @Autowired
    IdeCommonService ideCommonService;
    @Autowired
    IdeModuleProRepo ideModuleProRepo;
    @Autowired
    IdeModuleProService ideModuleProService;
    @Autowired
    IdeModulePrivateService ideModulePrivateService;
    @Autowired
    IdeEnvironmentService ideEnvironmentService;
    @Autowired
    IdeModulePrivateRepo ideModulePrivateRepo;
    @Autowired
	private MetadataReaderService metadataReaderService;
    @Autowired
	private ICustomTableApi iCustomTableApi;
	@Autowired
	IdeModulePageCache ideModulePageCache;

    @Override
	@Transactional
    public synchronized IdeModule saveOrUpdate(IdeModule ideModule) throws ClassCastException{
        IdeModule ideModuleTemp = null;
		setEnData(ideModule);
        if (ideModule.getId() == null) { // 新增
            if (StringUtils.isEmpty(String.valueOf(ideModule.getAppId()))) {
                throw new BusinessException("所属应用不能为空");
            }
            if (StringUtils.isEmpty(ideModule.getName())) {
                throw new BusinessException("页面名称不能为空");
            }
            List<IdeModule> ideModuleList = ideModuleRepo.findByName(ideModule.getName(), String.valueOf(ideModule.getAppId()));
            if (ideModuleList.size()>0) {
            	throw new BusinessException("已存在的页面名称");
            } else {
            	ideModule.setId(IdWorker.getId());
            	String code = ideCommonService.generateModuleCode();
            	ideModule.setCode(code);
            	Date nowDate = new Date();
                ideModule.setCreateDate(nowDate);
                /** 初始化页面数据 */
				ideModule.setData(getPageInitData(ideModule.getPageType(),ideModule.getName()));

                ideModuleRepo.save(ideModule);
                return ideModule;
            }
        } else { //修改
            ideModuleTemp = ideModuleRepo.findById(String.valueOf(ideModule.getId()));
            if(!Objects.equals(ideModule.getTs(),ideModuleTemp.getTs())){
				throw new BusinessException("数据已被团队其他成员修改，请刷新页面修改后再次保存！");
			}
            ideModuleTemp.setTs(new Date().getTime());
            ideModuleTemp.setName(ideModule.getName());
            if(StringUtils.isNotEmpty(ideModule.getClientType())) {
            	ideModuleTemp.setClientType(ideModule.getClientType());
            }
            ideModuleTemp.setModifyDate(new Date());
            ideModuleTemp.setModifyName(ideModule.getModifyName());
            if(ideModule.getData()!=null){
            	ideModuleTemp.setData(ideModule.getData());
            	ideModuleTemp.setEnData(ideModule.getEnData());
            }
            if(StringUtils.isNotEmpty(String.valueOf(ideModule.getGroupId()))){
            	 ideModuleTemp.setGroupId(ideModule.getGroupId());
            }
            //TODO: 向ejc-cfs传递更新信息
			if(ideModuleTemp.getCode().startsWith("CFS") && StringUtils.isNotEmpty(ideModule.getFromName())){
				Long userId = Long.parseLong(ideModule.getFromName().split(":")[0]);
				String token = ideModule.getFromName().split(":")[1];
				PageData pageData = new PageData();
				pageData.setAppCode(ideModuleTemp.getCode());
				pageData.setPageMeta(ideModule.getData());
				pageData.setToken(token);
				pageData.setUserId(userId);
				CommonResponse response = iCustomTableApi.parse(pageData);
				if(!response.isSuccess()){
					throw new BusinessException(response.getMsg());
				}
				ideModuleTemp.setFromName(null);
			}
            ideModuleRepo.update(ideModuleTemp);
            return ideModuleTemp;
        }
    }
    private void setEnData(IdeModule ideModule){
    	if(StringUtils.isNotEmpty(ideModule.getData())){
    		JSONObject data = JSONObject.parseObject(ideModule.getData());
			setUiTitleEn(data);
			if(data.get("children")!=null && data.getString("children").contains("[")){
				JSONArray children = data.getJSONArray("children");
				setChildrenEn(children);
			}
			ideModule.setEnData(JSONObject.toJSONString(data));
		}
	}
	private void setUiTitleEn(JSONObject ui){
    	if(StringUtils.isNotEmpty(ui.getString("enTitle"))){
    		ui.put("uititle",ui.getString("enTitle"));
    		if(ui.getString("children")!=null && !ui.getString("children").contains("[")){
    			ui.put("children",ui.getString("enTitle"));
			}
    		if(ui.getString("title")!=null){
    			ui.put("title",ui.getString("enTitle"));
			}
    		if(ui.getString("label")!=null){
    			ui.put("label",ui.getString("enTitle"));
			}
    		if(ui.getString("buttonText")!=null){
    			ui.put("buttonText",ui.getString("enTitle"));
			}
    		if(ui.getString("text")!=null){
    			ui.put("text",ui.getString("enTitle"));
			}
		}
	}
	private void setChildrenEn(JSONArray children){
		for (Object child : children) {
			JSONObject ui = (JSONObject) child;
			setUiTitleEn(ui);
			if(ui.get("children")!=null && ui.getString("children").contains("[")){
				JSONArray cChildren = ui.getJSONArray("children");
				setChildrenEn(cChildren);
			}
		}
	}
	private String getPageInitData(String pageType,String pageName) {
		String data = null;
    	switch (pageType){
			case "pageCard":
				data = "{" +
						"  \"uikey\": \"pageCard\"," +
						"  \"uititle\": \""+pageName+"-卡片\"," +
						"  \"uitype\": \"EJCPage\"," +
						"  \"pageName\": \""+pageName+"\"," +
						"  \"children\": [" +
						"    {" +
						"      \"uititle\": \"面包屑\"," +
						"      \"uitype\": \"EJCBreadcrumb\"," +
						"      \"nid\": \"nid_"+IdWorker.getId()+"_5158\"," +
						"      \"children\": [" +
						"        {" +
						"          \"uitype\": \"EJCBreadcrumbItem\"," +
						"          \"uititle\": \""+pageName+"\"," +
						"          \"key\": 1591858271953," +
						"          \"uikey\": \"K"+IdWorker.getId()+"\"," +
						"          \"children\": \""+pageName+"\"," +
						"          \"nid\": \"nid_"+IdWorker.getId()+"_5156\"" +
						"        }," +
						"        {" +
						"          \"uitype\": \"EJCBreadcrumbItem\"," +
						"          \"uititle\": \"详情\"," +
						"          \"key\": 1591858273111," +
						"          \"uikey\": \"K"+IdWorker.getId()+"\"," +
						"          \"children\": \"详情\"," +
						"          \"nid\": \"nid_"+IdWorker.getId()+"_5157\"" +
						"        }" +
						"      ]," +
						"      \"uikey\": \"K"+IdWorker.getId()+"\"," +
						"      \"separator\": \">\"" +
						"    }," +
						"{"+
						"\"uititle\":\"右侧审批面板\","+
						"\"uitype\":\"EJCRightBpmPanel\","+
						"\"nid\":\"nid_1647664365234_6790\","+
						"\"uikey\":\"rightBpmPanel\","+
						"      \"children\": [" +
						"    {" +
						"      \"uititle\": \"工具栏\"," +
						"      \"uitype\": \"EJCToolbar\"," +
						"      \"align\": \"right\"," +
						"      \"nid\": \"nid_"+IdWorker.getId()+"_125\"," +
						"      \"children\": [" +
						"        {" +
						"          \"uititle\": \"保存\"," +
						"          \"uitype\": \"EJCButton\"," +
						"          \"nid\": \"nid_"+IdWorker.getId()+"_126\"," +
						"          \"children\": \"保存\"," +
						"          \"uikey\": \"saveBtn\"," +
						"          \"type\": \"primary\"," +
						"          \"icon\": \"book\"," +
						"          \"visible\": false" +
						"        }," +
						"        {" +
						"          \"uititle\": \"取消\"," +
						"          \"uitype\": \"EJCButton\"," +
						"          \"nid\": \"nid_"+IdWorker.getId()+"_1157\"," +
						"          \"children\": \"取消\"," +
						"          \"uikey\": \"cancelBtn\"," +
						"          \"type\": \"primary\"," +
						"          \"ghost\": true," +
						"          \"icon\": \"cross-circle-o\"," +
						"          \"visible\": false" +
						"        }," +
						"        {" +
						"          \"uititle\": \"修改\"," +
						"          \"uitype\": \"EJCButton\"," +
						"          \"nid\": \"nid_"+IdWorker.getId()+"_129\"," +
						"          \"children\": \"修改\"," +
						"          \"uikey\": \"editBtn\"," +
						"          \"type\": \"primary\"," +
						"          \"ghost\": true," +
						"          \"icon\": \"edit\"," +
						"          \"visible\": false" +
						"        }," +
						"        {" +
						"          \"uititle\": \"打印\"," +
						"          \"uitype\": \"EJCPrintButton\"," +
						"          \"nid\": \"nid_"+IdWorker.getId()+"_130\"," +
						"          \"uikey\": \"printBtn\"," +
						"          \"ghost\": true," +
						"          \"type\": \"primary\"," +
						"          \"enableOrg\": true," +
						"          \"title\": \"打印\"" +
						"        }," +
						"        {" +
						"          \"uititle\": \"附件管理\"," +
						"          \"uitype\": \"AttachMgrWidget\"," +
						"          \"nid\": \"nid_"+IdWorker.getId()+"_8243\"," +
						"          \"uikey\": \"attachMgr\"," +
						"          \"align\": \"right\"," +
						"          \"btnType\": \"primary\"," +
						"          \"btnGhost\": true," +
						"          \"fileLengthVisible\": true," +
						"          \"multiple\": true," +
						"          \"sourceType\": \"attachMgr\"" +
						"        }," +
						"        {" +
						"          \"uititle\": \"提交\"," +
						"          \"uitype\": \"BpmSubmitButton\"," +
						"          \"nid\": \"nid_"+IdWorker.getId()+"_313\"," +
						"          \"uikey\": \"bpmSubmitBtn\"," +
						"          \"enableUser\": true," +
						"          \"type\": \"primary\"," +
						"          \"ghost\": true," +
						"          \"orgField\": \"orgId\"," +
						"          \"visible\": false" +
						"        }," +
						"        {" +
						"          \"uititle\": \"删除\"," +
						"          \"uitype\": \"EJCButton\"," +
						"          \"nid\": \"nid_"+IdWorker.getId()+"_153\"," +
						"          \"children\": \"删除\"," +
						"          \"uikey\": \"removeBtn\"," +
						"          \"type\": \"error\"," +
						"          \"icon\": \"delete\"," +
						"          \"ghost\": true," +
						"          \"visible\": false" +
						"        }," +
						"        {" +
						"          \"uititle\": \"撤回\"," +
						"          \"uitype\": \"EJCButton\"," +
						"          \"nid\": \"nid_"+IdWorker.getId()+"_478\"," +
						"          \"children\": \"撤回\"," +
						"          \"uikey\": \"callBackBtn\"," +
						"          \"type\": \"primary\"," +
						"          \"ghost\": true," +
						"          \"icon\": \"export\"," +
						"          \"visible\": false" +
						"        }" +
						"      ]" +
						"    }," +
						"    {" +
						"      \"uititle\": \"基本信息\"," +
						"      \"uitype\": \"EJCPanel\"," +
						"      \"nid\": \"nid_"+IdWorker.getId()+"_4941\"," +
						"      \"uikey\": \"K"+IdWorker.getId()+"\"," +
						"      \"title\": \"基本信息\"," +
						"      \"expandText\": \"收起\"," +
						"      \"collapseText\": \"展开\"," +
						"      \"children\": [" +
						"        {" +
						"          \"uititle\": \"表单-基本信息\"," +
						"          \"uitype\": \"FormWidget\"," +
						"          \"nid\": \"nid_"+IdWorker.getId()+"_6356\"," +
						"          \"colnumber\": 4," +
						"          \"children\": []," +
						"          \"uikey\": \"baseForm\"," +
						"          \"labelCol\": {" +
						"            \"span\": 6" +
						"          }," +
						"          \"wrapperCol\": {" +
						"            \"span\": 14" +
						"          }," +
						"          \"dataprops\": {}" +
						"        }" +
						"       ]" +
						"     },{\n" +
						"      	 \"uititle\": \"单据审计\",\n" +
						"     	 \"uitype\": \"CPAuditInfo\",\n" +
						"      	 \"nid\": \"nid_"+IdWorker.getId()+"_65\",\n" +
						"        \"uikey\": \"K"+IdWorker.getId()+"\"," +
						"        \"enTitle\": \"\",\n" +
						"        \"primaryKey\": \"id\"\n" +
						"     }" +
						"   ]" +
						"  }"+
						" ]," +
						"  \"nid\": \"nid_"+IdWorker.getId()+"_106\"," +
						"  \"dataprops\": {}," +
						"  \"themeClassName\": \"EJC\"" +
						"}";
				break;
			case "pageList":
				data = "{" +
						"    \"children\": [\n" +
						"        {\n" +
						"            \"children\": [\n" +
						"                {\n" +
						"                    \"children\": \""+pageName+"\",\n" +
						"                    \"key\": "+IdWorker.getId()+",\n" +
						"                    \"nid\": \"nid_"+IdWorker.getId()+"_3331\",\n" +
						"                    \"uikey\": \""+IdWorker.getId()+"\",\n" +
						"                    \"uititle\": \""+pageName+"\",\n" +
						"                    \"uitype\": \"EJCBreadcrumbItem\"\n" +
						"                },\n" +
						"                {\n" +
						"                    \"children\": \"列表\",\n" +
						"                    \"key\": "+IdWorker.getId()+",\n" +
						"                    \"nid\": \"nid_"+IdWorker.getId()+"_8\",\n" +
						"                    \"uikey\": \""+IdWorker.getId()+"\",\n" +
						"                    \"uititle\": \"列表\",\n" +
						"                    \"uitype\": \"EJCBreadcrumbItem\"\n" +
						"                }\n" +
						"            ],\n" +
						"            \"hideBack\": false,\n" +
						"            \"hideBillCode\": false,\n" +
						"            \"hideBillStatus\": false,\n" +
						"            \"nid\": \"nid_"+IdWorker.getId()+"_3328\",\n" +
						"            \"noshowadd\": false,\n" +
						"            \"separator\": \"/\",\n" +
						"            \"uikey\": \"\",\n" +
						"            \"uititle\": \"面包屑\",\n" +
						"            \"uitype\": \"EJCBreadcrumb\"\n" +
						"        },\n" +
						"        {\n" +
						"            \"btnsTop\": false,\n" +
						"            \"multiSelect\": true,\n" +
						"            \"nid\": \"nid_"+IdWorker.getId()+"_8\",\n" +
						"            \"notCeiling\": false,\n" +
						"            \"orderBtn\": true,\n" +
						"            \"rowHidden\": false,\n" +
						"            \"searchButtonText\": \"搜索\",\n" +
						"            \"searchPlaceholder\": \"请输入关键字查询\",\n" +
						"            \"showSearch\": true,\n" +
						"            \"sortGroupList\": [\n" +
						"                {\n" +
						"                    \"field\": \"createTime\",\n" +
						"                    \"name\": \"创建时间\",\n" +
						"                    \"sequence\": 1\n" +
						"                }\n" +
						"            ],\n" +
						"      		 \"filterItems\": [\n" +
						"        			{\n" +
						"         			  \"rowKey\": \"billState\",\n" +
						"        			  \"inputType\": \"selfDefine\",\n" +
						"        			  \"referCode\": null,\n" +
						"         			  \"title\": \"单据状态\",\n" +
						"           		  \"activekeys\": [],\n" +
						"        			  \"fields\": [\n" +
						"        			    {\n" +
						"          			     \"value\": \"0\",\n" +
						"         			     \"text\": \"自由态\"\n" +
						"         			   },\n" +
						"         			   {\n" +
						"         			     \"value\": \"2,5\",\n" +
						"          			     \"text\": \"审批中\"\n" +
						"          			   },\n" +
						"          			   {\n" +
						"           		    \"value\": \"1\",\n" +
						"          			    \"text\": \"已提交\"\n" +
						"          			   },\n" +
						"          			   {\n" +
						"        		        \"value\": \"3\",\n" +
						"         		        \"text\": \"审批通过\"\n" +
						"         			   },\n" +
						"         			   {\n" +
						"         			     \"value\": \"4,6\",\n" +
						"         			     \"text\": \"审批驳回\"\n" +
						"        			    }\n" +
						"        		  ]\n" +
						"       		 }\n" +
						"      		 ],\n" +
						"            \"uikey\": \"filterBar\",\n" +
						"            \"uititle\": \"筛选栏\",\n" +
						"            \"uitype\": \"EJCFilterArea\"\n" +
						"        },\n" +
						"        {\n" +
						"            \"bordered\": true,\n" +
						"            \"checkable\": false,\n" +
						"            \"children\": [\n" +
						"                {\n" +
						"                    \"dataIndex\": \"code\",\n" +
						"                    \"key\": \"code\",\n" +
						"                    \"nid\": \"nid_"+IdWorker.getId()+"\",\n" +
						"                    \"title\": \"单据编码\",\n" +
						"                    \"uikey\": \"code\",\n" +
						"                    \"uititle\": \"单据编码\",\n" +
						"                    \"uitype\": \"EJCTableCol\"\n" +
						"                }\n" +
						"            ],\n" +
						"            \"maxHeight\": 440,\n" +
						"            \"nid\": \"nid_"+IdWorker.getId()+"_971\",\n" +
						"            \"rowKey\": \"id\",\n" +
						"            \"showRowNum\": true,\n" +
						"            \"uikey\": \"CPListTable\",\n" +
						"            \"uititle\": \"数据表格\",\n" +
						"            \"uitype\": \"TableWidget\"\n" +
						"        },\n" +
						"        {\n" +
						"            \"uititle\": \"插件管理\",\n" +
						"            \"uitype\": \"CPPluginMgr\",\n" +
						"            \"nid\": \"nid_"+IdWorker.getId()+"_8\",\n" +
						"            \"uikey\": \"listPlugin\",\n" +
						"            \"exportExcel\": false,\n" +
						"            \"attachMgr\": false\n" +
						"        }\n" +
						"    ],\n" +
						"    \"dataprops\": {},\n" +
						"    \"nid\": \"nid_"+IdWorker.getId()+"_755\",\n" +
						"    \"themeClassName\": \"EJC\",\n" +
						"    \"uikey\": \"pageList\",\n" +
						"    \"uititle\": \""+pageName+"\",\n" +
						"    \"uitype\": \"EJCPage\"\n" +
						"}";
				break;
			case "listCardPage":
				/** 卡片列表 */
				data = "{\n" +
						"  \"uikey\": \"CPListPage\",\n" +
						"  \"uititle\": \""+pageName+"列表\",\n" +
						"  \"uitype\": \"CPListPage\",\n" +
						"  \"nid\": \"nid_"+IdWorker.getId()+"_5\",\n" +
						"  \"children\": [\n" +
						"    {\n" +
						"      \"uititle\": \"面包屑\",\n" +
						"      \"uitype\": \"EJCBreadcrumb\",\n" +
						"      \"nid\": \"nid_"+IdWorker.getId()+"_2\",\n" +
						"      \"children\": [\n" +
						"        {\n" +
						"          \"uitype\": \"EJCBreadcrumbItem\",\n" +
						"          \"uititle\": \""+pageName+"\",\n" +
						"          \"key\": 1591858544356,\n" +
						"          \"uikey\": \"1591858544356\",\n" +
						"          \"children\": \""+pageName+"\",\n" +
						"          \"nid\": \"nid_"+IdWorker.getId()+"_5\",\n" +
						"          \"enTitle\": \"\"\n" +
						"        },\n" +
						"        {\n" +
						"          \"uitype\": \"EJCBreadcrumbItem\",\n" +
						"          \"uititle\": \"列表\",\n" +
						"          \"key\": 1591858646983,\n" +
						"          \"uikey\": \"1591858646983\",\n" +
						"          \"children\": \"列表\",\n" +
						"          \"nid\": \"nid_"+IdWorker.getId()+"_7\"\n" +
						"        }\n" +
						"      ]\n" +
						"    },\n" +
						"    {\n" +
						"      \"uitype\": \"EJCFilterArea\",\n" +
						"      \"nid\": \"nid_"+IdWorker.getId()+"_2\",\n" +
						"      \"multiSelect\": true,\n" +
						"      \"showSearch\": true,\n" +
						"      \"rowHidden\": false,\n" +
						"      \"searchButtonText\": \"搜索\",\n" +
						"      \"orderBtn\": true,\n" +
						"      \"btnWrapperStyle\": {\n" +
						"        \"textAlign\": \"right\",\n" +
						"        \"marginBottom\": \"0px\",\n" +
						"        \"paddingBottom\": \"5px\"\n" +
						"      },\n" +
						"      \"sortGroupList\": [\n" +
						"        {\n" +
						"          \"field\": \"createTime\",\n" +
						"          \"name\": \"创建时间\",\n" +
						"          \"sequence\": 1\n" +
						"        }\n" +
						"      ],\n" +
						"      \"children\": [\n" +
						"        {\n" +
						"          \"uititle\": \"新建\",\n" +
						"          \"uitype\": \"EJCButton\",\n" +
						"          \"nid\": \"nid_"+IdWorker.getId()+"_2\",\n" +
						"          \"children\": \"新建\",\n" +
						"          \"style\": {\n" +
						"            \"float\": \"left\",\n" +
						"            \"borderRadius\": \"4px\"\n" +
						"          },\n" +
						"          \"uikey\": \"addBtn\",\n" +
						"          \"type\": \"primary\",\n" +
						"          \"icon\": \"plus\",\n" +
						"          \"textButton\": false\n" +
						"        },\n" +
						"        {\n" +
						"          \"uititle\": \"导出\",\n" +
						"          \"uitype\": \"EJCButton\",\n" +
						"          \"nid\": \"nid_"+IdWorker.getId()+"_5\",\n" +
						"          \"children\": \"导出\",\n" +
						"          \"style\": {\n" +
						"            \"float\": \"left\",\n" +
						"            \"borderRadius\": \"4px\"\n" +
						"          },\n" +
						"          \"uikey\": \"exportBtn\",\n" +
						"          \"type\": \"primary\",\n" +
						"          \"ghost\": true,\n" +
						"          \"icon\": \"upload\"\n" +
						"        }\n" +
						"      ],\n" +
						"      \"uikey\": \"listViewFilter\",\n" +
						"      \"uititle\": \"筛选栏\",\n" +
						"      \"filterItems\": [\n" +
						"        {\n" +
						"          \"rowKey\": \"billState\",\n" +
						"          \"inputType\": \"selfDefine\",\n" +
						"          \"referCode\": null,\n" +
						"          \"title\": \"单据状态\",\n" +
						"          \"activekeys\": [],\n" +
						"          \"fields\": [\n" +
						"            {\n" +
						"              \"value\": \"0\",\n" +
						"              \"text\": \"自由态\"\n" +
						"            },\n" +
						"            {\n" +
						"              \"value\": \"2,5\",\n" +
						"              \"text\": \"审批中\"\n" +
						"            },\n" +
						"            {\n" +
						"              \"value\": \"1\",\n" +
						"              \"text\": \"已提交\"\n" +
						"            },\n" +
						"            {\n" +
						"              \"value\": \"3\",\n" +
						"              \"text\": \"审批通过\"\n" +
						"            },\n" +
						"            {\n" +
						"              \"value\": \"4,6\",\n" +
						"              \"text\": \"审批驳回\"\n" +
						"            }\n" +
						"          ]\n" +
						"        }\n" +
						"      ],\n" +
						"      \"searchPlaceholder\": \"请输入关键字查询\",\n" +
						"      \"className\": \"btnWrapper\",\n" +
						"      \"btnsTop\": false,\n" +
						"      \"notCeiling\": false\n" +
						"    },\n" +
						"    {\n" +
						"      \"uititle\": \"列表卡片视图\",\n" +
						"      \"uitype\": \"EjcListView\",\n" +
						"      \"nid\": \"nid_"+IdWorker.getId()+"_2\",\n" +
						"      \"uikey\": \"listView\",\n" +
						"      \"dataprops\": {},\n" +
						"      \"rowKey\": \"id\",\n" +
						"      \"headerBtn\": false,\n" +
						"      \"viewModeBtnVisible\": false\n" +
						"    },\n" +
						"    {\n" +
						"      \"uititle\": \"插件管理\",\n" +
						"      \"uitype\": \"CPPluginMgr\",\n" +
						"      \"nid\": \"nid_"+IdWorker.getId()+"_6661\",\n" +
						"      \"uikey\": \"CPPluginMgr\"\n" +
						"    }\n" +
						"  ],\n" +
						"  \"dataprops\": {},\n" +
						"  \"themeClassName\": \"GEJC\"\n" +
						"}";
				break;
			default:
				data = null;
		}
		return data;
	}

    @Override
    public void copyModule(IdeModule ideModule)  throws Exception{
        IdeModule ideModuleSrc = ideModuleRepo.findById(String.valueOf(ideModule.getId()));
        IdeModule ideModuleSave = new IdeModule();
        ideModuleSave.setId(IdWorker.getId());
        BeanUtils.copyProperties(ideModuleSrc, ideModuleSave, new String[]{"id","fromId","fromName","createId","createDate","name","modifyName"});
        ideModuleSave.setCreateId(ideModule.getCreateId());
        ideModuleSave.setCreateDate(new Date());
        ideModuleSave.setName(ideModule.getName());
        String code = ideCommonService.generateModuleCode();
        ideModuleSave.setCode(code);
        ideModuleSave.setAppId(ideModule.getAppId());
        ideModuleSave.setGroupId(ideModule.getGroupId());
        ideModuleSave.setFromId(ideModule.getFromId());
        ideModuleSave.setPageType(ideModule.getPageType());
        ideModuleSave.setFromName(ideModule.getFromName());
        ideModuleRepo.save(ideModuleSave);
    }

    @Override
    public IdeModule findByCode(String moduleCode) {
        List<IdeModule> ideModules = ideModuleRepo.findAllByCode(moduleCode);
        if(ideModules!=null&&ideModules.size()>0){
			return ideModules.get(0);
		}else{
			return null;
		}
    }
    @Override
    public List<IdeModule> findByAppId(String appId) throws Exception {
        List<IdeModule> ideModules = ideModuleRepo.findDetailsByAppId(appId);
        return ideModules;
    }
    @Override
    public List<IdeModule> findIsDeleteModules(String appId) throws Exception {
    	List<IdeModule> ideModules = ideModuleRepo.findModulesByAppId(appId,1);
    	return ideModules;
    }

    @Override
    public void deleteById(String id) throws Exception {
    	ideModuleRepo.deleteById(id);
    	ideModulePrivateRepo.deleteByModuleIds(id);
		IdeModuleData moduleData = moduleDataRepo.findByModuleId(Long.parseLong(id));
		if (moduleData != null) {
			moduleDataRepo.deleteById(moduleData);
		}
    }

    @Override
    public IdeModuleBo findById(String id) throws Exception {
    	IdeModuleBo ideModuleBo = ideModuleRepoImpl.findDetailById(id);
    	if (ideModuleBo==null){
    		throw new BusinessException("没有可备份的页面");
    	}
        return ideModuleBo;
    }
    
    @Override
    public IdeModule findEntityById(String id) {
        return ideModuleRepo.findById(id);
    }

    @Override
    public IdeModule findByAppCodeAndModuleCode(String appCode, String moduleCode)  {
		LOGGER.info("findByAppCodeAndModuleCode ======== {{}}---{{}}",appCode,moduleCode);
        return ideModuleRepo.findByAppCodeAndModuleCode(appCode,moduleCode);
    }
    @Override
	public Object findByAppCodeAndModuleCodeAndOrgId(String appCode, String pageCode, String orgId,String tenantId) {
    	IdeModulePrivate orgPage = null;
    	//存在组织Id则优先按按组织查找实例化后的页面
		if(StringUtils.isNotEmpty(orgId)&&StringUtils.isNotEmpty(tenantId)){
			orgPage = ideModulePrivateService.findByOrgId(pageCode, appCode, orgId,tenantId);
		}
		LOGGER.info("orgPage ======== "+orgPage);
		//存在当前组织的页面实例则直接返回
		if(orgPage !=null){
			return orgPage;
		}else{//否则查询界面设计器的原页面
			return this.findByAppCodeAndModuleCode(appCode, pageCode);
		}
	}
	@Override
	public void publishHistory(IdeModule ideModule,String fromName,String toName) {
		IdeModulePro module = new IdeModulePro();
		BeanUtils.copyProperties(ideModule, module, new String[]{"id","createDate","modifyDate"});
		module.setCreateDate(new Date());//发布时间
		module.setFromName(fromName);
		module.setToName(toName);
		int maxVer = ideModuleProRepo.findMaxVersion(ideModule.getCode(),toName);
		maxVer = maxVer+1;
		module.setVerNum(maxVer);
		module.setId(IdWorker.getId());
		module.setCreateDate(new Date());
		ideModuleProRepo.save(module);
	}
	@Override
	public List<IdeModule> findInAppIds(String[] appIds) {
		List<IdeModule> modules = new ArrayList<>();
		if(appIds==null||appIds.length==0)return modules;
		String appIdStr = "'"+ org.apache.commons.lang.StringUtils.join(Arrays.asList(appIds),"','")+"'";
		modules = ideModuleRepo.findInAppIds(appIdStr);
		return modules;
	}
	@Override
	public List<IdeModule> findByGroupIds(String[] groupIds) {
		List<IdeModule> modules = new ArrayList<>();
		if(groupIds==null||groupIds.length==0)return modules;
		String groupIdStr = "'"+ org.apache.commons.lang.StringUtils.join(Arrays.asList(groupIds),"','")+"'";
		modules = ideModuleRepo.findByGroupIds(groupIdStr);
		return modules;
	}
	/**
	 * 作用在开发环境上，将数据发送给生产环境
	 */
	@Transactional
	@Override
	public JsonBackData syncPublishProduction(String appId, List<String> pageIds, String fromName, String toName)
			throws Exception {
		if (StringUtils.isEmpty(toName)) {
			return JsonBackData.toError("无法发布：发布目标地址不存在！");
		}
		if (pageIds == null || pageIds.size() == 0) {
			return JsonBackData.toError("无法发布：没有可发布的页面！");
		}
		// 查询已存在的应用和页面
		IdeApp app = ideAppService.findById(appId);
		if (app == null) {
			return JsonBackData.toError("发布的应用[" + appId + "]不存在，请刷新重试！");
		}
		// 获取应用所属团队信息
		IdeTeamBo team = null;
		// 如果发布的目标地址启用了白名单策略则验证本团队是否在白名单列表，如果不存在白名单中则不允许发布。
		if (app.getTeamId() != null) {
			if (!ideEnvironmentService.isInWhiteList(toName, String.valueOf(app.getTeamId()))) {
				return JsonBackData.toError("本团队被限制发布应用到[" + toName + "]环境，可联系超级管理员进行授权！");
			}
			IdeTeam teamBean = ideTeamRepo.findOne(String.valueOf(app.getTeamId()));
			if(teamBean!=null){
				team = new IdeTeamBo(teamBean);
			}
		}
		// 记录不存在的页面
		List<String> notExistPages = new ArrayList<String>();
		// 记录发失败的页面
		List<String> failPages = new ArrayList<String>();
		// 打包需要同步的应用和页面信息
		IdeProductionBo postData = new IdeProductionBo();
		postData.setIdeTeam(team);
		postData.setIdeApp(new IdeAppBo(app));
		postData.setFromName(fromName);
		postData.setToName(toName);
		List<IdeModule> publishModules = new ArrayList<IdeModule>();
		// 遍历同步发布页面
		for (String moduleId : pageIds) {
			IdeModule module = this.findEntityById(moduleId);
			if (module == null) {
				// 记录不存在的页面
				notExistPages.add(moduleId);
				continue;
			}
			module.setAppCode(app.getCode());
			publishModules.add(module);
		}
		//筛选出没发生改变的页面
		publishModules = ideModuleProService.findDiffLastPublish(publishModules, toName);
		if(publishModules.size()==0) {
			return JsonBackData.toSuccess("所发布页面与最新版本相同，无需重复发布");
		}
		for(IdeModule ideModule: publishModules) {
			// 追加存在的可发布的页面
			postData.getIdeModules().add(new IdeModuleBo(ideModule));
		}
		ObjectMapper mapper = new ObjectMapper();
		String postJson = mapper.writeValueAsString(postData);
		LOGGER.info("发送数据："+postJson);
		// 数据同步到目标服务器的数据库
		HttpResponse httpresponse = HttpClientUtil.postJSON(toName + Constant.PUBLISH_SYNC_URL, postJson);
		if (httpresponse == null) {
			return JsonBackData.toError("发布失败，目标服务器响应异常");
		}
		// 获取状态码
		int resCode = httpresponse.getStatusLine().getStatusCode();
		// 请求失败
		if (resCode != 200) {
			return JsonBackData.toError("发布失败，目标服务器异常，响应状态码：" + resCode);
		}
		// 请求成功，取到返回内容(JsonBackData对象)
		JSONObject resultObj = null;
		String result = EntityUtils.toString(httpresponse.getEntity());
		try {
			resultObj = (JSONObject) JSONObject.parse(result);
		} catch (Exception e) {
			// 解析不了的返回值直接return
			e.printStackTrace();
			return JsonBackData.toError(result);
		}
		// 返回数据
		JsonBackData jsonBackData = new JsonBackData();
		jsonBackData.setSuccess(resultObj.getBoolean("success"));
		jsonBackData.setBackData(resultObj.get("backData"));
		jsonBackData.setBackMsg(resultObj.getString("backMsg"));
		// 保存阿里云/本地环境
		if (jsonBackData.isSuccess()) {
			// 保存到发布历史记录
			for (IdeModule module : publishModules) {
				this.publishHistory(module, fromName, toName);
			}
			// 记录同步到目标服务器失败的页面
			ObjectMapper objectMapper = new ObjectMapper();
			failPages = objectMapper.readValue(objectMapper.writeValueAsString(jsonBackData.getBackData()),
					new TypeReference<ArrayList<String>>() {
					});
		} else {
			return jsonBackData;
		}
		if (notExistPages.size() > 0 || failPages.size() > 0) {
			Map<String, Object> backData = new HashMap<String, Object>();
			backData.put("notExist", notExistPages.size());
			backData.put("failPages", failPages);
			return JsonBackData.toSuccess("发布完成", backData);
		} else {
			return JsonBackData.toSuccess("发布成功");
		}
	}

	@Override
	public JSONObject getOnlineText(String appId, List<String> pageIds, String fromName, String toName) {
		if (StringUtils.isEmpty(toName)) {
			throw new BusinessException("无法发布：发布目标地址不存在！");
		}
		if (pageIds == null || pageIds.size() == 0) {
			throw new BusinessException("无法发布：没有可发布的页面！");
		}
		// 查询已存在的应用和页面
		IdeApp app = ideAppService.findById(appId);
		if (app == null) {
			throw new BusinessException("发布的应用[" + appId + "]不存在，请刷新重试！");
		}
		// 获取应用所属团队信息
		IdeTeamBo team = null;
		// 如果发布的目标地址启用了白名单策略则验证本团队是否在白名单列表，如果不存在白名单中则不允许发布。
		if (app.getTeamId() != null) {
			if (!ideEnvironmentService.isInWhiteList(toName, String.valueOf(app.getTeamId()))) {
				throw new BusinessException("本团队被限制发布应用到[" + toName + "]环境，可联系超级管理员进行授权！");
			}
			IdeTeam teamBean = ideTeamRepo.findOne(String.valueOf(app.getTeamId()));
			if(teamBean!=null){
				team = new IdeTeamBo(teamBean);
			}
		}
		// 记录不存在的页面
		// 记录发失败的页面
		List<String> failPages = new ArrayList<String>();
		// 打包需要同步的应用和页面信息
		IdeProductionBo postData = new IdeProductionBo();
		postData.setIdeTeam(team);
		postData.setIdeApp(new IdeAppBo(app));
		postData.setFromName(fromName);
		postData.setToName(toName);
		List<IdeModule> publishModules = new ArrayList<IdeModule>();
		// 遍历同步发布页面
		for (String moduleId : pageIds) {
			IdeModule module = this.findEntityById(moduleId);
			module.setAppCode(app.getCode());
			publishModules.add(module);
		}
		for(IdeModule ideModule: publishModules) {
			// 追加存在的可发布的页面
			postData.getIdeModules().add(new IdeModuleBo(ideModule));
		}
		String postJson = JSONObject.toJSONString(postData);
		JSONObject res= new JSONObject();
		res.put("version", "移动设计器上线版本:"+ DateFormatUtil.formatDate(DateFormatUtil.PATTERN_DEFAULT_ON_SECOND,new Date()) +".txt");
		res.put("textContent", postJson);
		return res;
	}

	/**
	 * 作用在生产环境上 只被生产环境的接收同步请求的接口调用
	 */
	@Transactional
	@Override
	public JsonBackData syncReciveProduction(IdeProductionBo production) throws Exception {
		LOGGER.info("接收数据："+JSONObject.toJSONString(production));
		// 获取团队
		IdeTeamBo teamBo = production.getIdeTeam();
		IdeTeam ideTeam = null;
		if(teamBo!=null){
			ideTeam = ideTeamRepo.findOne(teamBo.getId());
			if(ideTeam==null){
				ideTeam = new IdeTeam();
				BeanUtils.copyProperties(teamBo, ideTeam, "modifyDate");
				ideTeam.setId(Long.parseLong(teamBo.getId()));
				LOGGER.info("ideTeam==null 没找到新建team："+JSONObject.toJSONString(ideTeam));
				ideTeamRepo.save(ideTeam);
			}else {
				BeanUtils.copyProperties(teamBo, ideTeam, "modifyDate");
				LOGGER.info("找到team,更新："+JSONObject.toJSONString(ideTeam));
				ideTeamRepo.update(ideTeam);
			}
		}
		// 获取应用
		IdeAppBo appBo = production.getIdeApp();
		// 更新应用
		IdeApp ideApp = ideAppRepo.findById(appBo.getId());
		if(ideApp!=null){
			BeanUtils.copyProperties(appBo, ideApp );
			ideApp.setTeamId(Long.parseLong(appBo.getTeamId()));
			if(StringUtils.isNotEmpty(appBo.getGroupId()) && !Objects.equals(appBo.getGroupId(),"null")){
				ideApp.setGroupId(Long.parseLong(appBo.getGroupId()));
			}
			LOGGER.info("找到ideApp，更新："+JSONObject.toJSONString(ideApp));
			ideAppRepo.update(ideApp);
		}else {
			ideApp = new IdeApp();
			BeanUtils.copyProperties(appBo, ideApp, new String[]{"modifyDate"});
			ideApp.setId(Long.parseLong(appBo.getId()));
			ideApp.setTeamId(Long.parseLong(appBo.getTeamId()));
			if(StringUtils.isNotEmpty(appBo.getGroupId()) && !Objects.equals(appBo.getGroupId(),"null")){
				ideApp.setGroupId(Long.parseLong(appBo.getGroupId()));
			}
			LOGGER.info("没找到ideApp，新建："+JSONObject.toJSONString(ideApp));
			ideAppRepo.save(ideApp);
		}
		// 获取页面
		List<IdeModuleBo> moduleBos = production.getIdeModules();
		List<IdeModule> updatedPages = new ArrayList<>();
		LOGGER.info("接收到页面："+JSONObject.toJSONString(moduleBos));
		// 记录发布失败的页面
		List<String> failPages = new ArrayList<>();
		// 更新页面
		if(moduleBos!=null&&moduleBos.size()>0){
			for(IdeModuleBo moduleBo:moduleBos){
				try{
					IdeModule ideModule = ideModuleRepo.findById(moduleBo.getId());
					if(ideModule==null || ideModule.getId()==null){
						ideModule=new IdeModule();
						BeanUtils.copyProperties(moduleBo, ideModule, new String[]{ "modifyDate"});
						ideModule.setId(Long.parseLong(moduleBo.getId()));
						ideModule.setAppId(Long.parseLong(moduleBo.getAppId()));
						if(StringUtils.isNotEmpty(moduleBo.getGroupId()) && !Objects.equals(moduleBo.getGroupId(),"null")){
							ideModule.setGroupId(Long.parseLong(moduleBo.getGroupId()));
						}
						LOGGER.info("寻找页面：pageCode"+moduleBo.getCode()+" AppID："+ideApp.getId()+" 结果:没找到，新建："+JSONObject.toJSONString(ideModule));
						ideModuleRepo.save(ideModule);
					}else {
						BeanUtils.copyProperties(moduleBo, ideModule, new String[]{ "modifyDate"});
						ideModule.setAppId(Long.parseLong(moduleBo.getAppId()));
						if(StringUtils.isNotEmpty(moduleBo.getGroupId()) && !Objects.equals(moduleBo.getGroupId(),"null")){
							ideModule.setGroupId(Long.parseLong(moduleBo.getGroupId()));
						}
						LOGGER.info("寻找页面：pageCode"+moduleBo.getCode()+" AppID："+ideApp.getId()+" 结果找到了:更新"+JSONObject.toJSONString(ideModule));
						ideModuleRepo.update(ideModule);
						LOGGER.info("删除发布页面缓存：pageCode"+moduleBo.getCode()+" AppCode："+moduleBo.getAppCode());
						LOGGER.info("从缓存删除页面数据！发布页面{}---{}---{}",moduleBo.getAppCode(), moduleBo.getCode(), null);
						ideModulePageCache.removeModulePageCache(moduleBo.getAppCode(),moduleBo.getCode(),null);
						ideModule.setAppCode(ideApp.getCode());
						updatedPages.add(ideModule);
					}
					// 保存到发布历史记录
					LOGGER.info("保存到发布历史记录....." );
					this.publishHistory(ideModule,production.getFromName(),production.getToName());
					LOGGER.info("保存到发布历史记录.....成功" );
				}catch(Exception e){
					e.printStackTrace();
					LOGGER.error("发布失败："+e.getMessage()+"  页面：["+moduleBo.getCode()+"]"+moduleBo.getName());
					failPages.add("["+moduleBo.getCode()+"]"+moduleBo.getName());
				}
			}
			LOGGER.info("即将起动页面节点增量分析线程，处理页面新增节点问题......." );
			updatePrivatePage(updatedPages);
		}
		return JsonBackData.toSuccess("发布成功",failPages);
	}

	public void updatePrivatePage(List<IdeModule> pages){
		Thread runnable = new Thread(() -> {
			LOGGER.info("1、页面节点增量分析线程启动.....");
			for (IdeModule page : pages) {
				LOGGER.info("2、页面节点增量分析线程  page ={},{}",page.getCode(), page.getAppCode());
				List<IdeModulePrivate> privates = ideModulePrivateService.findByPageCodeAndAppCode(page.getCode(), page.getAppCode());
				if (ListUtil.isNotEmpty(privates)) {
					JsonObject baseData = gson.fromJson(page.getData(),JsonObject.class);
					for (IdeModulePrivate aPrivate : privates) {
						JsonObject provData = gson.fromJson(aPrivate.getData(),JsonObject.class);
						LOGGER.info("3、页面节点增量分析线程 {}{} baseData ={},provData={},",page.getCode(), page.getAppCode(),baseData,provData);
						JsonArray baseChildren = baseData.getAsJsonArray("children");
						JsonArray provChildren = provData.getAsJsonArray("children");
						processChildren(baseChildren,provChildren);
						aPrivate.setData(provData.toString());
						LOGGER.info("4、页面节点增量分析线程 保存私有化页面....{}",provData.toString());
						ideModulePrivateService.saveData(aPrivate);
						LOGGER.info("5、页面节点增量分析线程从缓存删除页面数据！私有化页面{}---{}---{}",aPrivate.getAppCode(), aPrivate.getCode(), aPrivate.getOrgId());
						ideModulePageCache.removeModulePageCache(aPrivate.getAppCode(),aPrivate.getCode(),aPrivate.getOrgId()+"");
					}
				}else {
					LOGGER.info("6、页面节点增量分析线程没有私有化页面---{}---{}",page.getAppCode(), page.getCode());
				}
			}
			LOGGER.info("7、.....页面节点增量分析线程执行完毕！");
		});
		runnable.start();
	}

	private static void processChildren(JsonArray baseChildren,JsonArray provChildren){
		if(baseChildren!=null && baseChildren.size() > 0){
			LOGGER.info("baseChildren ={},provChildren={}",baseChildren, provChildren);
			for (JsonElement child : baseChildren) {
				JsonObject base = (JsonObject)child;
				JsonObject provP = null;
				boolean exist = false;
				for (Object provChild : provChildren) {
					JsonObject prov = (JsonObject)provChild;
					if(Objects.equals(prov.get("nid"),base.get("nid"))){
						exist = true;
						provP = prov;
						break;
					}
				}
				if(exist){
					/** 存在，判断类型是否一致，不一致，用base覆盖直接覆盖原有的,一致，继续处理其下子组件*/
					if(!Objects.equals(base.get("uitype"),provP.get("uitype")) || !Objects.equals(base.get("uisubtype"),provP.get("uisubtype"))){
						provChildren.remove(provP);
						base.add("uititle",provP.get("uititle"));
						base.add("label",provP.get("label"));
						provChildren.add(base);
						LOGGER.info("存在，类型不同，替换 私有："+provP+"  新的："+base);
					}else {
						Object baseObj = base.get("children");
						if (baseObj instanceof JsonArray) {
							JsonArray baseChild = base.getAsJsonArray("children");
							JsonArray provChild = provP.getAsJsonArray("children");
							/** 私有化没有子组件，添加上去 */
							if(baseChild!=null && baseChild.size() > 0 && (provChild==null || provChild.size() == 0)){
								LOGGER.info("子组件children不存在，添加 私有："+provP+"  新的："+base);
								provP.add("children",baseChild);
							}else {
								processChildren(baseChild,provChild);
							}
						}
					}
				}else {
					LOGGER.info("不存在，则添加节点 {} {}",base,provChildren);
					provChildren.add(base);
				}
			}
		}
	}

	public static void main(String[] args) {
		String jsonBase = "{\"uikey\":\"M1366649681864491011\",\"uititle\":\"物资总计划详情\",\"uitype\":\"EJCPage\",\"themeClassName\":\"GEJC\",\"children\":[{\"uititle\":\"面包屑1\",\"uitype\":\"EJCBreadcrumb\",\"nid\":\"nid_1614669667403_29066\",\"uikey\":\"K1614669667403\",\"children\":[{\"uitype\":\"EJCBreadcrumbItem\",\"uititle\":\"物资总计划\",\"key\":1614669688705,\"uikey\":\"1614669688705\",\"children\":\"物资总计划\",\"nid\":\"nid_1614669688706_29068\",\"href\":\"/materialMasterPlan\"},{\"uitype\":\"EJCBreadcrumbItem\",\"uititle\":\"详情\",\"key\":1614669689688,\"uikey\":\"1614669689688\",\"children\":\"详情\",\"nid\":\"nid_1614669689688_29069\"}]},{\"uititle\":\"工具栏2\",\"uitype\":\"EJCToolbar\",\"nid\":\"nid_1614669845851_29082\",\"uikey\":\"K1614669845851\",\"children\":[{\"uititle\":\"保存\",\"uitype\":\"EJCButton\",\"nid\":\"nid_1614669850964_29087\",\"children\":\"保存\",\"uikey\":\"saveBtn\",\"type\":\"primary\",\"icon\":\"book\"},{\"uititle\":\"取消\",\"uitype\":\"EJCButton\",\"nid\":\"nid_1614669981594_29665\",\"children\":\"取消\",\"uikey\":\"cancelBtn\",\"icon\":\"cross-circle-o\",\"type\":\"primary\",\"ghost\":true},{\"uititle\":\"编辑\",\"uitype\":\"EJCButton\",\"nid\":\"nid_1614669889638_29262\",\"children\":\"编辑\",\"uikey\":\"editBtn\",\"icon\":\"edit\",\"type\":\"primary\",\"ghost\":true},{\"uititle\":\"打印\",\"uitype\":\"EJCPrintButton\",\"nid\":\"nid_1614670134241_29978\",\"uikey\":\"printBtn\",\"title\":\"打印\",\"enableOrg\":true,\"ghost\":true,\"type\":\"primary\",\"billName\":\"物资总计划\",\"billType\":\"BT210302000000004\"},{\"uititle\":\"审批相关\",\"uitype\":\"BpmApproveWidget\",\"nid\":\"nid_1614670194343_30093\",\"uikey\":\"bpmApprove\",\"enableUser\":true,\"enableOrg\":true,\"type\":\"primary\",\"ghost\":true,\"visible\":false,\"billName\":\"物资总计划\",\"billTypeId\":\"BT210302000000004\",\"billId\":\"421761164495814725\"},{\"uititle\":\"附件管理\",\"uitype\":\"AttachMgrWidget\",\"nid\":\"nid_1614670255184_30208\",\"uikey\":\"attachMgr\",\"btnType\":\"primary\",\"btnGhost\":true,\"align\":\"right\",\"billTypeId\":\"421761164495814725\",\"billTypeName\":\"物资总计划\",\"billType\":\"BT210302000000004\",\"sourceType\":\"materPlan001\",\"orgIdField\":\"orgId\",\"enTitle\":\"\",\"multiple\":false,\"fileLengthVisible\":true},{\"uititle\":\"提交\",\"uitype\":\"BpmSubmitButton\",\"nid\":\"nid_1614670277964_30257\",\"uikey\":\"bpmSubmitBtn\",\"enableUser\":true,\"type\":\"primary\",\"ghost\":true,\"visible\":false,\"billName\":\"物资总计划\",\"billRefId\":\"421761164495814725\",\"billTypeId\":\"BT210302000000004\",\"orgField\":\"orgId\",\"codeField\":\"{projectName}—物资总计划\",\"enTitle\":\"\"},{\"uititle\":\"撤回\",\"uitype\":\"EJCButton\",\"nid\":\"nid_1614670305087_30284\",\"children\":\"撤回\",\"uikey\":\"callBackBtn\",\"type\":\"primary\",\"ghost\":true,\"visible\":false},{\"uititle\":\"删除\",\"uitype\":\"EJCButton\",\"nid\":\"nid_1614670334900_30427\",\"children\":\"删除\",\"uikey\":\"removeBtn\",\"type\":\"error\",\"ghost\":true,\"icon\":\"delete\"},{\"uititle\":\"返回列表\",\"uitype\":\"EJCButton\",\"nid\":\"nid_1614670336614_30431\",\"children\":\"返回列表\",\"uikey\":\"goBackBtn\",\"ghost\":true,\"type\":\"primary\"}]},{\"uititle\":\"基本信息\",\"uitype\":\"EJCPanel\",\"nid\":\"nid_1614670464935_30978\",\"uikey\":\"K1614670464935\",\"title\":\"基本信息\",\"expandText\":\"收起\",\"collapseText\":\"展开\",\"children\":[{\"uititle\":\"表单2\",\"uitype\":\"FormWidget\",\"nid\":\"nid_1614673555088_111002\",\"colnumber\":3,\"uikey\":\"baseForm\",\"dataprops\":{},\"children\":[{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"inputrefer\",\"label\":\"项目名称（修改）\",\"uikey\":\"projectId\",\"uititle\":\"项目名称（修改）\",\"nid\":\"nid_1614673564425_111007\",\"labelCol\":{\"span\":6},\"wrapperCol\":{\"span\":14},\"subTableKey\":\"\",\"subTableColKey\":\"\",\"refinfokey\":\"market-project-refer-list\",\"refName\":\"项目登记参照\",\"refId\":\"320519315475660894\",\"referCode\":{\"code\":\"market-project-refer-list\",\"name\":\"项目登记参照\",\"id\":\"320519315475660894\"},\"required\":true,\"enTitle\":\"\",\"linkName\":\"新页签\"},{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"input\",\"label\":\"计划编码\",\"propsIndex\":2,\"uikey\":\"planCode\",\"uititle\":\"计划编码\",\"nid\":\"nid_1614673564935_111012\",\"formLabelCol\":{\"span\":6},\"formWrapperCol\":{\"span\":14},\"subTableKey\":\"\",\"subTableColKey\":\"\",\"labelCol\":{\"span\":6},\"wrapperCol\":{\"span\":14},\"maxLength\":\"30\",\"placeholder\":\"置空系统自动生成\"},{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"currency\",\"label\":\"总计划金额\",\"uikey\":\"totalPlanAmt\",\"uititle\":\"总计划金额\",\"nid\":\"nid_1614673565538_111017\",\"labelCol\":{\"span\":6},\"wrapperCol\":{\"span\":15},\"subTableKey\":\"\",\"subTableColKey\":\"\",\"decimal\":8,\"symbol\":\" \",\"subTableCalc\":false,\"showDecimal\":2,\"disabled\":true,\"placeholder\":\"由子表汇总\"},{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"input\",\"label\":\"备注\",\"uikey\":\"remark\",\"uititle\":\"备注\",\"nid\":\"nid_1614673632278_113045\",\"labelCol\":{\"span\":2},\"wrapperCol\":{\"span\":21},\"newline\":true,\"maxLength\":\"200\",\"autoTrim\":false,\"enTitle\":\"\",\"subTableKey\":\"\",\"subTableColKey\":\"\"},{\"uititle\":\"组件1\",\"uitype\":\"FormItemWidget\",\"nid\":\"nid_1676010621981_1182\",\"label\":\"组件1\",\"uisubtype\":\"input\",\"uikey\":\"K1676010621981\",\"subTableKey\":\"\",\"subTableColKey\":\"\",\"enTitle\":\"\",\"labelCol\":{\"span\":8},\"wrapperCol\":{\"span\":14},\"autoTrim\":false,\"required\":true},{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"input\",\"label\":\"文本框66\",\"propsIndex\":6,\"uikey\":\"K1676017473114\",\"uititle\":\"文本框66\",\"nid\":\"nid_1676017473115_215\",\"subTableKey\":\"\",\"subTableColKey\":\"\",\"enTitle\":\"\",\"labelCol\":{\"span\":8},\"wrapperCol\":{\"span\":14},\"autoTrim\":false}],\"labelCol\":{\"span\":6},\"wrapperCol\":{\"span\":14}}]},{\"uititle\":\"材料清单\",\"uitype\":\"EJCPanel\",\"nid\":\"nid_1614671008778_42433\",\"uikey\":\"K1614671008778\",\"title\":\"材料清单\",\"expandText\":\"收起\",\"collapseText\":\"展开\",\"children\":[{\"uititle\":\"工具栏1\",\"uitype\":\"EJCToolbar\",\"nid\":\"nid_1614671031450_42435\",\"uikey\":\"K1614671031450\",\"children\":[{\"uititle\":\"参照物资档案\",\"uitype\":\"EJCReferButton\",\"nid\":\"nid_1614671041124_42439\",\"buttonText\":\"参照物资档案\",\"uikey\":\"materialRefer\",\"ghost\":true,\"type\":\"primary\",\"refinfokey\":\"material-tree-grid\",\"refName\":\"物资参照\",\"refId\":\"320652154816954392\",\"multiselect\":true,\"often\":true,\"linkName\":\"新页签\"},{\"uititle\":\"引入预算\",\"uitype\":\"EJCReferButton\",\"nid\":\"nid_1632301956021_24\",\"buttonText\":\"引入预算\",\"uikey\":\"budgetRefer\",\"ghost\":true,\"type\":\"primary\",\"refinfokey\":\"BUDGET-REF-LIST\",\"refName\":\"预算参照\",\"refId\":\"495643151588540502\",\"multiselect\":true,\"linkName\":\"新页签\",\"enTitle\":\"\"},{\"uititle\":\"导入\",\"uitype\":\"EJCButton\",\"nid\":\"nid_1614671043215_42443\",\"children\":\"导入\",\"uikey\":\"excelImport\",\"type\":\"primary\",\"ghost\":true},{\"uititle\":\"删除\",\"uitype\":\"EJCButton\",\"nid\":\"nid_1614671045049_42447\",\"children\":\"删除\",\"uikey\":\"deleteRow\",\"type\":\"error\",\"ghost\":true}]},{\"uititle\":\"编辑表格2\",\"uitype\":\"EditTableWidget\",\"nid\":\"nid_1614671193216_43146\",\"uikey\":\"materialSubList\",\"children\":[{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"物资分类\",\"title\":\"物资分类\",\"uikey\":\"materialCategoryName\",\"key\":\"materialCategoryName\",\"dataIndex\":\"materialCategoryName\",\"nid\":\"nid_1614671202586_43148\",\"dataprops\":{},\"editable\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"物资名称\",\"title\":\"物资名称\",\"uikey\":\"materialName\",\"key\":\"materialName\",\"dataIndex\":\"materialName\",\"nid\":\"nid_1614671203709_43150\",\"dataprops\":{},\"editable\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"规格型号\",\"title\":\"规格型号\",\"uikey\":\"spec\",\"key\":\"spec\",\"dataIndex\":\"spec\",\"nid\":\"nid_1614671204236_43152\",\"dataprops\":{},\"editable\":false,\"enTitle\":\"\",\"autoTrim\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"计量单位\",\"title\":\"计量单位\",\"uikey\":\"unit\",\"key\":\"unit\",\"dataIndex\":\"unit\",\"nid\":\"nid_1614671204771_43154\",\"dataprops\":{},\"editable\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"currency\",\"uititle\":\"数量\",\"title\":\"数量\",\"uikey\":\"num\",\"key\":\"num\",\"dataIndex\":\"num\",\"nid\":\"nid_1614671209635_43156\",\"align\":\"left\",\"required\":true,\"dataprops\":{},\"commaVisible\":true,\"decimal\":8,\"symbol\":\" \",\"min\":\"0\",\"max\":\"999999999999\",\"showDecimal\":4,\"zeroFilling\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"currency\",\"uititle\":\"单价\",\"title\":\"单价\",\"uikey\":\"price\",\"key\":\"price\",\"dataIndex\":\"price\",\"nid\":\"nid_1614671211554_43158\",\"align\":\"left\",\"dataprops\":{},\"commaVisible\":true,\"decimal\":8,\"showDecimal\":4,\"symbol\":\" \",\"min\":\"0\",\"max\":\"999999999999\",\"zeroFilling\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"currency\",\"uititle\":\"金额\",\"title\":\"金额\",\"uikey\":\"amount\",\"key\":\"amount\",\"dataIndex\":\"amount\",\"nid\":\"nid_1614671212513_43160\",\"align\":\"left\",\"dataprops\":{},\"commaVisible\":true,\"decimal\":8,\"symbol\":\" \",\"showDecimal\":2,\"editable\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"物资分类Id\",\"title\":\"物资分类Id\",\"uikey\":\"materialCategoryId\",\"key\":\"materialCategoryId\",\"dataIndex\":\"materialCategoryId\",\"nid\":\"nid_1614843035426_1099\",\"dataprops\":{},\"isShow\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"物资Id\",\"title\":\"物资Id\",\"uikey\":\"materialId\",\"key\":\"materialId\",\"dataIndex\":\"materialId\",\"nid\":\"nid_1614843071288_3516\",\"dataprops\":{},\"isShow\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"物料来源类型\",\"title\":\"物料来源类型\",\"uikey\":\"sourceType\",\"key\":\"sourceType\",\"dataIndex\":\"sourceType\",\"nid\":\"nid_1614843124515_4916\",\"dataprops\":{},\"isShow\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"来自来源数据Id\",\"title\":\"来自来源数据Id\",\"uikey\":\"sourceId\",\"key\":\"sourceId\",\"dataIndex\":\"sourceId\",\"nid\":\"nid_1614843133912_4918\",\"dataprops\":{},\"isShow\":false}],\"rowKey\":\"id\",\"dataSource\":[],\"showRowNum\":true}]},{\"uititle\":\"历史版本\",\"uitype\":\"EJCPanel\",\"nid\":\"nid_1614671520907_75454\",\"uikey\":\"changeHisWrap\",\"title\":\"历史版本\",\"expandText\":\"收起\",\"collapseText\":\"展开\",\"children\":[{\"uititle\":\"历史版本表\",\"uitype\":\"EditTableWidget\",\"nid\":\"nid_1615289870685_4461\",\"uikey\":\"planChangeHisList\",\"rowKey\":\"id\",\"dataSource\":[],\"children\":[{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"历史版本编号\",\"title\":\"历史版本编号\",\"uikey\":\"planHisCode\",\"key\":\"planHisCode\",\"dataIndex\":\"planHisCode\",\"nid\":\"nid_1615289894505_4598\",\"dataprops\":{},\"editable\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"currency\",\"uititle\":\"原计划金额\",\"title\":\"原计划金额\",\"uikey\":\"originalPlanAmt\",\"key\":\"originalPlanAmt\",\"dataIndex\":\"originalPlanAmt\",\"nid\":\"nid_1615289895029_4600\",\"editable\":false,\"align\":\"left\",\"dataprops\":{},\"commaVisible\":true,\"decimal\":8,\"showDecimal\":4,\"symbol\":\" \"},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"currency\",\"uititle\":\"变更后金额\",\"title\":\"变更后金额\",\"uikey\":\"totalPlanAmt\",\"key\":\"totalPlanAmt\",\"dataIndex\":\"totalPlanAmt\",\"nid\":\"nid_1615289895534_4602\",\"editable\":false,\"align\":\"left\",\"dataprops\":{},\"commaVisible\":true,\"decimal\":8,\"symbol\":\" \",\"showDecimal\":4},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"编制人\",\"title\":\"编制人\",\"uikey\":\"createUserName\",\"key\":\"createUserName\",\"dataIndex\":\"createUserName\",\"nid\":\"nid_1615289896263_4604\",\"dataprops\":{},\"editable\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"编制时间\",\"title\":\"编制时间\",\"uikey\":\"createTime\",\"key\":\"createTime\",\"dataIndex\":\"createTime\",\"nid\":\"nid_1615289896991_4606\",\"dataprops\":{},\"editable\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"生效时间\",\"title\":\"生效时间\",\"uikey\":\"effectiveDate\",\"key\":\"effectiveDate\",\"dataIndex\":\"effectiveDate\",\"nid\":\"nid_1615289897687_4608\",\"dataprops\":{},\"editable\":false}],\"showRowNum\":true,\"checkable\":false}]},{\"uititle\":\"导入模板6\",\"uitype\":\"EJCImport\",\"nid\":\"nid_1614846222559_12568\",\"uikey\":\"importModal\",\"visible\":false,\"downTemplateUrl\":\"/ejc-material-web/instore/download\",\"uploadUrl\":\"/ejc-material-web/instore/excelImport\",\"downTemplateName\":\"物资导入\",\"enTitle\":\"\",\"cloumns\":\"[{\\\"type\\\":\\\"input\\\",\\\"title\\\":\\\"物资分类\\\",\\\"key\\\":\\\"materialCategoryName\\\"},{\\\"type\\\":\\\"input\\\",\\\"title\\\":\\\"物资名称\\\",\\\"key\\\":\\\"materialName\\\"},{\\\"type\\\":\\\"input\\\",\\\"title\\\":\\\"规格型号\\\",\\\"key\\\":\\\"materialSpec\\\"},{\\\"type\\\":\\\"input\\\",\\\"title\\\":\\\"计量单位\\\",\\\"key\\\":\\\"materialUnit\\\"},{\\\"type\\\":\\\"input\\\",\\\"title\\\":\\\"入库数量\\\",\\\"key\\\":\\\"instoreNumber\\\"},{\\\"type\\\":\\\"input\\\",\\\"title\\\":\\\"单价\\\",\\\"key\\\":\\\"unitPrice\\\"},{\\\"type\\\":\\\"input\\\",\\\"title\\\":\\\"金额\\\",\\\"key\\\":\\\"amount\\\"},{\\\"type\\\":\\\"input\\\",\\\"title\\\":\\\"备注\\\",\\\"key\\\":\\\"remark\\\"},{\\\"type\\\":\\\"input\\\",\\\"title\\\":\\\"错误类型\\\",\\\"key\\\":\\\"errorMessage\\\"},{\\\"type\\\":\\\"input\\\",\\\"title\\\":\\\"备注\\\",\\\"key\\\":\\\"remark\\\"}]\"},{\"uititle\":\"单据信息\",\"uitype\":\"EJCPanel\",\"nid\":\"nid_1592309689617_1950\",\"uikey\":\"billInfoArea\",\"title\":\"单据信息\",\"expandText\":\"收起\",\"collapseText\":\"展开\",\"children\":[{\"uititle\":\"单据审计1\",\"uitype\":\"CPAuditInfo\",\"nid\":\"nid_1592309897349_2238\",\"uikey\":\"CPAuditInfo\",\"primaryKey\":\"id\",\"enTitle\":\"\",\"billName\":\"物资总计划\",\"billType\":\"BT210302000000004\"}],\"expand\":false,\"visible\":false}],\"nid\":\"nid_1614669713542_29070\",\"enTitle\":\"\",\"dataprops\":{\"project\":{\"id\":\"322683907509321758\",\"displayName\":\"物资管理\",\"projectName\":\"ejc-material-web\"},\"entity\":{\"id\":\"422487372590219305\",\"displayName\":\"物资总计划\",\"entityFullName\":\"om.ejianc.business.plan.bean.MaterialMasterPlanEntity\"}},\"billName\":\"物资总计划\",\"billType\":\"BT210302000000004\"}";
//		String jsonProv = "{\"children\":[{\"children\":[{\"visible\":false,\"children\":[],\"nid\":\"nid_1602197149128515600\",\"uikey\":\"EJCLayoutPanel1\",\"uitype\":\"EJCLayoutPanel\",\"position\":\"top\",\"uititle\":\"头部\",\"height\":\"0px\"},{\"visible\":true,\"children\":[{\"backgroundColor\":\"#F5F5F5\",\"color\":\"#999999\",\"children\":[{\"visible\":true,\"children\":[{\"visible\":true,\"arrow\":\"horizontal\",\"nid\":\"nid_1602197149619249156\",\"uikey\":\"K1670827653423\",\"uitype\":\"EJCPicker\",\"label\":\"是否属于项目\",\"dismissText\":\"取消\",\"type\":\"1\",\"required\":true,\"field\":\"K1670827653423\",\"children\":[{\"children\":[],\"nid\":\"nid_1602197149619249157\",\"uikey\":\"K1670828292783\",\"uitype\":\"EJCPickerItem\",\"value\":\"K1670828292783\",\"uititle\":\"是\"},{\"children\":[],\"nid\":\"nid_1602197149619249158\",\"uikey\":\"K1670828303968\",\"uitype\":\"EJCPickerItem\",\"value\":\"K1670828303968\",\"uititle\":\"否\"}],\"extra\":\"请选择是否属于项目\",\"defDocType\":\"2\",\"subType\":\"select\",\"disabled\":false,\"okText\":\"确定\",\"cols\":1,\"uititle\":\"是否属于项目\"},{\"visible\":true,\"referCode\":{\"code\":\"market-project-refer-list\",\"name\":\"项目登记参照\",\"id\":\"320519315475660894\",\"refCode\":\"market-project-refer-list\"},\"nid\":\"nid_1602197149652803586\",\"uikey\":\"K1670827654445\",\"labelNumber\":7,\"uitype\":\"EJCRefer\",\"required\":false,\"children\":[],\"showField\":\"name\",\"disabled\":false,\"referName\":\"K1670827654445\",\"treeDisplayField\":\"name\",\"id\":\"id\",\"uititle\":\"项目名\"},{\"visible\":true,\"referCode\":{\"code\":\"idm_org_tree\",\"name\":\"组织\",\"id\":\"310428626500755491\",\"refCode\":\"idm_org_tree\"},\"nid\":\"nid_1602197149682163714\",\"uikey\":\"K1670827654959\",\"labelNumber\":7,\"uitype\":\"EJCRefer\",\"required\":true,\"children\":[],\"showField\":\"name\",\"disabled\":false,\"referName\":\"K1670827654959\",\"treeDisplayField\":\"name\",\"id\":\"id\",\"uititle\":\"所属组织\"},{\"visible\":true,\"referCode\":{\"code\":\"idm_dept_list\",\"name\":\"部门列表\",\"id\":\"322468364965642298\",\"refCode\":\"idm_dept_list\"},\"nid\":\"nid_1602197149711523843\",\"uikey\":\"K1670827657878\",\"labelNumber\":7,\"uitype\":\"EJCRefer\",\"required\":false,\"children\":[],\"showField\":\"name\",\"disabled\":false,\"referName\":\"K1670827657878\",\"treeDisplayField\":\"name\",\"id\":\"id\",\"uititle\":\"所属部门\"},{\"mode\":\"date\",\"field\":\"K1670827658392\",\"children\":[],\"arrow\":\"horizontal\",\"extra\":\"请选择申请日期\",\"nid\":\"nid_1602197149740883971\",\"uikey\":\"K1670827658392\",\"disabled\":false,\"uitype\":\"EJCDatePicker\",\"label\":\"申请日期\",\"uititle\":\"申请日期\",\"required\":false},{\"mode\":\"date\",\"field\":\"K1670827659736\",\"children\":[],\"arrow\":\"horizontal\",\"extra\":\"请选择使用日期\",\"nid\":\"nid_1602197149774438403\",\"uikey\":\"K1670827659736\",\"disabled\":false,\"uitype\":\"EJCDatePicker\",\"label\":\"使用日期\",\"uititle\":\"使用日期\",\"required\":true},{\"visible\":true,\"editable\":true,\"nid\":\"nid_1602197149803798531\",\"clear\":true,\"uikey\":\"K1670827660595\",\"labelNumber\":7,\"uitype\":\"EJCInput\",\"type\":\"text\",\"required\":true,\"comma\":true,\"field\":\"K1670827660595\",\"children\":[],\"placeholder\":\"请输入申请人\",\"decimal\":2,\"uititle\":\"申请人\"},{\"visible\":true,\"editable\":true,\"nid\":\"nid_1602197149833158658\",\"clear\":true,\"uikey\":\"K1670827661691\",\"labelNumber\":7,\"uitype\":\"EJCInput\",\"type\":\"text\",\"required\":true,\"comma\":true,\"field\":\"K1670827661691\",\"children\":[],\"placeholder\":\"请输入金额\",\"decimal\":2,\"uititle\":\"金额\"},{\"visible\":true,\"arrow\":\"horizontal\",\"nid\":\"nid_1602197149858324482\",\"uikey\":\"K1670827662739\",\"uitype\":\"EJCPicker\",\"label\":\"申请类别\",\"dismissText\":\"取消\",\"type\":\"1\",\"required\":false,\"field\":\"K1670827662739\",\"children\":[{\"children\":[],\"nid\":\"nid_1602197149858324483\",\"uikey\":\"K1670828387061\",\"uitype\":\"EJCPickerItem\",\"value\":\"K1670828387061\",\"uititle\":\"广告制作\"},{\"children\":[],\"nid\":\"nid_1602197149858324484\",\"uikey\":\"K1670828387705\",\"uitype\":\"EJCPickerItem\",\"value\":\"K1670828387705\",\"uititle\":\"办公用品\"},{\"children\":[],\"nid\":\"nid_1602197149858324485\",\"uikey\":\"K1670828388401\",\"uitype\":\"EJCPickerItem\",\"value\":\"K1670828388401\",\"uititle\":\"低值易耗品\"},{\"children\":[],\"nid\":\"nid_1602197149858324486\",\"uikey\":\"K1670828389221\",\"uitype\":\"EJCPickerItem\",\"value\":\"K1670828389221\",\"uititle\":\"工程物品\"},{\"children\":[],\"nid\":\"nid_1602197149858324487\",\"uikey\":\"K1670828392580\",\"uitype\":\"EJCPickerItem\",\"value\":\"K1670828392580\",\"uititle\":\"软件设备\"},{\"children\":[],\"nid\":\"nid_1602197149858324488\",\"uikey\":\"K1670828393276\",\"uitype\":\"EJCPickerItem\",\"value\":\"K1670828393276\",\"uititle\":\"其他\"}],\"extra\":\"请选择申请类别\",\"defDocType\":\"2\",\"subType\":\"select\",\"disabled\":false,\"okText\":\"确定\",\"cols\":1,\"uititle\":\"申请类别\"},{\"visible\":true,\"nid\":\"nid_1602197149891878914\",\"count\":200,\"clear\":true,\"uikey\":\"K1670827663271\",\"labelNumber\":7,\"uitype\":\"EJCTextareaItem\",\"label\":\"用途\",\"rows\":5,\"required\":false,\"field\":\"K1670827663271\",\"children\":[],\"disabled\":false,\"placeholder\":\"请输入用途\",\"uititle\":\"用途\",\"direction\":\"inside\"}],\"dataType\":\"object\",\"nid\":\"nid_1602197149619249154\",\"uikey\":\"EJCFormDev1\",\"uitype\":\"EJCFormDev\",\"uititle\":\"表单-基本信息\"}],\"nid\":\"nid_1602197149619249153\",\"uikey\":\"EJCPart1\",\"uitype\":\"EJCPart\",\"leftType\":\"1\",\"uititle\":\"表单-基本信息\",\"partName\":\"表单-基本信息\"},{\"children\":[],\"sourceType\":\"attachMgr\",\"billType\":{\"billName\":\"物资申购申请\",\"metadataName\":\"物资申购申请\",\"billCode\":\"CFS1670824902742\",\"id\":1602181883325767700},\"nid\":\"nid_1602197150609104897\",\"uikey\":\"attachMgr\",\"uitype\":\"EJCAttachFilePick\",\"source\":{\"code\":\"CFS1670824902742\",\"sourceType\":\"attachMgr\",\"billType\":\"CFS1670824902742\",\"name\":\"物资申购申请\",\"id\":1602181883325767700},\"uititle\":\"附件管理\",\"partName\":\"附件管理\"}],\"nid\":\"nid_1602197149128515601\",\"uikey\":\"EJCLayoutPanel2\",\"uitype\":\"EJCLayoutPanel\",\"position\":\"center\",\"uititle\":\"中部\",\"height\":\"calc(100% - 45px)\"},{\"visible\":true,\"children\":[{\"children\":[{\"visible\":true,\"size\":\"large\",\"children\":[],\"nid\":\"nid_1602197149128515604\",\"uikey\":\"removeBtn\",\"uitype\":\"EJCButton\",\"radius\":false,\"type\":\"warning\",\"uititle\":\"删除\"},{\"visible\":true,\"size\":\"large\",\"children\":[],\"nid\":\"nid_1602197149128515605\",\"uikey\":\"saveBtn\",\"uitype\":\"EJCButton\",\"radius\":false,\"type\":\"ghost\",\"uititle\":\"保存\"},{\"visible\":false,\"size\":\"large\",\"children\":[],\"nid\":\"nid_1602197149128515606\",\"uikey\":\"callBackBtn\",\"uitype\":\"EJCButton\",\"radius\":false,\"uititle\":\"收回\"},{\"orgField\":\"orgId\",\"visible\":true,\"size\":\"large\",\"children\":[],\"nid\":\"nid_1602197149128515607\",\"uikey\":\"EJCApproveSubmitBtn\",\"uitype\":\"EJCApproveSubmitBtn\",\"radius\":false,\"type\":\"primary\",\"uititle\":\"提交\",\"billTypeId\":{\"billName\":\"物资申购申请\",\"code\":\"CFS1670824902742\",\"name\":\"物资申购申请\",\"metadataName\":\"物资申购申请\",\"billCode\":\"CFS1670824902742\"}},{\"children\": [],\"nid\": \"nid_1602197169128515608\",\"radius\": false,\"size\": \"large\",\"type\": \"warning\",\"uikey\": \"EJCApproveRejectBtn\",\"uititle\": \"驳回\",\"uitype\": \"EJCApproveRejectBtn\",\"visible\": true},{\"children\": [],\"nid\": \"nid_1602197179128515608\",\"radius\": false,\"size\": \"large\",\"type\": \"primary\",\"uikey\": \"EJCApproveAgreeBtn\",\"uititle\": \"同意\",\"uitype\": \"EJCApproveAgreeBtn\",\"visible\": true},{\"visible\":true,\"size\":\"large\",\"children\":[],\"nid\":\"nid_1602197149128515608\",\"uikey\":\"EJCApproveHistoryBtn\",\"uitype\":\"EJCApproveHistoryBtn\",\"radius\":false,\"type\":\"primary\",\"uititle\":\"审批历史\"},{\"visible\":false,\"size\":\"large\",\"children\":[],\"nid\":\"nid_1602197149128515609\",\"uikey\":\"saveApproveEditBtn\",\"uitype\":\"EJCButton\",\"radius\":false,\"type\":\"primary\",\"uititle\":\"确认修改\"}],\"nid\":\"nid_1602197149128515603\",\"uikey\":\"EJCButtonBar1\",\"uitype\":\"EJCButtonBar\",\"uititle\":\"底部按钮组\"}],\"nid\":\"nid_1602197149128515602\",\"uikey\":\"EJCLayoutPanel3\",\"uitype\":\"EJCLayoutPanel\",\"position\":\"bottom\",\"uititle\":\"底部\",\"height\":\"45px\"}],\"nid\":\"nid_1602197149128515599\",\"uikey\":\"EJCLayout1\",\"uitype\":\"EJCLayout\",\"uititle\":\"上中下布局\"}],\"nid\":\"nid_1602197149128515598\",\"uikey\":\"CFS1670824902742card\",\"uitype\":\"EJCPage\",\"subCols\":{},\"cfsAppInfo\":{\"appCode\":\"CFS1670824902742\",\"appGroupId\":1602181721178169300,\"appIcon\":\"https://portal.17elian.com/ejc-file-web/attachment/filePreview?filePath=1564909352936882178/202212/1602181835419107330.jpg\",\"appName\":\"物资申购申请\",\"appState\":1,\"attachIds\":[],\"authFlag\":0,\"createTime\":1670824903000,\"createUserCode\":\"13923119641\",\"customField\":{},\"dr\":0,\"id\":1602181883325767700,\"publishState\":0,\"queryRange\":0,\"sequence\":1,\"syncEsFlag\":0,\"tenantId\":1564909352936882200,\"type\":\"1,2\",\"version\":1},\"uititle\":\"物资申购申请详情\"}";
		String jsonProv = "{\"dataprops\":{\"project\":{\"id\":\"322683907509321758\",\"displayName\":\"物资管理\",\"projectName\":\"ejc-material-web\"},\"entity\":{\"id\":\"422487372590219305\",\"displayName\":\"物资总计划\",\"entityFullName\":\"om.ejianc.business.plan.bean.MaterialMasterPlanEntity\"}},\"billName\":\"物资总计划\",\"enTitle\":\"\",\"children\":[{\"uititle\":\"面包屑1\",\"uitype\":\"EJCBreadcrumb\",\"nid\":\"nid_1614669667403_29066\",\"uikey\":\"K1614669667403\",\"children\":[{\"uitype\":\"EJCBreadcrumbItem\",\"uititle\":\"物资总计划\",\"key\":1.614669688705E12,\"uikey\":\"1614669688705\",\"children\":\"物资总计划\",\"nid\":\"nid_1614669688706_29068\",\"href\":\"/materialMasterPlan\"},{\"uitype\":\"EJCBreadcrumbItem\",\"uititle\":\"详情\",\"key\":1.614669689688E12,\"uikey\":\"1614669689688\",\"children\":\"详情\",\"nid\":\"nid_1614669689688_29069\"}]},{\"uititle\":\"工具栏2\",\"uitype\":\"EJCToolbar\",\"nid\":\"nid_1614669845851_29082\",\"uikey\":\"K1614669845851\",\"children\":[{\"uititle\":\"保存\",\"uitype\":\"EJCButton\",\"nid\":\"nid_1614669850964_29087\",\"children\":\"保存\",\"uikey\":\"saveBtn\",\"type\":\"primary\",\"icon\":\"book\"},{\"uititle\":\"取消\",\"uitype\":\"EJCButton\",\"nid\":\"nid_1614669981594_29665\",\"children\":\"取消\",\"uikey\":\"cancelBtn\",\"icon\":\"cross-circle-o\",\"type\":\"primary\",\"ghost\":true},{\"uititle\":\"编辑\",\"uitype\":\"EJCButton\",\"nid\":\"nid_1614669889638_29262\",\"children\":\"编辑\",\"uikey\":\"editBtn\",\"icon\":\"edit\",\"type\":\"primary\",\"ghost\":true},{\"uititle\":\"打印\",\"uitype\":\"EJCPrintButton\",\"nid\":\"nid_1614670134241_29978\",\"uikey\":\"printBtn\",\"title\":\"打印\",\"enableOrg\":true,\"ghost\":true,\"type\":\"primary\",\"billName\":\"物资总计划\",\"billType\":\"BT210302000000004\"},{\"uititle\":\"审批相关\",\"uitype\":\"BpmApproveWidget\",\"nid\":\"nid_1614670194343_30093\",\"uikey\":\"bpmApprove\",\"enableUser\":true,\"enableOrg\":true,\"type\":\"primary\",\"ghost\":true,\"visible\":false,\"billName\":\"物资总计划\",\"billTypeId\":\"BT210302000000004\",\"billId\":\"421761164495814725\"},{\"uititle\":\"附件管理\",\"uitype\":\"AttachMgrWidget\",\"nid\":\"nid_1614670255184_30208\",\"uikey\":\"attachMgr\",\"btnType\":\"primary\",\"btnGhost\":true,\"align\":\"right\",\"billTypeId\":\"421761164495814725\",\"billTypeName\":\"物资总计划\",\"billType\":\"BT210302000000004\",\"sourceType\":\"materPlan001\",\"orgIdField\":\"orgId\",\"enTitle\":\"\",\"multiple\":false,\"fileLengthVisible\":true},{\"uititle\":\"提交\",\"uitype\":\"BpmSubmitButton\",\"nid\":\"nid_1614670277964_30257\",\"uikey\":\"bpmSubmitBtn\",\"enableUser\":true,\"type\":\"primary\",\"ghost\":true,\"visible\":false,\"billName\":\"物资总计划\",\"billRefId\":\"421761164495814725\",\"billTypeId\":\"BT210302000000004\",\"orgField\":\"orgId\",\"codeField\":\"{projectName}—物资总计划\",\"enTitle\":\"\"},{\"uititle\":\"撤回\",\"uitype\":\"EJCButton\",\"nid\":\"nid_1614670305087_30284\",\"children\":\"撤回\",\"uikey\":\"callBackBtn\",\"type\":\"primary\",\"ghost\":true,\"visible\":false},{\"uititle\":\"删除\",\"uitype\":\"EJCButton\",\"nid\":\"nid_1614670334900_30427\",\"children\":\"删除\",\"uikey\":\"removeBtn\",\"type\":\"error\",\"ghost\":true,\"icon\":\"delete\"},{\"uititle\":\"返回列表\",\"uitype\":\"EJCButton\",\"nid\":\"nid_1614670336614_30431\",\"children\":\"返回列表\",\"uikey\":\"goBackBtn\",\"ghost\":true,\"type\":\"primary\"}]},{\"uititle\":\"基本信息\",\"uitype\":\"EJCPanel\",\"nid\":\"nid_1614670464935_30978\",\"uikey\":\"K1614670464935\",\"title\":\"基本信息\",\"expandText\":\"收起\",\"collapseText\":\"展开\",\"children\":[{\"uititle\":\"表单2\",\"uitype\":\"FormWidget\",\"nid\":\"nid_1614673555088_111002\",\"colnumber\":3.0,\"uikey\":\"baseForm\",\"dataprops\":{},\"children\":[{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"inputrefer\",\"label\":\"项目名称\",\"uikey\":\"projectId\",\"uititle\":\"项目名称\",\"nid\":\"nid_1614673564425_111007\",\"labelCol\":{\"span\":6.0},\"wrapperCol\":{\"span\":14.0},\"subTableKey\":\"\",\"subTableColKey\":\"\",\"refinfokey\":\"market-project-refer-list\",\"refName\":\"项目登记参照\",\"refId\":\"320519315475660894\",\"referCode\":{\"code\":\"market-project-refer-list\",\"name\":\"项目登记参照\",\"id\":\"320519315475660894\"},\"required\":true},{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"input\",\"label\":\"计划编码\",\"propsIndex\":2.0,\"uikey\":\"planCode\",\"uititle\":\"计划编码\",\"nid\":\"nid_1614673564935_111012\",\"formLabelCol\":{\"span\":6.0},\"formWrapperCol\":{\"span\":14.0},\"subTableKey\":\"\",\"subTableColKey\":\"\",\"labelCol\":{\"span\":6.0},\"wrapperCol\":{\"span\":14.0},\"maxLength\":\"30\",\"placeholder\":\"置空系统自动生成\"},{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"currency\",\"label\":\"总计划金额\",\"uikey\":\"totalPlanAmt\",\"uititle\":\"总计划金额\",\"nid\":\"nid_1614673565538_111017\",\"labelCol\":{\"span\":6.0},\"wrapperCol\":{\"span\":15.0},\"subTableKey\":\"\",\"subTableColKey\":\"\",\"decimal\":8.0,\"symbol\":\" \",\"subTableCalc\":false,\"showDecimal\":2.0,\"disabled\":true,\"placeholder\":\"由子表汇总\"},{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"date\",\"label\":\"备注123\",\"uikey\":\"remark\",\"uititle\":\"备注123\",\"nid\":\"nid_1614673632278_113045\",\"labelCol\":{\"span\":2.0},\"wrapperCol\":{\"span\":21.0},\"newline\":true,\"enTitle\":\"\",\"subTableKey\":\"\",\"subTableColKey\":\"\"}],\"labelCol\":{\"span\":6.0},\"wrapperCol\":{\"span\":14.0}}]},{\"uititle\":\"材料清单\",\"uitype\":\"EJCPanel\",\"nid\":\"nid_1614671008778_42433\",\"uikey\":\"K1614671008778\",\"title\":\"材料清单\",\"expandText\":\"收起\",\"collapseText\":\"展开\",\"children\":[{\"uititle\":\"工具栏1\",\"uitype\":\"EJCToolbar\",\"nid\":\"nid_1614671031450_42435\",\"uikey\":\"K1614671031450\",\"children\":[{\"uititle\":\"参照物资档案\",\"uitype\":\"EJCReferButton\",\"nid\":\"nid_1614671041124_42439\",\"buttonText\":\"参照物资档案\",\"uikey\":\"materialRefer\",\"ghost\":true,\"type\":\"primary\",\"refinfokey\":\"material-tree-grid\",\"refName\":\"物资参照\",\"refId\":\"320652154816954392\",\"multiselect\":true,\"often\":true,\"linkName\":\"新页签\"},{\"uititle\":\"引入预算\",\"uitype\":\"EJCReferButton\",\"nid\":\"nid_1632301956021_24\",\"buttonText\":\"引入预算\",\"uikey\":\"budgetRefer\",\"ghost\":true,\"type\":\"primary\",\"refinfokey\":\"BUDGET-REF-LIST\",\"refName\":\"预算参照\",\"refId\":\"495643151588540502\",\"multiselect\":true,\"linkName\":\"新页签\",\"enTitle\":\"\"},{\"uititle\":\"导入\",\"uitype\":\"EJCButton\",\"nid\":\"nid_1614671043215_42443\",\"children\":\"导入\",\"uikey\":\"excelImport\",\"type\":\"primary\",\"ghost\":true},{\"uititle\":\"删除\",\"uitype\":\"EJCButton\",\"nid\":\"nid_1614671045049_42447\",\"children\":\"删除\",\"uikey\":\"deleteRow\",\"type\":\"error\",\"ghost\":true}]},{\"uititle\":\"编辑表格2\",\"uitype\":\"EditTableWidget\",\"nid\":\"nid_1614671193216_43146\",\"uikey\":\"materialSubList\",\"children\":[{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"物资分类\",\"title\":\"物资分类\",\"uikey\":\"materialCategoryName\",\"key\":\"materialCategoryName\",\"dataIndex\":\"materialCategoryName\",\"nid\":\"nid_1614671202586_43148\",\"dataprops\":{},\"editable\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"物资名称\",\"title\":\"物资名称\",\"uikey\":\"materialName\",\"key\":\"materialName\",\"dataIndex\":\"materialName\",\"nid\":\"nid_1614671203709_43150\",\"dataprops\":{},\"editable\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"规格型号\",\"title\":\"规格型号\",\"uikey\":\"spec\",\"key\":\"spec\",\"dataIndex\":\"spec\",\"nid\":\"nid_1614671204236_43152\",\"dataprops\":{},\"editable\":false,\"enTitle\":\"\",\"autoTrim\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"计量单位\",\"title\":\"计量单位\",\"uikey\":\"unit\",\"key\":\"unit\",\"dataIndex\":\"unit\",\"nid\":\"nid_1614671204771_43154\",\"dataprops\":{},\"editable\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"currency\",\"uititle\":\"数量\",\"title\":\"数量\",\"uikey\":\"num\",\"key\":\"num\",\"dataIndex\":\"num\",\"nid\":\"nid_1614671209635_43156\",\"align\":\"left\",\"required\":true,\"dataprops\":{},\"commaVisible\":true,\"decimal\":8.0,\"symbol\":\" \",\"min\":\"0\",\"max\":\"999999999999\",\"showDecimal\":4.0,\"zeroFilling\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"currency\",\"uititle\":\"单价\",\"title\":\"单价\",\"uikey\":\"price\",\"key\":\"price\",\"dataIndex\":\"price\",\"nid\":\"nid_1614671211554_43158\",\"align\":\"left\",\"dataprops\":{},\"commaVisible\":true,\"decimal\":8.0,\"showDecimal\":4.0,\"symbol\":\" \",\"min\":\"0\",\"max\":\"999999999999\",\"zeroFilling\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"currency\",\"uititle\":\"金额\",\"title\":\"金额\",\"uikey\":\"amount\",\"key\":\"amount\",\"dataIndex\":\"amount\",\"nid\":\"nid_1614671212513_43160\",\"align\":\"left\",\"dataprops\":{},\"commaVisible\":true,\"decimal\":8.0,\"symbol\":\" \",\"showDecimal\":2.0,\"editable\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"物资分类Id\",\"title\":\"物资分类Id\",\"uikey\":\"materialCategoryId\",\"key\":\"materialCategoryId\",\"dataIndex\":\"materialCategoryId\",\"nid\":\"nid_1614843035426_1099\",\"dataprops\":{},\"isShow\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"物资Id\",\"title\":\"物资Id\",\"uikey\":\"materialId\",\"key\":\"materialId\",\"dataIndex\":\"materialId\",\"nid\":\"nid_1614843071288_3516\",\"dataprops\":{},\"isShow\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"物料来源类型\",\"title\":\"物料来源类型\",\"uikey\":\"sourceType\",\"key\":\"sourceType\",\"dataIndex\":\"sourceType\",\"nid\":\"nid_1614843124515_4916\",\"dataprops\":{},\"isShow\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"来自来源数据Id\",\"title\":\"来自来源数据Id\",\"uikey\":\"sourceId\",\"key\":\"sourceId\",\"dataIndex\":\"sourceId\",\"nid\":\"nid_1614843133912_4918\",\"dataprops\":{},\"isShow\":false}],\"rowKey\":\"id\",\"dataSource\":[],\"showRowNum\":true}]},{\"uititle\":\"历史版本\",\"uitype\":\"EJCPanel\",\"nid\":\"nid_1614671520907_75454\",\"uikey\":\"changeHisWrap\",\"title\":\"历史版本\",\"expandText\":\"收起\",\"collapseText\":\"展开\",\"children\":[{\"uititle\":\"历史版本表\",\"uitype\":\"EditTableWidget\",\"nid\":\"nid_1615289870685_4461\",\"uikey\":\"planChangeHisList\",\"rowKey\":\"id\",\"dataSource\":[],\"children\":[{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"历史版本编号\",\"title\":\"历史版本编号\",\"uikey\":\"planHisCode\",\"key\":\"planHisCode\",\"dataIndex\":\"planHisCode\",\"nid\":\"nid_1615289894505_4598\",\"dataprops\":{},\"editable\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"currency\",\"uititle\":\"原计划金额\",\"title\":\"原计划金额\",\"uikey\":\"originalPlanAmt\",\"key\":\"originalPlanAmt\",\"dataIndex\":\"originalPlanAmt\",\"nid\":\"nid_1615289895029_4600\",\"editable\":false,\"align\":\"left\",\"dataprops\":{},\"commaVisible\":true,\"decimal\":8.0,\"showDecimal\":4.0,\"symbol\":\" \"},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"currency\",\"uititle\":\"变更后金额\",\"title\":\"变更后金额\",\"uikey\":\"totalPlanAmt\",\"key\":\"totalPlanAmt\",\"dataIndex\":\"totalPlanAmt\",\"nid\":\"nid_1615289895534_4602\",\"editable\":false,\"align\":\"left\",\"dataprops\":{},\"commaVisible\":true,\"decimal\":8.0,\"symbol\":\" \",\"showDecimal\":4.0},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"编制人\",\"title\":\"编制人\",\"uikey\":\"createUserName\",\"key\":\"createUserName\",\"dataIndex\":\"createUserName\",\"nid\":\"nid_1615289896263_4604\",\"dataprops\":{},\"editable\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"编制时间\",\"title\":\"编制时间\",\"uikey\":\"createTime\",\"key\":\"createTime\",\"dataIndex\":\"createTime\",\"nid\":\"nid_1615289896991_4606\",\"dataprops\":{},\"editable\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"生效时间\",\"title\":\"生效时间\",\"uikey\":\"effectiveDate\",\"key\":\"effectiveDate\",\"dataIndex\":\"effectiveDate\",\"nid\":\"nid_1615289897687_4608\",\"dataprops\":{},\"editable\":false}],\"showRowNum\":true,\"checkable\":false}]},{\"uititle\":\"导入模板6\",\"uitype\":\"EJCImport\",\"nid\":\"nid_1614846222559_12568\",\"uikey\":\"importModal\",\"visible\":false,\"downTemplateUrl\":\"/ejc-material-web/instore/download\",\"uploadUrl\":\"/ejc-material-web/instore/excelImport\",\"downTemplateName\":\"物资导入\",\"enTitle\":\"\",\"cloumns\":\"[{\\\"type\\\":\\\"input\\\",\\\"title\\\":\\\"物资分类\\\",\\\"key\\\":\\\"materialCategoryName\\\"},{\\\"type\\\":\\\"input\\\",\\\"title\\\":\\\"物资名称\\\",\\\"key\\\":\\\"materialName\\\"},{\\\"type\\\":\\\"input\\\",\\\"title\\\":\\\"规格型号\\\",\\\"key\\\":\\\"materialSpec\\\"},{\\\"type\\\":\\\"input\\\",\\\"title\\\":\\\"计量单位\\\",\\\"key\\\":\\\"materialUnit\\\"},{\\\"type\\\":\\\"input\\\",\\\"title\\\":\\\"入库数量\\\",\\\"key\\\":\\\"instoreNumber\\\"},{\\\"type\\\":\\\"input\\\",\\\"title\\\":\\\"单价\\\",\\\"key\\\":\\\"unitPrice\\\"},{\\\"type\\\":\\\"input\\\",\\\"title\\\":\\\"金额\\\",\\\"key\\\":\\\"amount\\\"},{\\\"type\\\":\\\"input\\\",\\\"title\\\":\\\"备注\\\",\\\"key\\\":\\\"remark\\\"},{\\\"type\\\":\\\"input\\\",\\\"title\\\":\\\"错误类型\\\",\\\"key\\\":\\\"errorMessage\\\"},{\\\"type\\\":\\\"input\\\",\\\"title\\\":\\\"备注\\\",\\\"key\\\":\\\"remark\\\"}]\"},{\"uititle\":\"单据信息\",\"uitype\":\"EJCPanel\",\"nid\":\"nid_1592309689617_1950\",\"uikey\":\"billInfoArea\",\"title\":\"单据信息\",\"expandText\":\"收起\",\"collapseText\":\"展开\",\"children\":[{\"uititle\":\"单据审计1\",\"uitype\":\"CPAuditInfo\",\"nid\":\"nid_1592309897349_2238\",\"uikey\":\"CPAuditInfo\",\"primaryKey\":\"id\",\"enTitle\":\"\",\"billName\":\"物资总计划\",\"billType\":\"BT210302000000004\"}],\"expand\":false,\"visible\":false}],\"billType\":\"BT210302000000004\",\"nid\":\"nid_1614669713542_29070\",\"uikey\":\"M1366649681864491011\",\"uitype\":\"EJCPage\",\"uititle\":\"物资总计划详情\",\"themeClassName\":\"GEJC\"}";

		JsonObject baseData = gson.fromJson(jsonBase,JsonObject.class);
		JsonObject provData = gson.fromJson(jsonProv,JsonObject.class);
		JsonArray baseChildren = baseData.getAsJsonArray("children");
		JsonArray provChildren = provData.getAsJsonArray("children");
		processChildren(baseChildren,provChildren);
		System.out.println(provData.toString());
	}

	@Override
	public Page<IdeModule> findModulesByAppId(String appId,String searchText,boolean isDelete,Pageable pageable) throws Exception {
		Integer pageIndex = pageable.getPageNumber() * pageable.getPageSize();
		List<IdeModule> ideModules = ideModuleRepo.findModuleListByAppId(appId,searchText,isDelete,pageIndex,pageable.getPageSize());
		
		Long total = ideModuleRepo.findModuleCountByAppId(appId,searchText,isDelete);
		Page<IdeModule> page = new PageImpl<>(ideModules, pageable, total);
		return page;
	}
	
	@Override
	public List<IdeModulePrivate> checkCanDelete(List<String> ids) throws BusinessException, Exception {
		String moduleIds = "";
		if(ids != null && ids.size() > 0) {
			for(String id:ids) {
				moduleIds += id + ",";
			}
			moduleIds = moduleIds.substring(0, moduleIds.length()-1);
			List<IdeModulePrivate> modulePrivates = ideModulePrivateRepo.findListByModuleIds(moduleIds);
			return modulePrivates;
		}
		return null;
	}
	
	@Override
	public void deleteByIds(List<String> ids, boolean isRemove) throws BusinessException, Exception {
		String idStr = "";
		for(String id:ids) {
			idStr += id + ",";
		}
		if(StringUtils.isNotEmpty(idStr)) {
			idStr = idStr.substring(0, idStr.length()-1);
		}
		if (isRemove) {
			ideModuleRepo.removeByIds(idStr);
			ideModulePrivateRepo.removeByModuleIds(idStr);
		}else {	
			ideModuleRepo.deleteByIds(idStr);
	        moduleDataRepo.deleteByModuleIds(idStr);
	        ideModulePrivateRepo.deleteByModuleIds(idStr);
		}
	}

	@Override
	public void restoreByIds(List<String> ids) throws BusinessException, Exception {
		String idStr = "";
		if(ids != null && ids.size() > 0) {
			for(String id:ids) {
				idStr += id + ",";
			}
			idStr = idStr.substring(0, idStr.length()-1);
			ideModuleRepo.recoverByIds(idStr);
			ideModulePrivateRepo.recoverByModuleIds(idStr);
		}
	}

	@Override
	public JsonBackData movePage(List<String> pageIds, String appId) throws BusinessException, Exception {
		if(pageIds != null && pageIds.size() > 0) {
			String pageIdStr = "";
			for(String pageId:pageIds) {
				pageIdStr += pageId + ",";
			}
			pageIdStr = pageIdStr.substring(0, pageIdStr.length()-1);
			ideModuleRepo.movePagesByAppId(pageIdStr, appId);
		}
		return JsonBackData.toSuccess("迁移成功");
	}

	@Override
	public List<IdeModule> findByIds(List<String> ids) {
		if(ids != null && ids.size() > 0) {
			String idStr = "";
			for(String id:ids) {
				idStr += id + ",";
			}
			idStr = idStr.substring(0, idStr.length()-1);
			return ideModuleRepo.findByIds(idStr);
		}
		return null;
	}
}
