package com.ejianc.foundation.front.util;

/**
 * Ajax调用统一返回数据结构
 * 
 * @author 张远志
 * @time 2015年7月17日13:02:33
 *
 */
public class JsonBackData {
	/**
	 * 操作是否成功
	 */
	private boolean success;
	/**
	 * 操作返回的提示信息
	 */
	private String backMsg;
	/**
	 * 操作返回的数据
	 */
	private Object backData;

	public JsonBackData() {
		this.success = true;
	}

	public JsonBackData(boolean success, String backMsg, Object backData) {
		super();
		this.success = success;
		this.backMsg = backMsg;
		this.backData = backData;
	}

	/**
	 * 操作结果是否成功
	 * 
	 * @return
	 */
	public boolean isSuccess() {
		return success;
	}

	/**
	 * 设置操作结果
	 * 
	 * @param success
	 */
	public void setSuccess(boolean success) {
		this.success = success;
	}

	/**
	 * 获取操作返回消息
	 * 
	 * @return
	 */
	public String getBackMsg() {
		return backMsg;
	}

	/**
	 * 设置操作返回消息
	 * 
	 * @param backMsg
	 */
	public void setBackMsg(String backMsg) {
		this.backMsg = backMsg;
	}

	/**
	 * 获取操作返回数据
	 * 
	 * @return
	 */
	public Object getBackData() {
		return backData;
	}

	/**
	 * 设置操作返回数据
	 * 
	 * @param backData
	 */
	public void setBackData(Object backData) {
		this.backData = backData;
	}

	/**
	 * 返回错误信息
	 * 
	 * @param message
	 * @return
	 */
	public static JsonBackData toError(String message) {
		return new JsonBackData(false, message, null);
	}

	/**
	 * 成功信息
	 * @param message
	 * @return
	 */
	public static JsonBackData toSuccess(String message) {
		return new JsonBackData(true, message, null);
	}

	/**
	 * 成功
	 * 
	 * @return
	 */
	public static JsonBackData toSuccess() {
		return new JsonBackData(true, null, null);
	}

	/**
	 * 成功
	 * 
	 * @param message
	 * @param backData
	 * @return
	 */
	public static JsonBackData toSuccess(String message, Object backData) {
		return new JsonBackData(true, message, backData);
	}

	/**
	 * 成功
	 * 
	 * @param backData
	 * @return
	 */
	public static JsonBackData toSuccessData(Object backData) {
		return new JsonBackData(true, null, backData);
	}

}
