/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.front.business.ide.cache;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.front.business.ide.entity.IdeModule;
import com.ejianc.foundation.front.business.ide.entity.IdeModulePrivate;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class IdeModulePageCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdeModulePageCache.class);
    private static final String CURRENT_MODULEPAGE_KEY = "current_modulepage_key:";
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private IOrgApi orgApi;

    public void putModulePageCache(String appCode, String pageCode, String orgId, Object modulePro) {
        String currentModulePageKey = CURRENT_MODULEPAGE_KEY + appCode + "-" + pageCode;
        if (StringUtils.isNotBlank((CharSequence)orgId)) {
            LOGGER.info("redisTemplate\u5199\u5165\u79c1\u6709\u5316\u9875\u9762 " + appCode + "  " + pageCode + "  " + orgId);
            currentModulePageKey = currentModulePageKey + "-" + orgId;
        } else {
            LOGGER.info("redisTemplate\u5199\u5165\u516c\u5171\u9875\u9762 " + appCode + "  " + pageCode + "  " + orgId);
        }
        String jsonStr = JSONObject.toJSONString((Object)modulePro);
        this.redisTemplate.opsForValue().set((Object)currentModulePageKey, (Object)jsonStr, 1L, TimeUnit.DAYS);
    }

    public Object getModulePageCache(String appCode, String pageCode) {
        String currentModulePageKey = CURRENT_MODULEPAGE_KEY + appCode + "-" + pageCode;
        String jsonStr = (String)this.redisTemplate.opsForValue().get((Object)currentModulePageKey);
        if (jsonStr == null) {
            LOGGER.info("redisTemplate\u672a\u8bfb\u53d6\u5230\u516c\u5171\u9875\u9762\u4fe1\u606f " + appCode + "  " + pageCode);
            return null;
        }
        LOGGER.info("redisTemplate\u8bfb\u53d6\u5230\u4e86\u516c\u5171\u9875\u9762\u4fe1\u606f " + appCode + "  " + pageCode);
        return JSONObject.parseObject((String)jsonStr, IdeModule.class);
    }

    public Object getProvidePageCache(String appCode, String pageCode, String orgId) {
        CommonResponse response = this.orgApi.getOneById(Long.valueOf(Long.parseLong(orgId)));
        if (response.isSuccess()) {
            String[] innerCode;
            OrgVO orgVO = (OrgVO)response.getData();
            for (String s : innerCode = orgVO.getInnerCode().split("\\|")) {
                String currentModulePageKey = CURRENT_MODULEPAGE_KEY + appCode + "-" + pageCode;
                currentModulePageKey = currentModulePageKey + "-" + s;
                String jsonStr = (String)this.redisTemplate.opsForValue().get((Object)currentModulePageKey);
                if (!StringUtils.isNotBlank((CharSequence)jsonStr)) continue;
                LOGGER.info("redisTemplate\u8bfb\u53d6\u5230\u4e86\u79c1\u6709\u5316\u9875\u9762\u4fe1\u606f appCode=" + appCode + "  pageCode=" + pageCode + " orgId = " + orgId + " parentOrgId = " + s + " \u5b9e\u8d28\u8bfb\u53d6\u4e86 = " + s);
                return JSONObject.parseObject((String)jsonStr, IdeModulePrivate.class);
            }
        }
        LOGGER.info("redisTemplate\u672a\u8bfb\u53d6\u5230\u79c1\u6709\u5316\u9875\u9762\u4fe1\u606f " + appCode + "  " + pageCode + " " + orgId);
        return null;
    }

    public void removeModulePageCache(String appCode, String pageCode, String orgId) {
        String currentModulePageKey = CURRENT_MODULEPAGE_KEY + appCode + "-" + pageCode;
        if (StringUtils.isNotBlank((CharSequence)orgId)) {
            LOGGER.info("redisTemplate\u5220\u9664\u79c1\u6709\u5316\u9875\u9762 " + appCode + "  " + pageCode + "  " + orgId);
            currentModulePageKey = currentModulePageKey + "-" + orgId;
        } else {
            LOGGER.info("redisTemplate\u5220\u9664\u516c\u5171\u9875\u9762 " + appCode + "  " + pageCode + "  " + orgId);
        }
        this.redisTemplate.delete((Object)currentModulePageKey);
    }
}

