/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.front.business.ide.controller;

import com.ejianc.foundation.front.business.ide.service.IdeAppService;
import com.ejianc.foundation.front.util.JsonBackData;
import com.ejianc.framework.core.exception.BusinessException;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"ide/ideAppMgr"})
public class IdeAppMgrController {
    @Autowired
    private IdeAppService idAppService;

    @ResponseBody
    @RequestMapping(value={"showList"}, method={RequestMethod.POST})
    public JsonBackData showList(@RequestBody Map<String, Object> query) {
        JsonBackData back = new JsonBackData();
        int pageNumber = (Integer)query.get("pageNumber");
        int pageSize = (Integer)query.get("pageSize");
        String teamId = (String)query.get("teamId");
        boolean isDelete = (Boolean)query.get("isDelete");
        String searchText = (String)query.get("searchText");
        try {
            pageNumber = pageNumber < 1 ? 1 : (pageNumber - 1) * pageSize;
            PageRequest pageable = new PageRequest(pageNumber <= 0 ? 0 : pageNumber, pageSize);
            back.setBackData(this.idAppService.findPage(teamId, searchText, isDelete, (Pageable)pageable));
        }
        catch (Exception e) {
            e.printStackTrace();
            back.setSuccess(false);
            back.setBackMsg("\u67e5\u8be2\u5217\u8868\u6570\u636e\u5931\u8d25\uff01");
        }
        return back;
    }

    @ResponseBody
    @RequestMapping(value={"showAppByTeamId"})
    public JsonBackData showAppByTeamId(@RequestParam String teamId) {
        JsonBackData back = new JsonBackData();
        try {
            back.setBackData(this.idAppService.findAppTeamId(teamId));
        }
        catch (Exception e) {
            e.printStackTrace();
            back.setSuccess(false);
            back.setBackMsg("\u67e5\u8be2\u5217\u8868\u6570\u636e\u5931\u8d25\uff01");
        }
        return back;
    }

    @ResponseBody
    @RequestMapping(value={"delete"}, method={RequestMethod.POST})
    public JsonBackData deleteByUrls(@RequestBody Map<String, Object> query) {
        JsonBackData back = new JsonBackData();
        List ids = (List)query.get("ids");
        boolean isRemove = (Boolean)query.get("isRemove");
        try {
            this.idAppService.deleteByIds(ids, isRemove);
        }
        catch (BusinessException e) {
            back.setSuccess(false);
            back.setBackMsg(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            back.setSuccess(false);
            back.setBackMsg(e.getMessage());
        }
        return back;
    }

    @ResponseBody
    @RequestMapping(value={"restore"}, method={RequestMethod.POST})
    public JsonBackData restoreByIds(@RequestBody Map<String, Object> query) {
        JsonBackData back = new JsonBackData();
        List ids = (List)query.get("ids");
        try {
            this.idAppService.recoverByIds(ids);
        }
        catch (BusinessException e) {
            back.setSuccess(false);
            back.setBackMsg(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            back.setSuccess(false);
            back.setBackMsg(e.getMessage());
        }
        return back;
    }

    @ResponseBody
    @RequestMapping(value={"checkCanDelete"}, method={RequestMethod.POST})
    public JsonBackData checkCanDelete(@RequestBody Map<String, Object> query) {
        JsonBackData back = new JsonBackData();
        List ids = (List)query.get("ids");
        try {
            back.setBackData(this.idAppService.checkCanDelete(ids));
        }
        catch (BusinessException e) {
            back.setSuccess(false);
            back.setBackMsg(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            back.setSuccess(false);
            back.setBackMsg("\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff01");
        }
        return back;
    }
}

