/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.front.business.ide.controller;

import com.ejianc.foundation.front.business.ide.bo.IdeModuleBo;
import com.ejianc.foundation.front.business.ide.cache.IdeModulePageCache;
import com.ejianc.foundation.front.business.ide.controller.IdeTeamController;
import com.ejianc.foundation.front.business.ide.entity.IdeModule;
import com.ejianc.foundation.front.business.ide.entity.IdeModuleGroup;
import com.ejianc.foundation.front.business.ide.service.IdeModuleGroupService;
import com.ejianc.foundation.front.business.ide.service.IdeModuleService;
import com.ejianc.foundation.front.util.JsonBackData;
import com.ejianc.foundation.front.util.StringUtils;
import com.ejianc.framework.core.kit.collection.ListUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@ResponseBody
@RequestMapping(value={"/ide/moduleGroup"})
@Controller
public class IdeModuleGroupController {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdeTeamController.class);
    @Autowired
    private IdeModuleGroupService moduleGroupService;
    @Autowired
    IdeModuleService ideModuleService;
    @Autowired
    IdeModulePageCache ideModulePageCache;

    @RequestMapping(method={RequestMethod.POST})
    public JsonBackData save(@RequestBody IdeModuleGroup moduleGroup) {
        JsonBackData backData = new JsonBackData();
        try {
            backData.setBackData(this.moduleGroupService.save(moduleGroup));
            backData.setSuccess(true);
            backData.setBackMsg("\u4fdd\u5b58\u7ec4\u6210\u529f");
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u7ec4\u5931\u8d25", (Throwable)e);
            backData.setSuccess(false);
            backData.setBackMsg(e.getMessage());
        }
        return backData;
    }

    @RequestMapping(value={"{ids}"}, method={RequestMethod.DELETE})
    public JsonBackData delete(@PathVariable(value="ids") String[] ids) {
        JsonBackData backData = new JsonBackData();
        try {
            this.moduleGroupService.deleteByIds(ids);
            List<IdeModule> modules = this.ideModuleService.findByGroupIds(ids);
            if (ListUtil.isNotEmpty(modules)) {
                for (IdeModule module : modules) {
                    module.setGroupId(null);
                    this.ideModuleService.saveOrUpdate(module);
                    IdeModuleBo bo = this.ideModuleService.findById(module.getId() + "");
                    LOGGER.info("IdeModuleController77\u884c-\u4ece\u7f13\u5b58\u5220\u9664\u9875\u9762\u6570\u636e\uff01save {}---{}", (Object)bo.getAppCode(), (Object)bo.getCode());
                    if (StringUtils.isNotEmpty(bo.getCode()) && bo.getCode().startsWith("CFS")) {
                        if (bo.getCode().endsWith("card") || bo.getCode().endsWith("list")) {
                            this.ideModulePageCache.removeModulePageCache(bo.getCode().substring(0, bo.getCode().length() - 4), bo.getCode(), null);
                            continue;
                        }
                        LOGGER.info("IdeModuleController82\u884c-\u4ece\u7f13\u5b58\u5220\u9664\u9875\u9762\u6570\u636e\uff01save {}---{}", (Object)bo.getAppCode(), (Object)bo.getCode());
                        this.ideModulePageCache.removeModulePageCache(bo.getCode(), bo.getCode(), null);
                        this.ideModulePageCache.removeModulePageCache(bo.getCode(), bo.getCode() + "list", null);
                        this.ideModulePageCache.removeModulePageCache(bo.getCode(), bo.getCode() + "card", null);
                        continue;
                    }
                    LOGGER.info("IdeModuleController98\u884c-\u4ece\u7f13\u5b58\u5220\u9664\u9875\u9762\u6570\u636e\uff01save {}---{}", (Object)bo.getAppCode(), (Object)bo.getCode());
                    this.ideModulePageCache.removeModulePageCache(bo.getAppCode(), bo.getCode(), null);
                }
            }
            backData.setBackMsg("\u5220\u9664\u7ec4\u6210\u529f");
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u7ec4\u5931\u8d25", (Throwable)e);
            backData.setBackMsg("\u5220\u9664\u7ec4\u9519\u8bef");
            backData.setSuccess(false);
        }
        return backData;
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.GET})
    public JsonBackData get(@PathVariable(value="id") String id) {
        JsonBackData backData = new JsonBackData();
        try {
            backData.setBackData(this.moduleGroupService.findById(id));
            backData.setBackMsg("\u67e5\u627e\u6210\u529f");
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u7ec4\u5931\u8d25", (Throwable)e);
            backData.setBackMsg("\u67e5\u627e\u9519\u8bef");
            backData.setSuccess(false);
        }
        return backData;
    }

    @RequestMapping(value={"findByAppId/{appId}"}, method={RequestMethod.GET})
    public JsonBackData findByAppId(@PathVariable String appId) {
        JsonBackData backData = new JsonBackData();
        try {
            backData.setBackData(this.moduleGroupService.findByAppId(appId));
            backData.setBackMsg("\u67e5\u627e\u6210\u529f");
        }
        catch (Exception e) {
            backData.setBackMsg("\u67e5\u627e\u9519\u8bef");
            backData.setSuccess(false);
        }
        return backData;
    }
}

