/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.front.business.ide.service.impl;

import com.ejianc.foundation.front.business.ide.entity.IdeApp;
import com.ejianc.foundation.front.business.ide.entity.IdeAppGroup;
import com.ejianc.foundation.front.business.ide.repository.IdeAppGroupRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeAppRepo;
import com.ejianc.foundation.front.business.ide.service.IdeAppGroupService;
import com.ejianc.foundation.front.business.ide.service.IdeCommonService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional
public class IdeAppGroupServiceImpl
implements IdeAppGroupService {
    @Autowired
    IdeAppGroupRepo ideAppGroupRepo;
    @Autowired
    IdeAppRepo ideAppRepo;
    @Autowired
    IdeCommonService ideCommonService;

    @Override
    public IdeAppGroup save(IdeAppGroup appGroup) throws BusinessException {
        IdeAppGroup ideAppGroup = this.ideAppGroupRepo.findByTeamIdAndName(String.valueOf(appGroup.getTeamId()), appGroup.getName(), appGroup.getClientType());
        if (StringUtils.isEmpty((Object)appGroup.getId())) {
            if (ideAppGroup != null) {
                throw new BusinessException("\u540c\u4e00\u4e2a\u56e2\u961f\u4e0b\u4e0d\u80fd\u6709\u76f8\u540c\u7684\u5e94\u7528\u6a21\u5757\u540d\uff01");
            }
            appGroup.setId(IdWorker.getId());
            String appGroupCode = this.ideCommonService.generateAppGroupCode();
            appGroup.setCode(appGroupCode);
            appGroup.setCreateDate(new Date());
            this.ideAppGroupRepo.save(appGroup);
        } else {
            if (ideAppGroup != null && !ideAppGroup.getName().equals(appGroup.getName())) {
                throw new BusinessException("\u540c\u4e00\u4e2a\u56e2\u961f\u4e0b\u4e0d\u80fd\u6709\u76f8\u540c\u7684\u5e94\u7528\u6a21\u5757\u540d\uff01");
            }
            IdeAppGroup _appGroup = this.ideAppGroupRepo.findOne(String.valueOf(appGroup.getId()));
            _appGroup.setName(appGroup.getName());
            _appGroup.setModifyDate(new Date());
            appGroup = this.ideAppGroupRepo.update(_appGroup);
        }
        return appGroup;
    }

    @Override
    public void deleteByIds(String[] ids) throws BusinessException {
        if (ids != null && ids.length > 0) {
            for (String id : ids) {
                IdeAppGroup group = this.ideAppGroupRepo.findOne(id);
                List<IdeApp> groupApps = this.ideAppRepo.findAppByGroupId(String.valueOf(group.getId()));
                if (groupApps != null && groupApps.size() > 0) {
                    throw new BusinessException(group.getName() + "\u6a21\u5757\u4e0b\u5b58\u5728\u5e94\u7528\uff0c\u4e0d\u53ef\u5220\u9664\uff01");
                }
                this.ideAppGroupRepo.logicDel(id);
            }
        }
    }

    @Override
    public IdeAppGroup findById(String id) throws BusinessException {
        return this.ideAppGroupRepo.findOne(id);
    }

    @Override
    public List<IdeAppGroup> findByTeamId(String teamId, String clientType) {
        List<IdeAppGroup> appGroups = this.ideAppGroupRepo.findByTeamId(teamId, clientType);
        if (appGroups != null && appGroups.size() > 0) {
            for (IdeAppGroup ideAppGroup : appGroups) {
                ideAppGroup.setApps(this.ideAppRepo.findAppByGroupId(String.valueOf(ideAppGroup.getId())));
            }
        }
        return appGroups;
    }

    @Override
    public List<IdeAppGroup> findByTeamIds(String teamIds, String clientType) {
        String teamIdStr = teamIds;
        List<IdeAppGroup> appGroups = this.ideAppGroupRepo.findByTeamIds(teamIdStr, clientType);
        if (appGroups != null && appGroups.size() > 0) {
            String groupIds = "";
            for (int i = 0; i < appGroups.size(); ++i) {
                groupIds = groupIds + appGroups.get(i).getId() + ",";
            }
            List<IdeApp> ideApps = this.ideAppRepo.findAppByGroupIds(groupIds.substring(0, groupIds.length() - 1));
            if (ideApps != null && ideApps.size() > 0) {
                HashMap<String, ArrayList<IdeApp>> appMap = new HashMap<String, ArrayList<IdeApp>>();
                for (IdeApp app : ideApps) {
                    ArrayList<IdeApp> appList = (ArrayList<IdeApp>)appMap.get(app.getGroupId());
                    if (appList == null) {
                        appList = new ArrayList<IdeApp>();
                    }
                    appList.add(app);
                    appMap.put(String.valueOf(app.getGroupId()), appList);
                }
                for (IdeAppGroup appGroup : appGroups) {
                    appGroup.setApps((List)appMap.get(appGroup.getId()));
                }
            }
        }
        return appGroups;
    }
}

