/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.front.business.ide.service.impl;

import com.ejianc.foundation.front.business.ide.entity.IdeEntity;
import com.ejianc.foundation.front.business.ide.repository.IdeEntityAttrRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeEntityRepo;
import com.ejianc.foundation.front.business.ide.service.IdeEntityService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.support.idworker.util.IdWorker;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service
public class IdeEntityServiceImpl
implements IdeEntityService {
    @Autowired
    private IdeEntityRepo entityRepo;
    @Autowired
    private IdeEntityAttrRepo entityAttrRepo;

    @Override
    public IdeEntity saveOrUpdate(IdeEntity ideEntity) throws Exception, BusinessException {
        IdeEntity entity = this.entityRepo.findByCodeAndAppId(ideEntity.getCode(), ideEntity.getAppId());
        if (ideEntity.getId() != null && ideEntity.getId() > 0L) {
            if (entity != null && !entity.getCode().equals(ideEntity.getCode())) {
                throw new BusinessException("\u7f16\u7801\u4e0d\u80fd\u91cd\u590d\uff01");
            }
            IdeEntity newEntity = this.entityRepo.findById(ideEntity.getId().toString());
            if (newEntity == null) {
                throw new BusinessException("\u672c\u6a21\u578b\u88ab\u4ed6\u4eba\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u83b7\u53d6\u6700\u65b0\u6570\u636e\uff01");
            }
            if (ideEntity.getVersion() != newEntity.getVersion()) {
                throw new BusinessException(String.format("\u672c\u6a21\u578b\u88ab\u4ed6\u4eba\u4e8e[%s]\u4fee\u6539\u8fc7\uff0c\u8bf7\u5237\u65b0\u83b7\u53d6\u6700\u65b0\u6570\u636e\uff01", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(newEntity.getModifyDate())));
            }
            newEntity.setCode(ideEntity.getCode());
            newEntity.setName(ideEntity.getName());
            newEntity.setModifyDate(new Date());
            newEntity.setModifyId(InvocationInfoProxy.getUserid());
            this.entityRepo.update(newEntity);
            return newEntity;
        }
        if (entity != null) {
            throw new BusinessException("\u7f16\u7801\u4e0d\u80fd\u91cd\u590d\uff01");
        }
        ideEntity.setId(IdWorker.getId());
        ideEntity.setCreateDate(new Date());
        ideEntity.setCreateId(InvocationInfoProxy.getUserid());
        this.entityRepo.save(ideEntity);
        return ideEntity;
    }

    @Override
    public List<IdeEntity> findListByAppId(String appId) throws Exception, BusinessException {
        return this.entityRepo.findByAppId(appId);
    }

    @Override
    public void delete(String id) throws Exception, BusinessException {
        this.entityAttrRepo.deleteEntityId(id);
        this.entityRepo.deleteById(id);
    }

    @Override
    public IdeEntity findOne(String id) throws Exception, BusinessException {
        return this.entityRepo.findById(id);
    }
}

