/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.front.business.ide.service.impl;

import com.ejianc.foundation.front.business.ide.entity.IdeModule;
import com.ejianc.foundation.front.business.ide.entity.IdeModulePro;
import com.ejianc.foundation.front.business.ide.repository.IdeModuleProRepo;
import com.ejianc.foundation.front.business.ide.service.IdeModuleProService;
import com.ejianc.framework.core.exception.BusinessException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class IdeModuleProServiceImpl
implements IdeModuleProService {
    @Autowired
    IdeModuleProRepo ideModuleProRepo;

    @Override
    public List<IdeModulePro> findAllLastPublish() throws Exception {
        return this.ideModuleProRepo.findAllLastPublish();
    }

    @Override
    public List<IdeModulePro> findAllLastPublishByAppId(String appId) throws Exception {
        return this.ideModuleProRepo.findAllLastPublishByAppId(appId);
    }

    @Override
    public IdeModulePro findByAppCodeAndModuleCode(String appCode, String moduleCode) throws Exception {
        List<IdeModulePro> ideModuleProList = this.ideModuleProRepo.findByAppCodeAndModuleCode(appCode, moduleCode);
        return ideModuleProList.get(0);
    }

    @Override
    public void deleteById(String id) throws Exception {
        IdeModulePro ideModulePro = this.ideModuleProRepo.findById(id);
        if (ideModulePro == null) {
            throw new BusinessException("\u6b64\u53d1\u5e03\u9875\u9762\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        this.ideModuleProRepo.deleteByCode(ideModulePro.getCode(), ideModulePro.getToName());
    }

    @Override
    public List<IdeModule> findDiffLastPublish(List<IdeModule> modules, String toName) {
        List pageCodeList = modules.stream().map(IdeModule::getCode).collect(Collectors.toList());
        String pageCodeStr = "'" + StringUtils.join(pageCodeList, (String)"','") + "'";
        List<IdeModulePro> ideModuleProList = this.ideModuleProRepo.findAllLastPublishByCodes(pageCodeStr, toName);
        List<IdeModule> ideModuleList = modules.stream().filter(module -> {
            if (ideModuleProList.size() == 0) {
                return true;
            }
            List proModuleList = ideModuleProList.stream().filter(proModule -> proModule.getCode().equals(module.getCode())).collect(Collectors.toList());
            if (proModuleList == null || proModuleList.size() == 0) {
                return true;
            }
            if (!((IdeModulePro)proModuleList.get(0)).getAppId().equals(module.getAppId())) {
                return true;
            }
            String proData = ((IdeModulePro)proModuleList.get(0)).getData();
            if (!StringUtils.isEmpty((String)module.getData()) && !StringUtils.isEmpty((String)proData)) {
                return module.getData().hashCode() != proData.hashCode();
            }
            return !StringUtils.isEmpty((String)module.getData());
        }).collect(Collectors.toList());
        return ideModuleList;
    }
}

