/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.front.business.ide.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.cfs.api.ICustomTableApi;
import com.ejianc.foundation.cfs.vo.PageData;
import com.ejianc.foundation.front.business.ide.bo.IdeAppBo;
import com.ejianc.foundation.front.business.ide.bo.IdeModuleBo;
import com.ejianc.foundation.front.business.ide.bo.IdeProductionBo;
import com.ejianc.foundation.front.business.ide.bo.IdeTeamBo;
import com.ejianc.foundation.front.business.ide.cache.IdeModulePageCache;
import com.ejianc.foundation.front.business.ide.entity.IdeApp;
import com.ejianc.foundation.front.business.ide.entity.IdeModule;
import com.ejianc.foundation.front.business.ide.entity.IdeModuleData;
import com.ejianc.foundation.front.business.ide.entity.IdeModulePrivate;
import com.ejianc.foundation.front.business.ide.entity.IdeModulePro;
import com.ejianc.foundation.front.business.ide.entity.IdeTeam;
import com.ejianc.foundation.front.business.ide.repository.IdeAppRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeModuleDataRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeModulePrivateRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeModuleProRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeModuleRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeTeamRepo;
import com.ejianc.foundation.front.business.ide.service.IdeAppService;
import com.ejianc.foundation.front.business.ide.service.IdeCommonService;
import com.ejianc.foundation.front.business.ide.service.IdeEnvironmentService;
import com.ejianc.foundation.front.business.ide.service.IdeModulePrivateService;
import com.ejianc.foundation.front.business.ide.service.IdeModuleProService;
import com.ejianc.foundation.front.business.ide.service.IdeModuleService;
import com.ejianc.foundation.front.business.ide.service.MetadataReaderService;
import com.ejianc.foundation.front.common.http.HttpClientUtil;
import com.ejianc.foundation.front.util.JsonBackData;
import com.ejianc.foundation.front.util.StringUtils;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class IdeModuleServiceImpl
implements IdeModuleService {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdeModuleServiceImpl.class);
    private static final Gson gson = new Gson();
    @Autowired
    IdeModuleRepo ideModuleRepo;
    @Autowired
    IdeModuleDataRepo moduleDataRepo;
    @Autowired
    IdeModuleRepo ideModuleRepoImpl;
    @Autowired
    IdeTeamRepo ideTeamRepo;
    @Autowired
    IdeAppService ideAppService;
    @Autowired
    IdeAppRepo ideAppRepo;
    @Autowired
    IdeCommonService ideCommonService;
    @Autowired
    IdeModuleProRepo ideModuleProRepo;
    @Autowired
    IdeModuleProService ideModuleProService;
    @Autowired
    IdeModulePrivateService ideModulePrivateService;
    @Autowired
    IdeEnvironmentService ideEnvironmentService;
    @Autowired
    IdeModulePrivateRepo ideModulePrivateRepo;
    @Autowired
    private MetadataReaderService metadataReaderService;
    @Autowired
    private ICustomTableApi iCustomTableApi;
    @Autowired
    IdeModulePageCache ideModulePageCache;

    @Override
    @Transactional
    public synchronized IdeModule saveOrUpdate(IdeModule ideModule) throws ClassCastException {
        IdeModule ideModuleTemp = null;
        this.setEnData(ideModule);
        if (ideModule.getId() == null) {
            if (StringUtils.isEmpty(String.valueOf(ideModule.getAppId()))) {
                throw new BusinessException("\u6240\u5c5e\u5e94\u7528\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty(ideModule.getName())) {
                throw new BusinessException("\u9875\u9762\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            List<IdeModule> ideModuleList = this.ideModuleRepo.findByName(ideModule.getName(), String.valueOf(ideModule.getAppId()));
            if (ideModuleList.size() > 0) {
                throw new BusinessException("\u5df2\u5b58\u5728\u7684\u9875\u9762\u540d\u79f0");
            }
            ideModule.setId(IdWorker.getId());
            String code = this.ideCommonService.generateModuleCode();
            ideModule.setCode(code);
            Date nowDate = new Date();
            ideModule.setCreateDate(nowDate);
            ideModule.setData(this.getPageInitData(ideModule.getPageType(), ideModule.getName()));
            this.ideModuleRepo.save(ideModule);
            return ideModule;
        }
        ideModuleTemp = this.ideModuleRepo.findById(String.valueOf(ideModule.getId()));
        if (!Objects.equals(ideModule.getTs(), ideModuleTemp.getTs())) {
            throw new BusinessException("\u6570\u636e\u5df2\u88ab\u56e2\u961f\u5176\u4ed6\u6210\u5458\u4fee\u6539\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u4fee\u6539\u540e\u518d\u6b21\u4fdd\u5b58\uff01");
        }
        ideModuleTemp.setTs(new Date().getTime());
        ideModuleTemp.setName(ideModule.getName());
        if (StringUtils.isNotEmpty(ideModule.getClientType())) {
            ideModuleTemp.setClientType(ideModule.getClientType());
        }
        ideModuleTemp.setModifyDate(new Date());
        ideModuleTemp.setModifyName(ideModule.getModifyName());
        if (ideModule.getData() != null) {
            ideModuleTemp.setData(ideModule.getData());
            ideModuleTemp.setEnData(ideModule.getEnData());
        }
        if (StringUtils.isNotEmpty(String.valueOf(ideModule.getGroupId()))) {
            ideModuleTemp.setGroupId(ideModule.getGroupId());
        }
        if (ideModuleTemp.getCode().startsWith("CFS") && StringUtils.isNotEmpty(ideModule.getFromName())) {
            Long userId = Long.parseLong(ideModule.getFromName().split(":")[0]);
            String token = ideModule.getFromName().split(":")[1];
            PageData pageData = new PageData();
            pageData.setAppCode(ideModuleTemp.getCode());
            pageData.setPageMeta(ideModule.getData());
            pageData.setToken(token);
            pageData.setUserId(userId);
            CommonResponse response = this.iCustomTableApi.parse(pageData);
            if (!response.isSuccess()) {
                throw new BusinessException(response.getMsg());
            }
            ideModuleTemp.setFromName(null);
        }
        this.ideModuleRepo.update(ideModuleTemp);
        return ideModuleTemp;
    }

    private void setEnData(IdeModule ideModule) {
        if (StringUtils.isNotEmpty(ideModule.getData())) {
            JSONObject data = JSONObject.parseObject((String)ideModule.getData());
            this.setUiTitleEn(data);
            if (data.get((Object)"children") != null && data.getString("children").contains("[")) {
                JSONArray children = data.getJSONArray("children");
                this.setChildrenEn(children);
            }
            ideModule.setEnData(JSONObject.toJSONString((Object)data));
        }
    }

    private void setUiTitleEn(JSONObject ui) {
        if (StringUtils.isNotEmpty(ui.getString("enTitle"))) {
            ui.put("uititle", (Object)ui.getString("enTitle"));
            if (ui.getString("children") != null && !ui.getString("children").contains("[")) {
                ui.put("children", (Object)ui.getString("enTitle"));
            }
            if (ui.getString("title") != null) {
                ui.put("title", (Object)ui.getString("enTitle"));
            }
            if (ui.getString("label") != null) {
                ui.put("label", (Object)ui.getString("enTitle"));
            }
            if (ui.getString("buttonText") != null) {
                ui.put("buttonText", (Object)ui.getString("enTitle"));
            }
            if (ui.getString("text") != null) {
                ui.put("text", (Object)ui.getString("enTitle"));
            }
        }
    }

    private void setChildrenEn(JSONArray children) {
        for (Object child : children) {
            JSONObject ui = (JSONObject)child;
            this.setUiTitleEn(ui);
            if (ui.get((Object)"children") == null || !ui.getString("children").contains("[")) continue;
            JSONArray cChildren = ui.getJSONArray("children");
            this.setChildrenEn(cChildren);
        }
    }

    private String getPageInitData(String pageType, String pageName) {
        String data = null;
        switch (pageType) {
            case "pageCard": {
                data = "{  \"uikey\": \"pageCard\",  \"uititle\": \"" + pageName + "-\u5361\u7247\",  \"uitype\": \"EJCPage\",  \"pageName\": \"" + pageName + "\",  \"children\": [    {      \"uititle\": \"\u9762\u5305\u5c51\",      \"uitype\": \"EJCBreadcrumb\",      \"nid\": \"nid_" + IdWorker.getId() + "_5158\",      \"children\": [        {          \"uitype\": \"EJCBreadcrumbItem\",          \"uititle\": \"" + pageName + "\",          \"key\": 1591858271953,          \"uikey\": \"K" + IdWorker.getId() + "\",          \"children\": \"" + pageName + "\",          \"nid\": \"nid_" + IdWorker.getId() + "_5156\"        },        {          \"uitype\": \"EJCBreadcrumbItem\",          \"uititle\": \"\u8be6\u60c5\",          \"key\": 1591858273111,          \"uikey\": \"K" + IdWorker.getId() + "\",          \"children\": \"\u8be6\u60c5\",          \"nid\": \"nid_" + IdWorker.getId() + "_5157\"        }      ],      \"uikey\": \"K" + IdWorker.getId() + "\",      \"separator\": \">\"    },{\"uititle\":\"\u53f3\u4fa7\u5ba1\u6279\u9762\u677f\",\"uitype\":\"EJCRightBpmPanel\",\"nid\":\"nid_1647664365234_6790\",\"uikey\":\"rightBpmPanel\",      \"children\": [    {      \"uititle\": \"\u5de5\u5177\u680f\",      \"uitype\": \"EJCToolbar\",      \"align\": \"right\",      \"nid\": \"nid_" + IdWorker.getId() + "_125\",      \"children\": [        {          \"uititle\": \"\u4fdd\u5b58\",          \"uitype\": \"EJCButton\",          \"nid\": \"nid_" + IdWorker.getId() + "_126\",          \"children\": \"\u4fdd\u5b58\",          \"uikey\": \"saveBtn\",          \"type\": \"primary\",          \"icon\": \"book\",          \"visible\": false        },        {          \"uititle\": \"\u53d6\u6d88\",          \"uitype\": \"EJCButton\",          \"nid\": \"nid_" + IdWorker.getId() + "_1157\",          \"children\": \"\u53d6\u6d88\",          \"uikey\": \"cancelBtn\",          \"type\": \"primary\",          \"ghost\": true,          \"icon\": \"cross-circle-o\",          \"visible\": false        },        {          \"uititle\": \"\u4fee\u6539\",          \"uitype\": \"EJCButton\",          \"nid\": \"nid_" + IdWorker.getId() + "_129\",          \"children\": \"\u4fee\u6539\",          \"uikey\": \"editBtn\",          \"type\": \"primary\",          \"ghost\": true,          \"icon\": \"edit\",          \"visible\": false        },        {          \"uititle\": \"\u6253\u5370\",          \"uitype\": \"EJCPrintButton\",          \"nid\": \"nid_" + IdWorker.getId() + "_130\",          \"uikey\": \"printBtn\",          \"ghost\": true,          \"type\": \"primary\",          \"enableOrg\": true,          \"title\": \"\u6253\u5370\"        },        {          \"uititle\": \"\u9644\u4ef6\u7ba1\u7406\",          \"uitype\": \"AttachMgrWidget\",          \"nid\": \"nid_" + IdWorker.getId() + "_8243\",          \"uikey\": \"attachMgr\",          \"align\": \"right\",          \"btnType\": \"primary\",          \"btnGhost\": true,          \"fileLengthVisible\": true,          \"multiple\": true,          \"sourceType\": \"attachMgr\"        },        {          \"uititle\": \"\u63d0\u4ea4\",          \"uitype\": \"BpmSubmitButton\",          \"nid\": \"nid_" + IdWorker.getId() + "_313\",          \"uikey\": \"bpmSubmitBtn\",          \"enableUser\": true,          \"type\": \"primary\",          \"ghost\": true,          \"orgField\": \"orgId\",          \"visible\": false        },        {          \"uititle\": \"\u5220\u9664\",          \"uitype\": \"EJCButton\",          \"nid\": \"nid_" + IdWorker.getId() + "_153\",          \"children\": \"\u5220\u9664\",          \"uikey\": \"removeBtn\",          \"type\": \"error\",          \"icon\": \"delete\",          \"ghost\": true,          \"visible\": false        },        {          \"uititle\": \"\u64a4\u56de\",          \"uitype\": \"EJCButton\",          \"nid\": \"nid_" + IdWorker.getId() + "_478\",          \"children\": \"\u64a4\u56de\",          \"uikey\": \"callBackBtn\",          \"type\": \"primary\",          \"ghost\": true,          \"icon\": \"export\",          \"visible\": false        }      ]    },    {      \"uititle\": \"\u57fa\u672c\u4fe1\u606f\",      \"uitype\": \"EJCPanel\",      \"nid\": \"nid_" + IdWorker.getId() + "_4941\",      \"uikey\": \"K" + IdWorker.getId() + "\",      \"title\": \"\u57fa\u672c\u4fe1\u606f\",      \"expandText\": \"\u6536\u8d77\",      \"collapseText\": \"\u5c55\u5f00\",      \"children\": [        {          \"uititle\": \"\u8868\u5355-\u57fa\u672c\u4fe1\u606f\",          \"uitype\": \"FormWidget\",          \"nid\": \"nid_" + IdWorker.getId() + "_6356\",          \"colnumber\": 4,          \"children\": [],          \"uikey\": \"baseForm\",          \"labelCol\": {            \"span\": 6          },          \"wrapperCol\": {            \"span\": 14          },          \"dataprops\": {}        }       ]     },{\n      \t \"uititle\": \"\u5355\u636e\u5ba1\u8ba1\",\n     \t \"uitype\": \"CPAuditInfo\",\n      \t \"nid\": \"nid_" + IdWorker.getId() + "_65\",\n        \"uikey\": \"K" + IdWorker.getId() + "\",        \"enTitle\": \"\",\n        \"primaryKey\": \"id\"\n     }   ]  } ],  \"nid\": \"nid_" + IdWorker.getId() + "_106\",  \"dataprops\": {},  \"themeClassName\": \"EJC\"}";
                break;
            }
            case "pageList": {
                data = "{    \"children\": [\n        {\n            \"children\": [\n                {\n                    \"children\": \"" + pageName + "\",\n                    \"key\": " + IdWorker.getId() + ",\n                    \"nid\": \"nid_" + IdWorker.getId() + "_3331\",\n                    \"uikey\": \"" + IdWorker.getId() + "\",\n                    \"uititle\": \"" + pageName + "\",\n                    \"uitype\": \"EJCBreadcrumbItem\"\n                },\n                {\n                    \"children\": \"\u5217\u8868\",\n                    \"key\": " + IdWorker.getId() + ",\n                    \"nid\": \"nid_" + IdWorker.getId() + "_8\",\n                    \"uikey\": \"" + IdWorker.getId() + "\",\n                    \"uititle\": \"\u5217\u8868\",\n                    \"uitype\": \"EJCBreadcrumbItem\"\n                }\n            ],\n            \"hideBack\": false,\n            \"hideBillCode\": false,\n            \"hideBillStatus\": false,\n            \"nid\": \"nid_" + IdWorker.getId() + "_3328\",\n            \"noshowadd\": false,\n            \"separator\": \"/\",\n            \"uikey\": \"\",\n            \"uititle\": \"\u9762\u5305\u5c51\",\n            \"uitype\": \"EJCBreadcrumb\"\n        },\n        {\n            \"btnsTop\": false,\n            \"multiSelect\": true,\n            \"nid\": \"nid_" + IdWorker.getId() + "_8\",\n            \"notCeiling\": false,\n            \"orderBtn\": true,\n            \"rowHidden\": false,\n            \"searchButtonText\": \"\u641c\u7d22\",\n            \"searchPlaceholder\": \"\u8bf7\u8f93\u5165\u5173\u952e\u5b57\u67e5\u8be2\",\n            \"showSearch\": true,\n            \"sortGroupList\": [\n                {\n                    \"field\": \"createTime\",\n                    \"name\": \"\u521b\u5efa\u65f6\u95f4\",\n                    \"sequence\": 1\n                }\n            ],\n      \t\t \"filterItems\": [\n        \t\t\t{\n         \t\t\t  \"rowKey\": \"billState\",\n        \t\t\t  \"inputType\": \"selfDefine\",\n        \t\t\t  \"referCode\": null,\n         \t\t\t  \"title\": \"\u5355\u636e\u72b6\u6001\",\n           \t\t  \"activekeys\": [],\n        \t\t\t  \"fields\": [\n        \t\t\t    {\n          \t\t\t     \"value\": \"0\",\n         \t\t\t     \"text\": \"\u81ea\u7531\u6001\"\n         \t\t\t   },\n         \t\t\t   {\n         \t\t\t     \"value\": \"2,5\",\n          \t\t\t     \"text\": \"\u5ba1\u6279\u4e2d\"\n          \t\t\t   },\n          \t\t\t   {\n           \t\t    \"value\": \"1\",\n          \t\t\t    \"text\": \"\u5df2\u63d0\u4ea4\"\n          \t\t\t   },\n          \t\t\t   {\n        \t\t        \"value\": \"3\",\n         \t\t        \"text\": \"\u5ba1\u6279\u901a\u8fc7\"\n         \t\t\t   },\n         \t\t\t   {\n         \t\t\t     \"value\": \"4,6\",\n         \t\t\t     \"text\": \"\u5ba1\u6279\u9a73\u56de\"\n        \t\t\t    }\n        \t\t  ]\n       \t\t }\n      \t\t ],\n            \"uikey\": \"filterBar\",\n            \"uititle\": \"\u7b5b\u9009\u680f\",\n            \"uitype\": \"EJCFilterArea\"\n        },\n        {\n            \"bordered\": true,\n            \"checkable\": false,\n            \"children\": [\n                {\n                    \"dataIndex\": \"code\",\n                    \"key\": \"code\",\n                    \"nid\": \"nid_" + IdWorker.getId() + "\",\n                    \"title\": \"\u5355\u636e\u7f16\u7801\",\n                    \"uikey\": \"code\",\n                    \"uititle\": \"\u5355\u636e\u7f16\u7801\",\n                    \"uitype\": \"EJCTableCol\"\n                }\n            ],\n            \"maxHeight\": 440,\n            \"nid\": \"nid_" + IdWorker.getId() + "_971\",\n            \"rowKey\": \"id\",\n            \"showRowNum\": true,\n            \"uikey\": \"CPListTable\",\n            \"uititle\": \"\u6570\u636e\u8868\u683c\",\n            \"uitype\": \"TableWidget\"\n        },\n        {\n            \"uititle\": \"\u63d2\u4ef6\u7ba1\u7406\",\n            \"uitype\": \"CPPluginMgr\",\n            \"nid\": \"nid_" + IdWorker.getId() + "_8\",\n            \"uikey\": \"listPlugin\",\n            \"exportExcel\": false,\n            \"attachMgr\": false\n        }\n    ],\n    \"dataprops\": {},\n    \"nid\": \"nid_" + IdWorker.getId() + "_755\",\n    \"themeClassName\": \"EJC\",\n    \"uikey\": \"pageList\",\n    \"uititle\": \"" + pageName + "\",\n    \"uitype\": \"EJCPage\"\n}";
                break;
            }
            case "listCardPage": {
                data = "{\n  \"uikey\": \"CPListPage\",\n  \"uititle\": \"" + pageName + "\u5217\u8868\",\n  \"uitype\": \"CPListPage\",\n  \"nid\": \"nid_" + IdWorker.getId() + "_5\",\n  \"children\": [\n    {\n      \"uititle\": \"\u9762\u5305\u5c51\",\n      \"uitype\": \"EJCBreadcrumb\",\n      \"nid\": \"nid_" + IdWorker.getId() + "_2\",\n      \"children\": [\n        {\n          \"uitype\": \"EJCBreadcrumbItem\",\n          \"uititle\": \"" + pageName + "\",\n          \"key\": 1591858544356,\n          \"uikey\": \"1591858544356\",\n          \"children\": \"" + pageName + "\",\n          \"nid\": \"nid_" + IdWorker.getId() + "_5\",\n          \"enTitle\": \"\"\n        },\n        {\n          \"uitype\": \"EJCBreadcrumbItem\",\n          \"uititle\": \"\u5217\u8868\",\n          \"key\": 1591858646983,\n          \"uikey\": \"1591858646983\",\n          \"children\": \"\u5217\u8868\",\n          \"nid\": \"nid_" + IdWorker.getId() + "_7\"\n        }\n      ]\n    },\n    {\n      \"uitype\": \"EJCFilterArea\",\n      \"nid\": \"nid_" + IdWorker.getId() + "_2\",\n      \"multiSelect\": true,\n      \"showSearch\": true,\n      \"rowHidden\": false,\n      \"searchButtonText\": \"\u641c\u7d22\",\n      \"orderBtn\": true,\n      \"btnWrapperStyle\": {\n        \"textAlign\": \"right\",\n        \"marginBottom\": \"0px\",\n        \"paddingBottom\": \"5px\"\n      },\n      \"sortGroupList\": [\n        {\n          \"field\": \"createTime\",\n          \"name\": \"\u521b\u5efa\u65f6\u95f4\",\n          \"sequence\": 1\n        }\n      ],\n      \"children\": [\n        {\n          \"uititle\": \"\u65b0\u5efa\",\n          \"uitype\": \"EJCButton\",\n          \"nid\": \"nid_" + IdWorker.getId() + "_2\",\n          \"children\": \"\u65b0\u5efa\",\n          \"style\": {\n            \"float\": \"left\",\n            \"borderRadius\": \"4px\"\n          },\n          \"uikey\": \"addBtn\",\n          \"type\": \"primary\",\n          \"icon\": \"plus\",\n          \"textButton\": false\n        },\n        {\n          \"uititle\": \"\u5bfc\u51fa\",\n          \"uitype\": \"EJCButton\",\n          \"nid\": \"nid_" + IdWorker.getId() + "_5\",\n          \"children\": \"\u5bfc\u51fa\",\n          \"style\": {\n            \"float\": \"left\",\n            \"borderRadius\": \"4px\"\n          },\n          \"uikey\": \"exportBtn\",\n          \"type\": \"primary\",\n          \"ghost\": true,\n          \"icon\": \"upload\"\n        }\n      ],\n      \"uikey\": \"listViewFilter\",\n      \"uititle\": \"\u7b5b\u9009\u680f\",\n      \"filterItems\": [\n        {\n          \"rowKey\": \"billState\",\n          \"inputType\": \"selfDefine\",\n          \"referCode\": null,\n          \"title\": \"\u5355\u636e\u72b6\u6001\",\n          \"activekeys\": [],\n          \"fields\": [\n            {\n              \"value\": \"0\",\n              \"text\": \"\u81ea\u7531\u6001\"\n            },\n            {\n              \"value\": \"2,5\",\n              \"text\": \"\u5ba1\u6279\u4e2d\"\n            },\n            {\n              \"value\": \"1\",\n              \"text\": \"\u5df2\u63d0\u4ea4\"\n            },\n            {\n              \"value\": \"3\",\n              \"text\": \"\u5ba1\u6279\u901a\u8fc7\"\n            },\n            {\n              \"value\": \"4,6\",\n              \"text\": \"\u5ba1\u6279\u9a73\u56de\"\n            }\n          ]\n        }\n      ],\n      \"searchPlaceholder\": \"\u8bf7\u8f93\u5165\u5173\u952e\u5b57\u67e5\u8be2\",\n      \"className\": \"btnWrapper\",\n      \"btnsTop\": false,\n      \"notCeiling\": false\n    },\n    {\n      \"uititle\": \"\u5217\u8868\u5361\u7247\u89c6\u56fe\",\n      \"uitype\": \"EjcListView\",\n      \"nid\": \"nid_" + IdWorker.getId() + "_2\",\n      \"uikey\": \"listView\",\n      \"dataprops\": {},\n      \"rowKey\": \"id\",\n      \"headerBtn\": false,\n      \"viewModeBtnVisible\": false\n    },\n    {\n      \"uititle\": \"\u63d2\u4ef6\u7ba1\u7406\",\n      \"uitype\": \"CPPluginMgr\",\n      \"nid\": \"nid_" + IdWorker.getId() + "_6661\",\n      \"uikey\": \"CPPluginMgr\"\n    }\n  ],\n  \"dataprops\": {},\n  \"themeClassName\": \"GEJC\"\n}";
                break;
            }
            default: {
                data = null;
            }
        }
        return data;
    }

    @Override
    public void copyModule(IdeModule ideModule) throws Exception {
        IdeModule ideModuleSrc = this.ideModuleRepo.findById(String.valueOf(ideModule.getId()));
        IdeModule ideModuleSave = new IdeModule();
        ideModuleSave.setId(IdWorker.getId());
        BeanUtils.copyProperties((Object)ideModuleSrc, (Object)ideModuleSave, (String[])new String[]{"id", "fromId", "fromName", "createId", "createDate", "name", "modifyName"});
        ideModuleSave.setCreateId(ideModule.getCreateId());
        ideModuleSave.setCreateDate(new Date());
        ideModuleSave.setName(ideModule.getName());
        String code = this.ideCommonService.generateModuleCode();
        ideModuleSave.setCode(code);
        ideModuleSave.setAppId(ideModule.getAppId());
        ideModuleSave.setGroupId(ideModule.getGroupId());
        ideModuleSave.setFromId(ideModule.getFromId());
        ideModuleSave.setPageType(ideModule.getPageType());
        ideModuleSave.setFromName(ideModule.getFromName());
        this.ideModuleRepo.save(ideModuleSave);
    }

    @Override
    public IdeModule findByCode(String moduleCode) {
        List<IdeModule> ideModules = this.ideModuleRepo.findAllByCode(moduleCode);
        if (ideModules != null && ideModules.size() > 0) {
            return ideModules.get(0);
        }
        return null;
    }

    @Override
    public List<IdeModule> findByAppId(String appId) throws Exception {
        List<IdeModule> ideModules = this.ideModuleRepo.findDetailsByAppId(appId);
        return ideModules;
    }

    @Override
    public List<IdeModule> findIsDeleteModules(String appId) throws Exception {
        List<IdeModule> ideModules = this.ideModuleRepo.findModulesByAppId(appId, 1);
        return ideModules;
    }

    @Override
    public void deleteById(String id) throws Exception {
        this.ideModuleRepo.deleteById(id);
        this.ideModulePrivateRepo.deleteByModuleIds(id);
        IdeModuleData moduleData = this.moduleDataRepo.findByModuleId(Long.parseLong(id));
        if (moduleData != null) {
            this.moduleDataRepo.deleteById(moduleData);
        }
    }

    @Override
    public IdeModuleBo findById(String id) throws Exception {
        IdeModuleBo ideModuleBo = this.ideModuleRepoImpl.findDetailById(id);
        if (ideModuleBo == null) {
            throw new BusinessException("\u6ca1\u6709\u53ef\u5907\u4efd\u7684\u9875\u9762");
        }
        return ideModuleBo;
    }

    @Override
    public IdeModule findEntityById(String id) {
        return this.ideModuleRepo.findById(id);
    }

    @Override
    public IdeModule findByAppCodeAndModuleCode(String appCode, String moduleCode) {
        LOGGER.info("findByAppCodeAndModuleCode ======== {{}}---{{}}", (Object)appCode, (Object)moduleCode);
        return this.ideModuleRepo.findByAppCodeAndModuleCode(appCode, moduleCode);
    }

    @Override
    public Object findByAppCodeAndModuleCodeAndOrgId(String appCode, String pageCode, String orgId, String tenantId) {
        IdeModulePrivate orgPage = null;
        if (StringUtils.isNotEmpty(orgId) && StringUtils.isNotEmpty(tenantId)) {
            orgPage = this.ideModulePrivateService.findByOrgId(pageCode, appCode, orgId, tenantId);
        }
        LOGGER.info("orgPage ======== " + orgPage);
        if (orgPage != null) {
            return orgPage;
        }
        return this.findByAppCodeAndModuleCode(appCode, pageCode);
    }

    @Override
    public void publishHistory(IdeModule ideModule, String fromName, String toName) {
        IdeModulePro module = new IdeModulePro();
        BeanUtils.copyProperties((Object)ideModule, (Object)module, (String[])new String[]{"id", "createDate", "modifyDate"});
        module.setCreateDate(new Date());
        module.setFromName(fromName);
        module.setToName(toName);
        int maxVer = this.ideModuleProRepo.findMaxVersion(ideModule.getCode(), toName);
        module.setVerNum(++maxVer);
        module.setId(IdWorker.getId());
        module.setCreateDate(new Date());
        this.ideModuleProRepo.save(module);
    }

    @Override
    public List<IdeModule> findInAppIds(String[] appIds) {
        List<IdeModule> modules = new ArrayList<IdeModule>();
        if (appIds == null || appIds.length == 0) {
            return modules;
        }
        String appIdStr = "'" + org.apache.commons.lang.StringUtils.join(Arrays.asList(appIds), (String)"','") + "'";
        modules = this.ideModuleRepo.findInAppIds(appIdStr);
        return modules;
    }

    @Override
    public List<IdeModule> findByGroupIds(String[] groupIds) {
        List<IdeModule> modules = new ArrayList<IdeModule>();
        if (groupIds == null || groupIds.length == 0) {
            return modules;
        }
        String groupIdStr = "'" + org.apache.commons.lang.StringUtils.join(Arrays.asList(groupIds), (String)"','") + "'";
        modules = this.ideModuleRepo.findByGroupIds(groupIdStr);
        return modules;
    }

    @Override
    @Transactional
    public JsonBackData syncPublishProduction(String appId, List<String> pageIds, String fromName, String toName) throws Exception {
        if (StringUtils.isEmpty(toName)) {
            return JsonBackData.toError("\u65e0\u6cd5\u53d1\u5e03\uff1a\u53d1\u5e03\u76ee\u6807\u5730\u5740\u4e0d\u5b58\u5728\uff01");
        }
        if (pageIds == null || pageIds.size() == 0) {
            return JsonBackData.toError("\u65e0\u6cd5\u53d1\u5e03\uff1a\u6ca1\u6709\u53ef\u53d1\u5e03\u7684\u9875\u9762\uff01");
        }
        IdeApp app = this.ideAppService.findById(appId);
        if (app == null) {
            return JsonBackData.toError("\u53d1\u5e03\u7684\u5e94\u7528[" + appId + "]\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\uff01");
        }
        IdeTeamBo team = null;
        if (app.getTeamId() != null) {
            if (!this.ideEnvironmentService.isInWhiteList(toName, String.valueOf(app.getTeamId()))) {
                return JsonBackData.toError("\u672c\u56e2\u961f\u88ab\u9650\u5236\u53d1\u5e03\u5e94\u7528\u5230[" + toName + "]\u73af\u5883\uff0c\u53ef\u8054\u7cfb\u8d85\u7ea7\u7ba1\u7406\u5458\u8fdb\u884c\u6388\u6743\uff01");
            }
            IdeTeam teamBean = this.ideTeamRepo.findOne(String.valueOf(app.getTeamId()));
            if (teamBean != null) {
                team = new IdeTeamBo(teamBean);
            }
        }
        ArrayList<String> notExistPages = new ArrayList<String>();
        List failPages = new ArrayList();
        IdeProductionBo postData = new IdeProductionBo();
        postData.setIdeTeam(team);
        postData.setIdeApp(new IdeAppBo(app));
        postData.setFromName(fromName);
        postData.setToName(toName);
        List<IdeModule> publishModules = new ArrayList<IdeModule>();
        for (String moduleId : pageIds) {
            IdeModule module = this.findEntityById(moduleId);
            if (module == null) {
                notExistPages.add(moduleId);
                continue;
            }
            module.setAppCode(app.getCode());
            publishModules.add(module);
        }
        if ((publishModules = this.ideModuleProService.findDiffLastPublish(publishModules, toName)).size() == 0) {
            return JsonBackData.toSuccess("\u6240\u53d1\u5e03\u9875\u9762\u4e0e\u6700\u65b0\u7248\u672c\u76f8\u540c\uff0c\u65e0\u9700\u91cd\u590d\u53d1\u5e03");
        }
        for (IdeModule ideModule : publishModules) {
            postData.getIdeModules().add(new IdeModuleBo(ideModule));
        }
        ObjectMapper mapper = new ObjectMapper();
        String postJson = mapper.writeValueAsString((Object)postData);
        LOGGER.info("\u53d1\u9001\u6570\u636e\uff1a" + postJson);
        HttpResponse httpresponse = HttpClientUtil.postJSON(toName + "/ejc-front-web/ide/production/syncreceive", postJson);
        if (httpresponse == null) {
            return JsonBackData.toError("\u53d1\u5e03\u5931\u8d25\uff0c\u76ee\u6807\u670d\u52a1\u5668\u54cd\u5e94\u5f02\u5e38");
        }
        int resCode = httpresponse.getStatusLine().getStatusCode();
        if (resCode != 200) {
            return JsonBackData.toError("\u53d1\u5e03\u5931\u8d25\uff0c\u76ee\u6807\u670d\u52a1\u5668\u5f02\u5e38\uff0c\u54cd\u5e94\u72b6\u6001\u7801\uff1a" + resCode);
        }
        JSONObject resultObj = null;
        String result = EntityUtils.toString((HttpEntity)httpresponse.getEntity());
        try {
            resultObj = (JSONObject)JSONObject.parse((String)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return JsonBackData.toError(result);
        }
        JsonBackData jsonBackData = new JsonBackData();
        jsonBackData.setSuccess(resultObj.getBoolean("success"));
        jsonBackData.setBackData(resultObj.get((Object)"backData"));
        jsonBackData.setBackMsg(resultObj.getString("backMsg"));
        if (jsonBackData.isSuccess()) {
            for (IdeModule module : publishModules) {
                this.publishHistory(module, fromName, toName);
            }
        } else {
            return jsonBackData;
        }
        ObjectMapper objectMapper = new ObjectMapper();
        failPages = (List)objectMapper.readValue(objectMapper.writeValueAsString(jsonBackData.getBackData()), (TypeReference)new TypeReference<ArrayList<String>>(){});
        if (notExistPages.size() > 0 || failPages.size() > 0) {
            HashMap<String, Object> backData = new HashMap<String, Object>();
            backData.put("notExist", notExistPages.size());
            backData.put("failPages", failPages);
            return JsonBackData.toSuccess("\u53d1\u5e03\u5b8c\u6210", backData);
        }
        return JsonBackData.toSuccess("\u53d1\u5e03\u6210\u529f");
    }

    @Override
    public JSONObject getOnlineText(String appId, List<String> pageIds, String fromName, String toName) {
        if (StringUtils.isEmpty(toName)) {
            throw new BusinessException("\u65e0\u6cd5\u53d1\u5e03\uff1a\u53d1\u5e03\u76ee\u6807\u5730\u5740\u4e0d\u5b58\u5728\uff01");
        }
        if (pageIds == null || pageIds.size() == 0) {
            throw new BusinessException("\u65e0\u6cd5\u53d1\u5e03\uff1a\u6ca1\u6709\u53ef\u53d1\u5e03\u7684\u9875\u9762\uff01");
        }
        IdeApp app = this.ideAppService.findById(appId);
        if (app == null) {
            throw new BusinessException("\u53d1\u5e03\u7684\u5e94\u7528[" + appId + "]\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\uff01");
        }
        IdeTeamBo team = null;
        if (app.getTeamId() != null) {
            if (!this.ideEnvironmentService.isInWhiteList(toName, String.valueOf(app.getTeamId()))) {
                throw new BusinessException("\u672c\u56e2\u961f\u88ab\u9650\u5236\u53d1\u5e03\u5e94\u7528\u5230[" + toName + "]\u73af\u5883\uff0c\u53ef\u8054\u7cfb\u8d85\u7ea7\u7ba1\u7406\u5458\u8fdb\u884c\u6388\u6743\uff01");
            }
            IdeTeam teamBean = this.ideTeamRepo.findOne(String.valueOf(app.getTeamId()));
            if (teamBean != null) {
                team = new IdeTeamBo(teamBean);
            }
        }
        ArrayList failPages = new ArrayList();
        IdeProductionBo postData = new IdeProductionBo();
        postData.setIdeTeam(team);
        postData.setIdeApp(new IdeAppBo(app));
        postData.setFromName(fromName);
        postData.setToName(toName);
        ArrayList<IdeModule> publishModules = new ArrayList<IdeModule>();
        for (String moduleId : pageIds) {
            IdeModule module = this.findEntityById(moduleId);
            module.setAppCode(app.getCode());
            publishModules.add(module);
        }
        for (IdeModule ideModule : publishModules) {
            postData.getIdeModules().add(new IdeModuleBo(ideModule));
        }
        String postJson = JSONObject.toJSONString((Object)postData);
        JSONObject res = new JSONObject();
        res.put("version", (Object)("\u79fb\u52a8\u8bbe\u8ba1\u5668\u4e0a\u7ebf\u7248\u672c:" + DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)new Date()) + ".txt"));
        res.put("textContent", (Object)postJson);
        return res;
    }

    @Override
    @Transactional
    public JsonBackData syncReciveProduction(IdeProductionBo production) throws Exception {
        IdeAppBo appBo;
        IdeApp ideApp;
        LOGGER.info("\u63a5\u6536\u6570\u636e\uff1a" + JSONObject.toJSONString((Object)production));
        IdeTeamBo teamBo = production.getIdeTeam();
        IdeTeam ideTeam = null;
        if (teamBo != null) {
            ideTeam = this.ideTeamRepo.findOne(teamBo.getId());
            if (ideTeam == null) {
                ideTeam = new IdeTeam();
                BeanUtils.copyProperties((Object)teamBo, (Object)ideTeam, (String[])new String[]{"modifyDate"});
                ideTeam.setId(Long.parseLong(teamBo.getId()));
                LOGGER.info("ideTeam==null \u6ca1\u627e\u5230\u65b0\u5efateam\uff1a" + JSONObject.toJSONString((Object)ideTeam));
                this.ideTeamRepo.save(ideTeam);
            } else {
                BeanUtils.copyProperties((Object)teamBo, (Object)ideTeam, (String[])new String[]{"modifyDate"});
                LOGGER.info("\u627e\u5230team,\u66f4\u65b0\uff1a" + JSONObject.toJSONString((Object)ideTeam));
                this.ideTeamRepo.update(ideTeam);
            }
        }
        if ((ideApp = this.ideAppRepo.findById((appBo = production.getIdeApp()).getId())) != null) {
            BeanUtils.copyProperties((Object)appBo, (Object)ideApp);
            ideApp.setTeamId(Long.parseLong(appBo.getTeamId()));
            if (StringUtils.isNotEmpty(appBo.getGroupId()) && !Objects.equals(appBo.getGroupId(), "null")) {
                ideApp.setGroupId(Long.parseLong(appBo.getGroupId()));
            }
            LOGGER.info("\u627e\u5230ideApp\uff0c\u66f4\u65b0\uff1a" + JSONObject.toJSONString((Object)ideApp));
            this.ideAppRepo.update(ideApp);
        } else {
            ideApp = new IdeApp();
            BeanUtils.copyProperties((Object)appBo, (Object)ideApp, (String[])new String[]{"modifyDate"});
            ideApp.setId(Long.parseLong(appBo.getId()));
            ideApp.setTeamId(Long.parseLong(appBo.getTeamId()));
            if (StringUtils.isNotEmpty(appBo.getGroupId()) && !Objects.equals(appBo.getGroupId(), "null")) {
                ideApp.setGroupId(Long.parseLong(appBo.getGroupId()));
            }
            LOGGER.info("\u6ca1\u627e\u5230ideApp\uff0c\u65b0\u5efa\uff1a" + JSONObject.toJSONString((Object)ideApp));
            this.ideAppRepo.save(ideApp);
        }
        List<IdeModuleBo> moduleBos = production.getIdeModules();
        ArrayList<IdeModule> updatedPages = new ArrayList<IdeModule>();
        LOGGER.info("\u63a5\u6536\u5230\u9875\u9762\uff1a" + JSONObject.toJSONString(moduleBos));
        ArrayList<String> failPages = new ArrayList<String>();
        if (moduleBos != null && moduleBos.size() > 0) {
            for (IdeModuleBo moduleBo : moduleBos) {
                try {
                    IdeModule ideModule = this.ideModuleRepo.findById(moduleBo.getId());
                    if (ideModule == null || ideModule.getId() == null) {
                        ideModule = new IdeModule();
                        BeanUtils.copyProperties((Object)moduleBo, (Object)ideModule, (String[])new String[]{"modifyDate"});
                        ideModule.setId(Long.parseLong(moduleBo.getId()));
                        ideModule.setAppId(Long.parseLong(moduleBo.getAppId()));
                        if (StringUtils.isNotEmpty(moduleBo.getGroupId()) && !Objects.equals(moduleBo.getGroupId(), "null")) {
                            ideModule.setGroupId(Long.parseLong(moduleBo.getGroupId()));
                        }
                        LOGGER.info("\u5bfb\u627e\u9875\u9762\uff1apageCode" + moduleBo.getCode() + " AppID\uff1a" + ideApp.getId() + " \u7ed3\u679c:\u6ca1\u627e\u5230\uff0c\u65b0\u5efa\uff1a" + JSONObject.toJSONString((Object)ideModule));
                        this.ideModuleRepo.save(ideModule);
                    } else {
                        BeanUtils.copyProperties((Object)moduleBo, (Object)ideModule, (String[])new String[]{"modifyDate"});
                        ideModule.setAppId(Long.parseLong(moduleBo.getAppId()));
                        if (StringUtils.isNotEmpty(moduleBo.getGroupId()) && !Objects.equals(moduleBo.getGroupId(), "null")) {
                            ideModule.setGroupId(Long.parseLong(moduleBo.getGroupId()));
                        }
                        LOGGER.info("\u5bfb\u627e\u9875\u9762\uff1apageCode" + moduleBo.getCode() + " AppID\uff1a" + ideApp.getId() + " \u7ed3\u679c\u627e\u5230\u4e86:\u66f4\u65b0" + JSONObject.toJSONString((Object)ideModule));
                        this.ideModuleRepo.update(ideModule);
                        LOGGER.info("\u5220\u9664\u53d1\u5e03\u9875\u9762\u7f13\u5b58\uff1apageCode" + moduleBo.getCode() + " AppCode\uff1a" + moduleBo.getAppCode());
                        LOGGER.info("\u4ece\u7f13\u5b58\u5220\u9664\u9875\u9762\u6570\u636e\uff01\u53d1\u5e03\u9875\u9762{}---{}---{}", new Object[]{moduleBo.getAppCode(), moduleBo.getCode(), null});
                        this.ideModulePageCache.removeModulePageCache(moduleBo.getAppCode(), moduleBo.getCode(), null);
                        ideModule.setAppCode(ideApp.getCode());
                        updatedPages.add(ideModule);
                    }
                    LOGGER.info("\u4fdd\u5b58\u5230\u53d1\u5e03\u5386\u53f2\u8bb0\u5f55.....");
                    this.publishHistory(ideModule, production.getFromName(), production.getToName());
                    LOGGER.info("\u4fdd\u5b58\u5230\u53d1\u5e03\u5386\u53f2\u8bb0\u5f55.....\u6210\u529f");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LOGGER.error("\u53d1\u5e03\u5931\u8d25\uff1a" + e.getMessage() + "  \u9875\u9762\uff1a[" + moduleBo.getCode() + "]" + moduleBo.getName());
                    failPages.add("[" + moduleBo.getCode() + "]" + moduleBo.getName());
                }
            }
            LOGGER.info("\u5373\u5c06\u8d77\u52a8\u9875\u9762\u8282\u70b9\u589e\u91cf\u5206\u6790\u7ebf\u7a0b\uff0c\u5904\u7406\u9875\u9762\u65b0\u589e\u8282\u70b9\u95ee\u9898.......");
            this.updatePrivatePage(updatedPages);
        }
        return JsonBackData.toSuccess("\u53d1\u5e03\u6210\u529f", failPages);
    }

    @Override
    public void updatePrivatePage(List<IdeModule> pages) {
        Thread runnable = new Thread(() -> {
            LOGGER.info("1\u3001\u9875\u9762\u8282\u70b9\u589e\u91cf\u5206\u6790\u7ebf\u7a0b\u542f\u52a8.....");
            for (IdeModule page : pages) {
                LOGGER.info("2\u3001\u9875\u9762\u8282\u70b9\u589e\u91cf\u5206\u6790\u7ebf\u7a0b  page ={},{}", (Object)page.getCode(), (Object)page.getAppCode());
                List<IdeModulePrivate> privates = this.ideModulePrivateService.findByPageCodeAndAppCode(page.getCode(), page.getAppCode());
                if (ListUtil.isNotEmpty(privates)) {
                    JsonObject baseData = (JsonObject)gson.fromJson(page.getData(), JsonObject.class);
                    for (IdeModulePrivate aPrivate : privates) {
                        JsonObject provData = (JsonObject)gson.fromJson(aPrivate.getData(), JsonObject.class);
                        LOGGER.info("3\u3001\u9875\u9762\u8282\u70b9\u589e\u91cf\u5206\u6790\u7ebf\u7a0b {}{} baseData ={},provData={},", new Object[]{page.getCode(), page.getAppCode(), baseData, provData});
                        JsonArray baseChildren = baseData.getAsJsonArray("children");
                        JsonArray provChildren = provData.getAsJsonArray("children");
                        IdeModuleServiceImpl.processChildren(baseChildren, provChildren);
                        aPrivate.setData(provData.toString());
                        LOGGER.info("4\u3001\u9875\u9762\u8282\u70b9\u589e\u91cf\u5206\u6790\u7ebf\u7a0b \u4fdd\u5b58\u79c1\u6709\u5316\u9875\u9762....{}", (Object)provData.toString());
                        this.ideModulePrivateService.saveData(aPrivate);
                        LOGGER.info("5\u3001\u9875\u9762\u8282\u70b9\u589e\u91cf\u5206\u6790\u7ebf\u7a0b\u4ece\u7f13\u5b58\u5220\u9664\u9875\u9762\u6570\u636e\uff01\u79c1\u6709\u5316\u9875\u9762{}---{}---{}", new Object[]{aPrivate.getAppCode(), aPrivate.getCode(), aPrivate.getOrgId()});
                        this.ideModulePageCache.removeModulePageCache(aPrivate.getAppCode(), aPrivate.getCode(), aPrivate.getOrgId() + "");
                    }
                    continue;
                }
                LOGGER.info("6\u3001\u9875\u9762\u8282\u70b9\u589e\u91cf\u5206\u6790\u7ebf\u7a0b\u6ca1\u6709\u79c1\u6709\u5316\u9875\u9762---{}---{}", (Object)page.getAppCode(), (Object)page.getCode());
            }
            LOGGER.info("7\u3001.....\u9875\u9762\u8282\u70b9\u589e\u91cf\u5206\u6790\u7ebf\u7a0b\u6267\u884c\u5b8c\u6bd5\uff01");
        });
        runnable.start();
    }

    private static void processChildren(JsonArray baseChildren, JsonArray provChildren) {
        if (baseChildren != null && baseChildren.size() > 0) {
            LOGGER.info("baseChildren ={},provChildren={}", (Object)baseChildren, (Object)provChildren);
            for (JsonElement child : baseChildren) {
                JsonObject base = (JsonObject)child;
                JsonObject provP = null;
                boolean exist = false;
                for (Object provChild : provChildren) {
                    JsonObject prov = (JsonObject)provChild;
                    if (!Objects.equals(prov.get("nid"), base.get("nid"))) continue;
                    exist = true;
                    provP = prov;
                    break;
                }
                if (exist) {
                    if (!Objects.equals(base.get("uitype"), provP.get("uitype")) || !Objects.equals(base.get("uisubtype"), provP.get("uisubtype"))) {
                        provChildren.remove(provP);
                        base.add("uititle", provP.get("uititle"));
                        base.add("label", provP.get("label"));
                        provChildren.add((JsonElement)base);
                        LOGGER.info("\u5b58\u5728\uff0c\u7c7b\u578b\u4e0d\u540c\uff0c\u66ff\u6362 \u79c1\u6709\uff1a" + provP + "  \u65b0\u7684\uff1a" + base);
                        continue;
                    }
                    JsonElement baseObj = base.get("children");
                    if (!(baseObj instanceof JsonArray)) continue;
                    JsonArray baseChild = base.getAsJsonArray("children");
                    JsonArray provChild = provP.getAsJsonArray("children");
                    if (baseChild != null && baseChild.size() > 0 && (provChild == null || provChild.size() == 0)) {
                        LOGGER.info("\u5b50\u7ec4\u4ef6children\u4e0d\u5b58\u5728\uff0c\u6dfb\u52a0 \u79c1\u6709\uff1a" + provP + "  \u65b0\u7684\uff1a" + base);
                        provP.add("children", (JsonElement)baseChild);
                        continue;
                    }
                    IdeModuleServiceImpl.processChildren(baseChild, provChild);
                    continue;
                }
                LOGGER.info("\u4e0d\u5b58\u5728\uff0c\u5219\u6dfb\u52a0\u8282\u70b9 {} {}", (Object)base, (Object)provChildren);
                provChildren.add((JsonElement)base);
            }
        }
    }

    public static void main(String[] args) {
        String jsonBase = "{\"uikey\":\"M1366649681864491011\",\"uititle\":\"\u7269\u8d44\u603b\u8ba1\u5212\u8be6\u60c5\",\"uitype\":\"EJCPage\",\"themeClassName\":\"GEJC\",\"children\":[{\"uititle\":\"\u9762\u5305\u5c511\",\"uitype\":\"EJCBreadcrumb\",\"nid\":\"nid_1614669667403_29066\",\"uikey\":\"K1614669667403\",\"children\":[{\"uitype\":\"EJCBreadcrumbItem\",\"uititle\":\"\u7269\u8d44\u603b\u8ba1\u5212\",\"key\":1614669688705,\"uikey\":\"1614669688705\",\"children\":\"\u7269\u8d44\u603b\u8ba1\u5212\",\"nid\":\"nid_1614669688706_29068\",\"href\":\"/materialMasterPlan\"},{\"uitype\":\"EJCBreadcrumbItem\",\"uititle\":\"\u8be6\u60c5\",\"key\":1614669689688,\"uikey\":\"1614669689688\",\"children\":\"\u8be6\u60c5\",\"nid\":\"nid_1614669689688_29069\"}]},{\"uititle\":\"\u5de5\u5177\u680f2\",\"uitype\":\"EJCToolbar\",\"nid\":\"nid_1614669845851_29082\",\"uikey\":\"K1614669845851\",\"children\":[{\"uititle\":\"\u4fdd\u5b58\",\"uitype\":\"EJCButton\",\"nid\":\"nid_1614669850964_29087\",\"children\":\"\u4fdd\u5b58\",\"uikey\":\"saveBtn\",\"type\":\"primary\",\"icon\":\"book\"},{\"uititle\":\"\u53d6\u6d88\",\"uitype\":\"EJCButton\",\"nid\":\"nid_1614669981594_29665\",\"children\":\"\u53d6\u6d88\",\"uikey\":\"cancelBtn\",\"icon\":\"cross-circle-o\",\"type\":\"primary\",\"ghost\":true},{\"uititle\":\"\u7f16\u8f91\",\"uitype\":\"EJCButton\",\"nid\":\"nid_1614669889638_29262\",\"children\":\"\u7f16\u8f91\",\"uikey\":\"editBtn\",\"icon\":\"edit\",\"type\":\"primary\",\"ghost\":true},{\"uititle\":\"\u6253\u5370\",\"uitype\":\"EJCPrintButton\",\"nid\":\"nid_1614670134241_29978\",\"uikey\":\"printBtn\",\"title\":\"\u6253\u5370\",\"enableOrg\":true,\"ghost\":true,\"type\":\"primary\",\"billName\":\"\u7269\u8d44\u603b\u8ba1\u5212\",\"billType\":\"BT210302000000004\"},{\"uititle\":\"\u5ba1\u6279\u76f8\u5173\",\"uitype\":\"BpmApproveWidget\",\"nid\":\"nid_1614670194343_30093\",\"uikey\":\"bpmApprove\",\"enableUser\":true,\"enableOrg\":true,\"type\":\"primary\",\"ghost\":true,\"visible\":false,\"billName\":\"\u7269\u8d44\u603b\u8ba1\u5212\",\"billTypeId\":\"BT210302000000004\",\"billId\":\"421761164495814725\"},{\"uititle\":\"\u9644\u4ef6\u7ba1\u7406\",\"uitype\":\"AttachMgrWidget\",\"nid\":\"nid_1614670255184_30208\",\"uikey\":\"attachMgr\",\"btnType\":\"primary\",\"btnGhost\":true,\"align\":\"right\",\"billTypeId\":\"421761164495814725\",\"billTypeName\":\"\u7269\u8d44\u603b\u8ba1\u5212\",\"billType\":\"BT210302000000004\",\"sourceType\":\"materPlan001\",\"orgIdField\":\"orgId\",\"enTitle\":\"\",\"multiple\":false,\"fileLengthVisible\":true},{\"uititle\":\"\u63d0\u4ea4\",\"uitype\":\"BpmSubmitButton\",\"nid\":\"nid_1614670277964_30257\",\"uikey\":\"bpmSubmitBtn\",\"enableUser\":true,\"type\":\"primary\",\"ghost\":true,\"visible\":false,\"billName\":\"\u7269\u8d44\u603b\u8ba1\u5212\",\"billRefId\":\"421761164495814725\",\"billTypeId\":\"BT210302000000004\",\"orgField\":\"orgId\",\"codeField\":\"{projectName}\u2014\u7269\u8d44\u603b\u8ba1\u5212\",\"enTitle\":\"\"},{\"uititle\":\"\u64a4\u56de\",\"uitype\":\"EJCButton\",\"nid\":\"nid_1614670305087_30284\",\"children\":\"\u64a4\u56de\",\"uikey\":\"callBackBtn\",\"type\":\"primary\",\"ghost\":true,\"visible\":false},{\"uititle\":\"\u5220\u9664\",\"uitype\":\"EJCButton\",\"nid\":\"nid_1614670334900_30427\",\"children\":\"\u5220\u9664\",\"uikey\":\"removeBtn\",\"type\":\"error\",\"ghost\":true,\"icon\":\"delete\"},{\"uititle\":\"\u8fd4\u56de\u5217\u8868\",\"uitype\":\"EJCButton\",\"nid\":\"nid_1614670336614_30431\",\"children\":\"\u8fd4\u56de\u5217\u8868\",\"uikey\":\"goBackBtn\",\"ghost\":true,\"type\":\"primary\"}]},{\"uititle\":\"\u57fa\u672c\u4fe1\u606f\",\"uitype\":\"EJCPanel\",\"nid\":\"nid_1614670464935_30978\",\"uikey\":\"K1614670464935\",\"title\":\"\u57fa\u672c\u4fe1\u606f\",\"expandText\":\"\u6536\u8d77\",\"collapseText\":\"\u5c55\u5f00\",\"children\":[{\"uititle\":\"\u8868\u53552\",\"uitype\":\"FormWidget\",\"nid\":\"nid_1614673555088_111002\",\"colnumber\":3,\"uikey\":\"baseForm\",\"dataprops\":{},\"children\":[{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"inputrefer\",\"label\":\"\u9879\u76ee\u540d\u79f0\uff08\u4fee\u6539\uff09\",\"uikey\":\"projectId\",\"uititle\":\"\u9879\u76ee\u540d\u79f0\uff08\u4fee\u6539\uff09\",\"nid\":\"nid_1614673564425_111007\",\"labelCol\":{\"span\":6},\"wrapperCol\":{\"span\":14},\"subTableKey\":\"\",\"subTableColKey\":\"\",\"refinfokey\":\"market-project-refer-list\",\"refName\":\"\u9879\u76ee\u767b\u8bb0\u53c2\u7167\",\"refId\":\"320519315475660894\",\"referCode\":{\"code\":\"market-project-refer-list\",\"name\":\"\u9879\u76ee\u767b\u8bb0\u53c2\u7167\",\"id\":\"320519315475660894\"},\"required\":true,\"enTitle\":\"\",\"linkName\":\"\u65b0\u9875\u7b7e\"},{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"input\",\"label\":\"\u8ba1\u5212\u7f16\u7801\",\"propsIndex\":2,\"uikey\":\"planCode\",\"uititle\":\"\u8ba1\u5212\u7f16\u7801\",\"nid\":\"nid_1614673564935_111012\",\"formLabelCol\":{\"span\":6},\"formWrapperCol\":{\"span\":14},\"subTableKey\":\"\",\"subTableColKey\":\"\",\"labelCol\":{\"span\":6},\"wrapperCol\":{\"span\":14},\"maxLength\":\"30\",\"placeholder\":\"\u7f6e\u7a7a\u7cfb\u7edf\u81ea\u52a8\u751f\u6210\"},{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"currency\",\"label\":\"\u603b\u8ba1\u5212\u91d1\u989d\",\"uikey\":\"totalPlanAmt\",\"uititle\":\"\u603b\u8ba1\u5212\u91d1\u989d\",\"nid\":\"nid_1614673565538_111017\",\"labelCol\":{\"span\":6},\"wrapperCol\":{\"span\":15},\"subTableKey\":\"\",\"subTableColKey\":\"\",\"decimal\":8,\"symbol\":\" \",\"subTableCalc\":false,\"showDecimal\":2,\"disabled\":true,\"placeholder\":\"\u7531\u5b50\u8868\u6c47\u603b\"},{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"input\",\"label\":\"\u5907\u6ce8\",\"uikey\":\"remark\",\"uititle\":\"\u5907\u6ce8\",\"nid\":\"nid_1614673632278_113045\",\"labelCol\":{\"span\":2},\"wrapperCol\":{\"span\":21},\"newline\":true,\"maxLength\":\"200\",\"autoTrim\":false,\"enTitle\":\"\",\"subTableKey\":\"\",\"subTableColKey\":\"\"},{\"uititle\":\"\u7ec4\u4ef61\",\"uitype\":\"FormItemWidget\",\"nid\":\"nid_1676010621981_1182\",\"label\":\"\u7ec4\u4ef61\",\"uisubtype\":\"input\",\"uikey\":\"K1676010621981\",\"subTableKey\":\"\",\"subTableColKey\":\"\",\"enTitle\":\"\",\"labelCol\":{\"span\":8},\"wrapperCol\":{\"span\":14},\"autoTrim\":false,\"required\":true},{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"input\",\"label\":\"\u6587\u672c\u684666\",\"propsIndex\":6,\"uikey\":\"K1676017473114\",\"uititle\":\"\u6587\u672c\u684666\",\"nid\":\"nid_1676017473115_215\",\"subTableKey\":\"\",\"subTableColKey\":\"\",\"enTitle\":\"\",\"labelCol\":{\"span\":8},\"wrapperCol\":{\"span\":14},\"autoTrim\":false}],\"labelCol\":{\"span\":6},\"wrapperCol\":{\"span\":14}}]},{\"uititle\":\"\u6750\u6599\u6e05\u5355\",\"uitype\":\"EJCPanel\",\"nid\":\"nid_1614671008778_42433\",\"uikey\":\"K1614671008778\",\"title\":\"\u6750\u6599\u6e05\u5355\",\"expandText\":\"\u6536\u8d77\",\"collapseText\":\"\u5c55\u5f00\",\"children\":[{\"uititle\":\"\u5de5\u5177\u680f1\",\"uitype\":\"EJCToolbar\",\"nid\":\"nid_1614671031450_42435\",\"uikey\":\"K1614671031450\",\"children\":[{\"uititle\":\"\u53c2\u7167\u7269\u8d44\u6863\u6848\",\"uitype\":\"EJCReferButton\",\"nid\":\"nid_1614671041124_42439\",\"buttonText\":\"\u53c2\u7167\u7269\u8d44\u6863\u6848\",\"uikey\":\"materialRefer\",\"ghost\":true,\"type\":\"primary\",\"refinfokey\":\"material-tree-grid\",\"refName\":\"\u7269\u8d44\u53c2\u7167\",\"refId\":\"320652154816954392\",\"multiselect\":true,\"often\":true,\"linkName\":\"\u65b0\u9875\u7b7e\"},{\"uititle\":\"\u5f15\u5165\u9884\u7b97\",\"uitype\":\"EJCReferButton\",\"nid\":\"nid_1632301956021_24\",\"buttonText\":\"\u5f15\u5165\u9884\u7b97\",\"uikey\":\"budgetRefer\",\"ghost\":true,\"type\":\"primary\",\"refinfokey\":\"BUDGET-REF-LIST\",\"refName\":\"\u9884\u7b97\u53c2\u7167\",\"refId\":\"495643151588540502\",\"multiselect\":true,\"linkName\":\"\u65b0\u9875\u7b7e\",\"enTitle\":\"\"},{\"uititle\":\"\u5bfc\u5165\",\"uitype\":\"EJCButton\",\"nid\":\"nid_1614671043215_42443\",\"children\":\"\u5bfc\u5165\",\"uikey\":\"excelImport\",\"type\":\"primary\",\"ghost\":true},{\"uititle\":\"\u5220\u9664\",\"uitype\":\"EJCButton\",\"nid\":\"nid_1614671045049_42447\",\"children\":\"\u5220\u9664\",\"uikey\":\"deleteRow\",\"type\":\"error\",\"ghost\":true}]},{\"uititle\":\"\u7f16\u8f91\u8868\u683c2\",\"uitype\":\"EditTableWidget\",\"nid\":\"nid_1614671193216_43146\",\"uikey\":\"materialSubList\",\"children\":[{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"\u7269\u8d44\u5206\u7c7b\",\"title\":\"\u7269\u8d44\u5206\u7c7b\",\"uikey\":\"materialCategoryName\",\"key\":\"materialCategoryName\",\"dataIndex\":\"materialCategoryName\",\"nid\":\"nid_1614671202586_43148\",\"dataprops\":{},\"editable\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"\u7269\u8d44\u540d\u79f0\",\"title\":\"\u7269\u8d44\u540d\u79f0\",\"uikey\":\"materialName\",\"key\":\"materialName\",\"dataIndex\":\"materialName\",\"nid\":\"nid_1614671203709_43150\",\"dataprops\":{},\"editable\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"\u89c4\u683c\u578b\u53f7\",\"title\":\"\u89c4\u683c\u578b\u53f7\",\"uikey\":\"spec\",\"key\":\"spec\",\"dataIndex\":\"spec\",\"nid\":\"nid_1614671204236_43152\",\"dataprops\":{},\"editable\":false,\"enTitle\":\"\",\"autoTrim\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"\u8ba1\u91cf\u5355\u4f4d\",\"title\":\"\u8ba1\u91cf\u5355\u4f4d\",\"uikey\":\"unit\",\"key\":\"unit\",\"dataIndex\":\"unit\",\"nid\":\"nid_1614671204771_43154\",\"dataprops\":{},\"editable\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"currency\",\"uititle\":\"\u6570\u91cf\",\"title\":\"\u6570\u91cf\",\"uikey\":\"num\",\"key\":\"num\",\"dataIndex\":\"num\",\"nid\":\"nid_1614671209635_43156\",\"align\":\"left\",\"required\":true,\"dataprops\":{},\"commaVisible\":true,\"decimal\":8,\"symbol\":\" \",\"min\":\"0\",\"max\":\"999999999999\",\"showDecimal\":4,\"zeroFilling\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"currency\",\"uititle\":\"\u5355\u4ef7\",\"title\":\"\u5355\u4ef7\",\"uikey\":\"price\",\"key\":\"price\",\"dataIndex\":\"price\",\"nid\":\"nid_1614671211554_43158\",\"align\":\"left\",\"dataprops\":{},\"commaVisible\":true,\"decimal\":8,\"showDecimal\":4,\"symbol\":\" \",\"min\":\"0\",\"max\":\"999999999999\",\"zeroFilling\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"currency\",\"uititle\":\"\u91d1\u989d\",\"title\":\"\u91d1\u989d\",\"uikey\":\"amount\",\"key\":\"amount\",\"dataIndex\":\"amount\",\"nid\":\"nid_1614671212513_43160\",\"align\":\"left\",\"dataprops\":{},\"commaVisible\":true,\"decimal\":8,\"symbol\":\" \",\"showDecimal\":2,\"editable\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"\u7269\u8d44\u5206\u7c7bId\",\"title\":\"\u7269\u8d44\u5206\u7c7bId\",\"uikey\":\"materialCategoryId\",\"key\":\"materialCategoryId\",\"dataIndex\":\"materialCategoryId\",\"nid\":\"nid_1614843035426_1099\",\"dataprops\":{},\"isShow\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"\u7269\u8d44Id\",\"title\":\"\u7269\u8d44Id\",\"uikey\":\"materialId\",\"key\":\"materialId\",\"dataIndex\":\"materialId\",\"nid\":\"nid_1614843071288_3516\",\"dataprops\":{},\"isShow\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"\u7269\u6599\u6765\u6e90\u7c7b\u578b\",\"title\":\"\u7269\u6599\u6765\u6e90\u7c7b\u578b\",\"uikey\":\"sourceType\",\"key\":\"sourceType\",\"dataIndex\":\"sourceType\",\"nid\":\"nid_1614843124515_4916\",\"dataprops\":{},\"isShow\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"\u6765\u81ea\u6765\u6e90\u6570\u636eId\",\"title\":\"\u6765\u81ea\u6765\u6e90\u6570\u636eId\",\"uikey\":\"sourceId\",\"key\":\"sourceId\",\"dataIndex\":\"sourceId\",\"nid\":\"nid_1614843133912_4918\",\"dataprops\":{},\"isShow\":false}],\"rowKey\":\"id\",\"dataSource\":[],\"showRowNum\":true}]},{\"uititle\":\"\u5386\u53f2\u7248\u672c\",\"uitype\":\"EJCPanel\",\"nid\":\"nid_1614671520907_75454\",\"uikey\":\"changeHisWrap\",\"title\":\"\u5386\u53f2\u7248\u672c\",\"expandText\":\"\u6536\u8d77\",\"collapseText\":\"\u5c55\u5f00\",\"children\":[{\"uititle\":\"\u5386\u53f2\u7248\u672c\u8868\",\"uitype\":\"EditTableWidget\",\"nid\":\"nid_1615289870685_4461\",\"uikey\":\"planChangeHisList\",\"rowKey\":\"id\",\"dataSource\":[],\"children\":[{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"\u5386\u53f2\u7248\u672c\u7f16\u53f7\",\"title\":\"\u5386\u53f2\u7248\u672c\u7f16\u53f7\",\"uikey\":\"planHisCode\",\"key\":\"planHisCode\",\"dataIndex\":\"planHisCode\",\"nid\":\"nid_1615289894505_4598\",\"dataprops\":{},\"editable\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"currency\",\"uititle\":\"\u539f\u8ba1\u5212\u91d1\u989d\",\"title\":\"\u539f\u8ba1\u5212\u91d1\u989d\",\"uikey\":\"originalPlanAmt\",\"key\":\"originalPlanAmt\",\"dataIndex\":\"originalPlanAmt\",\"nid\":\"nid_1615289895029_4600\",\"editable\":false,\"align\":\"left\",\"dataprops\":{},\"commaVisible\":true,\"decimal\":8,\"showDecimal\":4,\"symbol\":\" \"},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"currency\",\"uititle\":\"\u53d8\u66f4\u540e\u91d1\u989d\",\"title\":\"\u53d8\u66f4\u540e\u91d1\u989d\",\"uikey\":\"totalPlanAmt\",\"key\":\"totalPlanAmt\",\"dataIndex\":\"totalPlanAmt\",\"nid\":\"nid_1615289895534_4602\",\"editable\":false,\"align\":\"left\",\"dataprops\":{},\"commaVisible\":true,\"decimal\":8,\"symbol\":\" \",\"showDecimal\":4},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"\u7f16\u5236\u4eba\",\"title\":\"\u7f16\u5236\u4eba\",\"uikey\":\"createUserName\",\"key\":\"createUserName\",\"dataIndex\":\"createUserName\",\"nid\":\"nid_1615289896263_4604\",\"dataprops\":{},\"editable\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"\u7f16\u5236\u65f6\u95f4\",\"title\":\"\u7f16\u5236\u65f6\u95f4\",\"uikey\":\"createTime\",\"key\":\"createTime\",\"dataIndex\":\"createTime\",\"nid\":\"nid_1615289896991_4606\",\"dataprops\":{},\"editable\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"\u751f\u6548\u65f6\u95f4\",\"title\":\"\u751f\u6548\u65f6\u95f4\",\"uikey\":\"effectiveDate\",\"key\":\"effectiveDate\",\"dataIndex\":\"effectiveDate\",\"nid\":\"nid_1615289897687_4608\",\"dataprops\":{},\"editable\":false}],\"showRowNum\":true,\"checkable\":false}]},{\"uititle\":\"\u5bfc\u5165\u6a21\u677f6\",\"uitype\":\"EJCImport\",\"nid\":\"nid_1614846222559_12568\",\"uikey\":\"importModal\",\"visible\":false,\"downTemplateUrl\":\"/ejc-material-web/instore/download\",\"uploadUrl\":\"/ejc-material-web/instore/excelImport\",\"downTemplateName\":\"\u7269\u8d44\u5bfc\u5165\",\"enTitle\":\"\",\"cloumns\":\"[{\\\"type\\\":\\\"input\\\",\\\"title\\\":\\\"\u7269\u8d44\u5206\u7c7b\\\",\\\"key\\\":\\\"materialCategoryName\\\"},{\\\"type\\\":\\\"input\\\",\\\"title\\\":\\\"\u7269\u8d44\u540d\u79f0\\\",\\\"key\\\":\\\"materialName\\\"},{\\\"type\\\":\\\"input\\\",\\\"title\\\":\\\"\u89c4\u683c\u578b\u53f7\\\",\\\"key\\\":\\\"materialSpec\\\"},{\\\"type\\\":\\\"input\\\",\\\"title\\\":\\\"\u8ba1\u91cf\u5355\u4f4d\\\",\\\"key\\\":\\\"materialUnit\\\"},{\\\"type\\\":\\\"input\\\",\\\"title\\\":\\\"\u5165\u5e93\u6570\u91cf\\\",\\\"key\\\":\\\"instoreNumber\\\"},{\\\"type\\\":\\\"input\\\",\\\"title\\\":\\\"\u5355\u4ef7\\\",\\\"key\\\":\\\"unitPrice\\\"},{\\\"type\\\":\\\"input\\\",\\\"title\\\":\\\"\u91d1\u989d\\\",\\\"key\\\":\\\"amount\\\"},{\\\"type\\\":\\\"input\\\",\\\"title\\\":\\\"\u5907\u6ce8\\\",\\\"key\\\":\\\"remark\\\"},{\\\"type\\\":\\\"input\\\",\\\"title\\\":\\\"\u9519\u8bef\u7c7b\u578b\\\",\\\"key\\\":\\\"errorMessage\\\"},{\\\"type\\\":\\\"input\\\",\\\"title\\\":\\\"\u5907\u6ce8\\\",\\\"key\\\":\\\"remark\\\"}]\"},{\"uititle\":\"\u5355\u636e\u4fe1\u606f\",\"uitype\":\"EJCPanel\",\"nid\":\"nid_1592309689617_1950\",\"uikey\":\"billInfoArea\",\"title\":\"\u5355\u636e\u4fe1\u606f\",\"expandText\":\"\u6536\u8d77\",\"collapseText\":\"\u5c55\u5f00\",\"children\":[{\"uititle\":\"\u5355\u636e\u5ba1\u8ba11\",\"uitype\":\"CPAuditInfo\",\"nid\":\"nid_1592309897349_2238\",\"uikey\":\"CPAuditInfo\",\"primaryKey\":\"id\",\"enTitle\":\"\",\"billName\":\"\u7269\u8d44\u603b\u8ba1\u5212\",\"billType\":\"BT210302000000004\"}],\"expand\":false,\"visible\":false}],\"nid\":\"nid_1614669713542_29070\",\"enTitle\":\"\",\"dataprops\":{\"project\":{\"id\":\"322683907509321758\",\"displayName\":\"\u7269\u8d44\u7ba1\u7406\",\"projectName\":\"ejc-material-web\"},\"entity\":{\"id\":\"422487372590219305\",\"displayName\":\"\u7269\u8d44\u603b\u8ba1\u5212\",\"entityFullName\":\"om.ejianc.business.plan.bean.MaterialMasterPlanEntity\"}},\"billName\":\"\u7269\u8d44\u603b\u8ba1\u5212\",\"billType\":\"BT210302000000004\"}";
        String jsonProv = "{\"dataprops\":{\"project\":{\"id\":\"322683907509321758\",\"displayName\":\"\u7269\u8d44\u7ba1\u7406\",\"projectName\":\"ejc-material-web\"},\"entity\":{\"id\":\"422487372590219305\",\"displayName\":\"\u7269\u8d44\u603b\u8ba1\u5212\",\"entityFullName\":\"om.ejianc.business.plan.bean.MaterialMasterPlanEntity\"}},\"billName\":\"\u7269\u8d44\u603b\u8ba1\u5212\",\"enTitle\":\"\",\"children\":[{\"uititle\":\"\u9762\u5305\u5c511\",\"uitype\":\"EJCBreadcrumb\",\"nid\":\"nid_1614669667403_29066\",\"uikey\":\"K1614669667403\",\"children\":[{\"uitype\":\"EJCBreadcrumbItem\",\"uititle\":\"\u7269\u8d44\u603b\u8ba1\u5212\",\"key\":1.614669688705E12,\"uikey\":\"1614669688705\",\"children\":\"\u7269\u8d44\u603b\u8ba1\u5212\",\"nid\":\"nid_1614669688706_29068\",\"href\":\"/materialMasterPlan\"},{\"uitype\":\"EJCBreadcrumbItem\",\"uititle\":\"\u8be6\u60c5\",\"key\":1.614669689688E12,\"uikey\":\"1614669689688\",\"children\":\"\u8be6\u60c5\",\"nid\":\"nid_1614669689688_29069\"}]},{\"uititle\":\"\u5de5\u5177\u680f2\",\"uitype\":\"EJCToolbar\",\"nid\":\"nid_1614669845851_29082\",\"uikey\":\"K1614669845851\",\"children\":[{\"uititle\":\"\u4fdd\u5b58\",\"uitype\":\"EJCButton\",\"nid\":\"nid_1614669850964_29087\",\"children\":\"\u4fdd\u5b58\",\"uikey\":\"saveBtn\",\"type\":\"primary\",\"icon\":\"book\"},{\"uititle\":\"\u53d6\u6d88\",\"uitype\":\"EJCButton\",\"nid\":\"nid_1614669981594_29665\",\"children\":\"\u53d6\u6d88\",\"uikey\":\"cancelBtn\",\"icon\":\"cross-circle-o\",\"type\":\"primary\",\"ghost\":true},{\"uititle\":\"\u7f16\u8f91\",\"uitype\":\"EJCButton\",\"nid\":\"nid_1614669889638_29262\",\"children\":\"\u7f16\u8f91\",\"uikey\":\"editBtn\",\"icon\":\"edit\",\"type\":\"primary\",\"ghost\":true},{\"uititle\":\"\u6253\u5370\",\"uitype\":\"EJCPrintButton\",\"nid\":\"nid_1614670134241_29978\",\"uikey\":\"printBtn\",\"title\":\"\u6253\u5370\",\"enableOrg\":true,\"ghost\":true,\"type\":\"primary\",\"billName\":\"\u7269\u8d44\u603b\u8ba1\u5212\",\"billType\":\"BT210302000000004\"},{\"uititle\":\"\u5ba1\u6279\u76f8\u5173\",\"uitype\":\"BpmApproveWidget\",\"nid\":\"nid_1614670194343_30093\",\"uikey\":\"bpmApprove\",\"enableUser\":true,\"enableOrg\":true,\"type\":\"primary\",\"ghost\":true,\"visible\":false,\"billName\":\"\u7269\u8d44\u603b\u8ba1\u5212\",\"billTypeId\":\"BT210302000000004\",\"billId\":\"421761164495814725\"},{\"uititle\":\"\u9644\u4ef6\u7ba1\u7406\",\"uitype\":\"AttachMgrWidget\",\"nid\":\"nid_1614670255184_30208\",\"uikey\":\"attachMgr\",\"btnType\":\"primary\",\"btnGhost\":true,\"align\":\"right\",\"billTypeId\":\"421761164495814725\",\"billTypeName\":\"\u7269\u8d44\u603b\u8ba1\u5212\",\"billType\":\"BT210302000000004\",\"sourceType\":\"materPlan001\",\"orgIdField\":\"orgId\",\"enTitle\":\"\",\"multiple\":false,\"fileLengthVisible\":true},{\"uititle\":\"\u63d0\u4ea4\",\"uitype\":\"BpmSubmitButton\",\"nid\":\"nid_1614670277964_30257\",\"uikey\":\"bpmSubmitBtn\",\"enableUser\":true,\"type\":\"primary\",\"ghost\":true,\"visible\":false,\"billName\":\"\u7269\u8d44\u603b\u8ba1\u5212\",\"billRefId\":\"421761164495814725\",\"billTypeId\":\"BT210302000000004\",\"orgField\":\"orgId\",\"codeField\":\"{projectName}\u2014\u7269\u8d44\u603b\u8ba1\u5212\",\"enTitle\":\"\"},{\"uititle\":\"\u64a4\u56de\",\"uitype\":\"EJCButton\",\"nid\":\"nid_1614670305087_30284\",\"children\":\"\u64a4\u56de\",\"uikey\":\"callBackBtn\",\"type\":\"primary\",\"ghost\":true,\"visible\":false},{\"uititle\":\"\u5220\u9664\",\"uitype\":\"EJCButton\",\"nid\":\"nid_1614670334900_30427\",\"children\":\"\u5220\u9664\",\"uikey\":\"removeBtn\",\"type\":\"error\",\"ghost\":true,\"icon\":\"delete\"},{\"uititle\":\"\u8fd4\u56de\u5217\u8868\",\"uitype\":\"EJCButton\",\"nid\":\"nid_1614670336614_30431\",\"children\":\"\u8fd4\u56de\u5217\u8868\",\"uikey\":\"goBackBtn\",\"ghost\":true,\"type\":\"primary\"}]},{\"uititle\":\"\u57fa\u672c\u4fe1\u606f\",\"uitype\":\"EJCPanel\",\"nid\":\"nid_1614670464935_30978\",\"uikey\":\"K1614670464935\",\"title\":\"\u57fa\u672c\u4fe1\u606f\",\"expandText\":\"\u6536\u8d77\",\"collapseText\":\"\u5c55\u5f00\",\"children\":[{\"uititle\":\"\u8868\u53552\",\"uitype\":\"FormWidget\",\"nid\":\"nid_1614673555088_111002\",\"colnumber\":3.0,\"uikey\":\"baseForm\",\"dataprops\":{},\"children\":[{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"inputrefer\",\"label\":\"\u9879\u76ee\u540d\u79f0\",\"uikey\":\"projectId\",\"uititle\":\"\u9879\u76ee\u540d\u79f0\",\"nid\":\"nid_1614673564425_111007\",\"labelCol\":{\"span\":6.0},\"wrapperCol\":{\"span\":14.0},\"subTableKey\":\"\",\"subTableColKey\":\"\",\"refinfokey\":\"market-project-refer-list\",\"refName\":\"\u9879\u76ee\u767b\u8bb0\u53c2\u7167\",\"refId\":\"320519315475660894\",\"referCode\":{\"code\":\"market-project-refer-list\",\"name\":\"\u9879\u76ee\u767b\u8bb0\u53c2\u7167\",\"id\":\"320519315475660894\"},\"required\":true},{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"input\",\"label\":\"\u8ba1\u5212\u7f16\u7801\",\"propsIndex\":2.0,\"uikey\":\"planCode\",\"uititle\":\"\u8ba1\u5212\u7f16\u7801\",\"nid\":\"nid_1614673564935_111012\",\"formLabelCol\":{\"span\":6.0},\"formWrapperCol\":{\"span\":14.0},\"subTableKey\":\"\",\"subTableColKey\":\"\",\"labelCol\":{\"span\":6.0},\"wrapperCol\":{\"span\":14.0},\"maxLength\":\"30\",\"placeholder\":\"\u7f6e\u7a7a\u7cfb\u7edf\u81ea\u52a8\u751f\u6210\"},{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"currency\",\"label\":\"\u603b\u8ba1\u5212\u91d1\u989d\",\"uikey\":\"totalPlanAmt\",\"uititle\":\"\u603b\u8ba1\u5212\u91d1\u989d\",\"nid\":\"nid_1614673565538_111017\",\"labelCol\":{\"span\":6.0},\"wrapperCol\":{\"span\":15.0},\"subTableKey\":\"\",\"subTableColKey\":\"\",\"decimal\":8.0,\"symbol\":\" \",\"subTableCalc\":false,\"showDecimal\":2.0,\"disabled\":true,\"placeholder\":\"\u7531\u5b50\u8868\u6c47\u603b\"},{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"date\",\"label\":\"\u5907\u6ce8123\",\"uikey\":\"remark\",\"uititle\":\"\u5907\u6ce8123\",\"nid\":\"nid_1614673632278_113045\",\"labelCol\":{\"span\":2.0},\"wrapperCol\":{\"span\":21.0},\"newline\":true,\"enTitle\":\"\",\"subTableKey\":\"\",\"subTableColKey\":\"\"}],\"labelCol\":{\"span\":6.0},\"wrapperCol\":{\"span\":14.0}}]},{\"uititle\":\"\u6750\u6599\u6e05\u5355\",\"uitype\":\"EJCPanel\",\"nid\":\"nid_1614671008778_42433\",\"uikey\":\"K1614671008778\",\"title\":\"\u6750\u6599\u6e05\u5355\",\"expandText\":\"\u6536\u8d77\",\"collapseText\":\"\u5c55\u5f00\",\"children\":[{\"uititle\":\"\u5de5\u5177\u680f1\",\"uitype\":\"EJCToolbar\",\"nid\":\"nid_1614671031450_42435\",\"uikey\":\"K1614671031450\",\"children\":[{\"uititle\":\"\u53c2\u7167\u7269\u8d44\u6863\u6848\",\"uitype\":\"EJCReferButton\",\"nid\":\"nid_1614671041124_42439\",\"buttonText\":\"\u53c2\u7167\u7269\u8d44\u6863\u6848\",\"uikey\":\"materialRefer\",\"ghost\":true,\"type\":\"primary\",\"refinfokey\":\"material-tree-grid\",\"refName\":\"\u7269\u8d44\u53c2\u7167\",\"refId\":\"320652154816954392\",\"multiselect\":true,\"often\":true,\"linkName\":\"\u65b0\u9875\u7b7e\"},{\"uititle\":\"\u5f15\u5165\u9884\u7b97\",\"uitype\":\"EJCReferButton\",\"nid\":\"nid_1632301956021_24\",\"buttonText\":\"\u5f15\u5165\u9884\u7b97\",\"uikey\":\"budgetRefer\",\"ghost\":true,\"type\":\"primary\",\"refinfokey\":\"BUDGET-REF-LIST\",\"refName\":\"\u9884\u7b97\u53c2\u7167\",\"refId\":\"495643151588540502\",\"multiselect\":true,\"linkName\":\"\u65b0\u9875\u7b7e\",\"enTitle\":\"\"},{\"uititle\":\"\u5bfc\u5165\",\"uitype\":\"EJCButton\",\"nid\":\"nid_1614671043215_42443\",\"children\":\"\u5bfc\u5165\",\"uikey\":\"excelImport\",\"type\":\"primary\",\"ghost\":true},{\"uititle\":\"\u5220\u9664\",\"uitype\":\"EJCButton\",\"nid\":\"nid_1614671045049_42447\",\"children\":\"\u5220\u9664\",\"uikey\":\"deleteRow\",\"type\":\"error\",\"ghost\":true}]},{\"uititle\":\"\u7f16\u8f91\u8868\u683c2\",\"uitype\":\"EditTableWidget\",\"nid\":\"nid_1614671193216_43146\",\"uikey\":\"materialSubList\",\"children\":[{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"\u7269\u8d44\u5206\u7c7b\",\"title\":\"\u7269\u8d44\u5206\u7c7b\",\"uikey\":\"materialCategoryName\",\"key\":\"materialCategoryName\",\"dataIndex\":\"materialCategoryName\",\"nid\":\"nid_1614671202586_43148\",\"dataprops\":{},\"editable\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"\u7269\u8d44\u540d\u79f0\",\"title\":\"\u7269\u8d44\u540d\u79f0\",\"uikey\":\"materialName\",\"key\":\"materialName\",\"dataIndex\":\"materialName\",\"nid\":\"nid_1614671203709_43150\",\"dataprops\":{},\"editable\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"\u89c4\u683c\u578b\u53f7\",\"title\":\"\u89c4\u683c\u578b\u53f7\",\"uikey\":\"spec\",\"key\":\"spec\",\"dataIndex\":\"spec\",\"nid\":\"nid_1614671204236_43152\",\"dataprops\":{},\"editable\":false,\"enTitle\":\"\",\"autoTrim\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"\u8ba1\u91cf\u5355\u4f4d\",\"title\":\"\u8ba1\u91cf\u5355\u4f4d\",\"uikey\":\"unit\",\"key\":\"unit\",\"dataIndex\":\"unit\",\"nid\":\"nid_1614671204771_43154\",\"dataprops\":{},\"editable\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"currency\",\"uititle\":\"\u6570\u91cf\",\"title\":\"\u6570\u91cf\",\"uikey\":\"num\",\"key\":\"num\",\"dataIndex\":\"num\",\"nid\":\"nid_1614671209635_43156\",\"align\":\"left\",\"required\":true,\"dataprops\":{},\"commaVisible\":true,\"decimal\":8.0,\"symbol\":\" \",\"min\":\"0\",\"max\":\"999999999999\",\"showDecimal\":4.0,\"zeroFilling\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"currency\",\"uititle\":\"\u5355\u4ef7\",\"title\":\"\u5355\u4ef7\",\"uikey\":\"price\",\"key\":\"price\",\"dataIndex\":\"price\",\"nid\":\"nid_1614671211554_43158\",\"align\":\"left\",\"dataprops\":{},\"commaVisible\":true,\"decimal\":8.0,\"showDecimal\":4.0,\"symbol\":\" \",\"min\":\"0\",\"max\":\"999999999999\",\"zeroFilling\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"currency\",\"uititle\":\"\u91d1\u989d\",\"title\":\"\u91d1\u989d\",\"uikey\":\"amount\",\"key\":\"amount\",\"dataIndex\":\"amount\",\"nid\":\"nid_1614671212513_43160\",\"align\":\"left\",\"dataprops\":{},\"commaVisible\":true,\"decimal\":8.0,\"symbol\":\" \",\"showDecimal\":2.0,\"editable\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"\u7269\u8d44\u5206\u7c7bId\",\"title\":\"\u7269\u8d44\u5206\u7c7bId\",\"uikey\":\"materialCategoryId\",\"key\":\"materialCategoryId\",\"dataIndex\":\"materialCategoryId\",\"nid\":\"nid_1614843035426_1099\",\"dataprops\":{},\"isShow\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"\u7269\u8d44Id\",\"title\":\"\u7269\u8d44Id\",\"uikey\":\"materialId\",\"key\":\"materialId\",\"dataIndex\":\"materialId\",\"nid\":\"nid_1614843071288_3516\",\"dataprops\":{},\"isShow\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"\u7269\u6599\u6765\u6e90\u7c7b\u578b\",\"title\":\"\u7269\u6599\u6765\u6e90\u7c7b\u578b\",\"uikey\":\"sourceType\",\"key\":\"sourceType\",\"dataIndex\":\"sourceType\",\"nid\":\"nid_1614843124515_4916\",\"dataprops\":{},\"isShow\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"\u6765\u81ea\u6765\u6e90\u6570\u636eId\",\"title\":\"\u6765\u81ea\u6765\u6e90\u6570\u636eId\",\"uikey\":\"sourceId\",\"key\":\"sourceId\",\"dataIndex\":\"sourceId\",\"nid\":\"nid_1614843133912_4918\",\"dataprops\":{},\"isShow\":false}],\"rowKey\":\"id\",\"dataSource\":[],\"showRowNum\":true}]},{\"uititle\":\"\u5386\u53f2\u7248\u672c\",\"uitype\":\"EJCPanel\",\"nid\":\"nid_1614671520907_75454\",\"uikey\":\"changeHisWrap\",\"title\":\"\u5386\u53f2\u7248\u672c\",\"expandText\":\"\u6536\u8d77\",\"collapseText\":\"\u5c55\u5f00\",\"children\":[{\"uititle\":\"\u5386\u53f2\u7248\u672c\u8868\",\"uitype\":\"EditTableWidget\",\"nid\":\"nid_1615289870685_4461\",\"uikey\":\"planChangeHisList\",\"rowKey\":\"id\",\"dataSource\":[],\"children\":[{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"\u5386\u53f2\u7248\u672c\u7f16\u53f7\",\"title\":\"\u5386\u53f2\u7248\u672c\u7f16\u53f7\",\"uikey\":\"planHisCode\",\"key\":\"planHisCode\",\"dataIndex\":\"planHisCode\",\"nid\":\"nid_1615289894505_4598\",\"dataprops\":{},\"editable\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"currency\",\"uititle\":\"\u539f\u8ba1\u5212\u91d1\u989d\",\"title\":\"\u539f\u8ba1\u5212\u91d1\u989d\",\"uikey\":\"originalPlanAmt\",\"key\":\"originalPlanAmt\",\"dataIndex\":\"originalPlanAmt\",\"nid\":\"nid_1615289895029_4600\",\"editable\":false,\"align\":\"left\",\"dataprops\":{},\"commaVisible\":true,\"decimal\":8.0,\"showDecimal\":4.0,\"symbol\":\" \"},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"currency\",\"uititle\":\"\u53d8\u66f4\u540e\u91d1\u989d\",\"title\":\"\u53d8\u66f4\u540e\u91d1\u989d\",\"uikey\":\"totalPlanAmt\",\"key\":\"totalPlanAmt\",\"dataIndex\":\"totalPlanAmt\",\"nid\":\"nid_1615289895534_4602\",\"editable\":false,\"align\":\"left\",\"dataprops\":{},\"commaVisible\":true,\"decimal\":8.0,\"symbol\":\" \",\"showDecimal\":4.0},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"\u7f16\u5236\u4eba\",\"title\":\"\u7f16\u5236\u4eba\",\"uikey\":\"createUserName\",\"key\":\"createUserName\",\"dataIndex\":\"createUserName\",\"nid\":\"nid_1615289896263_4604\",\"dataprops\":{},\"editable\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"\u7f16\u5236\u65f6\u95f4\",\"title\":\"\u7f16\u5236\u65f6\u95f4\",\"uikey\":\"createTime\",\"key\":\"createTime\",\"dataIndex\":\"createTime\",\"nid\":\"nid_1615289896991_4606\",\"dataprops\":{},\"editable\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"\u751f\u6548\u65f6\u95f4\",\"title\":\"\u751f\u6548\u65f6\u95f4\",\"uikey\":\"effectiveDate\",\"key\":\"effectiveDate\",\"dataIndex\":\"effectiveDate\",\"nid\":\"nid_1615289897687_4608\",\"dataprops\":{},\"editable\":false}],\"showRowNum\":true,\"checkable\":false}]},{\"uititle\":\"\u5bfc\u5165\u6a21\u677f6\",\"uitype\":\"EJCImport\",\"nid\":\"nid_1614846222559_12568\",\"uikey\":\"importModal\",\"visible\":false,\"downTemplateUrl\":\"/ejc-material-web/instore/download\",\"uploadUrl\":\"/ejc-material-web/instore/excelImport\",\"downTemplateName\":\"\u7269\u8d44\u5bfc\u5165\",\"enTitle\":\"\",\"cloumns\":\"[{\\\"type\\\":\\\"input\\\",\\\"title\\\":\\\"\u7269\u8d44\u5206\u7c7b\\\",\\\"key\\\":\\\"materialCategoryName\\\"},{\\\"type\\\":\\\"input\\\",\\\"title\\\":\\\"\u7269\u8d44\u540d\u79f0\\\",\\\"key\\\":\\\"materialName\\\"},{\\\"type\\\":\\\"input\\\",\\\"title\\\":\\\"\u89c4\u683c\u578b\u53f7\\\",\\\"key\\\":\\\"materialSpec\\\"},{\\\"type\\\":\\\"input\\\",\\\"title\\\":\\\"\u8ba1\u91cf\u5355\u4f4d\\\",\\\"key\\\":\\\"materialUnit\\\"},{\\\"type\\\":\\\"input\\\",\\\"title\\\":\\\"\u5165\u5e93\u6570\u91cf\\\",\\\"key\\\":\\\"instoreNumber\\\"},{\\\"type\\\":\\\"input\\\",\\\"title\\\":\\\"\u5355\u4ef7\\\",\\\"key\\\":\\\"unitPrice\\\"},{\\\"type\\\":\\\"input\\\",\\\"title\\\":\\\"\u91d1\u989d\\\",\\\"key\\\":\\\"amount\\\"},{\\\"type\\\":\\\"input\\\",\\\"title\\\":\\\"\u5907\u6ce8\\\",\\\"key\\\":\\\"remark\\\"},{\\\"type\\\":\\\"input\\\",\\\"title\\\":\\\"\u9519\u8bef\u7c7b\u578b\\\",\\\"key\\\":\\\"errorMessage\\\"},{\\\"type\\\":\\\"input\\\",\\\"title\\\":\\\"\u5907\u6ce8\\\",\\\"key\\\":\\\"remark\\\"}]\"},{\"uititle\":\"\u5355\u636e\u4fe1\u606f\",\"uitype\":\"EJCPanel\",\"nid\":\"nid_1592309689617_1950\",\"uikey\":\"billInfoArea\",\"title\":\"\u5355\u636e\u4fe1\u606f\",\"expandText\":\"\u6536\u8d77\",\"collapseText\":\"\u5c55\u5f00\",\"children\":[{\"uititle\":\"\u5355\u636e\u5ba1\u8ba11\",\"uitype\":\"CPAuditInfo\",\"nid\":\"nid_1592309897349_2238\",\"uikey\":\"CPAuditInfo\",\"primaryKey\":\"id\",\"enTitle\":\"\",\"billName\":\"\u7269\u8d44\u603b\u8ba1\u5212\",\"billType\":\"BT210302000000004\"}],\"expand\":false,\"visible\":false}],\"billType\":\"BT210302000000004\",\"nid\":\"nid_1614669713542_29070\",\"uikey\":\"M1366649681864491011\",\"uitype\":\"EJCPage\",\"uititle\":\"\u7269\u8d44\u603b\u8ba1\u5212\u8be6\u60c5\",\"themeClassName\":\"GEJC\"}";
        JsonObject baseData = (JsonObject)gson.fromJson(jsonBase, JsonObject.class);
        JsonObject provData = (JsonObject)gson.fromJson(jsonProv, JsonObject.class);
        JsonArray baseChildren = baseData.getAsJsonArray("children");
        JsonArray provChildren = provData.getAsJsonArray("children");
        IdeModuleServiceImpl.processChildren(baseChildren, provChildren);
        System.out.println(provData.toString());
    }

    @Override
    public Page<IdeModule> findModulesByAppId(String appId, String searchText, boolean isDelete, Pageable pageable) throws Exception {
        Integer pageIndex = pageable.getPageNumber() * pageable.getPageSize();
        List<IdeModule> ideModules = this.ideModuleRepo.findModuleListByAppId(appId, searchText, isDelete, pageIndex, pageable.getPageSize());
        Long total = this.ideModuleRepo.findModuleCountByAppId(appId, searchText, isDelete);
        PageImpl page = new PageImpl(ideModules, pageable, total.longValue());
        return page;
    }

    @Override
    public List<IdeModulePrivate> checkCanDelete(List<String> ids) throws BusinessException, Exception {
        String moduleIds = "";
        if (ids != null && ids.size() > 0) {
            for (String id : ids) {
                moduleIds = moduleIds + id + ",";
            }
            moduleIds = moduleIds.substring(0, moduleIds.length() - 1);
            List<IdeModulePrivate> modulePrivates = this.ideModulePrivateRepo.findListByModuleIds(moduleIds);
            return modulePrivates;
        }
        return null;
    }

    @Override
    public void deleteByIds(List<String> ids, boolean isRemove) throws BusinessException, Exception {
        String idStr = "";
        for (String id : ids) {
            idStr = idStr + id + ",";
        }
        if (StringUtils.isNotEmpty(idStr)) {
            idStr = idStr.substring(0, idStr.length() - 1);
        }
        if (isRemove) {
            this.ideModuleRepo.removeByIds(idStr);
            this.ideModulePrivateRepo.removeByModuleIds(idStr);
        } else {
            this.ideModuleRepo.deleteByIds(idStr);
            this.moduleDataRepo.deleteByModuleIds(idStr);
            this.ideModulePrivateRepo.deleteByModuleIds(idStr);
        }
    }

    @Override
    public void restoreByIds(List<String> ids) throws BusinessException, Exception {
        String idStr = "";
        if (ids != null && ids.size() > 0) {
            for (String id : ids) {
                idStr = idStr + id + ",";
            }
            idStr = idStr.substring(0, idStr.length() - 1);
            this.ideModuleRepo.recoverByIds(idStr);
            this.ideModulePrivateRepo.recoverByModuleIds(idStr);
        }
    }

    @Override
    public JsonBackData movePage(List<String> pageIds, String appId) throws BusinessException, Exception {
        if (pageIds != null && pageIds.size() > 0) {
            String pageIdStr = "";
            for (String pageId : pageIds) {
                pageIdStr = pageIdStr + pageId + ",";
            }
            pageIdStr = pageIdStr.substring(0, pageIdStr.length() - 1);
            this.ideModuleRepo.movePagesByAppId(pageIdStr, appId);
        }
        return JsonBackData.toSuccess("\u8fc1\u79fb\u6210\u529f");
    }

    @Override
    public List<IdeModule> findByIds(List<String> ids) {
        if (ids != null && ids.size() > 0) {
            String idStr = "";
            for (String id : ids) {
                idStr = idStr + id + ",";
            }
            idStr = idStr.substring(0, idStr.length() - 1);
            return this.ideModuleRepo.findByIds(idStr);
        }
        return null;
    }
}

