package com.ejianc.foundation.front.business.ide.controller;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.foundation.front.business.ide.entity.IdeAppGroup;
import com.ejianc.foundation.front.business.ide.service.IdeAppGroupService;
import com.ejianc.foundation.front.util.JsonBackData;
import com.ejianc.framework.core.exception.BusinessException;

@ResponseBody
@RequestMapping("/ide/appGroup")
@Controller
public class IdeAppGroupController {
	private static final Logger LOGGER = LoggerFactory.getLogger(IdeTeamController.class);
    @Autowired
    private IdeAppGroupService appGroupService;

    /**
     * 保存组
     *
     * @param moduleGroup 组
     * @return  {@link JsonBackData}
     */
    @RequestMapping(method = RequestMethod.POST)
    public JsonBackData save(@RequestBody IdeAppGroup appGroup) {
        JsonBackData backData = new JsonBackData();
        try {
            backData.setBackData(appGroupService.save(appGroup));
            backData.setSuccess(true);
            backData.setBackMsg("保存组成功");
        } catch (BusinessException e) {
        	backData.setSuccess(false);
        	backData.setBackMsg(e.getMessage());
		} catch (Exception e) {
            LOGGER.error("保存组失败", e);
            backData.setSuccess(false);
            backData.setBackMsg(e.getMessage());
        }
        return backData;
    }

    /**
     * 删除组
     *
     * @param ids 主键数组
     * @return {@link JsonBackData}
     */
    @RequestMapping(value = "{ids}", method = RequestMethod.DELETE)
    public JsonBackData delete(@PathVariable("ids") String[] ids) {
        JsonBackData backData = new JsonBackData();
        try {
        	appGroupService.deleteByIds(ids);
            backData.setBackMsg("删除组成功");
        }  catch (BusinessException e) {
        	backData.setSuccess(false);
        	backData.setBackMsg(e.getMessage());
		}  catch (Exception e) {
            backData.setBackMsg(e.getMessage());
            backData.setSuccess(false);
        }
        return backData;
    }

    /**
     * 获取组
     * @param id 主键
     * @return {@link JsonBackData}
     */
    @RequestMapping(value = "{id}", method = RequestMethod.GET)
    public JsonBackData get(@PathVariable("id") String id) {
        JsonBackData backData = new JsonBackData();
        try {
            backData.setBackData(appGroupService.findById(id));
            backData.setBackMsg("查找成功");
        }  catch (Exception e) {
            LOGGER.error("查找组失败", e);
            backData.setBackMsg("查找错误");
            backData.setSuccess(false);
        }
        return backData;
    }

    @RequestMapping(value = "findByTeamId/{teamId}", method = RequestMethod.GET)
    public JsonBackData findByAppId(@PathVariable String teamId,@RequestParam(value="clientType", required=false) String clientType) {
        JsonBackData backData = new JsonBackData();
        try {
            backData.setBackData(appGroupService.findByTeamId(teamId,clientType));
            backData.setBackMsg("查找成功");
        }  catch (Exception e) {
            backData.setBackMsg("查找错误");
            backData.setSuccess(false);
        }
        return backData;
    }
}
