package com.ejianc.foundation.front.business.ide.controller;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.ejianc.foundation.front.business.ide.bo.IdeModuleDataBO;
import com.ejianc.foundation.front.business.ide.service.IdeModuleDataService;
import com.ejianc.foundation.front.util.JsonBackData;

/**
 * Created by cdr_c on 2017/6/27.
 */
@RequestMapping(value = "/ide/data")
@RestController
public class IdeModuleDataController {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdeModuleDataController.class);
    private static Set<String> runningUsers = new HashSet<>();
    private static Set<String> runningModules = new HashSet<>();
    @Autowired
    private IdeModuleDataService moduleDataService;

    /**
     * 解析module
     *
     * @param userId userId
     * @return success or false
     */
    @RequestMapping("parseByUser/{userId}")
    public JsonBackData parseByUser(@PathVariable String userId) {
        JsonBackData backData = new JsonBackData();
        if (runningUsers.contains(userId)) {
            backData.setSuccess(false);
            backData.setBackMsg("解析中...请耐心等待");
        } else {
            try {
                runningUsers.add(userId);
                moduleDataService.createFromUser(userId);
                backData.setBackMsg("解析成功");
            } catch (Exception e) {
                LOGGER.error("解析失败", e);
                backData.setSuccess(false);
                backData.setBackMsg("解析失败");
            } finally {
                runningUsers.remove(userId);
            }
        }
        return backData;
    }

    /**
     * 解析module
     *
     * @param moduleId moduleId
     * @return success or false
     */
    @RequestMapping("parseByPage/{moduleId}")
    public JsonBackData parseModule(@PathVariable String moduleId) {
        JsonBackData backData = new JsonBackData();
        if (runningModules.contains(moduleId)) {
            backData.setSuccess(false);
            backData.setBackMsg("解析中...请耐心等待");
        } else {
            try {
                runningModules.add(moduleId);
                moduleDataService.createFromIdeModule(moduleId);
                backData.setBackMsg("解析成功");
            } catch (Exception e) {
                LOGGER.error("解析失败", e);
                backData.setSuccess(false);
                backData.setBackMsg("解析失败");
            } finally {
                runningModules.remove(moduleId);
            }
        }
        return backData;
    }


    /**
     * 解析module
     *
     * @return success or false
     */
    @RequestMapping(value = "parseByPages", method = RequestMethod.POST)
    public JsonBackData parseModules(String[] moduleIds) {
        JsonBackData backData = new JsonBackData();
        List<String> moduleIdList = Arrays.asList(moduleIds);
        if (runningModules.stream().anyMatch(moduleIdList::contains)) {
            backData.setSuccess(false);
            backData.setBackMsg("有模块正在解析中...请耐心等待");
        } else {
            for (String moduleId : moduleIdList) {
                try {
                    runningModules.add(moduleId);
                    moduleDataService.createFromIdeModule(moduleId);
                } catch (Exception e) {
                    LOGGER.error("解析失败", e);
                    backData.setSuccess(false);
                    backData.setBackMsg("解析失败");
                    return backData;
                } finally {
                    runningModules.remove(moduleId);
                }
            }
            backData.setBackMsg("解析成功");
        }
        return backData;
    }
    
    @RequestMapping(value="findDataByEntity",method = RequestMethod.GET)
    public JsonBackData module(String entityName) {
        try {
            List<IdeModuleDataBO> ideModuleDataBOs = moduleDataService.findDataByEntity(entityName);
            return JsonBackData.toSuccess("",ideModuleDataBOs);            
        } catch (Exception e) {
            e.printStackTrace();
        	return JsonBackData.toError(e.getMessage());
        }
    }
}
