package com.ejianc.foundation.front.business.ide.repository;

import java.util.List;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import com.ejianc.foundation.front.business.ide.entity.IdeEntity;

@Mapper
public interface IdeEntityRepo {
	
	//根据appId查找
	List<IdeEntity> findByAppId(@Param("appId") String appId);
	
	void deleteById(@Param("id") String id);
	
	//根据id查找
	IdeEntity findById(@Param("id") String id);
	
	//根据code和appId查找
	IdeEntity findByCodeAndAppId(@Param("code") String code,@Param("appId") String appId);

	void save(IdeEntity ideEntity);

	void update(IdeEntity ideEntity);

}
