package com.ejianc.foundation.front.business.ide.bo;

import com.ejianc.foundation.front.business.ide.Constant;
import com.ejianc.foundation.front.business.ide.entity.IdeApp;
import com.ejianc.foundation.front.business.ide.entity.IdeAppGroup;
import com.ejianc.foundation.front.business.ide.entity.IdeTeam;

import java.util.ArrayList;
import java.util.List;

public class IdeTeamBo implements java.io.Serializable {
	private static final long serialVersionUID = 7564888531042002115L;
	private String id;
	private String name;
	private String code;
	private int memberCount;
	private int appCount;
	private String createId;
	private Integer roleType;
	private Integer joinStatus;
	private String serverUrls;
	private String clientType;
	private int prodType = Constant.PROD_TYPE_PAGE;
	private List<IdeApp> apps = new ArrayList<IdeApp>();
	private List<IdeAppGroup> groups = new ArrayList<>();

	public IdeTeamBo() {
	}

	public IdeTeamBo(IdeTeam team) {
		this.id = team.getId() + "";
		this.name = team.getName();
		this.code = team.getCode();
		this.appCount = team.getAppCount();
		this.memberCount = team.getMemberCount();
		this.createId = team.getCreateId() + "";
		this.serverUrls = team.getServerUrls();
		this.prodType = team.getProdType();
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public int getMemberCount() {
		return memberCount;
	}

	public void setMemberCount(int memberCount) {
		this.memberCount = memberCount;
	}

	public int getAppCount() {
		return appCount;
	}

	public void setAppCount(int appCount) {
		this.appCount = appCount;
	}

	public String getCreateId() {
		return createId;
	}

	public void setCreateId(String createId) {
		this.createId = createId;
	}

	public Integer getRoleType() {
		return roleType;
	}

	public void setRoleType(Integer roleType) {
		this.roleType = roleType;
	}

	public Integer getJoinStatus() {
		return joinStatus;
	}

	public void setJoinStatus(Integer joinStatus) {
		this.joinStatus = joinStatus;
	}

	public List<IdeApp> getApps() {
		return apps;
	}

	public void setApps(List<IdeApp> apps) {
		this.apps = apps;
	}

	public String getServerUrls() {
		return serverUrls;
	}

	public void setServerUrls(String serverUrls) {
		this.serverUrls = serverUrls;
	}

	public int getProdType() {
		return prodType;
	}

	public void setProdType(int prodType) {
		this.prodType = prodType;
	}

	public List<IdeAppGroup> getGroups() {
		return groups;
	}

	public void setGroups(List<IdeAppGroup> groups) {
		this.groups = groups;
	}

	public String getClientType() {
		return clientType;
	}

	public void setClientType(String clientType) {
		this.clientType = clientType;
	}

}
