package com.ejianc.foundation.front.business.ide.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.ejianc.foundation.front.business.ide.bo.IdeProductionBo;
import com.ejianc.foundation.front.business.ide.service.IdeAppService;
import com.ejianc.foundation.front.business.ide.service.IdeModuleProService;
import com.ejianc.foundation.front.business.ide.service.IdeModuleService;
import com.ejianc.foundation.front.util.JsonBackData;

/**
 * 生产环境的同步数据服务
 */
@RestController
@RequestMapping(value = "/ide/production")
public class IdeProductionController {
	
	@Autowired
    IdeModuleProService ideModuleProService;
    @Autowired
    IdeModuleService ideModuleService;
	@Autowired
    IdeAppService ideAppService;
    
	/**
	 * 同步接收应用页面数据到生产环境
	 * 1.如果存在对应的应用，更新ide_module表，记录更新记录到ide_module_pro
	 * 2.不存在对应的应用，先更新ide_app, 再更新ide_module 和ide_module_pro
	 * @param module
	 */
	@RequestMapping(value="syncreceive",method=RequestMethod.POST)
    public JsonBackData syncReceive(@RequestBody IdeProductionBo productionBo) {
		try {
			return ideModuleService.syncReciveProduction(productionBo);
		} catch (Exception e) {
			e.printStackTrace();
			return JsonBackData.toError("系统错误"+e.getMessage());
		}
    }
}
