package com.ejianc.foundation.front.business.ide.service;

import java.util.List;

import com.ejianc.foundation.front.business.ide.bo.IdeTeamBo;
import com.ejianc.foundation.front.business.ide.entity.IdeApp;
import com.ejianc.foundation.front.business.ide.entity.IdeModulePrivate;
import com.ejianc.foundation.front.business.ide.entity.IdeTeam;
import com.ejianc.framework.core.exception.BusinessException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

public interface IdeAppService {
	/**通过id查找指定的应用 */
	IdeApp findById(String id) throws BusinessException;
	/**通过code查找指定的应用 */
	IdeApp findByCode(String code) throws BusinessException;
	/**查找用户创建的应用(包含公开的模板应用)**/
    List<IdeApp> findByCreateId(String createId, String clientType) throws BusinessException;
    /**查找用户所属团队下的全部应用，按团队进行分组（包含未归团应用）**/
    List<IdeTeamBo> findTeamAppsByUser(String createId, int prodType, String clientType);
    /**查找非当前用户所属团队下的公开应用，按团队进行分组**/
    List<IdeTeamBo> findTeamPublicApps(String createId, int prodType, String clientType);
    /**查找指定用户下未归属团队的应用**/
    List<IdeApp> findNoTeamApps(String createId, String clientType);
    
    /**查找所有应用及关联的页面*/
    List<IdeApp> findAll(String clientType) throws BusinessException, Exception;
    
    /**更新是否公开应用**/
    void updateOpen(String appId, int open, String createId);
    /**
     * 查询全部应用
     * @param isDelete 未删除|已删除的应用
     */
    List<IdeApp> findAllApps(boolean isDelete,String clientType) throws BusinessException;
    /** 标记删除 */
    void deleteById(String id) throws Exception;
//    void deleteByIds(String[] id) throws BusinessException, Exception;
    /** 彻底删除 */
    void removeById(String id) throws Exception;
    /** 恢复标记删除的应用 */
    void recoverById(String id) throws Exception;
    /** 新增|更新应用 */	
    void saveOrUpdate(IdeApp ideApp) throws BusinessException, Exception;
    /** 复制应用 */
    void copyApp(IdeApp ideApp) throws BusinessException, Exception;

    /**
     * 绑定应用其所属的团队
     *
     * @param teamId 团队id
     * @param appIds 应用id数组
     */
    void bindTeamOfApps(String teamId, String[] appIds,String groupId);
    
    /**
     * 更新团队应用个数
     * @param team
     */
    void updateTeamAppCount(IdeTeam team);
    
    /**
     * 根据团队Id查询应用
     */
    List<IdeApp> findAppTeamId(String teamId) throws BusinessException, Exception;
    
    //根据应用id查询是否存在已发布页面或进行过页面配置的页面
    List<IdeModulePrivate> checkCanDelete(List<String> ids) throws BusinessException,Exception;
    /** 批量删除（或彻底删除） */
    void deleteByIds(List<String> ids,boolean isRemove) throws BusinessException, Exception;
    /** 恢复标记删除的应用 */
    void recoverByIds(List<String> ids) throws BusinessException,Exception;
    /**
     * 分页查询全部应用
     */
    Page<IdeApp>  findPage(String teamId, String searchText, boolean isDelete, Pageable pageable) throws BusinessException,Exception;
}
