/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.front.business.ide.controller;

import com.ejianc.foundation.front.business.ide.bo.IdeAccountBo;
import com.ejianc.foundation.front.business.ide.entity.IdeUser;
import com.ejianc.foundation.front.business.ide.service.IdeAccountService;
import com.ejianc.foundation.front.common.qqconnect.QQUserInfo;
import com.ejianc.foundation.front.common.qqconnect.QQUserInfoBean;
import com.ejianc.foundation.front.util.JsonBackData;
import com.qq.connect.QQConnectException;
import com.qq.connect.api.OpenID;
import com.qq.connect.javabeans.AccessToken;
import com.qq.connect.oauth.Oauth;
import java.io.IOException;
import java.util.Date;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"ide/account/*"})
public class IdeAccountController {
    @Autowired
    private IdeAccountService accountService;

    @ResponseBody
    @RequestMapping(value={"reg"}, method={RequestMethod.POST})
    public JsonBackData regAccount(HttpServletRequest request, @RequestParam(required=true, value="userName", defaultValue="") String userName, @RequestParam(required=true, value="userPwd", defaultValue="") String userPwd) {
        try {
            IdeUser user = this.accountService.regAccount(userName, userPwd);
            if (user != null) {
                return JsonBackData.toSuccess("\u6ce8\u518c\u6210\u529f");
            }
            return JsonBackData.toError("\u6ce8\u518c\u5931\u8d25");
        }
        catch (Exception e) {
            return JsonBackData.toError(e.getMessage());
        }
    }

    @ResponseBody
    @RequestMapping(value={"login"}, method={RequestMethod.POST})
    public JsonBackData loginAccount(HttpServletRequest request, @RequestParam(required=true, value="userName", defaultValue="") String userName, @RequestParam(required=true, value="userPwd", defaultValue="") String userPwd, @RequestParam(required=false, value="md5", defaultValue="false") boolean md5) {
        JsonBackData backData = this.execLogin(request, userName, userPwd, md5);
        return backData;
    }

    private JsonBackData execLogin(HttpServletRequest request, String code, String password, boolean md5) {
        boolean result;
        boolean bl = result = md5 ? this.accountService.loginAccountMd5(code, password) : this.accountService.loginAccount(code, password);
        if (result) {
            IdeUser bean = this.accountService.findUserByCode(code);
            if (bean != null) {
                IdeAccountBo currUser = new IdeAccountBo(bean);
                if (!md5) {
                    currUser.setPassword(password);
                }
                this.accountService.setCurrUser(request, currUser);
                return JsonBackData.toSuccess("\u767b\u5f55\u6210\u529f", currUser);
            }
            return JsonBackData.toError("\u8d26\u53f7[" + code + "]\u4e0d\u5b58\u5728\uff01");
        }
        return JsonBackData.toError("\u8bf7\u68c0\u67e5\u60a8\u7684\u8d26\u53f7\u548c\u5bc6\u7801\u662f\u5426\u8f93\u5165\u6b63\u786e\uff01");
    }

    @ResponseBody
    @RequestMapping(value={"logout"}, method={RequestMethod.POST})
    public JsonBackData logoutAccount(HttpServletRequest request) {
        this.accountService.clearCurrUser(request);
        return JsonBackData.toSuccess();
    }

    @ResponseBody
    @RequestMapping(value={"pwdChange"}, method={RequestMethod.POST})
    public JsonBackData passwordChange(HttpServletRequest request, @RequestParam(required=true, value="password", defaultValue="") String password, @RequestParam(required=true, value="newPassword", defaultValue="") String newPassword, @RequestParam(required=true, value="account", defaultValue="") String account) {
        IdeAccountBo acc = this.accountService.getCurrUser(request);
        if (acc == null) {
            return JsonBackData.toError("\u5f53\u524d\u8d26\u53f7\u5df2\u5931\u6548\u8bf7\u91cd\u65b0\u767b\u5f55");
        }
        String result = this.accountService.changePassword(account, password, newPassword);
        if ("success".equals(result)) {
            return JsonBackData.toSuccess();
        }
        return JsonBackData.toError(result);
    }

    @RequestMapping(value={"quicklogin"}, method={RequestMethod.POST})
    public JsonBackData quickLogin(HttpServletRequest request, @RequestParam(required=true, value="userName", defaultValue="") String account, @RequestParam(required=true, value="userPwd", defaultValue="") String passwordMd5) {
        JsonBackData backData = this.execLogin(request, account, passwordMd5, true);
        return backData;
    }

    @ResponseBody
    @RequestMapping(value={"curruser"}, method={RequestMethod.GET})
    public IdeAccountBo getCurrUserInfo(HttpServletRequest request) {
        IdeAccountBo currUser = this.accountService.getCurrUser(request);
        return currUser;
    }

    @RequestMapping(value={"qqlogin"})
    public void qqLoginAuthorize(HttpServletRequest request, HttpServletResponse response) {
        try {
            response.sendRedirect(new Oauth().getAuthorizeURL((ServletRequest)request));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (QQConnectException e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"qqtoken"})
    public String qqLoginToken(HttpServletRequest request) {
        try {
            String accessToken = null;
            String openID = null;
            AccessToken accessTokenObj = new Oauth().getAccessTokenByRequest((ServletRequest)request);
            if (accessTokenObj.getAccessToken().equals("")) {
                System.out.println("\u83b7\u53d6accessToken\u4e3a\u7a7a");
            } else {
                accessToken = accessTokenObj.getAccessToken();
                OpenID openIDObj = new OpenID(accessToken);
                openID = openIDObj.getUserOpenID();
                IdeUser user = this.accountService.findByQQOpenId(openID);
                if (user == null) {
                    QQUserInfo qzoneUserInfo = new QQUserInfo(accessToken, openID);
                    QQUserInfoBean userInfoBean = qzoneUserInfo.getQQUserInfo();
                    if (userInfoBean.getRet() == 0) {
                        String nickName = userInfoBean.getNickname();
                        int sex = userInfoBean.getSex();
                        String avatarUrl = StringUtils.isBlank((String)userInfoBean.getQqAvatarURL100()) ? (StringUtils.isBlank((String)userInfoBean.getAvatar().getAvatarURL100()) ? userInfoBean.getQqAvatarURL40() : userInfoBean.getAvatar().getAvatarURL100()) : userInfoBean.getQqAvatarURL100();
                        user = this.accountService.generateNewAccountByQQ(accessToken, openID, nickName, sex, avatarUrl);
                    } else {
                        String errorMsg = "\u5f88\u62b1\u6b49\uff0c\u6211\u4eec\u6ca1\u80fd\u6b63\u786e\u83b7\u53d6\u5230\u60a8\u7684\u4fe1\u606f\uff0c\u539f\u56e0\u662f\uff1a " + userInfoBean.getMsg();
                        System.out.println("qq_connect_error--->" + errorMsg);
                        request.setAttribute("qq_connect_error", (Object)errorMsg);
                    }
                }
                if (user != null) {
                    user.setLoginDate(new Date());
                    this.accountService.saveOrUpdate(user);
                    IdeAccountBo currUser = new IdeAccountBo(user);
                    this.accountService.setCurrUser(request, currUser);
                }
            }
        }
        catch (QQConnectException e) {
            String errorMsg = "QQ\u767b\u5f55\u6388\u6743\u5931\u8d25";
            System.out.println("qq_connect_error--->" + errorMsg);
            request.setAttribute("qq_connect_error", (Object)errorMsg);
        }
        catch (Exception e) {
            request.setAttribute("qq_connect_error", (Object)e.getMessage());
        }
        return null;
    }

    @RequestMapping(value={"userChange"}, method={RequestMethod.POST})
    @ResponseBody
    public JsonBackData userChange(@RequestBody IdeUser user) {
        JsonBackData jsonBackData = new JsonBackData();
        IdeUser user2 = this.accountService.userUpdate(user);
        if (user2 != null) {
            jsonBackData.setBackData(user2);
            jsonBackData.setSuccess(true);
        } else {
            jsonBackData.setSuccess(false);
            jsonBackData.setBackMsg("\u627e\u4e0d\u5230\u8d26\u53f7\uff01");
        }
        return jsonBackData;
    }

    @ResponseBody
    @RequestMapping(value={"findUserByCode"})
    public JsonBackData findUserByCode(@RequestParam String code) {
        JsonBackData jsonBackData = new JsonBackData();
        IdeUser user2 = this.accountService.findUserByCode(code);
        if (user2 != null) {
            jsonBackData.setBackData(user2);
            jsonBackData.setSuccess(true);
        } else {
            jsonBackData.setSuccess(false);
            jsonBackData.setBackMsg("\u627e\u4e0d\u5230\u8d26\u53f7\uff01");
        }
        return jsonBackData;
    }
}

