/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.front.business.ide.controller;

import com.ejianc.foundation.front.business.ide.entity.IdeEntity;
import com.ejianc.foundation.front.business.ide.service.IdeEntityService;
import com.ejianc.foundation.front.util.JsonBackData;
import com.ejianc.framework.core.exception.BusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"ide/entity"})
public class IdeEntityController {
    @Autowired
    private IdeEntityService ideEntityService;

    @ResponseBody
    @RequestMapping(value={"showList"})
    public JsonBackData showList(@RequestParam String appId) {
        JsonBackData back = new JsonBackData();
        try {
            back.setBackData(this.ideEntityService.findListByAppId(appId));
        }
        catch (BusinessException e) {
            back.setSuccess(false);
            back.setBackMsg("\u67e5\u8be2\u5217\u8868\u6570\u636e\u5931\u8d25\uff0c" + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            back.setSuccess(false);
            back.setBackMsg("\u67e5\u8be2\u5217\u8868\u6570\u636e\u5931\u8d25\uff01");
        }
        return back;
    }

    @ResponseBody
    @RequestMapping(value={"saveOrUpdate"}, method={RequestMethod.POST})
    public JsonBackData saveOrUpdate(@RequestBody IdeEntity bo) {
        JsonBackData back = new JsonBackData();
        try {
            back.setBackData(this.ideEntityService.saveOrUpdate(bo));
        }
        catch (BusinessException e) {
            back.setSuccess(false);
            back.setBackMsg(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            back.setSuccess(false);
            back.setBackMsg(e.getMessage());
        }
        return back;
    }

    @ResponseBody
    @RequestMapping(value={"delete"})
    public JsonBackData deleteById(@RequestParam String id) {
        JsonBackData back = new JsonBackData();
        try {
            this.ideEntityService.delete(id);
        }
        catch (BusinessException e) {
            back.setSuccess(false);
            back.setBackMsg("\u67e5\u8be2\u5217\u8868\u6570\u636e\u5931\u8d25\uff0c" + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            back.setSuccess(false);
            back.setBackMsg("\u67e5\u8be2\u5217\u8868\u6570\u636e\u5931\u8d25\uff01");
        }
        return back;
    }
}

