/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.front.business.ide.controller;

import com.ejianc.foundation.front.business.ide.bo.IdeEnvironmentBO;
import com.ejianc.foundation.front.business.ide.service.IdeEnvironmentService;
import com.ejianc.foundation.front.util.JsonBackData;
import com.ejianc.framework.core.exception.BusinessException;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/ide/ideEnvironment"})
public class IdeEnvironmentController {
    @Autowired
    private IdeEnvironmentService ideEnvironmentService;

    @ResponseBody
    @RequestMapping(value={"showList"}, method={RequestMethod.POST})
    public JsonBackData showList(@RequestBody Map<String, Object> query) {
        JsonBackData back = new JsonBackData();
        int pageNumber = (Integer)query.get("pageNumber");
        int pageSize = (Integer)query.get("pageSize");
        try {
            PageRequest pageable = null;
            pageable = new PageRequest(pageNumber <= 0 ? 0 : pageNumber, pageSize);
            back.setBackData(this.ideEnvironmentService.findAll((Pageable)pageable));
        }
        catch (BusinessException e) {
            back.setSuccess(false);
            back.setBackMsg("\u67e5\u8be2\u5217\u8868\u6570\u636e\u5931\u8d25\uff0c" + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            back.setSuccess(false);
            back.setBackMsg("\u67e5\u8be2\u5217\u8868\u6570\u636e\u5931\u8d25\uff01");
        }
        return back;
    }

    @ResponseBody
    @RequestMapping(value={"saveOrUpdate"}, method={RequestMethod.POST})
    public JsonBackData saveOrUpdate(@RequestBody IdeEnvironmentBO bo) {
        JsonBackData back = new JsonBackData();
        try {
            this.ideEnvironmentService.saveOrUpdate(bo);
        }
        catch (BusinessException e) {
            back.setSuccess(false);
            back.setBackMsg(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            back.setSuccess(false);
            back.setBackMsg(e.getMessage());
        }
        return back;
    }

    @ResponseBody
    @RequestMapping(value={"delete"}, method={RequestMethod.POST})
    public JsonBackData deleteByUrls(@RequestBody Map<String, Object> query) {
        JsonBackData back = new JsonBackData();
        List list = (List)query.get("ids");
        String[] urls = list.toArray(new String[list.size()]);
        try {
            this.ideEnvironmentService.deleteByUrls(urls);
        }
        catch (BusinessException e) {
            back.setSuccess(false);
            back.setBackMsg(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            back.setSuccess(false);
            back.setBackMsg(e.getMessage());
        }
        return back;
    }

    @ResponseBody
    @RequestMapping(value={"findByUrl"})
    public JsonBackData findByUrl(@RequestParam String url, @RequestParam int prodType) {
        JsonBackData back = new JsonBackData();
        try {
            back.setBackData(this.ideEnvironmentService.findByUrl(url, prodType));
        }
        catch (BusinessException ex) {
            back.setSuccess(false);
            back.setBackMsg(ex.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            back.setSuccess(false);
            back.setBackMsg("\u83b7\u53d6\u6570\u636e\u5931\u8d25\uff01");
        }
        return back;
    }

    @ResponseBody
    @RequestMapping(value={"findAllUrls"})
    public JsonBackData findAllUrls() {
        JsonBackData back = new JsonBackData();
        try {
            back.setBackData(this.ideEnvironmentService.findAllUrls());
        }
        catch (Exception e) {
            e.printStackTrace();
            back.setSuccess(false);
            back.setBackMsg("\u67e5\u8be2\u5217\u8868\u6570\u636e\u5931\u8d25\uff01");
        }
        return back;
    }
}

