/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.front.business.ide.controller;

import com.ejianc.foundation.front.business.ide.bo.IdeUiFolderBO;
import com.ejianc.foundation.front.business.ide.service.IdeUiFolderService;
import com.ejianc.foundation.front.util.JsonBackData;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"ide/uiFolder"})
@RestController
public class IdeUiFolderController {
    private static final Logger logger = LoggerFactory.getLogger(IdeUiFolderController.class);
    @Autowired
    private IdeUiFolderService service;

    @RequestMapping(value={"create"}, method={RequestMethod.POST})
    public JsonBackData create(@Valid @RequestBody IdeUiFolderBO library) {
        JsonBackData back = new JsonBackData();
        try {
            back.setBackData(this.service.create(library));
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u6587\u4ef6\u5939\u5f02\u5e38\uff01", (Throwable)e);
            back.setSuccess(false);
            back.setBackMsg("\u521b\u5efa\u6587\u4ef6\u5939\u5f02\u5e38\uff01");
        }
        return back;
    }

    @RequestMapping(value={"update"}, method={RequestMethod.POST})
    public JsonBackData update(@Valid @RequestBody IdeUiFolderBO library) {
        JsonBackData back = new JsonBackData();
        try {
            this.service.update(library);
        }
        catch (Exception e) {
            logger.error("\u4fee\u6539\u6587\u4ef6\u5939\u5f02\u5e38\uff01", (Throwable)e);
            back.setSuccess(false);
            back.setBackMsg("\u4fee\u6539\u6587\u4ef6\u5939\u5f02\u5e38\uff01");
        }
        return back;
    }

    @RequestMapping(value={"delete"}, method={RequestMethod.GET})
    public JsonBackData delete(@RequestParam String id) {
        JsonBackData back = new JsonBackData();
        try {
            this.service.delete(id);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6587\u4ef6\u5939\u5f02\u5e38\uff01", (Throwable)e);
            back.setSuccess(false);
            back.setBackMsg("\u5220\u9664\u6587\u4ef6\u5939\u5f02\u5e38\uff01");
        }
        return back;
    }

    @RequestMapping(value={"queryDetail"}, method={RequestMethod.GET})
    public JsonBackData queryDetail(@RequestParam String id, String searchText) {
        JsonBackData back = new JsonBackData();
        try {
            back.setBackData(this.service.queryDetail(id, searchText));
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6587\u4ef6\u5939\u8be6\u60c5\u5f02\u5e38\uff01", (Throwable)e);
            back.setSuccess(false);
            back.setBackMsg("\u67e5\u8be2\u6587\u4ef6\u5939\u8be6\u60c5\u5f02\u5e38\uff01");
        }
        return back;
    }
}

