/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.front.business.ide.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.front.business.ide.entity.IdeModule;
import com.ejianc.foundation.front.business.ide.repository.IdeModuleRepo;
import com.ejianc.foundation.front.business.ide.service.IdeAjustTemplateService;
import com.ejianc.foundation.front.util.JsonBackData;
import com.ejianc.framework.core.exception.BusinessException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class IdeAjustTemplateServiceImpl
implements IdeAjustTemplateService {
    private static final String CPCARDPAGE = "CPCardPage";
    private static final String CPLISTPAGE = "CPListPage";
    private static final String UI_KEY = "uikey";
    private static final String UI_TITLE = "uititle";
    private static final String UI_TYPE = "uitype";
    private static final String CHILDREN = "children";
    private String billType;
    private String billName;
    private JSONObject YYSearchCondition;
    @Autowired
    private IdeModuleRepo moduleRepo;

    @Override
    public JsonBackData adjustTemplate(String[] moduleIds) throws BusinessException, Exception {
        ArrayList<String> failPages = new ArrayList<String>();
        if (moduleIds.length > 0) {
            String moduleIdStr = "";
            for (String moduleId : moduleIds) {
                moduleIdStr = moduleIdStr + moduleId + ",";
            }
            List<IdeModule> modules = this.moduleRepo.findByIds(moduleIdStr.substring(0, moduleIdStr.length() - 1));
            if (modules != null && modules.size() > 0) {
                for (IdeModule ideModule : modules) {
                    try {
                        String data;
                        JSONObject jsonData;
                        if (ideModule.getPageType().equals(CPCARDPAGE)) {
                            jsonData = JSONObject.parseObject((String)ideModule.getData());
                            jsonData = this.dealCardJSONObject(jsonData);
                            data = jsonData.toJSONString();
                            ideModule.setData(data);
                            ideModule.setPageType("cardPage");
                            this.moduleRepo.update(ideModule);
                            continue;
                        }
                        if (!ideModule.getPageType().equals(CPLISTPAGE)) continue;
                        jsonData = JSONObject.parseObject((String)ideModule.getData());
                        jsonData = this.dealListJSONObject(jsonData);
                        data = jsonData.toJSONString();
                        ideModule.setData(data);
                        ideModule.setPageType("listPage");
                        this.moduleRepo.update(ideModule);
                    }
                    catch (Exception e) {
                        failPages.add("[" + ideModule.getCode() + "]" + ideModule.getName());
                    }
                }
            } else {
                throw new BusinessException("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u9875\u9762");
            }
        }
        return JsonBackData.toSuccess("\u8f6c\u6362\u6a21\u677f\u6210\u529f", failPages);
    }

    private JSONObject dealCardJSONObject(JSONObject jsonObject) {
        JSONObject jsonObjectChild;
        int i;
        JSONArray jsonArray;
        if (jsonObject.get((Object)UI_TYPE).equals(CPCARDPAGE)) {
            jsonObject.put(UI_TYPE, (Object)"YYPage");
        }
        if (jsonObject.get((Object)UI_TYPE).equals("CPCardHeader")) {
            jsonObject.put(UI_TYPE, (Object)"YYToolbar");
        }
        if (jsonObject.get((Object)UI_TYPE).equals("YYAccordion")) {
            jsonObject.put(UI_TYPE, (Object)"YYPanel");
        }
        if (jsonObject.get((Object)UI_TYPE).equals("YYPanel")) {
            jsonObject.remove((Object)"isOpen");
            jsonObject.remove((Object)"header");
            jsonObject.remove((Object)"enableStepTarget");
            jsonObject.put("expandText", (Object)"\u6536\u8d77");
            jsonObject.put("collapseText", (Object)"\u5c55\u5f00");
            jsonObject.put("title", jsonObject.get((Object)UI_TITLE));
        }
        if ((jsonObject.get((Object)UI_TYPE).equals("YYPage") || jsonObject.get((Object)UI_TYPE).equals("YYCol")) && jsonObject.containsKey((Object)CHILDREN) && jsonObject.get((Object)CHILDREN) instanceof JSONArray) {
            jsonArray = jsonObject.getJSONArray(CHILDREN);
            for (i = 0; i < jsonArray.size(); ++i) {
                jsonObjectChild = (JSONObject)jsonArray.get(i);
                if (!jsonObjectChild.get((Object)UI_TYPE).equals("CPCardBody") && !jsonObjectChild.get((Object)UI_TYPE).equals("YYAccordions")) continue;
                if (jsonObjectChild.containsKey((Object)CHILDREN) && jsonObjectChild.get((Object)CHILDREN) instanceof JSONArray) {
                    JSONArray jsonArrayChild = jsonObjectChild.getJSONArray(CHILDREN);
                    for (Object objectChild : jsonArrayChild) {
                        jsonArray.add(objectChild);
                    }
                }
                jsonArray.remove(i);
                break;
            }
            jsonObject.put(CHILDREN, (Object)jsonArray);
        }
        if (jsonObject.get((Object)UI_TYPE).equals("YYPage")) {
            jsonObject.put("themeClassName", (Object)"GYY");
            if (jsonObject.containsKey((Object)CHILDREN) && jsonObject.get((Object)CHILDREN) instanceof JSONArray) {
                jsonArray = jsonObject.getJSONArray(CHILDREN);
                String title = "\u5355\u636e\u6807\u9898";
                for (int i2 = 0; i2 < jsonArray.size(); ++i2) {
                    JSONObject jsonObjectChild2 = (JSONObject)jsonArray.get(i2);
                    if (!jsonObjectChild2.get((Object)UI_TYPE).equals("CPCardTitle")) continue;
                    title = (String)jsonObjectChild2.get((Object)UI_TITLE);
                    jsonArray.remove(i2);
                    break;
                }
                jsonArray.add(0, (Object)this.getCardAreaJson(title));
                jsonObject.put(CHILDREN, (Object)jsonArray);
            }
        }
        if (jsonObject.get((Object)UI_TYPE).equals("YYToolbar") && jsonObject.containsKey((Object)CHILDREN) && jsonObject.get((Object)CHILDREN) instanceof JSONArray) {
            jsonArray = jsonObject.getJSONArray(CHILDREN);
            for (i = 0; i < jsonArray.size(); ++i) {
                jsonObjectChild = (JSONObject)jsonArray.get(i);
                if (!jsonObjectChild.get((Object)UI_TYPE).equals("CPGoBack")) continue;
                jsonArray.remove(i);
                break;
            }
            jsonObject.put(CHILDREN, (Object)jsonArray);
        }
        if (jsonObject.get((Object)UI_TYPE).equals("CPIconButton")) {
            jsonObject.put(UI_TYPE, (Object)"YYButton");
        }
        if (jsonObject.get((Object)UI_TYPE).equals("YYButton")) {
            jsonObject.put("type", (Object)"error");
            jsonObject.put("ghost", (Object)true);
            jsonObject.put(CHILDREN, jsonObject.get((Object)UI_TITLE));
            jsonObject.remove((Object)"text");
            jsonObject.remove((Object)"color");
            jsonObject.remove((Object)"align");
        }
        if (jsonObject.get((Object)UI_TYPE).equals("CPDropdownButton")) {
            jsonObject.put(UI_TYPE, (Object)"YYButtonSelect");
        }
        if (jsonObject.get((Object)UI_TYPE).equals("YYButtonSelect")) {
            jsonObject.put("type", (Object)"error");
            jsonObject.put("buttonText", jsonObject.get((Object)UI_TITLE));
            jsonObject.remove((Object)"text");
        }
        if (jsonObject.get((Object)UI_TYPE).equals("CPDropdownItem")) {
            jsonObject.put(UI_TYPE, (Object)"YYButtonItem");
            jsonObject.put("clickKey", jsonObject.get((Object)UI_KEY));
            jsonObject.put(CHILDREN, jsonObject.get((Object)UI_TITLE));
        }
        if (jsonObject.get((Object)UI_TYPE).equals("CPAttachMgr")) {
            jsonObject.put(UI_TYPE, (Object)"AttachMgrWidget");
        }
        if (jsonObject.get((Object)UI_TYPE).equals("CPBpmSubmit")) {
            jsonObject.put(UI_TYPE, (Object)"BpmSubmitWidget");
        }
        if (jsonObject.get((Object)UI_TYPE).equals("CPBpmApprove")) {
            jsonObject.put(UI_TYPE, (Object)"BpmApproveWidget");
        }
        if (jsonObject.get((Object)UI_TYPE).equals("CPPrintButton")) {
            jsonObject.put(UI_TYPE, (Object)"YYPrintButton");
        }
        if (jsonObject.containsKey((Object)CHILDREN) && jsonObject.get((Object)CHILDREN) instanceof JSONArray) {
            jsonArray = jsonObject.getJSONArray(CHILDREN);
            for (Object object : jsonArray) {
                if (object == null) continue;
                object = this.dealCardJSONObject((JSONObject)object);
            }
            jsonObject.put(CHILDREN, (Object)jsonArray);
        }
        return jsonObject;
    }

    private JSONObject dealListJSONObject(JSONObject jsonObject) {
        JSONArray jsonArray;
        if (jsonObject.get((Object)UI_TYPE).equals(CPLISTPAGE)) {
            jsonObject.put(UI_TYPE, (Object)"YYPage");
        }
        if (jsonObject.get((Object)UI_TYPE).equals("CPListToolbar")) {
            jsonObject.put(UI_TYPE, (Object)"YYToolbar");
        }
        if (jsonObject.get((Object)UI_TYPE).equals("YYPage")) {
            jsonObject.put("themeClassName", (Object)"GYY");
            if (jsonObject.containsKey((Object)CHILDREN) && jsonObject.get((Object)CHILDREN) instanceof JSONArray) {
                jsonArray = jsonObject.getJSONArray(CHILDREN);
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JSONObject jsonObjectChild = (JSONObject)jsonArray.get(i);
                    if (!jsonObjectChild.get((Object)UI_TYPE).equals("CPListHeader")) continue;
                    if (jsonObjectChild.containsKey((Object)CHILDREN) && jsonObjectChild.get((Object)CHILDREN) instanceof JSONArray) {
                        JSONArray jsonArrayChild = jsonObjectChild.getJSONArray(CHILDREN);
                        for (Object objectChild : jsonArrayChild) {
                            JSONObject jsonObjectChild2 = (JSONObject)objectChild;
                            if (jsonObjectChild2.get((Object)UI_TYPE).equals("YYSchemeGroup")) {
                                this.setBillType((String)jsonObjectChild2.get((Object)"billType"));
                                this.setBillName((String)jsonObjectChild2.get((Object)"billName"));
                            }
                            if (!jsonObjectChild2.get((Object)UI_TYPE).equals("CPSearchBar")) continue;
                            jsonObjectChild2.put(UI_TYPE, (Object)"YYSearchCondition");
                            this.setYYSearchCondition(jsonObjectChild2);
                        }
                    }
                    jsonArray.remove(i);
                    break;
                }
                jsonArray.add(0, (Object)this.getListAreaJson(this.getBillType(), this.getBillName()));
                jsonObject.put(CHILDREN, (Object)jsonArray);
            }
        }
        if (jsonObject.get((Object)UI_TYPE).equals("YYToolbar") && jsonObject.containsKey((Object)CHILDREN) && jsonObject.get((Object)CHILDREN) instanceof JSONArray) {
            jsonArray = jsonObject.getJSONArray(CHILDREN);
            jsonArray.add((Object)this.getYYSearchCondition());
            jsonObject.put(CHILDREN, (Object)jsonArray);
        }
        if (jsonObject.get((Object)UI_TYPE).equals("CPListTable")) {
            jsonObject.put(UI_TYPE, (Object)"TableWidget");
        }
        if (jsonObject.get((Object)UI_TYPE).equals("CPIconButton")) {
            jsonObject.put(UI_TYPE, (Object)"YYButton");
        }
        if (jsonObject.get((Object)UI_TYPE).equals("YYButton")) {
            jsonObject.put("type", (Object)"error");
            jsonObject.put("ghost", (Object)true);
            jsonObject.put(CHILDREN, jsonObject.get((Object)UI_TITLE));
            jsonObject.remove((Object)"text");
            jsonObject.remove((Object)"color");
            jsonObject.remove((Object)"align");
        }
        if (jsonObject.containsKey((Object)CHILDREN) && jsonObject.get((Object)CHILDREN) instanceof JSONArray) {
            jsonArray = jsonObject.getJSONArray(CHILDREN);
            for (Object object : jsonArray) {
                if (object == null) continue;
                object = this.dealListJSONObject((JSONObject)object);
            }
            jsonObject.put(CHILDREN, (Object)jsonArray);
        }
        return jsonObject;
    }

    private JSONObject getCardAreaJson(String title) {
        String jsonStr = "{\n  \"uititle\": \"\u9876\u90e8\u533a\u57df\",\n  \"uitype\": \"YYArea\",\n  \"nid\": \"nid_1525861773853_2\",\n  \"uikey\": \"cardTopBar\",\n  \"children\": [\n    {\n      \"uititle\": \"" + title + "\",\n      \"uitype\": \"YYCaption\",\n      \"nid\": \"nid_1525924478783_2\",\n      \"children\": \"" + title + "\",\n      \"uikey\": \"cardTitle\"\n    },\n    {\n      \"uititle\": \"\u9762\u5305\u5c51\",\n      \"uitype\": \"YYBreadcrumb\",\n      \"nid\": \"nid_1481614719767_14\",\n      \"children\": [\n        {\n          \"uitype\": \"YYBreadcrumbItem\",\n          \"uititle\": \"\u9996\u9875\",\n          \"key\": \"1481614729767_15\",\n          \"uikey\": \"goHome\",\n          \"title\": \"\u9762\u5305\u5c51\u5143\u7d201\",\n          \"children\": \"\u9996\u9875\",\n          \"nid\": \"nid_1481614729767_16\"\n        },\n        {\n          \"uitype\": \"YYBreadcrumbItem\",\n          \"uititle\": \"xx\u53f0\u8d26\",\n          \"key\": \"1525924550255_205\",\n          \"uikey\": \"goList\",\n          \"children\": \"xx\u53f0\u8d26\",\n          \"nid\": \"nid_1525924550255_206\"\n        },\n        {\n          \"uitype\": \"YYBreadcrumbItem\",\n          \"uititle\": \"\u65b0\u589e\",\n          \"key\": \"1481614731199_17\",\n          \"uikey\": \"opType\",\n          \"title\": \"\u9762\u5305\u5c51\u5143\u7d202\",\n          \"children\": \"\u65b0\u589e\",\n          \"nid\": \"nid_1481614731199_18\"\n        }\n      ],\n      \"uikey\": \"cardBreadcrumb\",\n      \"separator\": \"/\"\n    }\n  ]\n}";
        return JSONObject.parseObject((String)jsonStr);
    }

    private JSONObject getListAreaJson(String billType, String billName) {
        String jsonStr = "{\n  \"uititle\": \"\u9876\u90e8\u680f\",\n  \"uitype\": \"YYArea\",\n  \"nid\": \"nid_1526011032033_837\",\n  \"children\": [\n    {\n      \"uititle\": \"\u6807\u9898\u6587\u672c\",\n      \"uitype\": \"YYCaption\",\n      \"nid\": \"nid_1526011040921_840\",\n      \"children\": \"\u6807\u9898\u6587\u672c\",\n      \"uikey\": \"listTitle\"\n    },\n    {\n      \"nid\": \"nid_1526011053577_844\",\n      \"uikey\": \"listBreadcrumb\",\n      \"separator\": \"/\",\n      \"children\": [\n        {\n          \"uitype\": \"YYBreadcrumbItem\",\n          \"uititle\": \"\u9996\u9875\",\n          \"key\": \"1524537458375_450\",\n          \"uikey\": \"goHome\",\n          \"children\": \"\u9996\u9875\",\n          \"nid\": \"nid_1526011053577_841\"\n        },\n        {\n          \"uitype\": \"YYBreadcrumbItem\",\n          \"uititle\": \"XX\u5217\u8868\",\n          \"key\": \"1524537467633_562\",\n          \"uikey\": \"goList\",\n          \"children\": \"XX\u5217\u8868\",\n          \"nid\": \"nid_1526011053577_842\"\n        }\n      ],\n      \"uititle\": \"\u9762\u5305\u5c51\",\n      \"uitype\": \"YYBreadcrumb\"\n    },\n    {\n      \"uititle\": \"\u65b9\u6848\u680f\",\n      \"uitype\": \"YYSchemeGroup\",\n      \"nid\": \"nid_1526447764720_3\",\n      \"uikey\": \"schemeGroup\",\n      \"billName\": \"" + billName + "\",\n      \"billType\": \"" + billType + "\"\n    }\n  ],\n  \"uikey\": \"listTopBar\"\n}";
        return JSONObject.parseObject((String)jsonStr);
    }

    public String getBillType() {
        return this.billType;
    }

    public void setBillType(String billType) {
        this.billType = billType;
    }

    public String getBillName() {
        return this.billName;
    }

    public void setBillName(String billName) {
        this.billName = billName;
    }

    public JSONObject getYYSearchCondition() {
        return this.YYSearchCondition;
    }

    public void setYYSearchCondition(JSONObject yYSearchCondition) {
        this.YYSearchCondition = yYSearchCondition;
    }
}

