/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.front.business.ide.service.impl;

import com.ejianc.foundation.front.business.ide.bo.IdeProductAppBo;
import com.ejianc.foundation.front.business.ide.entity.IdeApp;
import com.ejianc.foundation.front.business.ide.entity.IdeAppGroup;
import com.ejianc.foundation.front.business.ide.entity.IdeModule;
import com.ejianc.foundation.front.business.ide.repository.IdeAppGroupRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeAppOpenRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeAppRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeModuleRepo;
import com.ejianc.foundation.front.business.ide.service.IdeAppOpenService;
import com.ejianc.foundation.front.business.ide.service.IdeCommonService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional
public class IdeAppOpenServiceImpl
implements IdeAppOpenService {
    @Autowired
    IdeAppRepo ideAppRepo;
    @Autowired
    IdeAppGroupRepo ideAppGroupRepo;
    @Autowired
    IdeAppOpenRepo ideAppOpenRepo;
    @Autowired
    IdeModuleRepo ideModuleRepo;
    @Autowired
    IdeCommonService ideCommonService;

    @Override
    public void saveAppForProduct(IdeApp ideApp) throws BusinessException, Exception {
        if (StringUtils.isEmpty((Object)ideApp.getName())) {
            throw new BusinessException("\u5e94\u7528\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)ideApp.getProductId())) {
            throw new BusinessException("\u6240\u5c5e\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)ideApp.getCreateId())) {
            throw new BusinessException("\u521b\u5efa\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)ideApp.getId())) {
            Long hasCount = this.ideAppOpenRepo.countNameInProduct(ideApp.getName(), String.valueOf(ideApp.getProductId()));
            if (hasCount != null && hasCount > 0L) {
                throw new BusinessException("\u9879\u76ee\u4e2d\u5df2\u5b58\u5728\u76f8\u540c\u7684\u5e94\u7528\u540d\u79f0");
            }
            ideApp.setId(IdWorker.getId());
            if (StringUtils.isEmpty((Object)ideApp.getCode())) {
                String code = this.ideCommonService.generateAppCode();
                ideApp.setCode(code);
            }
            ideApp.setCreateDate(new Date());
            this.ideAppRepo.save(ideApp);
        } else {
            IdeApp ideAppEntity = this.ideAppRepo.findById(String.valueOf(ideApp.getId()));
            ideAppEntity.setModifyDate(new Date());
            ideAppEntity.setName(ideApp.getName());
            ideAppEntity.setGroupId(ideApp.getGroupId());
            this.ideAppRepo.update(ideAppEntity);
        }
    }

    @Override
    public IdeProductAppBo findAppByProduct(String productId) throws BusinessException {
        IdeProductAppBo productAppBo = new IdeProductAppBo();
        if (StringUtils.isEmpty((Object)productId)) {
            throw new BusinessException("\u6240\u5c5e\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<IdeApp> apps = this.ideAppOpenRepo.findProductApps(productId);
        List<IdeAppGroup> appGroups = this.ideAppOpenRepo.findProductAppGroups(productId);
        final ArrayList<IdeApp> noGroupApps = new ArrayList<IdeApp>();
        final HashMap groupMapApps = new HashMap();
        apps.forEach(new Consumer<IdeApp>(){

            @Override
            public void accept(IdeApp app) {
                if (StringUtils.isEmpty((Object)app.getGroupId())) {
                    noGroupApps.add(app);
                } else {
                    ArrayList<IdeApp> applist = (ArrayList<IdeApp>)groupMapApps.get(app.getGroupId());
                    if (applist == null) {
                        applist = new ArrayList<IdeApp>();
                    }
                    applist.add(app);
                    groupMapApps.put(String.valueOf(app.getGroupId()), applist);
                }
            }
        });
        appGroups.forEach(new Consumer<IdeAppGroup>(){

            @Override
            public void accept(IdeAppGroup appGroup) {
                appGroup.setApps((List)groupMapApps.get(appGroup.getId()));
            }
        });
        productAppBo.setAppCount(apps.size());
        productAppBo.setApps(noGroupApps);
        productAppBo.setGroups(appGroups);
        return productAppBo;
    }

    @Override
    public IdeAppGroup saveAppGroupForProduct(IdeAppGroup appGroup) throws BusinessException {
        if (StringUtils.isEmpty((Object)appGroup.getName())) {
            throw new BusinessException("\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)appGroup.getProductId())) {
            throw new BusinessException("\u6240\u5c5e\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)appGroup.getCreateId())) {
            throw new BusinessException("\u521b\u5efa\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        }
        IdeAppGroup ideAppGroup = this.ideAppOpenRepo.findAppGroupByProductIdAndName(appGroup.getName(), String.valueOf(appGroup.getProductId()));
        if (StringUtils.isEmpty((Object)appGroup.getId())) {
            if (ideAppGroup != null) {
                throw new BusinessException("\u540c\u4e00\u4e2a\u9879\u76ee\u4e0b\u4e0d\u80fd\u6709\u76f8\u540c\u7684\u6587\u4ef6\u5939\u540d\uff01");
            }
            String appGroupCode = this.ideCommonService.generateAppGroupCode();
            appGroup.setId(IdWorker.getId());
            appGroup.setCode(appGroupCode);
            appGroup.setCreateDate(new Date());
            this.ideAppGroupRepo.save(appGroup);
        } else {
            if (ideAppGroup != null && !ideAppGroup.getName().equals(appGroup.getName())) {
                throw new BusinessException("\u540c\u4e00\u4e2a\u9879\u76ee\u4e0b\u4e0d\u80fd\u6709\u76f8\u540c\u7684\u6587\u4ef6\u5939\u540d\uff01");
            }
            IdeAppGroup oldAppGroup = this.ideAppGroupRepo.findOne(String.valueOf(appGroup.getId()));
            oldAppGroup.setName(appGroup.getName());
            oldAppGroup.setModifyDate(new Date());
            appGroup = this.ideAppGroupRepo.update(oldAppGroup);
        }
        return appGroup;
    }

    @Override
    public List<IdeModule> findPageByProductApp(String appId) throws BusinessException {
        List<IdeModule> beans = this.ideModuleRepo.findByAppId(appId);
        return beans;
    }

    @Override
    public Map<String, Integer> findProductAppCount(List<String> productIds) {
        String productIdStr = "";
        if (productIds != null && productIds.size() > 0) {
            for (String productId : productIds) {
                productIdStr = productIdStr + productId + ",";
            }
            productIdStr = productIdStr.substring(0, productIdStr.length() - 1);
            List<Map<String, Object>> rows = this.ideAppOpenRepo.findProductAppCount(productIdStr);
            HashMap<String, Integer> result = new HashMap<String, Integer>();
            for (Map<String, Object> row : rows) {
                result.put(row.get("productId").toString(), Integer.parseInt(row.get("appCount").toString()));
            }
            return result;
        }
        return null;
    }
}

