/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.front.business.ide.service.impl;

import com.ejianc.foundation.front.business.ide.bo.IdeTeamBo;
import com.ejianc.foundation.front.business.ide.entity.IdeApp;
import com.ejianc.foundation.front.business.ide.entity.IdeAppGroup;
import com.ejianc.foundation.front.business.ide.entity.IdeModule;
import com.ejianc.foundation.front.business.ide.entity.IdeModulePrivate;
import com.ejianc.foundation.front.business.ide.entity.IdeTeam;
import com.ejianc.foundation.front.business.ide.entity.JoinStatus;
import com.ejianc.foundation.front.business.ide.entity.RoleType;
import com.ejianc.foundation.front.business.ide.repository.IdeAppGroupRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeAppRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeModuleDataRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeModulePrivateRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeModuleProRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeModuleRepo;
import com.ejianc.foundation.front.business.ide.repository.IdePartWidgetRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeTeamRepo;
import com.ejianc.foundation.front.business.ide.service.IdeAppGroupService;
import com.ejianc.foundation.front.business.ide.service.IdeAppService;
import com.ejianc.foundation.front.business.ide.service.IdeCommonService;
import com.ejianc.foundation.front.business.ide.service.IdeModuleService;
import com.ejianc.foundation.front.business.ide.service.IdeTeamService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class IdeAppServiceImpl
implements IdeAppService {
    @Autowired
    IdeAppRepo ideAppRepo;
    @Autowired
    IdeModuleRepo ideModuleRepo;
    @Autowired
    IdePartWidgetRepo idePartWidgetRepo;
    @Autowired
    IdeTeamService ideTeamService;
    @Autowired
    IdeModuleProRepo ideModuleProRepo;
    @Autowired
    IdeTeamRepo teamRepo;
    @Autowired
    IdeModuleService ideModuleService;
    @Autowired
    IdeModuleDataRepo moduleDataRepo;
    @Autowired
    IdeModulePrivateRepo ideModulePrivateRepo;
    @Autowired
    IdeAppGroupRepo ideAppGroupRepo;
    @Autowired
    IdeCommonService ideCommonService;
    @Autowired
    IdeAppGroupService ideAppGroupService;

    @Override
    public void saveOrUpdate(IdeApp ideApp) throws BusinessException, Exception {
        if (StringUtils.isEmpty((String)ideApp.getName())) {
            throw new BusinessException("\u5e94\u7528\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        IdeTeam team = null;
        if (ideApp.getTeamId() != null && (team = this.teamRepo.findOne(String.valueOf(ideApp.getTeamId()))) == null) {
            throw new BusinessException("\u56e2\u961f\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        }
        if (ideApp.getId() != null && ideApp.getId() > 0L) {
            IdeApp ideAppEntity = this.ideAppRepo.findById(String.valueOf(ideApp.getId()));
            ideAppEntity.setModifyDate(new Date());
            ideAppEntity.setModifyId(InvocationInfoProxy.getUserid());
            ideAppEntity.setName(ideApp.getName());
            ideAppEntity.setBillTypeCode(ideApp.getBillTypeCode());
            ideAppEntity.setBillTypeName(ideApp.getBillTypeName());
            ideAppEntity.setGroupId(ideApp.getGroupId());
            ideAppEntity.setTechnicalType(ideApp.getTechnicalType());
            ideAppEntity.setIpAddress(ideApp.getIpAddress());
            this.ideAppRepo.update(ideAppEntity);
        } else {
            List<IdeApp> ideAppList = this.ideAppRepo.findNameInTeam(ideApp.getName(), String.valueOf(ideApp.getTeamId()));
            if (ideAppList.size() > 0) {
                throw new BusinessException("\u56e2\u961f\u4e2d\u5df2\u5b58\u5728\u76f8\u540c\u7684\u5e94\u7528\u540d\u79f0");
            }
            ideApp.setId(IdWorker.getId());
            if (StringUtils.isEmpty((String)ideApp.getCode())) {
                String code = this.ideCommonService.generateAppCode();
                ideApp.setCode(code);
            }
            ideApp.setCreateDate(new Date());
            this.ideAppRepo.save(ideApp);
        }
        if (team != null) {
            this.updateTeamAppCount(team);
        }
    }

    @Override
    public List<IdeApp> findByCreateId(String createId, String clientType) throws BusinessException {
        return this.ideAppRepo.findByCreateId(createId, clientType);
    }

    @Override
    public void updateOpen(String appId, int open, String createId) {
        IdeApp ideApp = this.ideAppRepo.findById(appId);
        if (ideApp == null) {
            throw new BusinessException("\u5e94\u7528\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        ideApp.setIsOpen(open);
        ideApp.setModifyDate(new Date());
        ideApp.setModifyId(Long.parseLong(createId));
        this.ideAppRepo.update(ideApp);
    }

    @Override
    public List<IdeTeamBo> findTeamAppsByUser(String createId, int prodType, String clientType) {
        List<IdeTeamBo> userTeams;
        ArrayList<IdeTeamBo> myTeamApps = new ArrayList<IdeTeamBo>();
        List<IdeApp> noteamApps = this.ideAppRepo.findNoTeamApps(createId, clientType);
        if (noteamApps != null && noteamApps.size() > 0) {
            IdeTeamBo noteam = new IdeTeamBo();
            noteam.setCode("NOTEAM");
            noteam.setName("\u672a\u5f52\u56e2");
            noteam.setCreateId(createId);
            noteam.setJoinStatus(JoinStatus.IN.getValue());
            noteam.setRoleType(RoleType.SUPER_ADMIN.getValue());
            noteam.setMemberCount(1);
            noteam.setAppCount(noteamApps.size());
            noteam.setApps(noteamApps);
            myTeamApps.add(noteam);
        }
        if ((userTeams = this.ideTeamService.queryUserTeams(createId, prodType)) == null || userTeams.size() == 0) {
            return myTeamApps;
        }
        myTeamApps.addAll(userTeams);
        String teamIds = "";
        for (int i = 0; i < userTeams.size(); ++i) {
            teamIds = teamIds + userTeams.get(i).getId() + ",";
        }
        if (teamIds.length() > 0) {
            teamIds = teamIds.substring(0, teamIds.length() - 1);
        }
        List<IdeApp> teamApps = this.ideAppRepo.findTeamApps(teamIds, clientType);
        HashMap mapper = new HashMap();
        for (int i = 0; i < teamApps.size(); ++i) {
            IdeApp app = teamApps.get(i);
            if (app.getGroupId() != null) continue;
            List appList = (List)mapper.get(app.getTeamId());
            if (appList == null) {
                appList = new ArrayList();
            }
            appList.add(app);
            mapper.put(app.getTeamId(), appList);
        }
        List<IdeAppGroup> appGroups = this.ideAppGroupService.findByTeamIds(teamIds, clientType);
        HashMap appGroupMap = new HashMap();
        if (appGroups != null && appGroups.size() > 0) {
            for (IdeAppGroup appGroup : appGroups) {
                ArrayList<IdeAppGroup> appGroupList = (ArrayList<IdeAppGroup>)appGroupMap.get(String.valueOf(appGroup.getTeamId()));
                if (appGroupList == null) {
                    appGroupList = new ArrayList<IdeAppGroup>();
                }
                List<IdeApp> groupApps = this.ideAppRepo.findAppByGroupId(String.valueOf(appGroup.getId()));
                appGroup.setApps(groupApps);
                appGroupList.add(appGroup);
                appGroupMap.put(String.valueOf(appGroup.getTeamId()), appGroupList);
            }
        }
        for (int i = 0; i < userTeams.size(); ++i) {
            IdeTeamBo team = userTeams.get(i);
            team.setApps((List)mapper.get(Long.parseLong(team.getId())));
            team.setGroups((List)appGroupMap.get(team.getId()));
        }
        return myTeamApps;
    }

    @Override
    public List<IdeTeamBo> findTeamPublicApps(String createId, int prodType, String clientType) {
        List<IdeTeamBo> joinTeams = this.ideTeamService.queryUserTeams(createId, prodType);
        if (joinTeams == null) {
            joinTeams = new ArrayList<IdeTeamBo>();
        }
        String joinTeamIds = "";
        for (int i = 0; i < joinTeams.size(); ++i) {
            joinTeamIds = joinTeamIds + joinTeams.get(i).getId() + ",";
        }
        joinTeamIds = StringUtils.isBlank((String)joinTeamIds) ? "-1" : joinTeamIds.substring(0, joinTeamIds.length() - 1);
        List<IdeApp> teamApps = this.ideAppRepo.findPublicApps(prodType, joinTeamIds, clientType);
        HashMap<String, ArrayList<IdeApp>> mapper = new HashMap<String, ArrayList<IdeApp>>();
        String teamIds = "";
        for (int i = 0; i < teamApps.size(); ++i) {
            IdeApp app = teamApps.get(i);
            ArrayList<IdeApp> appList = (ArrayList<IdeApp>)mapper.get(app.getTeamId());
            if (appList == null) {
                appList = new ArrayList<IdeApp>();
            }
            appList.add(app);
            mapper.put(String.valueOf(app.getTeamId()), appList);
            teamIds = teamIds + String.valueOf(app.getTeamId()) + ",";
        }
        ArrayList nojoinTeams = mapper.keySet().size() > 0 ? this.teamRepo.findAll(teamIds.substring(0, teamIds.length() - 1)) : new ArrayList();
        ArrayList<IdeTeamBo> nojoinTeamPublisApps = new ArrayList<IdeTeamBo>();
        for (int i = 0; i < nojoinTeams.size(); ++i) {
            IdeTeamBo team = new IdeTeamBo((IdeTeam)nojoinTeams.get(i));
            team.setApps((List)mapper.get(team.getId()));
            nojoinTeamPublisApps.add(team);
        }
        return nojoinTeamPublisApps;
    }

    @Override
    public List<IdeApp> findNoTeamApps(String createId, String clientType) {
        return this.ideAppRepo.findNoTeamApps(createId, clientType);
    }

    @Override
    public List<IdeApp> findAll(String clientType) throws BusinessException, Exception {
        List<IdeApp> ideApps = this.ideAppRepo.findAll(clientType);
        List<IdeModule> sysModules = this.ideModuleRepo.findAll(clientType);
        for (int i = 0; i < ideApps.size(); ++i) {
            ArrayList<IdeModule> appChildren = new ArrayList<IdeModule>();
            for (IdeModule module : sysModules) {
                if (module.getAppId() != null && module.getAppId() > 0L || !module.getAppId().equals(ideApps.get(i).getId())) continue;
                module.setAppCode(ideApps.get(i).getCode());
                appChildren.add(module);
            }
            if (appChildren.size() <= 0) continue;
            ideApps.get(i).setChildren(appChildren);
        }
        return ideApps;
    }

    @Override
    public void deleteById(String id) throws BusinessException, Exception {
        IdeTeam team;
        IdeApp app = this.ideAppRepo.findById(id);
        app.setIsDelete(1);
        this.ideAppRepo.deleteById(id);
        List<IdeModule> pageList = this.ideModuleRepo.findByAppId(id);
        ArrayList<String> idList = new ArrayList<String>();
        ArrayList<String> codeList = new ArrayList<String>();
        String ids = "";
        for (IdeModule page : pageList) {
            ids = ids + page.getId() + ",";
            idList.add(String.valueOf(page.getId()));
            codeList.add(page.getCode());
        }
        if (idList.size() > 0) {
            this.ideModuleRepo.deleteByIds(ids.substring(0, ids.length() - 1));
            this.ideModulePrivateRepo.deleteByModuleIds(ids.substring(0, ids.length() - 1));
        }
        if (app.getTeamId() != null && (team = this.teamRepo.findOne(String.valueOf(app.getTeamId()))) != null) {
            this.updateTeamAppCount(team);
        }
    }

    @Override
    public void copyApp(IdeApp ideApp) throws Exception {
        IdeTeam targetTeam;
        IdeTeam sourceTeam;
        IdeApp ideAppSrc = this.ideAppRepo.findById(String.valueOf(ideApp.getId()));
        if (ideAppSrc == null) {
            throw new BusinessException("\u5e94\u7528\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        }
        Date nowDate = new Date();
        List<IdeModule> ideModuleList = this.ideModuleRepo.findByAppId(String.valueOf(ideApp.getId()));
        IdeApp ideAppSave = new IdeApp();
        ideAppSave.setId(IdWorker.getId());
        ideAppSave.setName(ideApp.getName());
        ideAppSave.setTeamId(ideApp.getTeamId());
        ideAppSave.setCreateId(ideApp.getCreateId());
        ideAppSave.setCreateDate(nowDate);
        ideAppSave.setBillTypeCode(ideApp.getBillTypeCode());
        ideAppSave.setBillTypeName(ideApp.getBillTypeName());
        if (ideAppSrc.getTeamId() != null && ideAppSrc.getTeamId().equals(ideApp.getTeamId())) {
            ideAppSave.setGroupId(ideAppSrc.getGroupId());
        }
        String code = this.ideCommonService.generateAppCode();
        ideAppSave.setCode(code);
        ideAppSave.setIsOpen(0);
        this.ideAppRepo.save(ideAppSave);
        if (ideModuleList != null && ideModuleList.size() > 0) {
            String[] newPageCodes = this.ideCommonService.generateModuleCodes(ideModuleList.size());
            for (int i = 0; i < ideModuleList.size(); ++i) {
                IdeModule moduleSrc = ideModuleList.get(i);
                IdeModule moduleSave = new IdeModule();
                BeanUtils.copyProperties((Object)moduleSrc, (Object)moduleSave, (String[])new String[]{"id", "code", "createId", "createDate"});
                moduleSave.setId(IdWorker.getId());
                moduleSave.setCode(newPageCodes[i]);
                moduleSave.setAppId(ideAppSave.getId());
                moduleSave.setCreateId(ideApp.getCreateId());
                moduleSave.setCreateDate(nowDate);
                moduleSave.setFromId(moduleSrc.getId());
                moduleSave.setFromName(moduleSrc.getName());
                this.ideModuleRepo.save(moduleSave);
            }
        }
        if (ideAppSrc.getTeamId() != null && (sourceTeam = this.teamRepo.findOne(String.valueOf(ideAppSrc.getTeamId()))) != null) {
            this.updateTeamAppCount(sourceTeam);
        }
        if (ideApp.getTeamId() != null && (targetTeam = this.teamRepo.findOne(String.valueOf(ideApp.getTeamId()))) != null) {
            this.updateTeamAppCount(targetTeam);
        }
    }

    @Override
    public IdeApp findById(String id) throws BusinessException {
        return this.ideAppRepo.findById(id);
    }

    @Override
    public IdeApp findByCode(String code) throws BusinessException {
        List<IdeApp> apps = this.ideAppRepo.findAllByCode(code);
        if (apps != null && apps.size() > 0) {
            return apps.get(0);
        }
        return null;
    }

    @Override
    public List<IdeApp> findAllApps(boolean isDelete, String clientType) throws BusinessException {
        return this.ideAppRepo.findAllApps(clientType);
    }

    @Override
    public void removeById(String id) throws Exception {
        List<IdeTeam> ideTeams = this.teamRepo.findTeamByAppIds(id);
        List<String> moduleIds = this.ideModuleRepo.findModuleIdsByAppId(id);
        if (moduleIds != null && moduleIds.size() > 0) {
            String moduleIdStr = "";
            for (int i = 0; i < moduleIds.size(); ++i) {
                moduleIdStr = moduleIdStr + moduleIds.get(i) + ",";
            }
            this.ideModuleRepo.removeByIds(moduleIdStr.substring(0, moduleIdStr.length() - 1));
        }
        this.ideAppRepo.deleteById(id);
        if (ideTeams != null && ideTeams.size() > 0) {
            for (IdeTeam ideTeam : ideTeams) {
                ideTeam.setAppCount(this.teamRepo.countTeamApps(String.valueOf(ideTeam.getId())));
                this.teamRepo.update(ideTeam);
            }
        }
    }

    @Override
    public void recoverById(String id) throws Exception {
        this.ideAppRepo.recoverById(id);
    }

    @Override
    @Transactional
    public void bindTeamOfApps(String teamId, String[] appIds, final String groupId) {
        final IdeTeam team = this.teamRepo.findOne(teamId);
        if (team == null) {
            throw new BusinessException(String.format("\u56e2\u961f\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\uff0c\u56e2\u961fid: %s", teamId));
        }
        List<Object> apps = new ArrayList();
        String appIdStr = "";
        if (appIds != null && appIds.length > 0) {
            for (String appId : appIds) {
                appIdStr = appIdStr + appId + ",";
            }
            apps = this.ideAppRepo.findAllByIds(appIdStr.substring(0, appIdStr.length() - 1));
        }
        if (CollectionUtils.isEmpty(apps)) {
            throw new BusinessException(String.format("\u4e0d\u5b58\u5728id\u5c5e\u4e8e(%s)\u7684\u5e94\u7528", appIdStr));
        }
        apps.forEach(new Consumer<IdeApp>(){

            @Override
            public void accept(IdeApp app) {
                app.setTeamId(team.getId());
                app.setGroupId(Long.parseLong(groupId));
                IdeAppServiceImpl.this.ideAppRepo.update(app);
            }
        });
        this.updateTeamAppCount(team);
    }

    @Override
    public void updateTeamAppCount(IdeTeam team) {
        if (team != null) {
            int appsNum = this.ideAppRepo.countApps(String.valueOf(team.getId()));
            team.setAppCount(appsNum);
            this.teamRepo.update(team);
        }
    }

    @Override
    public List<IdeApp> findAppTeamId(String teamId) throws BusinessException, Exception {
        return this.ideAppRepo.findAppByTeamId(teamId);
    }

    @Override
    public List<IdeModulePrivate> checkCanDelete(List<String> ids) throws BusinessException, Exception {
        if (ids != null && ids.size() > 0) {
            String idStr = "";
            for (String id : ids) {
                idStr = idStr + id + ",";
            }
            List<IdeModulePrivate> modulePrivates = this.ideModulePrivateRepo.findListByAppIds(idStr.substring(0, idStr.length() - 1));
            return modulePrivates;
        }
        return null;
    }

    @Override
    public void deleteByIds(List<String> ids, boolean isRemove) throws BusinessException, Exception {
        List<IdeModule> ideModules = this.ideModuleService.findInAppIds(ids.toArray(new String[ids.size()]));
        if (isRemove) {
            if (ideModules != null && ideModules.size() > 0) {
                String moduleIds = "";
                for (IdeModule ideModule : ideModules) {
                    moduleIds = moduleIds + ideModule.getId() + ",";
                }
                this.ideModuleRepo.removeByIds(moduleIds.substring(0, moduleIds.length() - 1));
                this.ideModulePrivateRepo.removeByModuleIds(moduleIds.substring(0, moduleIds.length() - 1));
            }
            String idStr = "";
            if (ids != null && ids.size() > 0) {
                for (String id : ids) {
                    idStr = idStr + id + ",";
                }
                this.ideAppRepo.removeByIds(idStr.substring(0, idStr.length() - 1));
            }
        } else {
            String idStr = "";
            if (ids != null && ids.size() > 0) {
                for (String id : ids) {
                    idStr = idStr + id + ",";
                }
            }
            List<IdeTeam> ideTeams = this.teamRepo.findTeamByAppIds(idStr.substring(0, idStr.length() - 1));
            if (ideModules != null && ideModules.size() > 0) {
                String moduleIds = "";
                for (IdeModule ideModule : ideModules) {
                    moduleIds = moduleIds + ideModule.getId() + ",";
                }
                this.ideModuleRepo.deleteByIds(moduleIds.substring(0, moduleIds.length() - 1));
                this.moduleDataRepo.deleteByModuleIds(moduleIds.substring(0, moduleIds.length() - 1));
                this.ideModulePrivateRepo.deleteByModuleIds(moduleIds.substring(0, moduleIds.length() - 1));
            }
            String idStrs = "";
            if (ids != null && ids.size() > 0) {
                for (String id : ids) {
                    idStrs = idStrs + id + ",";
                }
                this.ideAppRepo.deleteByIds(idStrs.substring(0, idStrs.length() - 1));
            }
            if (ideTeams != null && ideTeams.size() > 0) {
                for (IdeTeam ideTeam : ideTeams) {
                    ideTeam.setAppCount(this.teamRepo.countTeamApps(String.valueOf(ideTeam.getId())));
                    this.teamRepo.update(ideTeam);
                }
            }
        }
    }

    @Override
    public void recoverByIds(List<String> ids) throws BusinessException, Exception {
        String idStr = "";
        for (String id : ids) {
            idStr = idStr + id + ",";
        }
        if (StringUtils.isNotBlank((String)idStr)) {
            idStr = idStr.substring(0, idStr.length() - 1);
        }
        this.ideAppRepo.recoverByIds(idStr);
        this.ideModuleRepo.recoverByAppIds(idStr);
        this.ideModulePrivateRepo.recoverByAppIds(idStr);
        List<IdeTeam> ideTeams = this.teamRepo.findTeamByAppIds(idStr);
        if (ideTeams != null && ideTeams.size() > 0) {
            for (IdeTeam ideTeam : ideTeams) {
                ideTeam.setAppCount(this.teamRepo.countTeamApps(String.valueOf(ideTeam.getId())));
                this.teamRepo.save(ideTeam);
            }
        }
    }

    @Override
    public Page<IdeApp> findPage(String teamId, String searchText, boolean isDelete, Pageable pageable) throws BusinessException, Exception {
        Integer pageIndex = pageable.getPageNumber() * pageable.getPageSize();
        List<IdeApp> list = this.ideAppRepo.findAppListByTeamId(teamId, searchText, isDelete, pageIndex, pageable.getPageSize());
        long total = this.ideAppRepo.findModuleCountByTeamId(teamId, searchText, isDelete);
        PageImpl page = new PageImpl(list, pageable, total);
        return page;
    }
}

