/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.front.business.ide.service.impl;

import com.ejianc.foundation.front.business.ide.entity.IdeEntity;
import com.ejianc.foundation.front.business.ide.entity.IdeEntityAttr;
import com.ejianc.foundation.front.business.ide.repository.IdeEntityAttrRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeEntityRepo;
import com.ejianc.foundation.front.business.ide.service.IdeEntityAttrService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.support.idworker.util.IdWorker;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class IdeEntityAttrServiceImpl
implements IdeEntityAttrService {
    @Autowired
    private IdeEntityAttrRepo entityAttrRepo;
    @Autowired
    private IdeEntityRepo entityRepo;

    @Override
    public IdeEntity save(List<IdeEntityAttr> ideEntityAttrs, String entityId, int version) throws Exception, BusinessException {
        for (IdeEntityAttr ideEntityAttr : ideEntityAttrs) {
            if (!ideEntityAttr.getRowState().equals("del")) continue;
            ideEntityAttrs.remove(ideEntityAttr);
        }
        IdeEntity entity = this.entityRepo.findById(entityId);
        if (entity == null) {
            throw new BusinessException("\u672c\u6a21\u578b\u88ab\u4ed6\u4eba\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u83b7\u53d6\u6700\u65b0\u6570\u636e\uff01");
        }
        if (version != entity.getVersion()) {
            throw new BusinessException(String.format("\u672c\u6a21\u578b\u88ab\u4ed6\u4eba\u4e8e[%s]\u4fee\u6539\u8fc7\uff0c\u8bf7\u5237\u65b0\u83b7\u53d6\u6700\u65b0\u6570\u636e\uff01", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(entity.getModifyDate())));
        }
        ArrayList<String> list = new ArrayList<String>();
        String errData = "";
        for (IdeEntityAttr ideEntityAttr : ideEntityAttrs) {
            if (list.contains(ideEntityAttr.getCode())) {
                errData = errData + ideEntityAttr.getCode() + ",";
                continue;
            }
            list.add(ideEntityAttr.getCode());
        }
        if (errData.equals("")) {
            this.entityAttrRepo.deleteEntityId(entityId);
            if (ideEntityAttrs != null && ideEntityAttrs.size() > 0) {
                for (IdeEntityAttr ideEntityAttr : ideEntityAttrs) {
                    ideEntityAttr.setId(IdWorker.getId());
                    this.entityAttrRepo.save(ideEntityAttr);
                }
            }
            entity.setModifyDate(new Date());
            entity.setModifyId(InvocationInfoProxy.getUserid());
            this.entityRepo.update(entity);
            return entity;
        }
        throw new BusinessException("\u952e\u503c" + errData.substring(0, errData.length() - 1) + "\u4e0d\u80fd\u91cd\u590d\uff01");
    }

    @Override
    public List<IdeEntityAttr> findListByEntityId(String entityId) throws Exception, BusinessException {
        return this.entityAttrRepo.findByEntityId(entityId);
    }
}

