/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.front.business.ide.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.front.business.ide.bo.IdeModuleBo;
import com.ejianc.foundation.front.business.ide.entity.IdeApp;
import com.ejianc.foundation.front.business.ide.entity.IdeModule;
import com.ejianc.foundation.front.business.ide.entity.IdeModulePrivate;
import com.ejianc.foundation.front.business.ide.entity.IdeModulePrivateVerifyHis;
import com.ejianc.foundation.front.business.ide.entity.IdeTeam;
import com.ejianc.foundation.front.business.ide.repository.IdeAppRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeModulePrivateRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeModulePrivateVerifyHisRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeModuleRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeTeamRepo;
import com.ejianc.foundation.front.business.ide.service.IdeModulePrivateService;
import com.ejianc.foundation.front.util.StringUtils;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class IdeModulePrivateServiceImpl
implements IdeModulePrivateService {
    @Autowired
    private IdeModulePrivateRepo ideModulePrivateRepo;
    @Autowired
    private IdeModuleRepo ideModuleRepo;
    @Autowired
    private IdeTeamRepo ideTeamRepo;
    @Autowired
    private IdeAppRepo ideAppRepo;
    @Autowired
    private IdeModulePrivateVerifyHisRepo ideModulePrivateVerifyHisRepo;
    @Autowired
    private IOrgApi orgApi;

    @Override
    public Page<IdeModulePrivate> findByCode(String code, String orgId, String appId, String tenantId, Pageable pageable) throws BusinessException, Exception {
        if (org.apache.commons.lang.StringUtils.isNotEmpty((String)orgId)) {
            Integer pageIndex = pageable.getPageNumber() * pageable.getPageSize();
            Integer pageSize = pageable.getPageSize();
            String orgIdStrs = "";
            List<String> orgIds = this.findChildOrgIds(orgId);
            if (ListUtil.isEmpty(orgIds)) {
                return new PageImpl(new ArrayList(), pageable, 0L);
            }
            for (String orgIdStr : orgIds) {
                orgIdStrs = orgIdStrs + orgIdStr + ",";
            }
            orgIdStrs = orgIdStrs.substring(0, orgIdStrs.length() - 1);
            List<IdeModulePrivate> ideModulePrivageList = this.ideModulePrivateRepo.queryModulePrivateList(orgIdStrs, code, appId, pageIndex, pageSize);
            Long ideModulePrivageCount = this.ideModulePrivateRepo.queryModulePrivateCount(orgIdStrs, code, appId);
            return new PageImpl(ideModulePrivageList, pageable, ideModulePrivageCount.longValue());
        }
        return new PageImpl(new ArrayList(), pageable, 0L);
    }

    @Override
    public IPage<IdeModulePrivate> findByCode(int pageNumber, int pageSize, String code, String orgId, String appId, String tenantId) throws BusinessException, Exception {
        if (!org.apache.commons.lang.StringUtils.isEmpty((String)orgId)) {
            Integer pageIndex = (pageNumber - 1) * pageSize;
            String orgIdStrs = "";
            List<String> orgIds = this.findChildOrgIds(orgId);
            for (String orgIdStr : orgIds) {
                orgIdStrs = orgIdStrs + orgIdStr + ",";
            }
            orgIdStrs = orgIdStrs.substring(0, orgIdStrs.length() - 1);
            List<IdeModulePrivate> records = this.ideModulePrivateRepo.queryModulePrivateList(orgIdStrs, code, appId, pageIndex, pageSize);
            Long total = this.ideModulePrivateRepo.queryModulePrivateCount(orgIdStrs, code, appId);
            com.baomidou.mybatisplus.extension.plugins.pagination.Page page = new com.baomidou.mybatisplus.extension.plugins.pagination.Page();
            page.setSize((long)pageSize);
            page.setCurrent((long)pageNumber);
            page.setTotal(total.longValue());
            page.setRecords(records);
            return page;
        }
        return new com.baomidou.mybatisplus.extension.plugins.pagination.Page();
    }

    @Override
    public void saveOrUpdate(IdeModulePrivate ideModulePrivate) throws BusinessException {
        if (ideModulePrivate.getId() == null || ideModulePrivate.getId() == 0L) {
            List<IdeModulePrivate> modulePrivate = this.ideModulePrivateRepo.findByCodeAndOrgId(ideModulePrivate.getCode(), String.valueOf(ideModulePrivate.getOrgId()));
            if (modulePrivate != null && modulePrivate.size() > 0) {
                throw new BusinessException("\u5f53\u524d\u7ec4\u7ec7\u5df2\u5b58\u5728\u914d\u7f6e\u9875\u9762\uff01");
            }
            IdeModule ideModule = this.ideModuleRepo.findByAppCodeAndModuleCode(ideModulePrivate.getAppCode(), ideModulePrivate.getCode());
            ideModulePrivate.setId(IdWorker.getId());
            ideModulePrivate.setAppId(ideModule.getAppId());
            ideModulePrivate.setCreateDate(new Date());
            ideModulePrivate.setCreateId(ideModule.getCreateId());
            ideModulePrivate.setData(ideModule.getData());
            ideModulePrivate.setName(ideModule.getName());
            ideModulePrivate.setPageType(ideModule.getPageType());
            ideModulePrivate.setAppCode(ideModule.getAppCode());
            ideModulePrivate.setClientType(ideModule.getClientType());
            this.ideModulePrivateRepo.save(ideModulePrivate);
        } else {
            IdeModulePrivate newModulePrivate = this.ideModulePrivateRepo.findById(String.valueOf(ideModulePrivate.getId()));
            newModulePrivate.setModifyDate(new Date());
            newModulePrivate.setIsCompatible(ideModulePrivate.getIsCompatible());
            this.ideModulePrivateRepo.update(newModulePrivate);
        }
    }

    @Override
    public void changeIsDevelopment(IdeModulePrivate ideModulePrivate) throws BusinessException {
        IdeModulePrivate newModulePrivate = this.ideModulePrivateRepo.findById(String.valueOf(ideModulePrivate.getId()));
        newModulePrivate.setModifyDate(new Date());
        newModulePrivate.setIsDevelopment(ideModulePrivate.getIsCompatible());
        this.ideModulePrivateRepo.update(newModulePrivate);
    }

    @Override
    public void deleteByIds(List<String> ids) throws BusinessException, Exception {
        String idStr = "";
        if (ids != null && ids.size() > 0) {
            for (String id : ids) {
                idStr = idStr + id + ",";
            }
            idStr = idStr.substring(0, idStr.length() - 1);
            this.ideModulePrivateRepo.deleteByIds(idStr);
        }
    }

    @Override
    public IdeModulePrivate findByOrgId(String pageCode, String appCode, String orgId, String tenantId) {
        IdeModulePrivate ideModulePrivate = this.ideModulePrivateRepo.findByOrgId(appCode, pageCode, orgId);
        if (ideModulePrivate != null) {
            return ideModulePrivate;
        }
        if (org.apache.commons.lang.StringUtils.isEmpty((String)orgId)) {
            return null;
        }
        CommonResponse response = this.orgApi.findParentsByOrgId(Long.valueOf(Long.parseLong(orgId)));
        if (response.isSuccess()) {
            List<IdeModulePrivate> list;
            String orgIds = "";
            List orgVos = (List)response.getData();
            if (orgVos != null && orgVos.size() > 0) {
                for (OrgVO orgVo : orgVos) {
                    orgIds = orgIds + orgVo.getId() + ",";
                }
                orgIds = orgIds.substring(0, orgIds.length() - 1);
            }
            if (!StringUtils.isEmpty(orgIds) && (list = this.ideModulePrivateRepo.findByOrgIds(appCode, pageCode, orgIds)) != null && list.size() > 0) {
                return list.get(0);
            }
        }
        return null;
    }

    @Override
    public IdeModulePrivate findByOrgIdAndCode(String pageCode, String appCode, String orgId) throws BusinessException {
        IdeModulePrivate ideModulePrivate = this.ideModulePrivateRepo.findByOrgId(appCode, pageCode, orgId);
        if (ideModulePrivate != null) {
            return ideModulePrivate;
        }
        throw new BusinessException("\u8be5\u7ec4\u7ec7\u4e0d\u5b58\u5728\u8be5\u9875\u9762\u7684\u5b9e\u4f8b");
    }

    @Override
    public List<IdeModulePrivate> findByPageCodeAndAppCode(String pageCode, String appCode) {
        return this.ideModulePrivateRepo.findByPageCodeAndAppCode(appCode, pageCode);
    }

    @Override
    public void saveData(IdeModulePrivate ideModulePrivate) throws BusinessException {
        IdeModulePrivate modulePrivate = this.ideModulePrivateRepo.findByOrgId(ideModulePrivate.getAppCode(), ideModulePrivate.getCode(), String.valueOf(ideModulePrivate.getOrgId()));
        if (modulePrivate == null) {
            throw new BusinessException("\u8be5\u7ec4\u7ec7\u4e0d\u5b58\u5728\u8be5\u9875\u9762\u7684\u5b9e\u4f8b");
        }
        modulePrivate.setData(ideModulePrivate.getData());
        this.ideModulePrivateRepo.update(modulePrivate);
    }

    @Override
    public void updateData(IdeModulePrivate ideModulePrivate) throws BusinessException {
        if (ideModulePrivate == null) {
            throw new BusinessException("\u8be5\u7ec4\u7ec7\u4e0d\u5b58\u5728\u8be5\u9875\u9762\u7684\u5b9e\u4f8b");
        }
        this.ideModulePrivateRepo.update(ideModulePrivate);
    }

    private List<String> findChildOrgIds(String orgId) throws BusinessException, Exception {
        List orgVos;
        ArrayList<String> orgIds = new ArrayList<String>();
        CommonResponse response = this.orgApi.findChildrenByParentId(Long.valueOf(Long.parseLong(orgId)));
        if (response.isSuccess() && (orgVos = (List)response.getData()) != null && orgVos.size() > 0) {
            for (OrgVO orgVo : orgVos) {
                orgIds.add(orgVo.getId().toString());
            }
        }
        return orgIds;
    }

    @Override
    public List<String> findNodeIds(String orgId, String tenantId) throws BusinessException, Exception {
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)orgId)) {
            List<IdeModule> list;
            List<IdeApp> ideApps;
            ArrayList<String> nodeIds = new ArrayList<String>();
            ArrayList<Object> params = new ArrayList<Object>();
            List<String> orgIds = this.findChildOrgIds(orgId);
            params.addAll(orgIds);
            List<IdeTeam> ideTeams = this.findTeamHasData(params);
            if (ideTeams != null && ideTeams.size() > 0) {
                for (IdeTeam ideTeam : ideTeams) {
                    nodeIds.add(String.valueOf(ideTeam.getId()));
                }
            }
            if ((ideApps = this.findAppHasData(params)) != null && ideApps.size() > 0) {
                for (IdeApp ideApp : ideApps) {
                    nodeIds.add(String.valueOf(ideApp.getId()));
                }
            }
            if ((list = this.findPageHasData(params)) != null && list.size() > 0) {
                for (IdeModule ideModule : list) {
                    nodeIds.add(String.valueOf(ideModule.getId()));
                }
            }
            return nodeIds;
        }
        return null;
    }

    private List<IdeTeam> findTeamHasData(List<Object> params) throws BusinessException, Exception {
        String orgIds = "";
        if (params != null && params.size() > 0) {
            for (Object object : params) {
                orgIds = orgIds + object.toString() + ",";
            }
            orgIds = orgIds.substring(0, orgIds.length() - 1);
        }
        List<IdeTeam> ideTeams = this.ideTeamRepo.findTeamHasData(orgIds);
        return ideTeams;
    }

    private List<IdeApp> findAppHasData(List<Object> params) throws BusinessException, Exception {
        String orgIds = "";
        for (Object param : params) {
            orgIds = orgIds + param.toString() + ",";
        }
        orgIds = orgIds.substring(0, orgIds.length() - 1);
        List<IdeApp> ideAppList = this.ideAppRepo.queryAppHasData(orgIds);
        return ideAppList;
    }

    private List<IdeModule> findPageHasData(List<Object> params) throws BusinessException, Exception {
        String orgIds = "";
        for (Object param : params) {
            orgIds = orgIds + param.toString() + ",";
        }
        orgIds = orgIds.substring(0, orgIds.length() - 1);
        List<IdeModule> ideModuleList = this.ideModuleRepo.queryPageHasData(orgIds);
        return ideModuleList;
    }

    @Override
    public List<IdeModule> findModule(String appId) throws BusinessException {
        List<IdeModule> ideModuleList = this.ideModuleRepo.findDetailsByAppId(appId);
        return ideModuleList;
    }

    @Override
    public List<IdeModuleBo> searchByModuleCodeAndName(String searchText, int maxCount) throws BusinessException {
        if (org.apache.commons.lang.StringUtils.isEmpty((String)searchText)) {
            return new ArrayList<IdeModuleBo>();
        }
        List<IdeModuleBo> ideModuleBoList = this.ideModuleRepo.queryListByModuleCodeAndName(searchText, maxCount);
        return ideModuleBoList;
    }

    @Override
    public IdeModulePrivate findById(String id) throws Exception {
        IdeModulePrivate ideModulePrivate = this.ideModulePrivateRepo.findById(id);
        if (ideModulePrivate == null) {
            throw new BusinessException("\u9875\u9762\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        return ideModulePrivate;
    }

    @Override
    public List<IdeModulePrivate> findByIds(String ids) throws Exception {
        return this.ideModulePrivateRepo.findByIds(ids);
    }

    @Override
    public void updateAttach(IdeModulePrivate ideModulePrivate) throws BusinessException {
        IdeModulePrivate newModulePrivate = this.ideModulePrivateRepo.findById(String.valueOf(ideModulePrivate.getId()));
        newModulePrivate.setModifyDate(new Date());
        newModulePrivate.setModifyId(ideModulePrivate.getModifyId());
        newModulePrivate.setAttachIdDev(ideModulePrivate.getAttachIdDev());
        newModulePrivate.setAttachPathDev(ideModulePrivate.getAttachPathDev());
        newModulePrivate.setAttachVerify(ideModulePrivate.getAttachVerify());
        this.ideModulePrivateRepo.update(newModulePrivate);
    }

    @Override
    public Page<IdeModulePrivate> findUnverifyList(String code, String orgId, String appId, String tenantId, Pageable pageable, String condition) throws BusinessException, Exception {
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)orgId)) {
            Integer pageIndex = pageable.getPageNumber() * pageable.getPageSize();
            Integer pageSize = pageable.getPageSize();
            String orgIdStrs = "";
            List<String> orgIds = this.findChildOrgIds(orgId);
            for (String orgIdStr : orgIds) {
                orgIdStrs = orgIdStrs + orgIdStr + ",";
            }
            orgIdStrs = orgIdStrs.substring(0, orgIdStrs.length() - 1);
            List<IdeModulePrivate> ideModulePrivateList = this.ideModulePrivateRepo.queryUnverifyList(code, orgIdStrs, appId, condition, pageIndex, pageSize);
            Long ideModulePrivateCount = this.ideModulePrivateRepo.queryUnverifyCount(code, orgIdStrs, appId, condition);
            return new PageImpl(ideModulePrivateList, pageable, ideModulePrivateCount.longValue());
        }
        return new PageImpl(new ArrayList(), pageable, 0L);
    }

    @Override
    public void updateAttachVerify(List<String> ids, String modifyId, String modifyName) throws BusinessException {
        if (null == ids || ids.isEmpty()) {
            throw new BusinessException("\u88ab\u5ba1\u6838\u7684\u6570\u636eid\u4e3a\u7a7a\u3002");
        }
        String idStr = "";
        for (String id : ids) {
            idStr = idStr + id + ",";
        }
        idStr = idStr.substring(0, idStr.length() - 1);
        this.ideModulePrivateRepo.updateAttachVerify(modifyId, idStr);
        List<IdeModulePrivate> ideModulePrivateList = this.ideModulePrivateRepo.findByIds(idStr);
        for (IdeModulePrivate item : ideModulePrivateList) {
            IdeModulePrivateVerifyHis his = new IdeModulePrivateVerifyHis();
            his.setId(IdWorker.getId());
            his.setPrivateId(String.valueOf(item.getId()));
            his.setAttachId(item.getAttachIdPro());
            his.setAttachPath(item.getAttachPathPro());
            his.setVerifyName(modifyName);
            his.setCreateId(Long.parseLong(modifyId));
            his.setCreateDate(item.getModifyDate());
            this.ideModulePrivateVerifyHisRepo.save(his);
        }
    }

    @Override
    public Page<IdeModulePrivateVerifyHis> findVerifyHistoryList(String code, String orgId, String appId, String tenantId, Pageable pageable, String condition) throws BusinessException, Exception {
        if (!org.apache.commons.lang.StringUtils.isEmpty((String)orgId)) {
            Integer pageIndex = pageable.getPageNumber() * pageable.getPageSize();
            Integer pageSize = pageable.getPageSize();
            String orgIdStrs = "";
            List<String> orgIds = this.findChildOrgIds(orgId);
            for (String orgIdStr : orgIds) {
                orgIdStrs = orgIdStrs + orgIdStr + ",";
            }
            orgIdStrs = orgIdStrs.substring(0, orgIdStrs.length() - 1);
            List<IdeModulePrivateVerifyHis> modulePrivateVerifyHisList = this.ideModulePrivateRepo.queryVerifyHistoryList(code, orgIdStrs, appId, condition, pageIndex, pageSize);
            Long modulePrivateVerifyHisCount = this.ideModulePrivateRepo.queryVerifyHistoryCount(code, orgIdStrs, appId, condition);
            return new PageImpl(modulePrivateVerifyHisList, pageable, modulePrivateVerifyHisCount.longValue());
        }
        return new PageImpl(new ArrayList(), pageable, 0L);
    }
}

