/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.front.business.ide.service.impl;

import com.ejianc.foundation.front.business.ide.bo.IdeModuleBo;
import com.ejianc.foundation.front.business.ide.bo.IdeTeamBo;
import com.ejianc.foundation.front.business.ide.bo.IdeUserBo;
import com.ejianc.foundation.front.business.ide.entity.IdeTeam;
import com.ejianc.foundation.front.business.ide.entity.IdeTeamUser;
import com.ejianc.foundation.front.business.ide.entity.IdeUser;
import com.ejianc.foundation.front.business.ide.entity.JoinStatus;
import com.ejianc.foundation.front.business.ide.entity.RoleType;
import com.ejianc.foundation.front.business.ide.repository.IdeAppRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeTeamRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeTeamUserRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeUserRepo;
import com.ejianc.foundation.front.business.ide.service.IdeCommonService;
import com.ejianc.foundation.front.business.ide.service.IdeTeamService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@Service
public class IdeTeamServiceImpl
implements IdeTeamService {
    @Autowired
    private IdeAppRepo appRepo;
    @Autowired
    private IdeTeamRepo teamRepo;
    @Autowired
    private IdeTeamUserRepo teamUserRepo;
    @Autowired
    IdeCommonService ideCommonService;
    @Autowired
    private IdeUserRepo userRepo;

    @Override
    @Transactional
    public IdeTeam save(IdeTeam team) {
        if (team.getId() != null && team.getId() > 0L) {
            IdeTeam _team = this.teamRepo.findOne(String.valueOf(team.getId()));
            _team.setName(team.getName());
            _team.setModifyDate(new Date());
            this.teamRepo.update(_team);
        } else {
            team.setId(IdWorker.getId());
            team.setCode(this.ideCommonService.generateTeamCode());
            team.setMemberCount(1);
            team.setCreateDate(new Date());
            this.teamRepo.save(team);
            IdeTeamUser teamUser = new IdeTeamUser();
            teamUser.setId(IdWorker.getId());
            teamUser.setTeamId(team.getId());
            teamUser.setUserId(team.getCreateId());
            teamUser.setJoinStatus(JoinStatus.IN.getValue());
            teamUser.setRoleType(RoleType.SUPER_ADMIN.getValue());
            this.teamUserRepo.save(teamUser);
        }
        return team;
    }

    @Override
    @Transactional
    public IdeTeam updateServerUrls(String id, String serverUrls) {
        IdeTeam team = this.teamRepo.findOne(id);
        team.setServerUrls(serverUrls);
        team.setModifyDate(new Date());
        this.teamRepo.update(team);
        return team;
    }

    @Override
    public IdeTeam findById(String id) {
        return this.teamRepo.findOne(id);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        IdeTeam team = this.teamRepo.findOne(id);
        if (team == null) {
            throw new BusinessException("\u8be5\u56e2\u961f\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664!");
        }
        if (this.appRepo.countApps(id) > 0) {
            throw new BusinessException("\u8be5\u56e2\u961f\u4e0b\u5b58\u5728\u5e94\u7528\uff0c\u4e0d\u80fd\u5220\u9664!");
        }
        if (this.teamRepo.countTeamUsers(id) > 0) {
            throw new BusinessException("\u8be5\u56e2\u961f\u4e0b\u5b58\u5728\u7528\u6237\uff0c\u4e0d\u80fd\u5220\u9664!");
        }
        this.teamRepo.logicDel(String.valueOf(team.getId()));
        this.teamUserRepo.deleteByTeamId(String.valueOf(team.getId()));
    }

    @Override
    public Page<IdeTeamBo> queryForPage(String key, String userId, int prodType, Pageable pageable) {
        Integer pageIndex = pageable.getPageNumber() * pageable.getPageSize();
        Integer pageSize = pageable.getPageSize();
        List<IdeTeamBo> teamBoList = this.teamRepo.queryForPageList(key, prodType, userId, pageIndex, pageSize);
        Long teamBoCount = this.teamRepo.queryForPageCount(key, prodType, userId);
        PageImpl page = new PageImpl(teamBoList, pageable, teamBoCount.longValue());
        return page;
    }

    @Override
    public List<IdeTeamBo> queryUserTeams(String userId, int prodType) {
        List<IdeTeamBo> ideTeamBoList = this.teamRepo.queryUserTeams(userId, prodType);
        return ideTeamBoList;
    }

    @Override
    public List<IdeUserBo> findUsers(String teamId) {
        List<IdeUserBo> ideUserBoList = this.userRepo.findUsers(teamId);
        return ideUserBoList;
    }

    @Override
    @Transactional
    public void applyToJoin(String teamId, String userId) {
        IdeTeamUser teamUser = new IdeTeamUser();
        teamUser.setId(IdWorker.getId());
        teamUser.setTeamId(Long.parseLong(teamId));
        teamUser.setUserId(Long.parseLong(userId));
        teamUser.setJoinStatus(JoinStatus.APPLYING.getValue());
        teamUser.setRoleType(RoleType.MEMBER.getValue());
        this.teamUserRepo.save(teamUser);
    }

    @Override
    @Transactional
    public void agreeToJoin(String teamId, String userId) {
        IdeTeam team = this.teamRepo.findOne(teamId);
        if (team == null) {
            throw new BusinessException(String.format("\u56e2\u961f\u4e0d\u5b58\u5728\uff0c\u56e2\u961fid: %s", teamId));
        }
        IdeTeamUser teamUser = this.teamUserRepo.findByTeamIdAndUserId(teamId, userId);
        if (teamUser == null) {
            throw new BusinessException(String.format("\u56e2\u961f-\u7528\u6237\u5173\u8054\u4e0d\u5b58\u5728\uff0c\u56e2\u961fid: %s\uff0c\u7528\u6237id: %s", teamId, userId));
        }
        teamUser.setJoinStatus(JoinStatus.IN.getValue());
        teamUser.setRoleType(RoleType.MEMBER.getValue());
        this.teamUserRepo.update(teamUser);
        int usersNum = this.teamUserRepo.countUsers(teamId);
        team.setMemberCount(usersNum);
        this.teamRepo.update(team);
    }

    @Override
    @Transactional
    public void refuseToJoin(String teamId, String userId) {
        IdeTeamUser teamUser = this.teamUserRepo.findByTeamIdAndUserId(teamId, userId);
        if (teamUser == null) {
            throw new BusinessException(String.format("\u56e2\u961f-\u7528\u6237\u5173\u8054\u4e0d\u5b58\u5728\uff0c\u56e2\u961fid: %s\uff0c\u7528\u6237id: %s", teamId, userId));
        }
        teamUser.setJoinStatus(JoinStatus.OUT.getValue());
        this.teamUserRepo.update(teamUser);
        IdeTeam team = this.teamRepo.findOne(teamId);
        if (team == null) {
            throw new BusinessException(String.format("\u56e2\u961f\u4e0d\u5b58\u5728\uff0c\u56e2\u961fid: %s", teamId));
        }
        this.teamRepo.update(team);
    }

    @Override
    @Transactional
    public void agreeToJoinByCode(String teamId, String code) {
        IdeTeam team = this.teamRepo.findOne(teamId);
        if (team == null) {
            throw new BusinessException(String.format("\u56e2\u961f\u4e0d\u5b58\u5728\uff0c\u56e2\u961fid: %s", teamId));
        }
        List<IdeUser> users = this.userRepo.selectAccountByCode(code);
        if (CollectionUtils.isEmpty(users)) {
            throw new BusinessException(String.format("\u8d26\u53f7%s\u4e0d\u5b58\u5728", code));
        }
        String userId = users.get(0).getId().toString();
        IdeTeamUser teamUser = this.teamUserRepo.findByTeamIdAndUserId(teamId, userId);
        if (teamUser == null) {
            teamUser = new IdeTeamUser();
            teamUser.setId(IdWorker.getId());
            teamUser.setTeamId(Long.parseLong(teamId));
            teamUser.setUserId(Long.parseLong(userId));
            teamUser.setJoinStatus(JoinStatus.IN.getValue());
            teamUser.setRoleType(RoleType.MEMBER.getValue());
            this.teamUserRepo.save(teamUser);
        } else if (teamUser.getJoinStatus().intValue() != JoinStatus.IN.getValue()) {
            teamUser.setJoinStatus(JoinStatus.IN.getValue());
            teamUser.setRoleType(RoleType.MEMBER.getValue());
            this.teamUserRepo.update(teamUser);
        }
        int usersNum = this.teamUserRepo.countUsers(teamId);
        team.setMemberCount(usersNum);
        this.teamRepo.update(team);
    }

    @Override
    @Transactional
    public void removeUsers(String teamId, String[] userIds) {
        IdeTeam team = this.teamRepo.findOne(teamId);
        if (team == null) {
            throw new BusinessException(String.format("\u56e2\u961f\u4e0d\u5b58\u5728\uff0c\u56e2\u961fid: %s", teamId));
        }
        String userIdStr = "";
        for (String userId : userIds) {
            userIdStr = userIdStr + userId + ",";
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)userIdStr)) {
            userIdStr = userIdStr.substring(0, userIdStr.length() - 1);
            this.teamUserRepo.deleteUsers(teamId, userIdStr);
        }
        int usersNum = this.teamUserRepo.countUsers(teamId);
        team.setMemberCount(usersNum);
        this.teamRepo.update(team);
    }

    @Override
    @Transactional
    public void updateTeamCreator(String teamId, String userId) {
        IdeTeamUser teamUser = this.teamUserRepo.getTeamUser(teamId, userId);
        if (teamUser == null) {
            throw new BusinessException(String.format("\u7528\u6237\u4e0d\u5728\u8be5\u56e2\u961f\u4e2d\uff0c\u7528\u6237id\uff1a%s, \u56e2\u961fid\uff1a%s", userId, teamId));
        }
        if (teamUser.getJoinStatus().intValue() != JoinStatus.IN.getValue()) {
            throw new BusinessException(String.format("\u7528\u6237\u5c1a\u672a\u52a0\u5165\u8be5\u56e2\u961f\uff0c\u7528\u6237id\uff1a%s, \u56e2\u961fid\uff1a%s", userId, teamId));
        }
        IdeTeamUser creator = this.teamUserRepo.getTeamCreator(teamId);
        if (creator != null) {
            creator.setRoleType(RoleType.MEMBER.getValue());
            this.teamUserRepo.update(creator);
        }
        teamUser.setRoleType(RoleType.SUPER_ADMIN.getValue());
        this.teamUserRepo.update(teamUser);
    }

    @Override
    @Transactional
    public void setTeamManagers(String teamId, String[] userIds) {
        List<IdeTeamUser> teamUsers;
        String userIdStr = "";
        for (String userId : userIds) {
            userIdStr = userIdStr + userId + ",";
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)userIdStr)) {
            userIdStr = userIdStr.substring(0, userIdStr.length() - 1);
        }
        if (CollectionUtils.isEmpty(teamUsers = this.teamUserRepo.getTeamUsers(teamId, userIdStr))) {
            throw new BusinessException(String.format("\u7528\u6237\u90fd\u4e0d\u5728\u8be5\u56e2\u961f\u4e2d\uff0c\u7528\u6237ids\uff1a%s\uff0c\u56e2\u961fid\uff1a%s", userIdStr, teamId));
        }
        List notJoinTeamUserIds = teamUsers.stream().filter(teamUser -> teamUser.getJoinStatus().intValue() != JoinStatus.IN.getValue()).map(IdeTeamUser::getUserId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(notJoinTeamUserIds)) {
            throw new BusinessException(String.format("\u5b58\u5728\u7528\u6237\u5c1a\u672a\u52a0\u5165\u8be5\u56e2\u961f\uff0c\u7528\u6237ids\uff1a%s, \u56e2\u961fid\uff1a%s", notJoinTeamUserIds.toString(), teamId));
        }
        for (IdeTeamUser ideTeamUser : teamUsers) {
            ideTeamUser.setRoleType(RoleType.ADMIN.getValue());
            this.teamUserRepo.update(ideTeamUser);
        }
    }

    @Override
    @Transactional
    public void cancelTeamManagers(String teamId, String[] userIds) {
        List<IdeTeamUser> teamUsers;
        String userIdStr = "";
        for (String userId : userIds) {
            userIdStr = userIdStr + userId + ",";
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)userIdStr)) {
            userIdStr = userIdStr.substring(0, userIdStr.length() - 1);
        }
        if (CollectionUtils.isEmpty(teamUsers = this.teamUserRepo.getTeamUsers(teamId, userIdStr))) {
            throw new BusinessException(String.format("\u7528\u6237\u90fd\u4e0d\u5728\u8be5\u56e2\u961f\u4e2d\uff0c\u7528\u6237ids\uff1a%s\uff0c\u56e2\u961fid\uff1a%s", userIdStr, teamId));
        }
        List notJoinTeamUserIds = teamUsers.stream().filter(teamUser -> teamUser.getJoinStatus().intValue() != JoinStatus.IN.getValue()).map(IdeTeamUser::getUserId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(notJoinTeamUserIds)) {
            throw new BusinessException(String.format("\u5b58\u5728\u7528\u6237\u5c1a\u672a\u52a0\u5165\u8be5\u56e2\u961f\uff0c\u7528\u6237ids\uff1a%s, \u56e2\u961fid\uff1a%s", notJoinTeamUserIds.toString(), teamId));
        }
        for (IdeTeamUser ideTeamUser : teamUsers) {
            ideTeamUser.setRoleType(RoleType.MEMBER.getValue());
            this.teamUserRepo.update(ideTeamUser);
        }
    }

    @Override
    public Page<IdeTeamBo> findPage(String searchText, int prodType, boolean isDelete, Pageable pageable) {
        Integer pageIndex = pageable.getPageNumber() * pageable.getPageSize();
        Integer pageSize = pageable.getPageSize();
        List<IdeTeamBo> teamBoList = this.teamRepo.queryTeamList(searchText, prodType, isDelete, pageIndex, pageSize);
        Long teamBoCount = this.teamRepo.queryTeamCount(searchText, prodType, isDelete);
        PageImpl page = new PageImpl(teamBoList, pageable, teamBoCount.longValue());
        return page;
    }

    @Override
    public List<IdeTeam> findTeamByProdType(int prodType) {
        return this.teamRepo.findTeamByProdType(prodType);
    }

    @Override
    public List<IdeModuleBo> searchByAppName(String searchText, int maxCount) {
        if (StringUtils.isEmpty((String)searchText)) {
            return new ArrayList<IdeModuleBo>();
        }
        return this.teamRepo.searchByAppName(searchText, maxCount);
    }

    @Override
    @Transactional
    public void deleteByIds(List<String> ids, boolean isRemove) throws BusinessException, Exception {
        String idStr = "";
        if (ids != null && ids.size() > 0) {
            for (String id : ids) {
                idStr = idStr + id + ",";
            }
            idStr = idStr.substring(0, idStr.length() - 1);
        }
        if (isRemove) {
            this.teamRepo.removeByIds(idStr);
            this.teamUserRepo.deleteUsersByTeamIds(idStr);
        } else {
            List<IdeTeam> teams = this.teamRepo.findByIds(idStr);
            for (IdeTeam team : teams) {
                if (this.appRepo.countApps(String.valueOf(team.getId())) > 0) {
                    throw new BusinessException("\u56e2\u961f[" + team.getName() + "]\u4e0b\u5b58\u5728\u5e94\u7528\uff0c\u4e0d\u80fd\u5220\u9664!");
                }
                if (this.teamRepo.countTeamUsers(String.valueOf(team.getId())) <= 0) continue;
                throw new BusinessException("\u56e2\u961f[" + team.getName() + "]\u4e0b\u5b58\u5728\u7528\u6237\uff0c\u4e0d\u80fd\u5220\u9664!");
            }
            this.teamRepo.deleteByIds(idStr);
        }
    }

    @Override
    @Transactional
    public void recoverByIds(List<String> ids) throws BusinessException, Exception {
        String idStr = "";
        if (ids != null && ids.size() > 0) {
            for (String id : ids) {
                idStr = idStr + id + ",";
            }
            idStr = idStr.substring(0, idStr.length() - 1);
            this.teamRepo.recoverByIds(idStr);
        }
    }

    @Override
    public Page<IdeUserBo> findUsersByTeamId(String searchText, boolean isDelete, String teamId, Pageable pageable) {
        return null;
    }

    @Override
    @Transactional
    public void deleteUsersByTeamId(List<String> ids, String teamId, boolean isRemove) throws BusinessException, Exception {
        String idStr = "";
        if (ids != null && ids.size() > 0) {
            for (String id : ids) {
                idStr = idStr + id + ",";
            }
            idStr = idStr.substring(0, idStr.length() - 1);
        }
        if (isRemove) {
            this.teamUserRepo.deleteUsers(teamId, idStr);
        } else {
            IdeTeam team = this.teamRepo.findOne(teamId);
            if (team == null) {
                throw new BusinessException(String.format("\u56e2\u961f\u4e0d\u5b58\u5728\uff0c\u56e2\u961fid: %s", teamId));
            }
            this.teamUserRepo.deleteUsersByTeamId(teamId, idStr);
            int usersNum = this.teamUserRepo.countUsers(teamId);
            team.setMemberCount(usersNum);
            this.teamRepo.update(team);
        }
    }

    @Override
    @Transactional
    public void recoverUsersByIds(List<String> ids, String teamId) throws BusinessException, Exception {
        IdeTeam team = this.teamRepo.findOne(teamId);
        if (team == null) {
            throw new BusinessException(String.format("\u56e2\u961f\u4e0d\u5b58\u5728\uff0c\u56e2\u961fid: %s", teamId));
        }
        String idStr = "";
        if (ids != null && ids.size() > 0) {
            for (String id : ids) {
                idStr = idStr + id + ",";
            }
            idStr = idStr.substring(0, idStr.length() - 1);
            this.teamUserRepo.recoverUsers(teamId, idStr);
        }
        int usersNum = this.teamUserRepo.countUsers(teamId);
        team.setMemberCount(usersNum);
        this.teamRepo.update(team);
    }
}

