/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.front.business.ide.service.impl;

import com.ejianc.foundation.front.business.ide.bo.IdeUiDefineBO;
import com.ejianc.foundation.front.business.ide.entity.IdeUiDefine;
import com.ejianc.foundation.front.business.ide.repository.IdeUiDefineRepo;
import com.ejianc.foundation.front.business.ide.service.IdeUiDefineService;
import com.ejianc.framework.core.exception.BusinessException;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Transactional
@Service
public class IdeUiDefineServiceImpl
implements IdeUiDefineService {
    @Autowired
    private IdeUiDefineRepo ideUiDefineRepo;

    @Override
    public List<IdeUiDefine> findList(String searchText) throws BusinessException, Exception {
        List<IdeUiDefine> ideUiDefines = this.ideUiDefineRepo.findBySearchText(searchText);
        return ideUiDefines;
    }

    @Override
    public IdeUiDefine saveOrUpdate(IdeUiDefine ideUiDefine) throws BusinessException, Exception {
        IdeUiDefine entity = this.ideUiDefineRepo.findById(String.valueOf(ideUiDefine.getId()));
        if (entity == null) {
            IdeUiDefine uiDefine = this.ideUiDefineRepo.findByCode(ideUiDefine.getCode());
            if (uiDefine != null) {
                throw new BusinessException("\u8be5\u7ec4\u4ef6\u7f16\u7801\u5df2\u5b58\u5728\uff01");
            }
            ideUiDefine.setCreateDate(new Date());
            return this.ideUiDefineRepo.save(ideUiDefine);
        }
        IdeUiDefine uiDefine = this.ideUiDefineRepo.findByCode(ideUiDefine.getCode());
        if (uiDefine != null && !uiDefine.getCode().equals(ideUiDefine.getCode())) {
            throw new BusinessException("\u8be5\u7ec4\u4ef6\u7f16\u7801\u5df2\u5b58\u5728\uff01");
        }
        entity.setCode(ideUiDefine.getCode());
        entity.setParser(ideUiDefine.getParser());
        entity.setName(ideUiDefine.getName());
        entity.setDefaults(ideUiDefine.getDefaults());
        entity.setIcon(ideUiDefine.getIcon());
        entity.setIncludeType(ideUiDefine.getIncludeType());
        entity.setIncludeContents(ideUiDefine.getIncludeContents());
        entity.setModifyDate(new Date());
        return this.ideUiDefineRepo.update(entity);
    }

    @Override
    public IdeUiDefineBO findByCode(String code) throws BusinessException, Exception {
        IdeUiDefine uiDefine = this.ideUiDefineRepo.findByCode(code);
        if (uiDefine != null) {
            IdeUiDefineBO bo = new IdeUiDefineBO();
            bo.setId(String.valueOf(uiDefine.getId()));
            bo.setCode(uiDefine.getCode());
            bo.setDefaults(uiDefine.getDefaults());
            bo.setIcon(uiDefine.getIcon());
            bo.setIncludeContents(uiDefine.getIncludeContents());
            bo.setIncludeType(uiDefine.getIncludeType());
            bo.setName(uiDefine.getName());
            bo.setParser(uiDefine.getParser());
            List<IdeUiDefine> allData = this.ideUiDefineRepo.findAllData();
            if (!StringUtils.isEmpty((Object)uiDefine.getIncludeContents())) {
                String[] codes = uiDefine.getIncludeContents().split(",");
                StringBuffer codeBuffer = new StringBuffer("'");
                for (String codeString : codes) {
                    codeBuffer.append(codeString).append("','");
                }
                List<IdeUiDefine> rightData = this.ideUiDefineRepo.findByCodes(codeBuffer.substring(0, codeBuffer.length() - 2));
                allData.removeAll(rightData);
                bo.setLeftData(allData);
                bo.setRightData(rightData);
            } else {
                bo.setLeftData(allData);
            }
            return bo;
        }
        return null;
    }

    @Override
    public void deleteByIds(List<String> ids) throws BusinessException, Exception {
        if (ids != null && ids.size() > 0) {
            StringBuffer idStr = new StringBuffer("'");
            for (String id : ids) {
                idStr.append(id).append("','");
            }
            this.ideUiDefineRepo.deleteByIds(idStr.toString().substring(0, idStr.length() - 2));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(String id) {
        this.ideUiDefineRepo.deleteByIds(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByFolderId(String folderId) {
        List<IdeUiDefine> defines = this.ideUiDefineRepo.findByFolderId(folderId);
        defines.forEach(define -> this.delete(String.valueOf(define.getId())));
    }

    @Override
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public List<IdeUiDefineBO> findByFolderId(String folderId, String searchText) {
        List<IdeUiDefine> defines = StringUtils.isEmpty((Object)searchText) ? this.ideUiDefineRepo.findByFolderId(folderId) : this.ideUiDefineRepo.findByFolderIdAndSearchText(folderId, searchText);
        return defines.stream().map(item -> {
            IdeUiDefineBO define = new IdeUiDefineBO();
            BeanUtils.copyProperties((Object)item, (Object)define);
            return define;
        }).collect(Collectors.toList());
    }
}

