/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.front.business.ide.service.impl;

import com.ejianc.foundation.front.business.ide.bo.IdeUiDefineBO;
import com.ejianc.foundation.front.business.ide.bo.IdeUiFolderBO;
import com.ejianc.foundation.front.business.ide.entity.IdeUiFolder;
import com.ejianc.foundation.front.business.ide.repository.IdeUiFolderRepo;
import com.ejianc.foundation.front.business.ide.service.IdeUiDefineService;
import com.ejianc.foundation.front.business.ide.service.IdeUiFolderService;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class IdeUiFolderServiceImpl
implements IdeUiFolderService {
    @Autowired
    private IdeUiFolderRepo repo;
    @Autowired
    private IdeUiDefineService defineService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String create(IdeUiFolderBO folder) {
        IdeUiFolder entity = new IdeUiFolder();
        entity.setLibraryId(Long.parseLong(folder.getLibraryId()));
        entity.setName(folder.getName());
        if (StringUtils.isEmpty((Object)folder.getParentId())) {
            entity.setIsRoot(true);
        }
        entity.setParentId(Long.parseLong(folder.getParentId()));
        this.repo.save(entity);
        return entity.getId().toString();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(IdeUiFolderBO folder) {
        IdeUiFolder entity = this.repo.findOne(folder.getId());
        entity.setName(folder.getName());
        this.repo.update(entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(String id) {
        this.deleteParent(id);
    }

    private void deleteParent(String parentId) {
        List<IdeUiFolder> children = this.repo.findByParentId(parentId);
        if (!CollectionUtils.isEmpty(children)) {
            children.forEach(child -> this.deleteParent(child.getId().toString()));
        }
        this.repo.delete(parentId);
        this.defineService.deleteByFolderId(parentId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByLibraryId(String libraryId) {
        List<IdeUiFolder> folders = this.repo.findByLibraryIdAndIsRootTrue(libraryId);
        folders.forEach(folder -> this.delete(folder.getId().toString()));
    }

    @Override
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public IdeUiFolderBO queryDetail(String id, String searchText) {
        IdeUiFolder entity = this.repo.findOne(id);
        if (entity == null) {
            return null;
        }
        IdeUiFolderBO vo = new IdeUiFolderBO();
        BeanUtils.copyProperties((Object)entity, (Object)vo);
        this.setDetails(vo, vo, true, searchText);
        return vo;
    }

    @Override
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public List<IdeUiFolderBO> findByLibraryId(String libraryId, String searchText) {
        return this.repo.findByLibraryIdAndIsRootTrue(libraryId).stream().map(item -> {
            IdeUiFolderBO vo = new IdeUiFolderBO();
            BeanUtils.copyProperties((Object)item, (Object)vo);
            this.setDetails(vo, vo, true, searchText);
            return vo;
        }).collect(Collectors.toList());
    }

    private void setDetails(IdeUiFolderBO root, IdeUiFolderBO parent, boolean containsDefine, String searchText) {
        List<IdeUiFolder> children;
        if (containsDefine && CollectionUtils.isEmpty(root.getDefines())) {
            root.setDefines(Optional.ofNullable(this.defineService.findByFolderId(root.getId(), searchText)).orElse(new ArrayList()));
        }
        if (!CollectionUtils.isEmpty(children = this.repo.findByParentId(parent.getId()))) {
            parent.setChildren(children.stream().map(item -> {
                IdeUiFolderBO vo = new IdeUiFolderBO();
                BeanUtils.copyProperties((Object)item, (Object)vo);
                if (containsDefine) {
                    List<IdeUiDefineBO> defines = root.getDefines();
                    defines.addAll(this.defineService.findByFolderId(item.getId().toString(), searchText));
                    root.setDefines(defines);
                }
                this.setDetails(root, vo, containsDefine, searchText);
                return vo;
            }).collect(Collectors.toList()));
        }
    }

    @Override
    public List<IdeUiFolderBO> findLibraryFolders(String libraryId) {
        return this.repo.findByLibraryIdAndIsRootTrue(libraryId).stream().map(item -> {
            IdeUiFolderBO vo = new IdeUiFolderBO();
            BeanUtils.copyProperties((Object)item, (Object)vo);
            this.setDetails(vo, vo, false, null);
            return vo;
        }).collect(Collectors.toList());
    }
}

