/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.front.business.ide.utils;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xssf.extractor.XSSFEventBasedExcelExtractor;
import org.apache.poi.xwpf.extractor.XWPFWordExtractor;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.xmlbeans.XmlException;

public class PageParser {
    private static final String LABEL = "label";
    private static final String TYPE = "type";
    private static final String PATTERN_PREFIX = "\\$[TF]?(\\.[a-zA-Z]+)?\\{(.*?)}@";
    private static final Map<String, String> typeMap = new HashMap<String, String>();

    public static Map<String, Map<String, List<Map<String, String>>>> parse(InputStream is, FileType fileType) {
        String fileText = null;
        try {
            switch (fileType) {
                case WORD: {
                    fileText = new XWPFWordExtractor(new XWPFDocument(is)).getText();
                    break;
                }
                case EXCEL: {
                    fileText = new XSSFEventBasedExcelExtractor(OPCPackage.open((InputStream)is)).getText();
                    break;
                }
            }
        }
        catch (IOException | OpenXML4JException | XmlException e) {
            throw new BusinessException("\u89e3\u6790\u6587\u4ef6\u5185\u5bb9\u5f02\u5e38");
        }
        String content = fileText;
        HashMap forms = new HashMap();
        HashMap tables = new HashMap();
        typeMap.keySet().forEach(key -> {
            Pattern pattern = Pattern.compile("\\$[TF]?(\\.[a-zA-Z]+)?\\{(.*?)}@(" + key + ")");
            Matcher matcher = pattern.matcher(content);
            while (matcher.find()) {
                String itemKey;
                String text = matcher.group(0);
                String label = matcher.group(2);
                String type = typeMap.get(matcher.group(3));
                HashMap<String, String> item = new HashMap<String, String>();
                item.put(LABEL, label);
                item.put(TYPE, type);
                if (text.startsWith("${") || text.startsWith("$F{")) {
                    List formItems = forms.getOrDefault("default", new ArrayList());
                    formItems.add(item);
                    forms.put("default", formItems);
                    continue;
                }
                if (text.startsWith("$T{")) {
                    List tableItems = tables.getOrDefault("default", new ArrayList());
                    tableItems.add(item);
                    tables.put("default", tableItems);
                    continue;
                }
                if (text.startsWith("$F.")) {
                    itemKey = matcher.group(1).substring(1);
                    List formItems = forms.getOrDefault(itemKey, new ArrayList());
                    formItems.add(item);
                    forms.put(itemKey, formItems);
                    continue;
                }
                if (!text.startsWith("$T.")) continue;
                itemKey = matcher.group(1).substring(1);
                List tableItems = tables.getOrDefault(itemKey, new ArrayList());
                tableItems.add(item);
                tables.put(itemKey, tableItems);
            }
        });
        HashMap<String, Map<String, List<Map<String, String>>>> result = new HashMap<String, Map<String, List<Map<String, String>>>>();
        result.put("forms", forms);
        result.put("tables", tables);
        return result;
    }

    public static Map<String, Object> parse(InputStream is, FileType fileType, Function<Map<String, Map<String, List<Map<String, String>>>>, Map<String, Object>> function) {
        return function.apply(PageParser.parse(is, fileType));
    }

    public static Map<String, Object> basicParse(InputStream is, FileType fileType) {
        HashMap<String, Integer> labelCol = new HashMap<String, Integer>();
        labelCol.put("span", 9);
        HashMap<String, Integer> wrapperCol = new HashMap<String, Integer>();
        wrapperCol.put("span", 15);
        return PageParser.parse(is, fileType, result -> {
            ArrayList cardChildren = new ArrayList();
            ((Map)result.getOrDefault("forms", new HashMap())).forEach((key, value) -> {
                HashMap<String, Object> form = new HashMap<String, Object>();
                form.put("nid", "nid_" + IdWorker.getId());
                form.put("uikey", "form:" + key);
                form.put("uitype", "FormWidget");
                form.put("uititle", "\u8868\u5355:" + key);
                form.put("labelCol", labelCol);
                form.put("wrapperCol", wrapperCol);
                form.put("colnumber", 3);
                form.put("children", value.stream().map(item -> {
                    HashMap<String, Object> formItem = new HashMap<String, Object>();
                    formItem.put("nid", "nid_" + IdWorker.getId());
                    formItem.put("uitype", "FormItemWidget");
                    formItem.put("uisubtype", item.get(TYPE));
                    formItem.put("uititle", item.get(LABEL));
                    formItem.put(LABEL, item.get(LABEL));
                    formItem.put("labelCol", labelCol);
                    formItem.put("wrapperCol", wrapperCol);
                    return formItem;
                }).collect(Collectors.toList()));
                HashMap<String, Object> cardChild = new HashMap<String, Object>();
                cardChild.put("nid", "nid_" + IdWorker.getId());
                cardChild.put("uikey", "card:" + key);
                cardChild.put("uitype", "YYAccordion");
                cardChild.put("uititle", key);
                cardChild.put("header", key);
                cardChild.put("isOpen", true);
                cardChild.put("enableStepTarget", true);
                cardChild.put("children", Collections.singletonList(form));
                cardChildren.add(cardChild);
            });
            HashMap<String, Object> pageChild = new HashMap<String, Object>();
            pageChild.put("nid", "ncardaccordions");
            pageChild.put("uikey", "CPCardBody");
            pageChild.put("uitype", "CPCardBody");
            pageChild.put("uititle", "\u591a\u5361\u7247");
            pageChild.put("header", "\u591a\u5361\u7247");
            pageChild.put("children", cardChildren);
            HashMap<String, Object> pageContent = new HashMap<String, Object>();
            pageContent.put("nid", "ncardpage");
            pageContent.put("uikey", "CPCardPage");
            pageContent.put("uitype", "CPCardPage");
            pageContent.put("uititle", "\u5361\u7247\u9875");
            pageContent.put("children", Collections.singletonList(pageChild));
            return pageContent;
        });
    }

    public static void main(String[] args) throws IOException {
        System.out.println(JSONObject.toJSONString(PageParser.parse(new FileInputStream("E:\\yonyou\\\u5408\u540c\u6a21\u677f.docx"), FileType.WORD)));
        System.out.println(JSONObject.toJSONString(PageParser.parse(new FileInputStream("E:\\yonyou\\\u4e0a\u7ebf\u7533\u8bf7\u5355.xlsx"), FileType.EXCEL)));
        System.out.println(JSONObject.toJSONString(PageParser.basicParse(new FileInputStream("E:\\yonyou\\\u5408\u540c\u6a21\u677f.docx"), FileType.WORD), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
    }

    static {
        typeMap.put("text", "input");
        typeMap.put("textarea", "textarea");
        typeMap.put("date", "date");
        typeMap.put("time", "time");
        typeMap.put("number", "number");
        typeMap.put("refer", "inputrefer");
        typeMap.put("switch", "switch");
        typeMap.put("enumselect", "enumselect");
        typeMap.put("currency", "currency");
        typeMap.put("attach", "attachupload");
        typeMap.put("radio", "radiogroup");
        typeMap.put("checkbox", "checkboxgroup");
    }

    public static enum FileType {
        WORD,
        EXCEL;

    }
}

