package com.ejianc.foundation.front.business.ide.bo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ejianc.foundation.front.business.ide.entity.IdeApp;
import com.ejianc.foundation.front.business.ide.entity.IdeModule;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

public class IdeAppBo implements Serializable {
	private static final long serialVersionUID = -7666701915044161164L;
	
	private String id;
	private String code;
	private String name;
	private Integer isOpen;
	private String resourceData; // 资源数据
	private List<IdeModule> children;
	private String teamId;// 关联团队
	private String groupId;// 关联模块
	private String createId; // 创建人
	private Date createDate; // 创建时间
	private String modifyId; // 最后修改人
	private Date modifyDate; // 最后修改时间
	private Boolean isDelete = false; // 是否激活（逻辑删除）
	private String billTypeCode;
	private String billTypeName;
    private String productId;//关联项目
    private String moduleId;//关联模块
    private Integer presentType=1;//显示端：1-桌面端PC、2-移动端Mobile

	public IdeAppBo() {
	}

	public IdeAppBo(IdeApp ideApp) {
		if (ideApp == null)
			return;
		this.id = ideApp.getId() + "";
		this.code = ideApp.getCode();
		this.name = ideApp.getName();
		this.isOpen = ideApp.getIsOpen();
		this.resourceData = ideApp.getResourceData();
		this.children = ideApp.getChildren();
		this.teamId = ideApp.getTeamId() + "";
		this.groupId = ideApp.getGroupId() + "";
		this.createId = ideApp.getCreateId() + "";
		this.createDate = ideApp.getCreateDate();
		this.modifyId = ideApp.getModifyId() + "";
		this.modifyDate = ideApp.getModifyDate();
		this.isDelete = ideApp.getIsDelete() == 1;
		this.billTypeCode = ideApp.getBillTypeCode();
		this.billTypeName = ideApp.getBillTypeName();
		this.productId = ideApp.getProductId() + "";
		this.moduleId = ideApp.getModuleId() + "";
		this.presentType = ideApp.getPresentType();
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getResourceData() {
		return resourceData;
	}

	public void setResourceData(String resourceData) {
		this.resourceData = resourceData;
	}

	public Integer getIsOpen() {
		return isOpen;
	}

	public void setIsOpen(Integer isOpen) {
		this.isOpen = isOpen;
	}

	public List<IdeModule> getChildren() {
		return children;
	}

	public void setChildren(List<IdeModule> children) {
		this.children = children;
	}

	public Date getCreateDate() {
		return createDate;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}

	public String getCreateId() {
		return createId;
	}

	public void setCreateId(String createId) {
		this.createId = createId;
	}

	public String getModifyId() {
		return modifyId;
	}

	public void setModifyId(String modifyId) {
		this.modifyId = modifyId;
	}

	public Date getModifyDate() {
		return modifyDate;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	public void setModifyDate(Date modifyDate) {
		this.modifyDate = modifyDate;
	}

	public boolean getIsDelete() {
		return isDelete;
	}

	public void setIsDelete(boolean isDelete) {
		this.isDelete = isDelete;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getTeamId() {
		return teamId;
	}

	public void setTeamId(String teamId) {
		this.teamId = teamId;
	}

	public String getGroupId() {
		return groupId;
	}

	public void setGroupId(String groupId) {
		this.groupId = groupId;
	}

	public String getBillTypeCode() {
		return billTypeCode;
	}

	public void setBillTypeCode(String billTypeCode) {
		this.billTypeCode = billTypeCode;
	}

	public String getBillTypeName() {
		return billTypeName;
	}

	public void setBillTypeName(String billTypeName) {
		this.billTypeName = billTypeName;
	}

	public String getProductId() {
		return productId;
	}

	public void setProductId(String productId) {
		this.productId = productId;
	}

	public String getModuleId() {
		return moduleId;
	}

	public void setModuleId(String moduleId) {
		this.moduleId = moduleId;
	}

	public Integer getPresentType() {
		return presentType;
	}

	public void setPresentType(Integer presentType) {
		this.presentType = presentType;
	}

}
