package com.ejianc.foundation.front.business.ide.controller;

import java.io.IOException;
import java.util.Date;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.foundation.front.business.ide.bo.IdeAccountBo;
import com.ejianc.foundation.front.business.ide.entity.IdeUser;
import com.ejianc.foundation.front.business.ide.service.IdeAccountService;
import com.ejianc.foundation.front.common.qqconnect.QQUserInfo;
import com.ejianc.foundation.front.common.qqconnect.QQUserInfoBean;
import com.ejianc.foundation.front.util.JsonBackData;
import com.qq.connect.QQConnectException;
import com.qq.connect.api.OpenID;
import com.qq.connect.javabeans.AccessToken;
import com.qq.connect.oauth.Oauth;

/**
 * 账号相关交互服务
 * 
 * @author Dio
 */
@Controller
@RequestMapping("ide/account/*")
public class IdeAccountController {
	@Autowired
	private IdeAccountService accountService;

	/**
	 * 注册账号
	 * 
	 * @param account
	 * @param password
	 * @return
	 */
	@ResponseBody
	@RequestMapping(value = "reg", method = RequestMethod.POST)
	public JsonBackData regAccount(HttpServletRequest request,
			@RequestParam(required = true, value = "userName", defaultValue = "") String userName,
			@RequestParam(required = true, value = "userPwd", defaultValue = "") String userPwd) {
		try {
			IdeUser user = accountService.regAccount(userName, userPwd);
			if (user != null) {
				return JsonBackData.toSuccess("注册成功");
			} else {
				return JsonBackData.toError("注册失败");
			}
		} catch (Exception e) {
			return JsonBackData.toError(e.getMessage());
		}
	}

	/**
	 * 登录账号
	 * 
	 * @param account
	 * @param password
	 * @return
	 */
	@ResponseBody
	@RequestMapping(value = "login", method = RequestMethod.POST)
	public JsonBackData loginAccount(HttpServletRequest request,
			@RequestParam(required = true, value = "userName", defaultValue = "") String userName,
			@RequestParam(required = true, value = "userPwd", defaultValue = "") String userPwd,
			@RequestParam(required = false, value = "md5", defaultValue = "false") boolean md5) {
		JsonBackData backData = execLogin(request, userName, userPwd, md5);
		return backData;
	}

	/**
	 * 执行账号登录
	 * 
	 * @param code
	 * @param password
	 * @param md5
	 *            指明password是否为md5加密的密码
	 * @return
	 */
	private JsonBackData execLogin(HttpServletRequest request, String code, String password, boolean md5) {
		boolean result = md5 ? accountService.loginAccountMd5(code, password)
				: accountService.loginAccount(code, password);
		if (result) {
			IdeUser bean = accountService.findUserByCode(code);
			if (bean != null) {
				IdeAccountBo currUser = new IdeAccountBo(bean);
				if (!md5) {
					currUser.setPassword(password);// 设置明码
				}
				// 保存当前登录用户到Session
				accountService.setCurrUser(request, currUser);
				return JsonBackData.toSuccess("登录成功", currUser);
			} else {
				return JsonBackData.toError("账号[" + code + "]不存在！");
			}
		} else {
			return JsonBackData.toError("请检查您的账号和密码是否输入正确！");
		}
	}

	/**
	 * 退出账号
	 * 
	 * @return
	 */
	@ResponseBody
	@RequestMapping(value = "logout", method = RequestMethod.POST)
	public JsonBackData logoutAccount(HttpServletRequest request) {
		accountService.clearCurrUser(request);
		return JsonBackData.toSuccess();
	}

	/**
	 * 修改当前用户密码
	 * 
	 * @param account
	 * @param password
	 * @param newPassword
	 * @return
	 */
	@ResponseBody
	@RequestMapping(value = "pwdChange", method = RequestMethod.POST)
	public JsonBackData passwordChange(HttpServletRequest request,
			@RequestParam(required = true, value = "password", defaultValue = "") String password,
			@RequestParam(required = true, value = "newPassword", defaultValue = "") String newPassword,
			@RequestParam(required = true, value = "account", defaultValue = "") String account) {
		IdeAccountBo acc = accountService.getCurrUser(request);
		if (acc == null) {
			return JsonBackData.toError("当前账号已失效请重新登录");
		}
		String result = accountService.changePassword(account, password, newPassword);
		if ("success".equals(result)) {
			return JsonBackData.toSuccess();
		} else {
			return JsonBackData.toError(result);
		}
	}

	/**
	 * 快捷直接登录
	 * 
	 * @param account
	 * @param passwordMd5
	 * @return
	 */
	@RequestMapping(value = "quicklogin", method = RequestMethod.POST)
	public JsonBackData quickLogin(HttpServletRequest request,
			@RequestParam(required = true, value = "userName", defaultValue = "") String account,
			@RequestParam(required = true, value = "userPwd", defaultValue = "") String passwordMd5) {
		JsonBackData backData = execLogin(request, account, passwordMd5, true);
		return backData;
	}

	/**
	 * 获取当前登录用户的信息
	 * 
	 * @return
	 */
	@ResponseBody
	@RequestMapping(value = "curruser", method = RequestMethod.GET)
	public IdeAccountBo getCurrUserInfo(HttpServletRequest request) {
		IdeAccountBo currUser = accountService.getCurrUser(request);
		return currUser;
	}

	/**
	 * QQ登录授权前
	 * 
	 * @param request
	 * @param response
	 */
	@RequestMapping("qqlogin")
	public void qqLoginAuthorize(HttpServletRequest request, HttpServletResponse response) {
		try {
			response.sendRedirect(new Oauth().getAuthorizeURL(request));
		} catch (IOException e) {
			e.printStackTrace();
		} catch (QQConnectException e) {
			e.printStackTrace();
		}
	}

	/**
	 * QQ登录授权后的回调
	 * 
	 * @return
	 */
	@RequestMapping("qqtoken")
	public String qqLoginToken(HttpServletRequest request) {
		// System.out.println("---------------qqLoginToken------------------");
		try {
			String accessToken = null;
			String openID = null;
			// long tokenExpireIn = 0L;
			// 登录后
			AccessToken accessTokenObj = (new Oauth()).getAccessTokenByRequest(request);
			if (accessTokenObj.getAccessToken().equals("")) {
				// 我们的网站被CSRF攻击了或者用户取消了授权，跳转回主界面
				System.out.println("获取accessToken为空");
			} else {
				accessToken = accessTokenObj.getAccessToken();
				// tokenExpireIn = accessTokenObj.getExpireIn();
				// System.out.println("获取accessToken="+accessToken);
				// System.out.println("获取tokenExpireIn="+tokenExpireIn);
				// 利用获取到的accessToken 去获取当前用的openid
				OpenID openIDObj = new OpenID(accessToken);
				openID = openIDObj.getUserOpenID();
				// System.out.println("获取openID="+openID);
				// 查找用户qq_open_id
				IdeUser user = accountService.findByQQOpenId(openID);
				if (user == null) {// 用户第一次登录
					// 获取QQ用户信息
					QQUserInfo qzoneUserInfo = new QQUserInfo(accessToken, openID);
					QQUserInfoBean userInfoBean = qzoneUserInfo.getQQUserInfo();
					if (userInfoBean.getRet() == 0) {
						String nickName = userInfoBean.getNickname();
						int sex = userInfoBean.getSex();
						String avatarUrl = StringUtils.isBlank(userInfoBean.getQqAvatarURL100())
								? (StringUtils.isBlank(userInfoBean.getAvatar().getAvatarURL100())
										? userInfoBean.getQqAvatarURL40() : userInfoBean.getAvatar().getAvatarURL100())
								: userInfoBean.getQqAvatarURL100();
						// System.out.println("获取QQ信息：昵称["+nickName+"],性别["+sex+"-"+userInfoBean.getGender()+"],头像["+avatarUrl+"]");
						// 自注册，生成账号信息
						user = accountService.generateNewAccountByQQ(accessToken, openID, nickName, sex, avatarUrl);
					} else {
						String errorMsg = "很抱歉，我们没能正确获取到您的信息，原因是： " + userInfoBean.getMsg();
						System.out.println(QQUserInfo.QQ_CONNECT_ERROR + "--->" + errorMsg);
						request.setAttribute(QQUserInfo.QQ_CONNECT_ERROR, errorMsg);
					}
				}
				if (user != null) {
					// 更新最后一次登录的时间
					user.setLoginDate(new Date());
					// 保存用户信息
					accountService.saveOrUpdate(user);
					IdeAccountBo currUser = new IdeAccountBo(user);
					// 保存当前登录用户到Session
					accountService.setCurrUser(request, currUser);
				}
			}
		} catch (QQConnectException e) {
			String errorMsg = "QQ登录授权失败";
			System.out.println(QQUserInfo.QQ_CONNECT_ERROR + "--->" + errorMsg);
			request.setAttribute(QQUserInfo.QQ_CONNECT_ERROR, errorMsg);
		} catch (Exception e) {
			request.setAttribute(QQUserInfo.QQ_CONNECT_ERROR, e.getMessage());
		}
		// QQ登录成功后，重定向到主页
		// return redirectTo("/index");
		return null;
	}

	// 修改个人信息接口
	@RequestMapping(value = "userChange", method = RequestMethod.POST)
	@ResponseBody
	public JsonBackData userChange(@RequestBody IdeUser user) {
		JsonBackData jsonBackData = new JsonBackData();
		IdeUser user2 = accountService.userUpdate(user);
		if (user2 != null) {
			jsonBackData.setBackData(user2);
			jsonBackData.setSuccess(true);
		} else {
			jsonBackData.setSuccess(false);
			jsonBackData.setBackMsg("找不到账号！");
		}
		return jsonBackData;
	}

	// 修改个人信息接口
	@ResponseBody
	@RequestMapping(value = "findUserByCode")
	public JsonBackData findUserByCode(@RequestParam String code) {
		JsonBackData jsonBackData = new JsonBackData();
		IdeUser user2 = accountService.findUserByCode(code);
		if (user2 != null) {
			jsonBackData.setBackData(user2);
			jsonBackData.setSuccess(true);
		} else {
			jsonBackData.setSuccess(false);
			jsonBackData.setBackMsg("找不到账号！");
		}
		return jsonBackData;
	}
}
