package com.ejianc.foundation.front.business.ide.service;

import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.front.business.ide.entity.IdeOnline;
import com.ejianc.foundation.front.business.ide.entity.IdeRelease;
import com.ejianc.foundation.front.business.ide.entity.IdeReleasePage;

/**
 * 版本管理service
 */
public interface IdeReleaseService {

    /**
     * 发版
     * @param appId 应用id
     * @param version 版本号
     * @param pageIds 页面ids
     */
    void release(String appId, String version, List<String> pageIds,String releaseGroupId);
    
    /**
     * 发版
     * @param appId 应用id 
     * @param version 版本号
     * @param pageIds 页面ids
     */
    void releaseAppIds(Map<String, Object> appList,String version);

    /**
     * 查看应用下所有发版
     * @param appId 应用id
     * @return 应用下所有发版
     */
    List<IdeRelease> findReleases(String appId);

    /**
     * 查看某版本下所有页面
     * @param releaseId 发版id
     * @return 所有页面
     */
    List<IdeReleasePage> findReleasePages(String releaseGroupId);

    /**
     * 上线
     * @param releaseGroupId 发版id
     * @param envUrl     环境地址
     */
    void online(String releaseGroupId, String envUrl);

    /**
     * 上线
     * @param releaseGroupId 发版id
     */
    JSONObject getOnlineText(String releaseGroupId);

    /**
     * 查找上线历史
     *
     * @param appId 应用id
     * @return 各环境上线历史记录
     */
    Map<String, List<IdeOnline>> viewOnlineHistory(String appId);
    
    /**
     * 删除版本
     * @param releaseGroupId 发版分组id
     */
    void deleteVersion(String releaseGroupId);
}
