/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.front.business.ide.service.impl;

import com.ejianc.foundation.front.business.ide.bo.IdeUiDefineBO;
import com.ejianc.foundation.front.business.ide.bo.IdeUiFolderBO;
import com.ejianc.foundation.front.business.ide.bo.IdeUiLibraryBO;
import com.ejianc.foundation.front.business.ide.entity.IdeUiLibrary;
import com.ejianc.foundation.front.business.ide.repository.IdeUiLibraryRepo;
import com.ejianc.foundation.front.business.ide.service.IdeUiFolderService;
import com.ejianc.foundation.front.business.ide.service.IdeUiLibraryService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class IdeUiLibraryServiceImpl
implements IdeUiLibraryService {
    @Autowired
    private IdeUiLibraryRepo repo;
    @Autowired
    private IdeUiFolderService folderService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String create(IdeUiLibraryBO library) {
        IdeUiLibrary entity = new IdeUiLibrary();
        entity.setName(library.getName());
        this.repo.save(entity);
        return entity.getId().toString();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(IdeUiLibraryBO library) {
        IdeUiLibrary entity = this.repo.findOne(library.getId());
        entity.setName(library.getName());
        this.repo.save(entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(String id) {
        this.repo.delete(id);
        this.folderService.deleteByLibraryId(id);
    }

    @Override
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public List<IdeUiLibraryBO> queryList() {
        List<IdeUiLibrary> entities = this.repo.findAll();
        return entities.stream().map(item -> {
            IdeUiLibraryBO vo = new IdeUiLibraryBO();
            BeanUtils.copyProperties((Object)item, (Object)vo);
            vo.setFolders(this.folderService.findLibraryFolders(String.valueOf(item.getId())));
            return vo;
        }).collect(Collectors.toList());
    }

    @Override
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public IdeUiLibraryBO queryDetail(String id, String searchText) {
        IdeUiLibrary entity = this.repo.findOne(id);
        if (entity == null) {
            return null;
        }
        IdeUiLibraryBO vo = new IdeUiLibraryBO();
        BeanUtils.copyProperties((Object)entity, (Object)vo);
        List<IdeUiFolderBO> folders = this.folderService.findByLibraryId(id, searchText);
        ArrayList<IdeUiDefineBO> defines = new ArrayList<IdeUiDefineBO>();
        if (!CollectionUtils.isEmpty(folders)) {
            folders.forEach(item -> {
                defines.addAll(item.getDefines());
                item.setDefines(null);
            });
        }
        vo.setFolders(folders);
        vo.setDefines(defines);
        return vo;
    }
}

