package com.ejianc.foundation.front.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.front.api.bean.ApiEntity;
import com.ejianc.foundation.front.api.service.IApiService;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.*;

/**
 * 前端组件 API
 *
 * @author wxp
 *
 */
@Controller
@RequestMapping("api")
public class ApiController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IApiService service;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ApiEntity> saveOrUpdate(@RequestBody ApiEntity entity) {
        setNull(entity);
        QueryParam param = new QueryParam();
        param.getParams().put("uitype",new Parameter(QueryParam.EQ,entity.getUitype()));
        param.getParams().put("uisubtype",new Parameter(QueryParam.EQ,entity.getUisubtype()));
        param.getParams().put("method",new Parameter(QueryParam.EQ,entity.getMethod()));
        param.getParams().put("type",new Parameter(QueryParam.EQ,entity.getType()));
        param.getParams().put("id",new Parameter(QueryParam.NE,entity.getId()));
        List<ApiEntity> list = service.queryList(param);
        if(ListUtil.isNotEmpty(list)){
            return CommonResponse.error("该API已存在！");
        }
    	service.saveOrUpdate(entity, false);
    	return CommonResponse.success("保存或修改API成功！",entity);
    }

    private void setNull(ApiEntity entity){
        if(StringUtils.isBlank(entity.getUitype())){
            entity.setUitype(null);
        }
        if(StringUtils.isBlank(entity.getUisubtype())){
            entity.setUisubtype(null);
        }
        if(StringUtils.isBlank(entity.getMethod())){
            entity.setMethod(null);
        }
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ApiEntity> queryDetail(@RequestParam("id") Long id) {
    	ApiEntity entity = service.selectById(id);
        return CommonResponse.success("查询详情数据成功！",entity);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        try{
            service.removeByIds(ids,false);
            return CommonResponse.success("删除成功");
        }catch (Exception e){
            return CommonResponse.error("删除失败,"+e.getMessage());
        }
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ApiEntity>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        param.getOrderMap().put("sequence",QueryParam.ASC);
        /** 租户隔离 */
        IPage<ApiEntity> page = service.queryPage(param,false);
        return CommonResponse.success("查询列表数据成功！",page);
    }

    /**
     * @Description updateSequence 更新序号
     */
    @RequestMapping(value = "/updateSequence", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> updateSequence(@RequestParam("id") Long id,@RequestParam("sequence") String sequence) {
        ApiEntity entity = service.selectById(id);
        if(entity==null){
            return CommonResponse.error("更新失败！没有该API！");
        }
        entity.setSequence(sequence);
        service.saveOrUpdate(entity);
        return CommonResponse.success("更新成功！");
    }


    /**
     * @Description queryApi 查询方法的api
     */
    @RequestMapping(value = "/queryApi", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> queryApi(@RequestParam("uitype") String uitype
                                          ,@RequestParam("uisubtype") String uisubtype
                                          ,@RequestParam("method") String method
                                          ,@RequestParam("type") String type
    ) {
        QueryParam param = new QueryParam();
        param.getParams().put("uitype",new Parameter(QueryParam.EQ,StringUtils.isBlank(uitype)?null:uitype));
        param.getParams().put("uisubtype",new Parameter(QueryParam.EQ,StringUtils.isBlank(uisubtype)?null:uisubtype));
        param.getParams().put("method",new Parameter(QueryParam.EQ,StringUtils.isBlank(method)?null:method));
        param.getParams().put("type",new Parameter(QueryParam.EQ,type));
        List<ApiEntity> list = service.queryList(param);
        if(ListUtil.isNotEmpty(list)){
            return CommonResponse.success("查询成功！",list.get(0).getContent());
        }
        if(StringUtils.isBlank(method)){
            return CommonResponse.success("查询成功！","该组件暂未定义示例API！");
        }
        return CommonResponse.success("查询成功！","该方法暂未定义示例API！");
    }
}
