package com.ejianc.foundation.front.business.ide.cache;

import java.util.concurrent.TimeUnit;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.front.business.ide.entity.IdeModule;
import com.ejianc.foundation.front.business.ide.entity.IdeModulePrivate;

@Component
public class IdeModulePageCache {
	private static final Logger LOGGER = LoggerFactory.getLogger(IdeModulePageCache.class);
	// 当前模块的缓存Key
	private final static String CURRENT_MODULEPAGE_KEY = "current_modulepage_key:";

	@Autowired
	private RedisTemplate<String, Object> redisTemplate;
	@Autowired
	private IOrgApi orgApi;

	/**
	 * 前端页面放入缓存
	 * 
	 * @param appCode
	 * @param pageCode
	 * @param orgId
	 */
	public void putModulePageCache(String appCode, String pageCode, String orgId, Object modulePro) {
		String currentModulePageKey = CURRENT_MODULEPAGE_KEY + appCode + "-" + pageCode;
		if (StringUtils.isNotBlank(orgId)) {
			LOGGER.info("redisTemplate写入私有化页面 "+appCode+"  "+pageCode+"  "+orgId);
			currentModulePageKey = currentModulePageKey + "-" + orgId;
		}else {
			LOGGER.info("redisTemplate写入公共页面 "+appCode+"  "+pageCode+"  "+orgId);
		}
		String jsonStr = JSONObject.toJSONString(modulePro);

		redisTemplate.opsForValue().set(currentModulePageKey, jsonStr, 1, TimeUnit.DAYS);
 	}

	/**
	 * 从redis中获取前端页面
	 * 
	 * @param appCode
	 * @param pageCode
	 * @return
	 */
	public Object getModulePageCache(String appCode, String pageCode) {
		String currentModulePageKey = CURRENT_MODULEPAGE_KEY + appCode + "-" + pageCode;
		String jsonStr = (String) redisTemplate.opsForValue().get(currentModulePageKey);
		if(jsonStr==null){
			LOGGER.info("redisTemplate未读取到公共页面信息 "+appCode+"  "+pageCode );
			return null;
		}
		LOGGER.info("redisTemplate读取到了公共页面信息 "+appCode+"  "+pageCode );
		return JSONObject.parseObject(jsonStr, IdeModule.class);
	}

	/**
	 * 从redis中获取前端页面
	 *
	 * @param appCode
	 * @param pageCode
	 * @param orgId
	 * @return
	 */
	public Object getProvidePageCache(String appCode, String pageCode, String orgId) {
		CommonResponse<OrgVO> response = orgApi.getOneById(Long.parseLong(orgId));
		if(response.isSuccess()) {
			OrgVO orgVO = response.getData();
			String[] innerCode = orgVO.getInnerCode().split("\\|");
			for (String s : innerCode) {
				String currentModulePageKey = CURRENT_MODULEPAGE_KEY + appCode + "-" + pageCode;
				currentModulePageKey = currentModulePageKey + "-" + s;
				String jsonStr = (String) redisTemplate.opsForValue().get(currentModulePageKey);
				/** 读取的私有化页面 */
				if (StringUtils.isNotBlank(jsonStr)) {
					LOGGER.info("redisTemplate读取到了私有化页面信息 appCode="+appCode+"  pageCode="+pageCode+" orgId = "+orgId +" parentOrgId = "+ s+" 实质读取了 = "+s  );
					return JSONObject.parseObject(jsonStr, IdeModulePrivate.class);
				}
			}
		}
		LOGGER.info("redisTemplate未读取到私有化页面信息 "+appCode+"  "+pageCode+" "+orgId  );
		return null;
	}

	/**
	 * 当前页面变动时或私有化后，删除该appCode和pageCode下所有缓存
	 * 
	 * @param appCode
	 * @param pageCode
	 */
	public void removeModulePageCache(String appCode, String pageCode,String orgId) {
		String currentModulePageKey = CURRENT_MODULEPAGE_KEY + appCode + "-" + pageCode;
		if (StringUtils.isNotBlank(orgId)) {
			LOGGER.info("redisTemplate删除私有化页面 "+appCode+"  "+pageCode+"  "+orgId);
			currentModulePageKey = currentModulePageKey + "-" + orgId;
		}else {
			LOGGER.info("redisTemplate删除公共页面 "+appCode+"  "+pageCode+"  "+orgId);
		}
		redisTemplate.delete(currentModulePageKey);
	}

}
