package com.ejianc.foundation.front.business.ide.controller;

import com.ejianc.foundation.front.business.ide.bo.IdeModuleBo;
import com.ejianc.foundation.front.business.ide.cache.IdeModulePageCache;
import com.ejianc.foundation.front.business.ide.entity.IdeModule;
import com.ejianc.foundation.front.business.ide.service.IdeModuleService;
import com.ejianc.foundation.front.util.StringUtils;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejianc.foundation.front.business.ide.entity.IdeModuleGroup;
import com.ejianc.foundation.front.business.ide.service.IdeModuleGroupService;
import com.ejianc.foundation.front.util.JsonBackData;

import java.util.List;

/**
 * 组controller
 */
@ResponseBody
@RequestMapping("/ide/moduleGroup")
@Controller
public class IdeModuleGroupController {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdeTeamController.class);
    @Autowired
    private IdeModuleGroupService moduleGroupService;
    @Autowired
    IdeModuleService ideModuleService;
    @Autowired
    IdeModulePageCache ideModulePageCache;
    /**
     * 保存组
     *
     * @param moduleGroup 组
     * @return  {@link JsonBackData}
     */
    @RequestMapping(method = RequestMethod.POST)
    public JsonBackData save(@RequestBody IdeModuleGroup moduleGroup) {
        JsonBackData backData = new JsonBackData();
        try {
            backData.setBackData(moduleGroupService.save(moduleGroup));
            backData.setSuccess(true);
            backData.setBackMsg("保存组成功");
        } catch (Exception e) {
            LOGGER.error("保存组失败", e);
            backData.setSuccess(false);
            backData.setBackMsg(e.getMessage());
        }
        return backData;
    }

    /**
     * 删除组
     *
     * @param ids 主键数组
     * @return {@link JsonBackData}
     */
    @RequestMapping(value = "{ids}", method = RequestMethod.DELETE)
    public JsonBackData delete(@PathVariable("ids") String[] ids) {
        JsonBackData backData = new JsonBackData();
        try {
            moduleGroupService.deleteByIds(ids);
            List<IdeModule> modules = ideModuleService.findByGroupIds(ids);
            if(ListUtil.isNotEmpty(modules)){
                for (IdeModule module : modules) {
                    module.setGroupId(null);
                    ideModuleService.saveOrUpdate(module);
                    IdeModuleBo bo = ideModuleService.findById(module.getId()+"");
                    LOGGER.info("IdeModuleController77行-从缓存删除页面数据！save {}---{}",bo.getAppCode(), bo.getCode());
                    if(StringUtils.isNotEmpty(bo.getCode()) && bo.getCode().startsWith("CFS")){
                        if(bo.getCode().endsWith("card") || bo.getCode().endsWith("list")){
                            ideModulePageCache.removeModulePageCache(bo.getCode().substring(0,bo.getCode().length()-4),bo.getCode(),null);
                        }else {
                            LOGGER.info("IdeModuleController82行-从缓存删除页面数据！save {}---{}",bo.getAppCode(), bo.getCode());
                            ideModulePageCache.removeModulePageCache(bo.getCode(),bo.getCode(),null);
                            ideModulePageCache.removeModulePageCache(bo.getCode(),bo.getCode()+"list",null);
                            ideModulePageCache.removeModulePageCache(bo.getCode(),bo.getCode()+"card",null);
                        }
                    }else {
                        LOGGER.info("IdeModuleController98行-从缓存删除页面数据！save {}---{}",bo.getAppCode(), bo.getCode());
                        ideModulePageCache.removeModulePageCache(bo.getAppCode(),bo.getCode(),null);
                    }
                }
            }
            backData.setBackMsg("删除组成功");
        }  catch (Exception e) {
            LOGGER.error("删除组失败", e);
            backData.setBackMsg("删除组错误");
            backData.setSuccess(false);
        }
        return backData;
    }

    /**
     * 获取组
     * @param id 主键
     * @return {@link JsonBackData}
     */
    @RequestMapping(value = "{id}", method = RequestMethod.GET)
    public JsonBackData get(@PathVariable("id") String id) {
        JsonBackData backData = new JsonBackData();
        try {
            backData.setBackData(moduleGroupService.findById(id));
            backData.setBackMsg("查找成功");
        }  catch (Exception e) {
            LOGGER.error("查找组失败", e);
            backData.setBackMsg("查找错误");
            backData.setSuccess(false);
        }
        return backData;
    }

    @RequestMapping(value = "findByAppId/{appId}", method = RequestMethod.GET)
    public JsonBackData findByAppId(@PathVariable String appId) {
        JsonBackData backData = new JsonBackData();
        try {
            backData.setBackData(moduleGroupService.findByAppId(appId));
            backData.setBackMsg("查找成功");
        }  catch (Exception e) {
            backData.setBackMsg("查找错误");
            backData.setSuccess(false);
        }
        return backData;
    }
}
