package com.ejianc.foundation.front.business.ide.controller;

import java.io.IOException;
import java.util.Map;

import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import com.ejianc.foundation.front.business.ide.utils.PageParser;

@RestController
@RequestMapping(value = "/ide/pageParser")
public class IdePageParserController {

    @RequestMapping(value = "/upload/{fileType}", method = RequestMethod.POST)
    public Map<String, Object> upload(@PathVariable String fileType, @RequestParam("file") MultipartFile file) throws IOException {
        return PageParser.basicParse(file.getInputStream(), PageParser.FileType.valueOf(fileType));
    }
}
