package com.ejianc.foundation.front.business.ide.service.impl;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejianc.foundation.front.business.ide.entity.IdeEntity;
import com.ejianc.foundation.front.business.ide.repository.IdeEntityAttrRepo;
import com.ejianc.foundation.front.business.ide.repository.IdeEntityRepo;
import com.ejianc.foundation.front.business.ide.service.IdeEntityService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.support.idworker.util.IdWorker;

@Transactional
@Service
public class IdeEntityServiceImpl implements IdeEntityService{
	
	@Autowired
	private IdeEntityRepo entityRepo;
	@Autowired
	private IdeEntityAttrRepo entityAttrRepo;

	@Override
	public IdeEntity saveOrUpdate(IdeEntity ideEntity) throws Exception, BusinessException {
		IdeEntity entity = entityRepo.findByCodeAndAppId(ideEntity.getCode(), ideEntity.getAppId());
		//新增
		if (ideEntity.getId() != null && ideEntity.getId() > 0) {
			if (entity != null&&!entity.getCode().equals(ideEntity.getCode())) {
				throw new BusinessException("编码不能重复！");
			}else {
				IdeEntity newEntity = entityRepo.findById(ideEntity.getId().toString());
				if (newEntity == null) {
					throw new BusinessException("本模型被他人删除，请刷新获取最新数据！");
				}
				if (ideEntity.getVersion() != newEntity.getVersion()) {
		            throw new BusinessException(String.format("本模型被他人于[%s]修改过，请刷新获取最新数据！", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(newEntity.getModifyDate())));
		        }
				newEntity.setCode(ideEntity.getCode());
				newEntity.setName(ideEntity.getName());
				newEntity.setModifyDate(new Date());
				newEntity.setModifyId(InvocationInfoProxy.getUserid());
				entityRepo.update(newEntity);
				return newEntity;
			}
		}else {
			if (entity != null) {
				throw new BusinessException("编码不能重复！");
			}else {
				ideEntity.setId(IdWorker.getId());
				ideEntity.setCreateDate(new Date());
				ideEntity.setCreateId(InvocationInfoProxy.getUserid());
				entityRepo.save(ideEntity);
				return ideEntity ;
			}
		}	
	}

	@Override
	public List<IdeEntity> findListByAppId(String appId) throws Exception, BusinessException {
		return entityRepo.findByAppId(appId);
	}

	@Override
	public void delete(String id) throws Exception, BusinessException {
		entityAttrRepo.deleteEntityId(id);
		entityRepo.deleteById(id);
		
	}

	@Override
	public IdeEntity findOne(String id) throws Exception, BusinessException {
		return entityRepo.findById(id);
	}

}
