/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.front.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.front.api.bean.ApiEntity;
import com.ejianc.foundation.front.api.service.IApiService;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"api"})
public class ApiController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IApiService service;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ApiEntity> saveOrUpdate(@RequestBody ApiEntity entity) {
        this.setNull(entity);
        QueryParam param = new QueryParam();
        param.getParams().put("uitype", new Parameter("eq", (Object)entity.getUitype()));
        param.getParams().put("uisubtype", new Parameter("eq", (Object)entity.getUisubtype()));
        param.getParams().put("method", new Parameter("eq", (Object)entity.getMethod()));
        param.getParams().put("type", new Parameter("eq", (Object)entity.getType()));
        param.getParams().put("id", new Parameter("ne", (Object)entity.getId()));
        List list = this.service.queryList(param);
        if (ListUtil.isNotEmpty((List)list)) {
            return CommonResponse.error((String)"\u8be5API\u5df2\u5b58\u5728\uff01");
        }
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539API\u6210\u529f\uff01", (Object)((Object)entity));
    }

    private void setNull(ApiEntity entity) {
        if (StringUtils.isBlank((CharSequence)entity.getUitype())) {
            entity.setUitype(null);
        }
        if (StringUtils.isBlank((CharSequence)entity.getUisubtype())) {
            entity.setUisubtype(null);
        }
        if (StringUtils.isBlank((CharSequence)entity.getMethod())) {
            entity.setMethod(null);
        }
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ApiEntity> queryDetail(@RequestParam(value="id") Long id) {
        ApiEntity entity = (ApiEntity)((Object)this.service.selectById(id));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)entity));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        try {
            this.service.removeByIds(ids, false);
            return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            return CommonResponse.error((String)("\u5220\u9664\u5931\u8d25," + e.getMessage()));
        }
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ApiEntity>> queryList(@RequestBody QueryParam param) {
        param.getOrderMap().put("sequence", "asc");
        IPage page = this.service.queryPage(param, false);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/updateSequence"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> updateSequence(@RequestParam(value="id") Long id, @RequestParam(value="sequence") String sequence) {
        ApiEntity entity = (ApiEntity)((Object)this.service.selectById(id));
        if (entity == null) {
            return CommonResponse.error((String)"\u66f4\u65b0\u5931\u8d25\uff01\u6ca1\u6709\u8be5API\uff01");
        }
        entity.setSequence(sequence);
        this.service.saveOrUpdate((Object)entity);
        return CommonResponse.success((String)"\u66f4\u65b0\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryApi"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> queryApi(@RequestParam(value="uitype") String uitype, @RequestParam(value="uisubtype") String uisubtype, @RequestParam(value="method") String method, @RequestParam(value="type") String type) {
        QueryParam param = new QueryParam();
        param.getParams().put("uitype", new Parameter("eq", (Object)(StringUtils.isBlank((CharSequence)uitype) ? null : uitype)));
        param.getParams().put("uisubtype", new Parameter("eq", (Object)(StringUtils.isBlank((CharSequence)uisubtype) ? null : uisubtype)));
        param.getParams().put("method", new Parameter("eq", (Object)(StringUtils.isBlank((CharSequence)method) ? null : method)));
        param.getParams().put("type", new Parameter("eq", (Object)type));
        List list = this.service.queryList(param);
        if (ListUtil.isNotEmpty((List)list)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)((ApiEntity)((Object)list.get(0))).getContent());
        }
        if (StringUtils.isBlank((CharSequence)method)) {
            return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)"\u8be5\u7ec4\u4ef6\u6682\u672a\u5b9a\u4e49\u793a\u4f8bAPI\uff01");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)"\u8be5\u65b9\u6cd5\u6682\u672a\u5b9a\u4e49\u793a\u4f8bAPI\uff01");
    }
}

