/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.front.business.ide.service.impl;

import com.ejianc.foundation.front.business.ide.bo.IdeAccountBo;
import com.ejianc.foundation.front.business.ide.entity.IdeUser;
import com.ejianc.foundation.front.business.ide.repository.IdeUserRepo;
import com.ejianc.foundation.front.business.ide.service.IdeAccountService;
import com.ejianc.foundation.front.util.MD5Util;
import com.ejianc.foundation.front.util.RandomUtils;
import com.ejianc.foundation.front.util.TimeUtils;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Transactional
@Service
public class IdeAccountServiceImpl
implements IdeAccountService {
    @Autowired
    IdeUserRepo ideUserRepo;

    @Override
    public IdeAccountBo getNewAccount() throws Exception {
        IdeUser newUser = this.generateNewAccount();
        IdeAccountBo bo = new IdeAccountBo();
        bo.setGid(newUser.getId() + "");
        bo.setCode(newUser.getCode());
        bo.setPassword(newUser.getUnencryptPwd());
        bo.setPasswordMd5(newUser.getPassword());
        return bo;
    }

    private IdeUser generateNewAccount(boolean defaultPwd, String qqAccessToken, String qqOpenId, String nickName, int sex, String avatarUrl) throws Exception {
        String newAccount = RandomUtils.getRandomNumbersAndLetters(3) + new Date().getTime();
        boolean inUse = false;
        int tryCount = 1;
        do {
            if (inUse = this.checkAccountInUse(newAccount)) {
                newAccount = newAccount + 1;
                ++tryCount;
            }
            if (tryCount <= 100) continue;
            return null;
        } while (inUse);
        String newPwd = defaultPwd ? "123456" : RandomUtils.getRandomNumbers(6);
        IdeUser newUser = this.createNewAccount(newAccount, newPwd, qqAccessToken, qqOpenId, nickName, sex, avatarUrl);
        return newUser;
    }

    private IdeUser createNewAccount(String code, String pwd, String qqAccessToken, String qqOpenId, String nickName, int sex, String avatarUrl) throws Exception {
        if (StringUtils.isNotBlank((String)code) && StringUtils.isNotBlank((String)pwd)) {
            if (this.checkAccountInUse(code)) {
                throw new Exception("\u8d26\u53f7[" + code + "]\u5df2\u88ab\u6ce8\u518c\uff01");
            }
            IdeUser newUser = new IdeUser();
            newUser.setId(IdWorker.getId());
            newUser.setCode(code);
            newUser.setUnencryptPwd(pwd);
            newUser.setPassword(MD5Util.MD5(pwd));
            newUser.setCreateDate(new Date());
            newUser.setSex(sex);
            if (!StringUtils.isBlank((String)nickName)) {
                newUser.setName(nickName);
            }
            if (!StringUtils.isBlank((String)qqOpenId)) {
                newUser.setQqOpenId(qqOpenId);
            }
            if (!StringUtils.isBlank((String)qqAccessToken)) {
                newUser.setQqAccessToken(qqAccessToken);
            }
            if (!StringUtils.isBlank((String)avatarUrl)) {
                newUser.setQqAvatarUrl(avatarUrl);
            }
            newUser.setCreateId(InvocationInfoProxy.getUserid());
            newUser.setIsDelete(0);
            this.ideUserRepo.save(newUser);
            return newUser;
        }
        return null;
    }

    private IdeUser generateNewAccount() throws Exception {
        return this.generateNewAccount(false, null, null, null, 0, null);
    }

    @Override
    public IdeUser regAccount(String code, String password) throws Exception {
        IdeUser newUser = this.createNewAccount(code, password, null, null, null, 0, null);
        return newUser;
    }

    @Override
    public boolean loginAccount(String code, String password) {
        String pwdMd5 = MD5Util.MD5(password);
        boolean result = this.loginAccountMd5(code, pwdMd5);
        return result;
    }

    @Override
    public boolean loginAccountMd5(String code, String pwdMd5) {
        IdeUser user = this.ideUserRepo.selectAccount(code, pwdMd5);
        if (user != null) {
            boolean isExpire = this.checkAccountIsExpire(user);
            if (isExpire) {
                return false;
            }
            user.setLoginDate(new Date());
            this.ideUserRepo.update(user);
            return true;
        }
        return false;
    }

    @Override
    public boolean checkAccount(String code, String password) {
        String pwdMd5 = MD5Util.MD5(password);
        IdeUser user = this.ideUserRepo.selectAccount(code, pwdMd5);
        return user != null;
    }

    @Override
    public boolean checkAccountExpire(String code) {
        IdeUser user = this.findUserByCode(code);
        return this.checkAccountIsExpire(user);
    }

    private boolean checkAccountIsExpire(IdeUser user) {
        if (user == null) {
            return true;
        }
        Date date = user.getExpireDate();
        if (date != null) {
            Date expireDate = TimeUtils.stringToDate(TimeUtils.dateToString(date, "yyyy-MM-dd"), "yyyy-MM-dd");
            Date nowDate = TimeUtils.stringToDate(TimeUtils.dateToString(new Date(), "yyyy-MM-dd"), "yyyy-MM-dd");
            return nowDate.after(expireDate);
        }
        return false;
    }

    @Override
    public IdeUser findUserByCode(String code) {
        List<IdeUser> user = this.ideUserRepo.selectAccountByCode(code);
        if (user != null && user.size() > 0) {
            return user.get(user.size() - 1);
        }
        return null;
    }

    @Override
    public boolean checkAccountInUse(String code) {
        IdeUser user = this.findUserByCode(code);
        return user != null;
    }

    @Override
    public String changePassword(String code, String oldPwd, String newPwd) {
        if (StringUtils.isEmpty((String)oldPwd)) {
            return "\u8bf7\u8f93\u5165\u539f\u59cb\u5bc6\u7801";
        }
        String pwdMd5 = MD5Util.MD5(oldPwd);
        IdeUser user = this.ideUserRepo.selectAccount(code, pwdMd5);
        if (user == null) {
            return "\u539f\u59cb\u5bc6\u7801\u4e0d\u6b63\u786e";
        }
        if (StringUtils.isEmpty((String)newPwd)) {
            return "\u8bf7\u8f93\u5165\u65b0\u7684\u5bc6\u7801";
        }
        user.setPassword(MD5Util.MD5(newPwd));
        this.ideUserRepo.update(user);
        return "success";
    }

    @Override
    public IdeUser findAccount(String code, String password) {
        String pwdMd5 = MD5Util.MD5(password);
        IdeUser user = this.ideUserRepo.selectAccount(code, pwdMd5);
        return user;
    }

    @Override
    public IdeUser findByQQOpenId(String qqOpenId) {
        IdeUser user = this.ideUserRepo.selectByQQOpenId(qqOpenId);
        return user;
    }

    @Override
    public IdeUser generateNewAccountByQQ(String qqAccessToken, String qqOpenId, String nickName, int sex, String avatarUrl) throws Exception {
        IdeUser user = this.generateNewAccount(true, qqAccessToken, qqOpenId, nickName, sex, avatarUrl);
        return user;
    }

    @Override
    public void saveOrUpdate(IdeUser user) {
        if (user.getId() != null && user.getId() > 0L) {
            this.ideUserRepo.update(user);
        } else {
            this.ideUserRepo.save(user);
        }
    }

    @Override
    public void setCurrUser(HttpServletRequest request, IdeAccountBo acc) {
        if (request != null && request.getSession() != null) {
            request.getSession().setAttribute("sess_user", (Object)acc);
        }
    }

    @Override
    public IdeAccountBo getCurrUser(HttpServletRequest request) {
        if (request == null) {
            request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        }
        if (request.getSession() != null) {
            return (IdeAccountBo)request.getSession().getAttribute("sess_user");
        }
        return null;
    }

    @Override
    public void clearCurrUser(HttpServletRequest request) {
        if (request != null && request.getSession() != null) {
            request.getSession().removeAttribute("sess_user");
            request.getSession().invalidate();
        }
    }

    @Override
    public IdeUser userUpdate(IdeUser user) {
        IdeUser ideUser = this.ideUserRepo.selectAccountByCode(user.getCode()).get(0);
        if (ideUser != null) {
            ideUser.setCode(user.getCode());
            ideUser.setEmail(user.getEmail());
            ideUser.setName(user.getName());
            ideUser.setPhone(user.getPhone());
            this.ideUserRepo.update(ideUser);
            return ideUser;
        }
        return null;
    }
}

