/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.front.business.ide.service.impl;

import com.ejianc.foundation.front.business.ide.entity.IdeResource;
import com.ejianc.foundation.front.business.ide.repository.IdeResourceRepo;
import com.ejianc.foundation.front.business.ide.service.IdeCommonService;
import com.ejianc.foundation.front.business.ide.service.IdeResourceService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.support.idworker.util.IdWorker;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Transactional(readOnly=true)
@Service
public class IdeResourceServiceImpl
implements IdeResourceService {
    @Autowired
    private IdeResourceRepo resourceRepo;
    @Autowired
    IdeCommonService ideCommonService;

    @Override
    @Transactional
    public IdeResource save(IdeResource resource) {
        boolean isAdd = StringUtils.isEmpty((Object)resource.getId());
        if (isAdd) {
            resource.setId(IdWorker.getId());
            resource.setCreateDate(new Date());
            resource.setCode(this.ideCommonService.generateResourceCode());
            return this.resourceRepo.save(resource);
        }
        IdeResource _resource = this.resourceRepo.findOne(String.valueOf(resource.getId()));
        if (resource.getVersion() != _resource.getVersion()) {
            throw new BusinessException(String.format("\u672c\u8d44\u6e90\u6a21\u578b\u88ab\u4ed6\u4eba\u4e8e[%s]\u4fee\u6539\u8fc7\uff0c\u8bf7\u5237\u65b0\u83b7\u53d6\u6700\u65b0\u6570\u636e\uff01", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(_resource.getModifyDate())));
        }
        _resource.setAppId(resource.getAppId());
        _resource.setName(resource.getName());
        _resource.setCode(resource.getCode());
        _resource.setData(resource.getData());
        _resource.setModifyId(resource.getModifyId());
        _resource.setModifyDate(new Date());
        return this.resourceRepo.update(_resource);
    }

    @Override
    public IdeResource findById(String id) {
        return this.resourceRepo.findOne(id);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        this.resourceRepo.del(id);
    }

    @Override
    public List<IdeResource> findByAppId(String appId) {
        return this.resourceRepo.findByAppId(appId);
    }

    @Override
    @Transactional
    public IdeResource updateName(String createId, String id, String name, int version) {
        IdeResource resource = this.resourceRepo.findOne(id);
        if (resource == null) {
            throw new BusinessException(String.format("\u4e0d\u5b58\u5728\u4e3b\u952e\u4e3a%s\u7684\u8d44\u6e90", id));
        }
        if (version != resource.getVersion()) {
            throw new BusinessException(String.format("\u672c\u8d44\u6e90\u6a21\u578b\u88ab\u4ed6\u4eba\u4e8e[%s]\u4fee\u6539\u8fc7\uff0c\u8bf7\u5237\u65b0\u83b7\u53d6\u6700\u65b0\u6570\u636e\uff01", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(resource.getModifyDate())));
        }
        resource.setModifyId(Long.parseLong(createId));
        resource.setModifyDate(new Date());
        resource.setName(name);
        resource.setVersion(version);
        return this.resourceRepo.update(resource);
    }

    @Override
    @Transactional
    public IdeResource updateData(String createId, String id, String data, int version) {
        IdeResource resource = this.resourceRepo.findOne(id);
        if (resource == null) {
            throw new BusinessException(String.format("\u4e0d\u5b58\u5728\u4e3b\u952e\u4e3a%s\u7684\u8d44\u6e90", id));
        }
        if (version != resource.getVersion()) {
            throw new BusinessException(String.format("\u672c\u8d44\u6e90\u6a21\u578b\u88ab\u4ed6\u4eba\u4e8e[%s]\u4fee\u6539\u8fc7\uff0c\u8bf7\u5237\u65b0\u83b7\u53d6\u6700\u65b0\u6570\u636e\uff01", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(resource.getModifyDate())));
        }
        resource.setModifyId(Long.parseLong(createId));
        resource.setModifyDate(new Date());
        resource.setData(data);
        resource.setVersion(version);
        return this.resourceRepo.update(resource);
    }

    @Override
    public IdeResource findByAppCodeAndResourceCode(String appCode, String resourceCode) {
        return this.resourceRepo.findAppCodeAndResourcCode(appCode, resourceCode);
    }
}

