package com.ejianc.foundation.front.business.ide.repository;

import java.util.List;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import com.ejianc.foundation.front.business.ide.entity.IdeApp;

@Mapper
public interface IdeAppRepo {

    IdeApp findById(@Param("id") String id);

    List<IdeApp> findAll(@Param("clientType") String clientType);

    List<IdeApp> findAllApps(@Param("clientType") String clientType);

    void deleteById(@Param("id") String id);

    void recoverById(@Param("id") String id);
    
    void deleteByIds(@Param("ids") String ids);

    List<IdeApp> findByCodeOrName(@Param("code") String code,@Param("name") String name);
    
    List<IdeApp> findByName(@Param("name") String name,@Param("createId") String createId);

    List<IdeApp> findNameInTeam(@Param("name") String name,@Param("teamId") String teamId);

    List<IdeApp> findAllByCode(@Param("code") String code);
    
    List<IdeApp> findByCreateId(@Param("createId") String createId,@Param("clientType") String clientType);
    
    List<IdeApp> findTeamApps(@Param("teamIds") String teamIds, @Param("clientType") String clientType);
    /**
     * 查询当前账号下未归属团队的应用
     * @param createId
     * @return
     */
    List<IdeApp> findNoTeamApps(@Param("createId") String createId, @Param("clientType") String clientType);
    
    /**
     * 查询公共的应用，排除掉未归团的应用和指定团队的应用
     * @param teamIds
     * @return
     */
    List<IdeApp> findPublicApps(@Param("prodType") int prodType, @Param("teamIds") String teamIds, @Param("clientType") String clientType);

    /**
     * 查找团队下应用实际个数
     *
     * @param teamId 团队id
     */
    int countApps(@Param("teamId") String teamId);
    
    List<IdeApp> findAppByTeamId(@Param("teamId") String teamId);
    
    //恢复删除
    void recoverByIds(@Param("ids") String ids);
    //彻底删除
    void removeByIds(@Param("ids") String ids);
    
    void updateGroupId(@Param("groupId") String groupId);
    
    //根据分组id查找应用
    List<IdeApp> findAppByGroupId(@Param("groupId") String groupId);
    
  //根据分组ids查找应用
    List<IdeApp> findAppByGroupIds(@Param("groupIds") String groupIds);

	void save(IdeApp ideApp);

	void update(IdeApp ideAppEntity);

	List<IdeApp> findAllByIds(@Param("appIds") String appIds);

	List<IdeApp> queryAppHasData(@Param("orgIds") String orgIds);
    
    List<IdeApp> findAppListByTeamId(@Param("teamId") String teamId,@Param("searchText") String searchText,
                          @Param("isDelete") boolean isDelete,@Param("pageIndex") Integer pageIndex,@Param("pageSize") Integer pageSize);

    Long findModuleCountByTeamId(@Param("teamId") String teamId,@Param("searchText") String searchText,
                                @Param("isDelete") boolean isDelete);

    List<IdeApp> findListBySql(@Param("appCodesParam") String appCodesParam);
}
