package com.ejianc.foundation.front.business.ide.repository;

import java.util.List;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import com.ejianc.foundation.front.business.ide.entity.IdeResource;

/**
 * 模块数据模型repository
 */
@Mapper
public interface IdeResourceRepo {

    /**
     * 获取数据模型列表
     *
     * @param appId 应用id
     * @return 数据模型列表
     */
    List<IdeResource> findByAppId(@Param("appId") String appId);
    
    IdeResource findAppCodeAndResourcCode(@Param("appCode") String appCode,@Param("resourceCode") String resourceCode);
    
    List<IdeResource> findAllByCode(@Param("code") String code);

	IdeResource findOne(@Param("id") String id);

	void del(@Param("id") String id);
	
	IdeResource save(IdeResource resource);

	IdeResource update(IdeResource resource);
}
