package com.ejianc.foundation.front.business.ide.service;

import javax.servlet.http.HttpServletRequest;

import com.ejianc.foundation.front.business.ide.bo.IdeAccountBo;
import com.ejianc.foundation.front.business.ide.entity.IdeUser;

/**
 * 账号相关接口定义
 * @author Dio
 */
public interface IdeAccountService {
	/**
	 * 保存到Session的用户信息KEY
	 */
	final String SESSION_USER_KEY = "sess_user"; 
	/**
	 * QQ互联时的错误信息  
	 */
	final String QQ_CONNECT_ERROR = "qq_connect_error";
	/**
	 * 账号生成的默认密码
	 */
	final String ACCOUNT_DEFAULT_PASSWORD = "123456";
	/**
	 * 生成一个新的账号信息
	 * @return
	 */
	public IdeAccountBo getNewAccount()throws Exception;
	
	/**
	 * 通过账号名称查找唯一账号
	 * @param code
	 * @return
	 */
	public IdeUser findUserByCode(String code);
	
	/**
	 * 通过明文账号密码进行注册
	 * @param code 账号
	 * @param password 明码
	 * @return
	 */
	public IdeUser regAccount(String code, String password)throws Exception;

	/**
	 * 通过明文账号密码进行登录
	 * @param code 账号
	 * @param password 明码
	 * @return
	 */
	public boolean loginAccount(String code, String password);
	/**
	 * 通过密文登录账号进行密码
	 * @param code 账号
	 * @param passwordMd5 加密密码
	 * @return
	 */
	public boolean loginAccountMd5(String code, String passwordMd5);
	/**
	 * 通过账号密码查询用户信息
	 * @return
	 */
	public IdeUser findAccount(String code, String password);

	/**
	 * 检查账号和密码是否正确
	 * @return
	 */
	public boolean checkAccount(String code, String password);

	/**
	 * 检查指定账号是否被使用中
	 * @param code
	 * @return
	 */
	public boolean checkAccountInUse(String code);

	/**
	 * 检查账号是否过期
	 * @param code
	 * @return
	 */
	public boolean checkAccountExpire(String code);

	/**
	 * 修改账号密码
	 * @param code
	 * @param oldPwd
	 * @param newPwd
	 * @return
	 * 		修改成功则返回 success ，否则返回错误消息。
	 */
	public String changePassword(String code, String oldPwd, String newPwd);

	/**
	 * 通过QQ_Open_Id查找账号信息
	 * @return
	 */
	public IdeUser findByQQOpenId(String qqOpenId);

	/**
	 * 通过QQ信息生成一个新的账号
	 * @param qqAccessToken
	 * @param qqOpenId
	 * @param nickName 昵称
	 * @param sex	性别,0-男、1-女
	 * @param avatarUrl	头像URL
	 * @return
	 */
	public IdeUser generateNewAccountByQQ(String qqAccessToken, String qqOpenId, String nickName, int sex, String avatarUrl)throws Exception;

	/**
	 * 存储或更新用户原始信息
	 * @param user
	 */
	public void saveOrUpdate(IdeUser user);
	/**
	 * 设置当前登录用户信息
	 * @param mv
	 * @param acc
	 */
	public void setCurrUser(HttpServletRequest request, IdeAccountBo acc);

	/**
	 * 获取当前登录用户信息
	 * @return
	 */
	public IdeAccountBo getCurrUser(HttpServletRequest request);
	
	/**
	 * 注销登录用户
	 * @param request
	 */
	public void clearCurrUser(HttpServletRequest request);
	
	/**
	 * 修改用户原始信息
	 * @param user
	 */
	public IdeUser userUpdate(IdeUser user);
}
