package com.ejianc.foundation.front.business.ide.service;

import com.ejianc.foundation.front.business.ide.bo.IdeModuleBillTypeRefBO;
import com.ejianc.foundation.front.business.ide.bo.IdeModuleRefBO;
import com.ejianc.foundation.front.business.ide.bo.IdeSearchItemRefBO;
import com.ejianc.foundation.front.business.ide.utils.refer.ReferTreeData;
import com.ejianc.framework.core.exception.BusinessException;
import org.springframework.data.domain.Page;

import java.awt.print.Pageable;
import java.util.List;
import java.util.Map;

public interface IdeReferService {
	
	//小应用和页面的参照树
	List<ReferTreeData> referTree(Map<String, Object> paras) throws BusinessException;

	//小应用和页面的参照树
	List<ReferTreeData> referModuleTree(Map<String, Object> paras) throws BusinessException;

	//小应用和页面的参照树
	List<ReferTreeData> referModuleDataTree(Map<String, Object> paras) throws BusinessException;

	//树表页面的应用树
	List<ReferTreeData> treeData() throws BusinessException;

	//树表页面的表数据
	List<IdeModuleRefBO> listData(Pageable pageable, Map<String, Object> paras) throws BusinessException;

	//搜索栏子项的参照表数据
	Page<IdeSearchItemRefBO> searchItemList(Pageable pageable, Map<String,Object> paras) throws BusinessException;

	//搜索栏子项树表页面的页面树
	List<ReferTreeData> pageTreeData(Map<String, Object> paras) throws BusinessException;

	//搜索栏子项树表页面的表数据
	List<IdeSearchItemRefBO> searchItemListByPageId(Map<String,Object> paras) throws BusinessException;

	//单据类型-页面参照的页面列表
	Page<IdeModuleBillTypeRefBO> moduleListByBillType(Map<String, Object> paras, Pageable pageable) throws BusinessException,Exception;
}
