package com.ejianc.foundation.front.business.ide.service.impl;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejianc.foundation.front.business.ide.entity.IdeModule;
import com.ejianc.foundation.front.business.ide.entity.IdeModulePro;
import com.ejianc.foundation.front.business.ide.repository.IdeModuleProRepo;
import com.ejianc.foundation.front.business.ide.service.IdeModuleProService;
import com.ejianc.framework.core.exception.BusinessException;

@Service
@Transactional
public class IdeModuleProServiceImpl implements IdeModuleProService {

	@Autowired
	IdeModuleProRepo ideModuleProRepo;
	
	@Override
	public List<IdeModulePro> findAllLastPublish()  throws Exception {
		return ideModuleProRepo.findAllLastPublish();
	}

	@Override
	public List<IdeModulePro> findAllLastPublishByAppId(String appId) throws Exception {
		return ideModuleProRepo.findAllLastPublishByAppId(appId);
	}
	
	 @Override
    public IdeModulePro findByAppCodeAndModuleCode(String appCode, String moduleCode) throws Exception {
 		List<IdeModulePro> ideModuleProList = ideModuleProRepo.findByAppCodeAndModuleCode(appCode,moduleCode); 
        return ideModuleProList.get(0);
    }

	@Override
	public void deleteById(String id) throws Exception {
		IdeModulePro ideModulePro = ideModuleProRepo.findById(id);
		if(ideModulePro!=null){
			//删除目标环境下对应页面编码的发布信息
			ideModuleProRepo.deleteByCode(ideModulePro.getCode(),ideModulePro.getToName());	
		}else{
			throw new BusinessException("此发布页面不存在或已被删除");
		}
	}

	@Override
	public List<IdeModule> findDiffLastPublish(List<IdeModule> modules, String toName) {
		//查找出所有需要发布的页面
		List<String> pageCodeList = modules.stream().map(IdeModule::getCode).collect(Collectors.toList());
		String pageCodeStr = "'"+ org.apache.commons.lang.StringUtils.join(pageCodeList,"','")+"'";
		List<IdeModulePro> ideModuleProList = ideModuleProRepo.findAllLastPublishByCodes(pageCodeStr, toName);
		//筛选页面内容发生改变的页面
		List<IdeModule> ideModuleList = modules.stream().filter(module -> {
			//所选的页面都没发布
			if(ideModuleProList.size() == 0) {
				return true;
			} else {
				//根据pageCode匹配出modulePropList中的module
				List<IdeModulePro> proModuleList = ideModuleProList.stream().filter(proModule -> {
					return proModule.getCode().equals(module.getCode());
				}).collect(Collectors.toList());
				//在ideModulePro中没有找到当前页面，可能是没有发布过的页面
				if(proModuleList==null ||proModuleList.size()==0) {
					return true;
				}else if(!proModuleList.get(0).getAppId().equals(module.getAppId())) {
					return true;
				}
				else {
					String proData = proModuleList.get(0).getData();
					if(!StringUtils.isEmpty(module.getData())&&!StringUtils.isEmpty(proData)){
						//比较data字段是否发生改变
						return module.getData().hashCode() != proData.hashCode();
					}else if (StringUtils.isEmpty(module.getData())) {
						return false;
					}else {
						return true;
					}	
				}
			}
		}).collect(Collectors.toList());	
		return ideModuleList;
	}
}
