package com.ejianc.foundation.front.business.ide.service.impl;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import com.ejianc.foundation.front.business.ide.entity.IdeResource;
import com.ejianc.foundation.front.business.ide.repository.IdeResourceRepo;
import com.ejianc.foundation.front.business.ide.service.IdeCommonService;
import com.ejianc.foundation.front.business.ide.service.IdeResourceService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.support.idworker.util.IdWorker;
/**
 * 模块数据模型service impl
 */
@Transactional(readOnly = true)
@Service
public class IdeResourceServiceImpl implements IdeResourceService {
    @Autowired
    private IdeResourceRepo resourceRepo;
    @Autowired
    IdeCommonService ideCommonService;

    /**
     * 保存数据模型
     *
     * @param resource 数据模型
     * @return 数据模型
     */
    @Transactional
    @Override
    public IdeResource save(IdeResource resource) {
        boolean isAdd = StringUtils.isEmpty(resource.getId());
        if (isAdd) {
        	resource.setId(IdWorker.getId());
            resource.setCreateDate(new Date());
            resource.setCode(ideCommonService.generateResourceCode());
            return resourceRepo.save(resource);
        } else {
            IdeResource _resource = resourceRepo.findOne(String.valueOf(resource.getId()));
            if (resource.getVersion() != _resource.getVersion()) {
                throw new BusinessException(String.format("本资源模型被他人于[%s]修改过，请刷新获取最新数据！",
                        new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(_resource.getModifyDate())));
            }
            _resource.setAppId(resource.getAppId());
            _resource.setName(resource.getName());
            _resource.setCode(resource.getCode());
            _resource.setData(resource.getData());
            _resource.setModifyId(resource.getModifyId());
            _resource.setModifyDate(new Date());
            return resourceRepo.update(_resource);
        }
    }

    /**
     * 获取数据模型
     *
     * @param id 主键
     * @return 数据模型
     */
    @Override
    public IdeResource findById(String id) {
        return resourceRepo.findOne(id);
    }

    /**
     * 删除数据模型
     *
     * @param id 主键
     */
    @Transactional
    @Override
    public void deleteById(String id) {
        resourceRepo.del(id);
    }

    /**
     * 获取数据模型列表
     *
     * @param appId 应用id
     * @return 数据模型列表
     */
    @Override
    public List<IdeResource> findByAppId(String appId) {
        return resourceRepo.findByAppId(appId);
    }

    /**
     * 更改资源名称
     *
     * @param createId 用户id
     * @param id       主键
     * @param name     资源名
     * @param version  版本号
     * @return 数据模型
     */
    @Transactional
    @Override
    public IdeResource updateName(String createId, String id, String name, int version) {
        IdeResource resource = resourceRepo.findOne(id);
        if (resource == null) {
            throw new BusinessException(String.format("不存在主键为%s的资源", id));
        }
        if (version != resource.getVersion()) {
            throw new BusinessException(String.format("本资源模型被他人于[%s]修改过，请刷新获取最新数据！", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(resource.getModifyDate())));
        }
        resource.setModifyId(Long.parseLong(createId));
        resource.setModifyDate(new Date());
        resource.setName(name);
        resource.setVersion(version);
        return resourceRepo.update(resource);
    }

    /**
     * 更改资源数据
     *
     * @param createId 用户id
     * @param id       主键
     * @param data     资源数据
     * @param version  版本号
     * @return 数据模型
     */
    @Transactional
    @Override
    public IdeResource updateData(String createId, String id, String data, int version) {
        IdeResource resource = resourceRepo.findOne(id);
        if (resource == null) {
            throw new BusinessException(String.format("不存在主键为%s的资源", id));
        }
        if (version != resource.getVersion()) {
            throw new BusinessException(String.format("本资源模型被他人于[%s]修改过，请刷新获取最新数据！",
                    new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(resource.getModifyDate())));
        }
        resource.setModifyId(Long.parseLong(createId));
        resource.setModifyDate(new Date());
        resource.setData(data);
        resource.setVersion(version);
        return resourceRepo.update(resource);
    }

	@Override
	public IdeResource findByAppCodeAndResourceCode(String appCode, String resourceCode) {
		return resourceRepo.findAppCodeAndResourcCode(appCode, resourceCode);
	}
}
