/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.front.business.ide.controller;

import com.ejianc.foundation.front.business.ide.entity.IdeResource;
import com.ejianc.foundation.front.business.ide.service.IdeResourceService;
import com.ejianc.foundation.front.util.JsonBackData;
import com.ejianc.framework.core.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ide/resource"})
public class IdeResourceController {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdeResourceController.class);
    @Autowired
    private IdeResourceService resourceService;

    @RequestMapping(method={RequestMethod.POST})
    public JsonBackData save(@RequestBody IdeResource resource) {
        JsonBackData backData = new JsonBackData();
        try {
            backData.setBackData(this.resourceService.save(resource));
            backData.setBackMsg("\u4fdd\u5b58\u6a21\u5757\u6570\u636e\u6a21\u578b\u6210\u529f");
        }
        catch (BusinessException e) {
            LOGGER.error("\u4fdd\u5b58\u6a21\u5757\u6570\u636e\u6a21\u578b\u5931\u8d25\uff1a", (Object)e.getMessage());
            backData.setSuccess(false);
            backData.setBackMsg(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u6a21\u5757\u6570\u636e\u6a21\u578b\u5931\u8d25", (Throwable)e);
            backData.setSuccess(false);
            backData.setBackMsg("\u4fdd\u5b58\u6a21\u5757\u6570\u636e\u6a21\u578b\u5931\u8d25");
        }
        return backData;
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.GET})
    public JsonBackData get(@PathVariable String id) {
        JsonBackData backData = new JsonBackData();
        try {
            backData.setBackData(this.resourceService.findById(id));
            backData.setBackMsg("\u83b7\u53d6\u6a21\u5757\u6570\u636e\u6a21\u578b\u6210\u529f");
        }
        catch (BusinessException e) {
            LOGGER.error("\u83b7\u53d6\u6a21\u5757\u6570\u636e\u6a21\u578b\u5931\u8d25\uff1a", (Object)e.getMessage());
            backData.setSuccess(false);
            backData.setBackMsg(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u6a21\u5757\u6570\u636e\u6a21\u578b\u5931\u8d25", (Throwable)e);
            backData.setSuccess(false);
            backData.setBackMsg("\u83b7\u53d6\u6a21\u5757\u6570\u636e\u6a21\u578b\u5931\u8d25");
        }
        return backData;
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.DELETE})
    public JsonBackData delete(@PathVariable String id) {
        JsonBackData backData = new JsonBackData();
        try {
            this.resourceService.deleteById(id);
            backData.setBackMsg("\u5220\u9664\u6a21\u5757\u6570\u636e\u6a21\u578b\u6210\u529f");
        }
        catch (BusinessException e) {
            LOGGER.error("\u5220\u9664\u6a21\u5757\u6570\u636e\u6a21\u578b\u5931\u8d25\uff1a", (Object)e.getMessage());
            backData.setSuccess(false);
            backData.setBackMsg(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u6a21\u5757\u6570\u636e\u6a21\u578b\u5931\u8d25", (Throwable)e);
            backData.setSuccess(false);
            backData.setBackMsg("\u5220\u9664\u6a21\u5757\u6570\u636e\u6a21\u578b\u5931\u8d25");
        }
        return backData;
    }

    @RequestMapping(value={"find/{appId}"}, method={RequestMethod.GET})
    public JsonBackData module(@PathVariable String appId) {
        JsonBackData backData = new JsonBackData();
        try {
            backData.setBackData(this.resourceService.findByAppId(appId));
            backData.setBackMsg("\u67e5\u627e\u6a21\u5757\u6570\u636e\u6a21\u578b\u5217\u8868\u6210\u529f");
        }
        catch (BusinessException e) {
            LOGGER.error("\u67e5\u627e\u6a21\u5757\u6570\u636e\u6a21\u578b\u5217\u8868\u5931\u8d25\uff1a", (Object)e.getMessage());
            backData.setSuccess(false);
            backData.setBackMsg(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u627e\u6a21\u5757\u6570\u636e\u6a21\u578b\u5217\u8868\u5931\u8d25", (Throwable)e);
            backData.setSuccess(false);
            backData.setBackMsg("\u67e5\u627e\u6a21\u5757\u6570\u636e\u6a21\u578b\u5217\u8868\u5931\u8d25");
        }
        return backData;
    }

    @RequestMapping(value={"updateName"}, method={RequestMethod.POST})
    public JsonBackData updateName(@RequestBody IdeResource resource) {
        JsonBackData backData = new JsonBackData();
        try {
            backData.setBackData(this.resourceService.updateName(String.valueOf(resource.getCreateId()), String.valueOf(resource.getId()), resource.getName(), resource.getVersion()));
            backData.setBackMsg("\u66f4\u6539\u8d44\u6e90\u540d\u79f0\u6210\u529f");
        }
        catch (BusinessException e) {
            LOGGER.error("\u66f4\u6539\u8d44\u6e90\u540d\u79f0\u5931\u8d25\uff1a", (Object)e.getMessage());
            backData.setSuccess(false);
            backData.setBackMsg(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u66f4\u6539\u8d44\u6e90\u540d\u79f0\u5931\u8d25", (Throwable)e);
            backData.setSuccess(false);
            backData.setBackMsg("\u66f4\u6539\u8d44\u6e90\u540d\u79f0\u5931\u8d25");
        }
        return backData;
    }

    @RequestMapping(value={"updateData"}, method={RequestMethod.POST})
    public JsonBackData updateData(@RequestBody IdeResource resource) {
        JsonBackData backData = new JsonBackData();
        try {
            backData.setBackData(this.resourceService.updateData(String.valueOf(resource.getCreateId()), String.valueOf(resource.getId()), resource.getData(), resource.getVersion()));
            backData.setBackMsg("\u66f4\u6539\u8d44\u6e90\u6570\u636e\u6210\u529f");
        }
        catch (BusinessException e) {
            LOGGER.error("\u66f4\u6539\u8d44\u6e90\u6570\u636e\u5931\u8d25\uff1a", (Object)e.getMessage());
            backData.setSuccess(false);
            backData.setBackMsg(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u66f4\u6539\u8d44\u6e90\u6570\u636e\u5931\u8d25", (Throwable)e);
            backData.setSuccess(false);
            backData.setBackMsg("\u66f4\u6539\u8d44\u6e90\u6570\u636e\u5931\u8d25");
        }
        return backData;
    }

    @RequestMapping(value={"getData/{appCode}/{resourceCode}"}, method={RequestMethod.GET})
    public JsonBackData findByAppCodeAndResourceCode(@PathVariable String appCode, @PathVariable String resourceCode) {
        try {
            IdeResource bean = this.resourceService.findByAppCodeAndResourceCode(appCode, resourceCode);
            return JsonBackData.toSuccess("\u83b7\u53d6\u8d44\u6e90\u6210\u529f", bean);
        }
        catch (Exception e) {
            e.printStackTrace();
            return JsonBackData.toError(e.getMessage());
        }
    }
}

